/*
 * Decompiled with CFR 0.152.
 */
package tragicneko.tragicmc.worldgen.biome;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import tragicneko.tragicmc.TragicBiome;
import tragicneko.tragicmc.TragicBlocks;
import tragicneko.tragicmc.TragicConfig;
import tragicneko.tragicmc.entity.boss.EntityKitsune;
import tragicneko.tragicmc.entity.miniboss.EntityMagmox;
import tragicneko.tragicmc.entity.mob.EntityJabba;
import tragicneko.tragicmc.entity.mob.EntityWisp;
import tragicneko.tragicmc.util.WorldHelper;
import tragicneko.tragicmc.worldgen.InvertedSpikeWorldGen;
import tragicneko.tragicmc.worldgen.PitWorldGen;
import tragicneko.tragicmc.worldgen.SurfaceWorldGen2;

public class BiomeGenScorchedWasteland
extends TragicBiome {
    public final SurfaceWorldGen2 fireGen;
    public final PitWorldGen pitGen;
    public final InvertedSpikeWorldGen scarGen;
    public static final float[][] heights = new float[][]{{0.15f, 0.05f}, {0.05f, -0.45f}, {0.45f, -0.05f}};

    public BiomeGenScorchedWasteland(int par1, byte par2) {
        super(par1, par2);
        this.field_76762_K.clear();
        if (TragicConfig.getBoolean("allowKindlingSpirit")) {
            this.field_76762_K.add(new BiomeGenBase.SpawnListEntry(EntityWisp.class, TragicConfig.getInt("kindlingSpiritSpawnChance"), TragicConfig.getIntArray("kindlingSpiritGroupSize")[0], TragicConfig.getIntArray("kindlingSpiritGroupSize")[1]));
        }
        if (TragicConfig.getBoolean("allowJabba")) {
            this.field_76761_J.add(new BiomeGenBase.SpawnListEntry(EntityJabba.class, TragicConfig.getInt("jabbaSpawnChance"), TragicConfig.getIntArray("jabbaGroupSize")[0], TragicConfig.getIntArray("jabbaGroupSize")[1]));
        }
        if (TragicConfig.getBoolean("allowMagmox")) {
            this.field_76761_J.add(new BiomeGenBase.SpawnListEntry(EntityMagmox.class, TragicConfig.getInt("magmoxSpawnChance"), TragicConfig.getIntArray("magmoxGroupSize")[0], TragicConfig.getIntArray("magmoxGroupSize")[1]));
        }
        if (TragicConfig.getBoolean("allowKitsunakuma")) {
            this.field_76761_J.add(new BiomeGenBase.SpawnListEntry(EntityKitsune.class, TragicConfig.getInt("kitsunakumaSpawnChance"), 0, 0));
        }
        this.field_76766_R = false;
        this.field_76765_S = false;
        this.field_76750_F = 2.0f;
        this.field_76751_G = 0.0f;
        this.field_76749_E = heights[this.variant][0];
        this.field_76748_D = heights[this.variant][1];
        this.field_76760_I.field_76832_z = -999;
        this.field_76760_I.field_76798_D = -999;
        this.field_76753_B = TragicBlocks.ScorchedRock.func_176223_P();
        this.field_76752_A = TragicBlocks.MoltenRock.func_176223_P();
        this.fireGen = new SurfaceWorldGen2((byte)(this.variant == 2 ? 16 : 4), (Block)Blocks.field_150480_ab, 0, 8, 4);
        this.pitGen = new PitWorldGen((Block)Blocks.field_150356_k, 0, 12, 6, 4.0, 3.0);
        this.scarGen = new InvertedSpikeWorldGen(6, 1.5, 2.5, 0.90977745, 0.48943755);
    }

    @Override
    public int getFlowersFromBiomeType() {
        return this.variant == 2 ? 4 : 0;
    }

    public void func_180624_a(World world, Random rand, BlockPos pos) {
        Block block;
        byte i;
        super.func_180624_a(world, rand, pos);
        int Xcoord = pos.func_177958_n() + rand.nextInt(16);
        int Zcoord = pos.func_177952_p() + rand.nextInt(16);
        int Ycoord = world.func_175672_r(pos).func_177956_o();
        byte mew = (byte)(this.variant == 2 ? 8 : 2);
        ArrayList<BlockPos> cands = new ArrayList<BlockPos>();
        for (i = 0; i < mew; i = (byte)(i + 1)) {
            Xcoord = pos.func_177958_n() + rand.nextInt(16);
            block = world.func_180495_p(new BlockPos(Xcoord, Ycoord = world.func_175672_r(new BlockPos(Xcoord, 0, Zcoord = pos.func_177952_p() + rand.nextInt(16))).func_177977_b().func_177956_o(), Zcoord)).func_177230_c();
            if (block != TragicBlocks.MoltenRock || rand.nextInt(4) != 0) continue;
            world.func_175656_a(new BlockPos(Xcoord, Ycoord, Zcoord), TragicBlocks.Geyser.func_176223_P());
            world.func_175656_a(new BlockPos(Xcoord, Ycoord - 1, Zcoord), Blocks.field_150353_l.func_176223_P());
        }
        mew = (byte)(this.variant == 2 ? 10 : 5);
        for (i = 0; i < mew; i = (byte)(i + 1)) {
            Xcoord = pos.func_177958_n() + rand.nextInt(16);
            Zcoord = pos.func_177952_p() + rand.nextInt(16);
            Ycoord = world.func_175672_r(pos).func_177977_b().func_177956_o();
            block = world.func_180495_p(new BlockPos(Xcoord, Ycoord, Zcoord)).func_177230_c();
            if (block != TragicBlocks.MoltenRock || rand.nextInt(4) != 0) continue;
            world.func_175656_a(new BlockPos(Xcoord, Ycoord, Zcoord), TragicBlocks.SteamVent.func_176223_P());
        }
        mew = (byte)(this.variant == 0 ? 8 : 2);
        for (i = 0; i < mew; i = (byte)(i + 1)) {
            Xcoord = pos.func_177958_n() + rand.nextInt(16);
            block = world.func_180495_p(new BlockPos(Xcoord, Ycoord = world.func_175672_r(new BlockPos(Xcoord, 0, Zcoord = pos.func_177952_p() + rand.nextInt(16))).func_177977_b().func_177956_o(), Zcoord)).func_177230_c();
            if (block != TragicBlocks.MoltenRock || rand.nextInt(4) != 0) continue;
            cands.clear();
            cands.addAll(WorldHelper.getBlocksInSphericalRange(world, rand.nextDouble() * 2.25 + 1.5, Xcoord, Ycoord - 1, Zcoord));
            for (BlockPos coords : cands) {
                block = world.func_180495_p(coords).func_177230_c();
                if (!block.func_176200_f(world, coords)) continue;
                world.func_175656_a(coords, TragicBlocks.ScorchedRock.func_176223_P());
            }
        }
        if (rand.nextInt(8) == 0) {
            this.pitGen.generate(rand, pos.func_177958_n() / 16, pos.func_177952_p() / 16, world);
        }
        this.fireGen.generate(rand, pos.func_177958_n() / 16, pos.func_177952_p() / 16, world);
        if (this.variant == 2 && rand.nextInt(100) > 3 && rand.nextInt(6) != 0) {
            this.scarGen.generate(rand, pos.func_177958_n() / 16, pos.func_177952_p() / 16, world);
        }
    }
}

