/*
 * Decompiled with CFR 0.152.
 */
package tragicneko.tragicmc.worldgen.biome;

import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.feature.WorldGenerator;
import tragicneko.tragicmc.TragicBiome;
import tragicneko.tragicmc.TragicBlocks;
import tragicneko.tragicmc.TragicConfig;
import tragicneko.tragicmc.entity.boss.EntityYeti;
import tragicneko.tragicmc.entity.mob.EntityAbomination;
import tragicneko.tragicmc.entity.mob.EntityCryse;
import tragicneko.tragicmc.entity.mob.EntityRagr;
import tragicneko.tragicmc.worldgen.CustomSpikesWorldGen;
import tragicneko.tragicmc.worldgen.PitWorldGen;
import tragicneko.tragicmc.worldgen.RuggedTerrainWorldGen;
import tragicneko.tragicmc.worldgen.SurfaceWorldGen2;
import tragicneko.tragicmc.worldgen.WorldGenCustomTallGrass;
import tragicneko.tragicmc.worldgen.WorldGenCustomVine;

public class BiomeGenFrozenTundra
extends TragicBiome {
    public final RuggedTerrainWorldGen permafrostGen;
    public final SurfaceWorldGen2 iceSpikeGen;
    public final PitWorldGen pitGen;
    public final WorldGenCustomVine vineGen;
    public static final float[][] heights = new float[][]{{0.01f, 0.12f}, {0.35f, 0.22f}, {0.65f, -1.15f}};

    public BiomeGenFrozenTundra(int par1, byte par2) {
        super(par1, par2);
        this.field_76766_R = true;
        this.field_76765_S = false;
        this.field_76750_F = 0.1f;
        this.field_76751_G = 0.1f;
        this.field_76749_E = heights[this.variant][0];
        this.field_76748_D = heights[this.variant][1];
        this.field_76753_B = TragicBlocks.IcedDirt.func_176223_P();
        this.field_76752_A = TragicBlocks.Permafrost.func_176223_P();
        if (TragicConfig.getBoolean("allowCryse")) {
            this.field_76761_J.add(new BiomeGenBase.SpawnListEntry(EntityCryse.class, TragicConfig.getInt("cryseSpawnChance"), TragicConfig.getIntArray("cryseGroupSize")[0], TragicConfig.getIntArray("cryseGroupSize")[1]));
        }
        if (TragicConfig.getBoolean("allowRagr")) {
            this.field_76761_J.add(new BiomeGenBase.SpawnListEntry(EntityRagr.class, TragicConfig.getInt("ragrSpawnChance"), TragicConfig.getIntArray("ragrGroupSize")[0], TragicConfig.getIntArray("ragrGroupSize")[1]));
        }
        if (TragicConfig.getBoolean("allowAbomination")) {
            this.field_76761_J.add(new BiomeGenBase.SpawnListEntry(EntityAbomination.class, TragicConfig.getInt("abominationSpawnChance"), TragicConfig.getIntArray("abominationGroupSize")[0], TragicConfig.getIntArray("abominationGroupSize")[1]));
        }
        if (TragicConfig.getBoolean("allowEmpariah")) {
            this.field_76761_J.add(new BiomeGenBase.SpawnListEntry(EntityYeti.class, TragicConfig.getInt("empariahSpawnChance"), 0, 0));
        }
        this.field_76760_I.field_76832_z = -999;
        this.field_76760_I.field_76798_D = 16;
        this.field_76760_I.field_76803_B = this.variant == 1 ? 12 : (this.variant == 2 ? 6 : 2);
        this.permafrostGen = new RuggedTerrainWorldGen(TragicBlocks.Permafrost, 1, TragicBlocks.Permafrost, 2, 2.0, 3.0, false, 8);
        this.iceSpikeGen = new SurfaceWorldGen2((byte)(this.variant == 2 ? 12 : 4), TragicBlocks.IceSpike, 0, 4, 8);
        this.pitGen = new PitWorldGen(TragicBlocks.IceSpike, 0, 12, 6, 4.0, 3.0);
        this.vineGen = new WorldGenCustomVine(TragicBlocks.Moss.func_176223_P(), 84);
    }

    @Override
    public int getFlowersFromBiomeType() {
        return this.variant == 0 ? 6 : 2;
    }

    public void func_180624_a(World world, Random rand, BlockPos pos) {
        super.func_180624_a(world, rand, pos);
        byte mew = (byte)(this.variant > 0 ? 18 : 6);
        for (byte a = 0; a < mew; a = (byte)(a + 1)) {
            int k = pos.func_177958_n() + rand.nextInt(16) - 8;
            int l = pos.func_177952_p() + rand.nextInt(16) - 8;
            this.vineGen.func_180709_b(world, rand, new BlockPos(k, rand.nextInt(64) + 36, l));
        }
        this.permafrostGen.generate(rand, pos.func_177958_n() / 16, pos.func_177952_p() / 16, world);
        if (this.variant != 1) {
            this.iceSpikeGen.generate(rand, pos.func_177958_n() / 16, pos.func_177952_p() / 16, world);
        }
        new CustomSpikesWorldGen((byte)(this.variant == 2 ? 6 : (this.variant == 0 ? 2 : 4)), Blocks.field_150403_cj, 0, 0.89477735, 0.441114525, 1.0, 0.35, false, false).generate(rand, pos.func_177958_n() / 16, pos.func_177952_p() / 16, world);
        if (rand.nextInt(8) == 0) {
            this.pitGen.generate(rand, pos.func_177958_n() / 16, pos.func_177952_p() / 16, world);
        }
    }

    public WorldGenerator func_76730_b(Random rand) {
        return new WorldGenCustomTallGrass(TragicBlocks.Lichen.func_176223_P());
    }
}

