/*
 * Decompiled with CFR 0.152.
 */
package tragicneko.tragicmc.worldgen.biome;

import java.util.Random;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import tragicneko.tragicmc.TragicBiome;
import tragicneko.tragicmc.TragicBlocks;
import tragicneko.tragicmc.TragicConfig;
import tragicneko.tragicmc.entity.boss.EntityDeathReaper;
import tragicneko.tragicmc.entity.mob.EntitySirv;
import tragicneko.tragicmc.worldgen.CustomSpikesWorldGen;
import tragicneko.tragicmc.worldgen.RuggedTerrainWorldGen;
import tragicneko.tragicmc.worldgen.VoidPitWorldGen;

public class BiomeGenDecayingWasteland
extends TragicBiome {
    public final VoidPitWorldGen voidPitGen;
    public final RuggedTerrainWorldGen mixedDirtGen;
    public static final float[][] heights = new float[][]{{0.35f, 0.22f}, {0.05f, -0.35f}, {0.18f, 0.15f}, {0.75f, 0.35f}};

    public BiomeGenDecayingWasteland(int par1, byte par2) {
        super(par1, par2);
        this.field_76762_K.add(new BiomeGenBase.SpawnListEntry(EntityBat.class, 50, 3, 5));
        if (TragicConfig.getBoolean("allowSirv")) {
            this.field_76761_J.add(new BiomeGenBase.SpawnListEntry(EntitySirv.class, TragicConfig.getInt("sirvSpawnChance"), TragicConfig.getIntArray("sirvGroupSize")[0], TragicConfig.getIntArray("sirvGroupSize")[1]));
        }
        if (TragicConfig.getBoolean("allowSkultar")) {
            this.field_76761_J.add(new BiomeGenBase.SpawnListEntry(EntityDeathReaper.class, TragicConfig.getInt("skultarSpawnChance"), 0, 0));
        }
        this.field_76765_S = false;
        this.field_76766_R = false;
        this.field_76750_F = 0.6f;
        this.field_76751_G = 0.0f;
        this.field_76749_E = heights[this.variant][0];
        this.field_76748_D = heights[this.variant][1];
        this.field_76760_I.field_76798_D = this.variant == 0 || this.variant == 3 ? 2 : 8;
        this.field_76753_B = TragicBlocks.DarkStone.func_176223_P();
        this.field_76752_A = TragicBlocks.DeadDirt.func_176223_P();
        this.field_76760_I.field_76798_D = 16;
        this.voidPitGen = new VoidPitWorldGen(3.5, 3.5);
        this.mixedDirtGen = new RuggedTerrainWorldGen(TragicBlocks.DeadDirt, 2, TragicBlocks.DeadDirt, 6, 3.0, 4.0, false, 8);
    }

    @Override
    public int getBushesFromBiomeType() {
        return this.variant == 0 ? 8 : 4;
    }

    @Override
    public int getFlowersFromBiomeType() {
        return this.variant == 1 ? 12 : 4;
    }

    public void func_180624_a(World world, Random rand, BlockPos pos) {
        super.func_180624_a(world, rand, pos);
        new CustomSpikesWorldGen((byte)(this.variant == 3 ? 6 : 2), TragicBlocks.BoneBlock, (byte)rand.nextInt(2), 0.8977735, 0.441114525, 1.0, 0.35, false, false).generate(rand, pos.func_177958_n() / 16, pos.func_177952_p() / 16, world);
        this.mixedDirtGen.generate(rand, pos.func_177958_n() / 16, pos.func_177952_p() / 16, world);
        if (TragicConfig.getBoolean("allowVoidPitGen") && rand.nextInt(200) >= 5 && rand.nextInt(6) == 0) {
            this.voidPitGen.generate(rand, pos.func_177958_n() / 16, pos.func_177952_p() / 16, world);
        }
    }
}

