/*
 * Decompiled with CFR 0.152.
 */
package tragicneko.tragicmc.worldgen;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.BlockVine;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraftforge.common.IPlantable;

public class WorldGenCustomOakTree
extends WorldGenAbstractTree {
    private final int minTreeHeight;
    private final IBlockState logState;
    private final IBlockState leafState;
    private final boolean growsVines;
    private final IBlockState vineState;
    private IBlockState trimState = null;

    public WorldGenCustomOakTree(boolean largeTree, int treeMin, IBlockState log, IBlockState leaf) {
        this(largeTree, treeMin, log, leaf, false, null);
    }

    public WorldGenCustomOakTree(boolean largeTree, int treeMin, IBlockState log, IBlockState leaf, boolean growVine, IBlockState vine) {
        super(largeTree);
        this.minTreeHeight = treeMin;
        this.logState = log;
        this.leafState = leaf;
        this.growsVines = growVine;
        this.vineState = vine;
    }

    public WorldGenCustomOakTree setTrim(IBlockState state) {
        this.trimState = state;
        return this;
    }

    public boolean func_180709_b(World worldIn, Random rand, BlockPos pos) {
        int i = rand.nextInt(3) + this.minTreeHeight;
        boolean flag = true;
        if (pos.func_177956_o() >= 1 && pos.func_177956_o() + i + 1 <= 256) {
            int l;
            int b0;
            for (int j = pos.func_177956_o(); j <= pos.func_177956_o() + 1 + i; ++j) {
                b0 = 1;
                if (j == pos.func_177956_o()) {
                    b0 = 0;
                }
                if (j >= pos.func_177956_o() + 1 + i - 2) {
                    b0 = 2;
                }
                for (int k = pos.func_177958_n() - b0; k <= pos.func_177958_n() + b0 && flag; ++k) {
                    for (l = pos.func_177952_p() - b0; l <= pos.func_177952_p() + b0 && flag; ++l) {
                        if (j >= 0 && j < 256) {
                            if (this.isReplaceable(worldIn, new BlockPos(k, j, l))) continue;
                            flag = false;
                            continue;
                        }
                        flag = false;
                    }
                }
            }
            if (!flag) {
                return false;
            }
            BlockPos down = pos.func_177977_b();
            Block block1 = worldIn.func_180495_p(down).func_177230_c();
            boolean isSoil = block1.canSustainPlant((IBlockAccess)worldIn, down, EnumFacing.UP, (IPlantable)((BlockSapling)Blocks.field_150345_g));
            if (isSoil && pos.func_177956_o() < 256 - i - 1) {
                BlockPos blockpos1;
                int l1;
                int k1;
                int j1;
                int i1;
                block1.onPlantGrow(worldIn, down, pos);
                b0 = 3;
                int b1 = 0;
                for (l = pos.func_177956_o() - b0 + i; l <= pos.func_177956_o() + i; ++l) {
                    i1 = l - (pos.func_177956_o() + i);
                    j1 = b1 + 1 - i1 / 2;
                    for (k1 = pos.func_177958_n() - j1; k1 <= pos.func_177958_n() + j1; ++k1) {
                        l1 = k1 - pos.func_177958_n();
                        for (int i2 = pos.func_177952_p() - j1; i2 <= pos.func_177952_p() + j1; ++i2) {
                            Block block;
                            int j2 = i2 - pos.func_177952_p();
                            if (Math.abs(l1) == j1 && Math.abs(j2) == j1 && (rand.nextInt(2) == 0 || i1 == 0) || !(block = worldIn.func_180495_p(blockpos1 = new BlockPos(k1, l, i2)).func_177230_c()).isAir((IBlockAccess)worldIn, blockpos1) && !block.isLeaves((IBlockAccess)worldIn, blockpos1) && block.func_149688_o() != Material.field_151582_l) continue;
                            this.func_175903_a(worldIn, blockpos1, this.leafState);
                            if (this.trimState == null || !block.isAir((IBlockAccess)worldIn, blockpos1.func_177984_a()) && !block.isLeaves((IBlockAccess)worldIn, blockpos1.func_177984_a())) continue;
                            this.func_175903_a(worldIn, blockpos1.func_177984_a(), this.trimState);
                        }
                    }
                }
                for (l = 0; l < i; ++l) {
                    BlockPos upN = pos.func_177981_b(l);
                    Block block2 = worldIn.func_180495_p(upN).func_177230_c();
                    if (!block2.isAir((IBlockAccess)worldIn, upN) && !block2.isLeaves((IBlockAccess)worldIn, upN) && block2.func_149688_o() != Material.field_151582_l) continue;
                    this.func_175903_a(worldIn, pos.func_177981_b(l), this.logState);
                    if (!this.growsVines || l <= 0) continue;
                    if (rand.nextInt(3) > 0 && worldIn.func_175623_d(pos.func_177982_a(-1, l, 0))) {
                        this.func_175903_a(worldIn, pos.func_177982_a(-1, l, 0), this.vineState.func_177230_c().func_176223_P().func_177226_a((IProperty)BlockVine.field_176278_M, (Comparable)Boolean.valueOf(true)));
                    }
                    if (rand.nextInt(3) > 0 && worldIn.func_175623_d(pos.func_177982_a(1, l, 0))) {
                        this.func_175903_a(worldIn, pos.func_177982_a(1, l, 0), this.vineState.func_177230_c().func_176223_P().func_177226_a((IProperty)BlockVine.field_176280_O, (Comparable)Boolean.valueOf(true)));
                    }
                    if (rand.nextInt(3) > 0 && worldIn.func_175623_d(pos.func_177982_a(0, l, -1))) {
                        this.func_175903_a(worldIn, pos.func_177982_a(0, l, -1), this.vineState.func_177230_c().func_176223_P().func_177226_a((IProperty)BlockVine.field_176279_N, (Comparable)Boolean.valueOf(true)));
                    }
                    if (rand.nextInt(3) <= 0 || !worldIn.func_175623_d(pos.func_177982_a(0, l, 1))) continue;
                    this.func_175903_a(worldIn, pos.func_177982_a(0, l, 1), this.vineState.func_177230_c().func_176223_P().func_177226_a((IProperty)BlockVine.field_176273_b, (Comparable)Boolean.valueOf(true)));
                }
                if (this.growsVines) {
                    for (l = pos.func_177956_o() - 3 + i; l <= pos.func_177956_o() + i; ++l) {
                        i1 = l - (pos.func_177956_o() + i);
                        j1 = 2 - i1 / 2;
                        for (k1 = pos.func_177958_n() - j1; k1 <= pos.func_177958_n() + j1; ++k1) {
                            for (l1 = pos.func_177952_p() - j1; l1 <= pos.func_177952_p() + j1; ++l1) {
                                BlockPos blockpos3 = new BlockPos(k1, l, l1);
                                if (!worldIn.func_180495_p(blockpos3).func_177230_c().isLeaves((IBlockAccess)worldIn, blockpos3)) continue;
                                BlockPos blockpos4 = blockpos3.func_177976_e();
                                blockpos1 = blockpos3.func_177974_f();
                                BlockPos blockpos5 = blockpos3.func_177978_c();
                                BlockPos blockpos2 = blockpos3.func_177968_d();
                                if (rand.nextInt(4) == 0 && worldIn.func_180495_p(blockpos4).func_177230_c().isAir((IBlockAccess)worldIn, blockpos4)) {
                                    this.placeHangingVines(worldIn, blockpos4, BlockVine.field_176278_M);
                                }
                                if (rand.nextInt(4) == 0 && worldIn.func_180495_p(blockpos1).func_177230_c().isAir((IBlockAccess)worldIn, blockpos1)) {
                                    this.placeHangingVines(worldIn, blockpos1, BlockVine.field_176280_O);
                                }
                                if (rand.nextInt(4) == 0 && worldIn.func_180495_p(blockpos5).func_177230_c().isAir((IBlockAccess)worldIn, blockpos5)) {
                                    this.placeHangingVines(worldIn, blockpos5, BlockVine.field_176279_N);
                                }
                                if (rand.nextInt(4) != 0 || !worldIn.func_180495_p(blockpos2).func_177230_c().isAir((IBlockAccess)worldIn, blockpos2)) continue;
                                this.placeHangingVines(worldIn, blockpos2, BlockVine.field_176273_b);
                            }
                        }
                    }
                    if (rand.nextInt(5) == 0 && i > 5) {
                        for (l = 0; l < 2; ++l) {
                            for (i1 = 0; i1 < 4; ++i1) {
                                if (rand.nextInt(4 - l) != 0) continue;
                                j1 = rand.nextInt(3);
                                EnumFacing enumfacing = EnumFacing.func_176731_b((int)i1).func_176734_d();
                                this.func_175903_a(worldIn, pos.func_177982_a(enumfacing.func_82601_c(), i - 5 + l, enumfacing.func_82599_e()), Blocks.field_150375_by.func_176203_a(j1 << 2 | EnumFacing.func_176731_b((int)i1).func_176736_b()));
                            }
                        }
                    }
                }
                return true;
            }
            return false;
        }
        return false;
    }

    private void placeHangingVines(World worldIn, BlockPos pos, PropertyBool bool) {
        this.func_175903_a(worldIn, pos, this.vineState.func_177226_a((IProperty)bool, (Comparable)Boolean.valueOf(true)));
        pos = pos.func_177977_b();
        for (int j = 4; worldIn.func_180495_p(pos).func_177230_c().isAir((IBlockAccess)worldIn, pos) && j > 0; --j) {
            this.func_175903_a(worldIn, pos, this.vineState.func_177226_a((IProperty)bool, (Comparable)Boolean.valueOf(true)));
            pos = pos.func_177977_b();
        }
    }
}

