/*
 * Decompiled with CFR 0.152.
 */
package tragicneko.tragicmc.worldgen;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockGrass;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import tragicneko.tragicmc.blocks.BlockGenericGrass;
import tragicneko.tragicmc.util.WorldHelper;

public class WorldGenCustomLollipopTree
extends WorldGenAbstractTree {
    private final IBlockState logState;
    private final IBlockState leafState;

    public WorldGenCustomLollipopTree(IBlockState log, IBlockState leaf) {
        super(false);
        this.logState = log;
        this.leafState = leaf;
    }

    public boolean func_180709_b(World world, Random rand, BlockPos pos) {
        Block block = world.func_180495_p(pos).func_177230_c();
        if (!(block instanceof BlockGenericGrass || block instanceof BlockGrass || block.func_149688_o() == Material.field_151578_c || block.func_149688_o() == Material.field_151577_b || block instanceof BlockBush)) {
            return false;
        }
        double scale = rand.nextDouble() * 3.25 + 1.15;
        if (scale < 2.0) {
            return false;
        }
        ArrayList<BlockPos> list = WorldHelper.getBlocksInSphericalRange(world, scale * 0.5, pos.func_177958_n(), (double)(pos.func_177956_o() + 1) + scale * 3.0 / 4.0, pos.func_177952_p());
        int y1 = 0;
        while ((double)y1 < 1.0 + scale * 3.0 / 4.0) {
            block = world.func_180495_p(pos.func_177981_b(y1)).func_177230_c();
            if (block.canBeReplacedByLeaves((IBlockAccess)world, pos.func_177981_b(y1))) {
                world.func_175656_a(pos.func_177981_b(y1), this.logState);
            }
            ++y1;
        }
        for (int i = 0; i < list.size(); ++i) {
            BlockPos coords = list.get(i);
            block = world.func_180495_p(coords).func_177230_c();
            if (!block.canBeReplacedByLeaves((IBlockAccess)world, coords) || block.func_149688_o() == Material.field_151575_d) continue;
            world.func_175656_a(coords, this.leafState);
        }
        return true;
    }
}

