/*
 * Decompiled with CFR 0.152.
 */
package tragicneko.tragicmc.worldgen;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraftforge.common.IPlantable;

public abstract class WorldGenCustomHugeTree
extends WorldGenAbstractTree {
    protected final int baseHeight;
    protected int heightVariation;
    protected final IBlockState leafState;

    public WorldGenCustomHugeTree(boolean isLarge, int baseH, int heightV, IBlockState leaf) {
        super(isLarge);
        this.baseHeight = baseH;
        this.heightVariation = heightV;
        this.leafState = leaf;
    }

    protected int func_150533_a(Random p_150533_1_) {
        int i = p_150533_1_.nextInt(3) + this.baseHeight;
        if (this.heightVariation > 1) {
            i += p_150533_1_.nextInt(this.heightVariation);
        }
        return i;
    }

    private boolean func_175926_c(World worldIn, BlockPos p_175926_2_, int p_175926_3_) {
        boolean flag = true;
        if (p_175926_2_.func_177956_o() >= 1 && p_175926_2_.func_177956_o() + p_175926_3_ + 1 <= 256) {
            for (int j = 0; j <= 1 + p_175926_3_; ++j) {
                int b0 = 2;
                if (j == 0) {
                    b0 = 1;
                } else if (j >= 1 + p_175926_3_ - 2) {
                    b0 = 2;
                }
                for (int k = -b0; k <= b0 && flag; ++k) {
                    for (int l = -b0; l <= b0 && flag; ++l) {
                        if (p_175926_2_.func_177956_o() + j >= 0 && p_175926_2_.func_177956_o() + j < 256 && this.isReplaceable(worldIn, p_175926_2_.func_177982_a(k, j, l))) continue;
                        flag = false;
                    }
                }
            }
            return flag;
        }
        return false;
    }

    private boolean func_175927_a(BlockPos p_175927_1_, World worldIn) {
        BlockPos blockpos1 = p_175927_1_.func_177977_b();
        Block block = worldIn.func_180495_p(blockpos1).func_177230_c();
        boolean isSoil = block.canSustainPlant((IBlockAccess)worldIn, blockpos1, EnumFacing.UP, (IPlantable)((BlockSapling)Blocks.field_150345_g));
        if (isSoil && p_175927_1_.func_177956_o() >= 2) {
            this.onPlantGrow(worldIn, blockpos1, p_175927_1_);
            this.onPlantGrow(worldIn, blockpos1.func_177974_f(), p_175927_1_);
            this.onPlantGrow(worldIn, blockpos1.func_177968_d(), p_175927_1_);
            this.onPlantGrow(worldIn, blockpos1.func_177968_d().func_177974_f(), p_175927_1_);
            return true;
        }
        return false;
    }

    protected boolean func_175929_a(World worldIn, Random p_175929_2_, BlockPos p_175929_3_, int p_175929_4_) {
        return this.func_175926_c(worldIn, p_175929_3_, p_175929_4_) && this.func_175927_a(p_175929_3_, worldIn);
    }

    protected void func_175925_a(World worldIn, BlockPos p_175925_2_, int p_175925_3_) {
        int j = p_175925_3_ * p_175925_3_;
        for (int k = -p_175925_3_; k <= p_175925_3_ + 1; ++k) {
            for (int l = -p_175925_3_; l <= p_175925_3_ + 1; ++l) {
                BlockPos blockpos1;
                IBlockState state;
                int i1 = k - 1;
                int j1 = l - 1;
                if (k * k + l * l > j && i1 * i1 + j1 * j1 > j && k * k + j1 * j1 > j && i1 * i1 + l * l > j || !(state = worldIn.func_180495_p(blockpos1 = p_175925_2_.func_177982_a(k, 0, l))).func_177230_c().isAir((IBlockAccess)worldIn, blockpos1) && !state.func_177230_c().isLeaves((IBlockAccess)worldIn, blockpos1)) continue;
                this.func_175903_a(worldIn, blockpos1, this.leafState);
            }
        }
    }

    protected void func_175928_b(World worldIn, BlockPos p_175928_2_, int p_175928_3_) {
        int j = p_175928_3_ * p_175928_3_;
        for (int k = -p_175928_3_; k <= p_175928_3_; ++k) {
            for (int l = -p_175928_3_; l <= p_175928_3_; ++l) {
                BlockPos blockpos1;
                Block block;
                if (k * k + l * l > j || !(block = worldIn.func_180495_p(blockpos1 = p_175928_2_.func_177982_a(k, 0, l)).func_177230_c()).isAir((IBlockAccess)worldIn, blockpos1) && !block.isLeaves((IBlockAccess)worldIn, blockpos1)) continue;
                this.func_175903_a(worldIn, blockpos1, this.leafState);
            }
        }
    }

    private void onPlantGrow(World world, BlockPos pos, BlockPos source) {
        world.func_180495_p(pos).func_177230_c().onPlantGrow(world, pos, source);
    }
}

