/*
 * Decompiled with CFR 0.152.
 */
package tragicneko.tragicmc.worldgen;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;
import tragicneko.tragicmc.TragicConfig;
import tragicneko.tragicmc.util.WorldHelper;
import tragicneko.tragicmc.worldgen.IWorldGen;

public class VoidPitWorldGen
implements IWorldGen {
    public final double radius;
    public final double variation;

    public VoidPitWorldGen(double radius, double var) {
        this.radius = radius;
        this.variation = var;
    }

    @Override
    public void generate(Random random, int chunkX, int chunkZ, World world) {
        if (!TragicConfig.getBoolean("allowVoidPitGen")) {
            return;
        }
        int Xcoord = chunkX * 16 + random.nextInt(16);
        int Ycoord = random.nextInt(35) + 60;
        int Zcoord = chunkZ * 16 + random.nextInt(16);
        ArrayList<BlockPos> cands = new ArrayList<BlockPos>();
        double size = this.variation * random.nextDouble() + this.radius;
        int pow = 0;
        while (pow + Ycoord >= 0 && pow + Ycoord <= 256) {
            ArrayList<BlockPos> list;
            if (size >= 5.5) {
                list = WorldHelper.getBlocksInCircularRange(world, size * 0.31773, Xcoord, Ycoord + pow, Zcoord);
                for (BlockPos coords : list) {
                    if (random.nextInt(4) == 0 || cands.contains(coords)) continue;
                    cands.add(coords);
                }
            }
            list = WorldHelper.getBlocksInCircularRange(world, size * 0.64773, Xcoord, Ycoord + pow, Zcoord);
            for (BlockPos coords : list) {
                if (random.nextInt(3) == 0 || cands.contains(coords)) continue;
                cands.add(coords);
            }
            list = WorldHelper.getBlocksInCircularRange(world, size, Xcoord, Ycoord + pow, Zcoord);
            for (BlockPos coords : list) {
                if (!random.nextBoolean() || cands.contains(coords)) continue;
                cands.add(coords);
            }
            if (size >= 3.0 && random.nextInt(3) == 0) {
                size *= 0.977425;
            }
            --pow;
        }
        for (BlockPos coords2 : cands) {
            world.func_175698_g(coords2);
        }
    }
}

