/*
 * Decompiled with CFR 0.152.
 */
package tragicneko.tragicmc.worldgen;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.util.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import tragicneko.tragicmc.TragicConfig;
import tragicneko.tragicmc.worldgen.IWorldGen;

public class SurfaceWorldGen2
implements IWorldGen {
    public final byte iterations;
    public final Block block;
    public final byte meta;
    public final byte width;
    public final byte height;

    public SurfaceWorldGen2(byte iterations, Block block, byte meta, byte width, byte height) {
        this.iterations = iterations;
        this.block = block;
        this.meta = meta;
        this.width = width;
        this.height = height;
    }

    @Override
    public void generate(Random random, int chunkX, int chunkZ, World world) {
        if (!TragicConfig.getBoolean("allowScatteredSurfaceGen")) {
            return;
        }
        int Xcoord = chunkX * 16 + random.nextInt(16);
        int Zcoord = chunkZ * 16 + random.nextInt(16);
        int Ycoord = world.func_175672_r(new BlockPos(Xcoord, 0, Zcoord)).func_177956_o();
        for (byte i = 0; i < this.iterations; i = (byte)(i + 1)) {
            Xcoord += random.nextInt(this.width) - random.nextInt(this.width);
            Zcoord += random.nextInt(this.width) - random.nextInt(this.width);
            if ((Ycoord += random.nextInt(this.height) - random.nextInt(this.height)) < 0 || Ycoord > 256) break;
            Block block = world.func_180495_p(new BlockPos(Xcoord, Ycoord, Zcoord)).func_177230_c();
            if (!block.canBeReplacedByLeaves((IBlockAccess)world, new BlockPos(Xcoord, Ycoord, Zcoord)) && !block.isAir((IBlockAccess)world, new BlockPos(Xcoord, Ycoord, Zcoord)) || !World.func_175683_a((IBlockAccess)world, (BlockPos)new BlockPos(Xcoord, Ycoord - 1, Zcoord)) || block.func_149688_o().func_76224_d()) continue;
            world.func_180501_a(new BlockPos(Xcoord, Ycoord, Zcoord), this.block.func_176203_a((int)this.meta), 2);
        }
    }
}

