/*
 * Decompiled with CFR 0.152.
 */
package tragicneko.tragicmc.worldgen;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;
import tragicneko.tragicmc.TragicConfig;
import tragicneko.tragicmc.blocks.BlockGenericTallGrass;
import tragicneko.tragicmc.util.WorldHelper;
import tragicneko.tragicmc.worldgen.IWorldGen;

public class RuggedTerrainWorldGen
implements IWorldGen {
    public final Block block;
    public final byte meta;
    public final byte iterations;
    public final double radius;
    public final double variation;
    public final boolean replacesAir;
    public final Block toReplace;
    public final byte width;

    public RuggedTerrainWorldGen(Block block, byte meta, Block toReplace, byte iterations, double radius, double var, boolean flag, byte width) {
        this.block = block;
        this.meta = meta;
        this.toReplace = toReplace;
        this.iterations = iterations;
        this.radius = radius;
        this.variation = var;
        this.replacesAir = flag;
        this.width = width;
    }

    @Override
    public void generate(Random random, int chunkX, int chunkZ, World world) {
        if (!TragicConfig.getBoolean("allowScatteredSurfaceGen")) {
            return;
        }
        int x = chunkX * 16 + random.nextInt(16);
        int z = chunkZ * 16 + random.nextInt(16);
        int y = world.func_175672_r(new BlockPos(x, 0, z)).func_177956_o();
        for (byte pow = 0; pow < this.iterations; pow = (byte)(pow + 1)) {
            x += random.nextInt(this.width) - random.nextInt(this.width);
            z += random.nextInt(this.width) - random.nextInt(this.width);
            double radius = this.variation * random.nextDouble() + this.radius;
            for (int y1 = -1; y1 < 2; y1 = (int)((byte)(y1 + 1))) {
                ArrayList<BlockPos> list = WorldHelper.getBlocksInCircularRange(world, radius, x, y + y1, z);
                for (BlockPos coords : list) {
                    if (random.nextInt(16) != 0) continue;
                    Block block = world.func_180495_p(coords).func_177230_c();
                    if (!world.func_180495_p(coords.func_177977_b()).func_177230_c().func_149662_c() || block != this.toReplace && (block.func_149688_o() != Material.field_151579_a || !this.replacesAir) && !(block instanceof BlockGenericTallGrass)) continue;
                    world.func_180501_a(coords, this.block.func_176203_a((int)this.meta), 2);
                }
            }
        }
    }
}

