/*
 * Decompiled with CFR 0.152.
 */
package tragicneko.tragicmc.worldgen;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.util.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import tragicneko.tragicmc.TragicBlocks;
import tragicneko.tragicmc.TragicConfig;
import tragicneko.tragicmc.util.WorldHelper;
import tragicneko.tragicmc.worldgen.IWorldGen;

public class CustomSpikesWorldGen
implements IWorldGen {
    public final byte relays;
    public final Block block;
    public final byte meta;
    public final double regression;
    public final double cutoff;
    public final boolean usesSpikeTypes;
    public final boolean isStarCrystal;
    public final double size;
    public final double sizeVariation;

    public CustomSpikesWorldGen(byte relay, Block spikeBlock, byte metaValue, double regress, double spikeCutoff, double baseSize, double sizeVariation, boolean flag, boolean flag2) {
        this.relays = relay;
        this.block = spikeBlock;
        this.meta = metaValue;
        this.regression = regress;
        this.cutoff = spikeCutoff;
        this.size = baseSize;
        this.sizeVariation = sizeVariation;
        this.usesSpikeTypes = flag;
        this.isStarCrystal = flag2;
    }

    public CustomSpikesWorldGen(byte relay, Block spikeBlock, byte metaValue, double regress, double spikeCutoff, double baseSize, double sizeVariation) {
        this(relay, spikeBlock, metaValue, regress, spikeCutoff, baseSize, sizeVariation, true, false);
    }

    @Override
    public void generate(Random random, int chunkX, int chunkZ, World world) {
        if (!TragicConfig.getBoolean("allowSpikeGen") || random.nextInt(4) == 0) {
            return;
        }
        int Xcoord = chunkX * 16 + random.nextInt(16);
        int Zcoord = chunkZ * 16 + random.nextInt(16);
        int Ycoord = world.func_175672_r(new BlockPos(Xcoord, 0, Zcoord)).func_177956_o();
        ArrayList<BlockPos> cands = new ArrayList<BlockPos>();
        double regress = this.regression;
        byte m = this.meta;
        for (byte buzza = 0; buzza < this.relays; buzza = (byte)(buzza + 1)) {
            double spikeSize = random.nextDouble() * this.sizeVariation + this.size;
            Ycoord = world.func_175672_r(new BlockPos(Xcoord += random.nextInt(8) - random.nextInt(8), 0, Zcoord += random.nextInt(8) - random.nextInt(8))).func_177956_o();
            Block block = WorldHelper.getBlock(world, new BlockPos(Xcoord, Ycoord, Zcoord).func_177977_b());
            if (!World.func_175683_a((IBlockAccess)world, (BlockPos)new BlockPos(Xcoord, Ycoord, Zcoord).func_177977_b()) || !block.func_149662_c()) continue;
            byte spikeType = (byte)(this.usesSpikeTypes ? random.nextInt(6) : random.nextInt(2));
            if (this.isStarCrystal) {
                m = (byte)random.nextInt(16);
            }
            boolean flag3 = false;
            boolean flag2 = false;
            for (int y1 = 0; y1 < 127 && !(spikeSize < this.cutoff) && Ycoord + y1 <= world.func_72940_L(); y1 = (int)((byte)(y1 + 1))) {
                if (random.nextBoolean()) {
                    spikeSize *= regress;
                    if (random.nextInt(3) == 0 && spikeSize >= 0.4888233) {
                        Xcoord += random.nextInt(2) - random.nextInt(2);
                        Zcoord += random.nextInt(2) - random.nextInt(2);
                    }
                    if (spikeType == 1 && !flag3 && y1 >= 35 && y1 <= 70 && random.nextBoolean() && this.size <= 0.774446314) {
                        spikeSize *= 2.86333567;
                        flag3 = true;
                    }
                }
                spikeSize *= regress;
                if (this.usesSpikeTypes && random.nextBoolean()) {
                    if (spikeType == 2 && this.size >= 0.5625292) {
                        Xcoord += random.nextInt(2) - random.nextInt(2);
                        Zcoord += random.nextInt(2) - random.nextInt(2);
                    } else if (spikeType == 3 && !flag2 && random.nextInt(4) == 0 && y1 >= 35 && spikeSize <= 1.41115648 && spikeSize >= 0.76663601) {
                        this.generateChildSpike(world, random, spikeSize * 1.32977745, Xcoord + random.nextInt(5) - random.nextInt(5), Ycoord + y1, Zcoord + random.nextInt(5) - random.nextInt(5), this.block, m);
                        flag2 = true;
                    } else if (spikeType == 4 && random.nextInt(4) == 0 && y1 >= 35 && spikeSize >= 0.76663601) {
                        this.generateChildSpike(world, random, spikeSize * 1.12977745, Xcoord + random.nextInt(5) - random.nextInt(5), Ycoord + y1, Zcoord + random.nextInt(5) - random.nextInt(5), this.block, m);
                    } else if (spikeType == 5 && random.nextInt(4) == 0) {
                        if (y1 <= 24) {
                            this.generateChildSpike(world, random, spikeSize * 1.12977745, Xcoord + random.nextInt(6) - random.nextInt(6), Ycoord + y1, Zcoord + random.nextInt(6) - random.nextInt(6), this.block, m);
                        } else if (spikeSize >= 0.76663601) {
                            this.generateChildSpike(world, random, spikeSize * 1.13977745, Xcoord + random.nextInt(5) - random.nextInt(5), Ycoord + y1, Zcoord + random.nextInt(5) - random.nextInt(5), this.block, m);
                        }
                    }
                }
                ArrayList<BlockPos> list = WorldHelper.getBlocksInSphericalRange(world, spikeSize, Xcoord, Ycoord + y1, Zcoord);
                for (BlockPos coords : list) {
                    Block ablock = world.func_180495_p(coords).func_177230_c();
                    if (ablock == TragicBlocks.DarkStone || cands.contains(coords)) continue;
                    cands.add(coords);
                }
            }
            for (BlockPos coords : cands) {
                world.func_180501_a(coords, this.block.func_176203_a((int)m), 2);
            }
        }
    }

    public void generateChildSpike(World world, Random rand, double size, double Xcoord, double Ycoord, double Zcoord, Block spike, int meta) {
        ArrayList<BlockPos> cands = new ArrayList<BlockPos>();
        for (int y1 = 0; y1 < 127 && !(size < 0.36443755) && !(Ycoord + (double)y1 > 256.0); y1 = (int)((byte)(y1 + 1))) {
            if (rand.nextBoolean() && (size *= 0.95977745) >= 0.54288233) {
                Xcoord += (double)(rand.nextInt(2) - rand.nextInt(2));
                Zcoord += (double)(rand.nextInt(2) - rand.nextInt(2));
            }
            ArrayList<BlockPos> list = WorldHelper.getBlocksInSphericalRange(world, size, Xcoord, Ycoord + (double)y1, Zcoord);
            for (BlockPos coords : list) {
                Block block = world.func_180495_p(coords).func_177230_c();
                if (cands.contains(coords)) continue;
                cands.add(coords);
            }
        }
        for (BlockPos coords : cands) {
            world.func_180501_a(coords, spike.func_176203_a(meta), 2);
        }
    }
}

