/*
 * Decompiled with CFR 0.152.
 */
package tragicneko.tragicmc.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatBase;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.RegistryNamespaced;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLLog;
import org.apache.logging.log4j.Level;
import tragicneko.tragicmc.TragicMC;

public class TragicEntityList {
    public static RegistryNamespaced entityRegistry = new RegistryNamespaced();
    public static HashMap<Integer, EntityEggInfo> entityEggs = new LinkedHashMap<Integer, EntityEggInfo>();

    public static void addMapping(Class<? extends Entity> clazz, String name, int id) {
        if (entityRegistry.func_148741_d((Object)name)) {
            throw new IllegalArgumentException("Entity list already contains a mapping with that name! " + name);
        }
        if (entityRegistry.func_148754_a(id) != null) {
            throw new IllegalArgumentException("Entity list already contains a mapping for that id! " + id);
        }
        entityRegistry.func_177775_a(id, (Object)name, clazz);
    }

    public static void addMapping(Class<? extends Entity> clazz, String name, int id, int eggColor, int eggColor2) {
        TragicEntityList.addMapping(clazz, name, id);
        entityEggs.put(id, new EntityEggInfo(name, eggColor, eggColor2, EnumEggType.NORMAL));
    }

    public static void addMapping(Class<? extends Entity> clazz, String name, int id, int eggColor, int eggColor2, EnumEggType eggType) {
        TragicEntityList.addMapping(clazz, name, id);
        entityEggs.put(id, new EntityEggInfo(name, eggColor, eggColor2, eggType));
    }

    public static Entity createEntityByName(String name, World world) {
        Entity entity = null;
        try {
            Class oclass = (Class)entityRegistry.func_82594_a((Object)name);
            if (oclass != null) {
                entity = (Entity)oclass.getConstructor(World.class).newInstance(world);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return entity;
    }

    public static Entity createEntityFromNBT(NBTTagCompound tag, World world) {
        Entity entity = null;
        Class oclass = null;
        try {
            oclass = (Class)entityRegistry.func_82594_a((Object)tag.func_74779_i("id"));
            if (oclass != null) {
                entity = (Entity)oclass.getConstructor(World.class).newInstance(world);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (entity != null) {
            try {
                entity.func_70020_e(tag);
            }
            catch (Exception e) {
                FMLLog.log((Level)Level.ERROR, (Throwable)e, (String)"An Entity %s(%s) has thrown an exception during loading, its state cannot be restored. Report this to the mod author", (Object[])new Object[]{tag.func_74779_i("id"), oclass.getName()});
                entity = null;
            }
        } else {
            TragicMC.logWarning("Skipping Entity with id " + tag.func_74779_i("id"));
        }
        return entity;
    }

    public static Entity createEntityByID(int id, World world) {
        Entity entity = null;
        try {
            Class<? extends Entity> oclass = TragicEntityList.getClassFromID(id);
            if (oclass != null) {
                entity = oclass.getConstructor(World.class).newInstance(world);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (entity == null) {
            TragicMC.logWarning("Skipping Entity with id " + id);
        }
        return entity;
    }

    public static int getEntityID(Entity entity) {
        Integer integer = entityRegistry.func_148757_b(entity.getClass());
        return integer == null ? 0 : integer;
    }

    public static Class<? extends Entity> getClassFromID(int id) {
        return (Class)entityRegistry.func_148754_a(id);
    }

    public static String getEntityString(Entity entity) {
        return (String)(entity != null ? entityRegistry.func_177774_c(entity.getClass()) : null);
    }

    public static String getStringFromID(int id) {
        return (String)entityRegistry.func_177774_c(TragicEntityList.getClassFromID(id));
    }

    public static int getIDFromString(String string) {
        Integer integer = entityRegistry.func_148757_b(entityRegistry.func_82594_a((Object)string));
        return integer == null ? -1 : integer;
    }

    public static List getEntityNameList() {
        Set set = entityRegistry.func_148742_b();
        ArrayList arraylist = Lists.newArrayList();
        for (String s : set) {
            Class oclass = (Class)entityRegistry.func_82594_a((Object)s);
            if ((oclass.getModifiers() & 0x400) == 1024) continue;
            arraylist.add(s);
        }
        return arraylist;
    }

    public static enum EnumEggType {
        NORMAL,
        PET,
        MINIBOSS,
        BOSS,
        ALPHA;

    }

    public static class EntityEggInfo {
        public final String name;
        public final int primaryColor;
        public final int secondaryColor;
        public final StatBase killStat;
        public final StatBase killedByStat;
        public final EnumEggType eggType;

        public EntityEggInfo(String name, int par2, int par3, EnumEggType eggType) {
            this.name = name;
            this.primaryColor = par2;
            this.secondaryColor = par3;
            this.eggType = eggType;
            this.killStat = new StatBase("stat.killEntity." + name, (IChatComponent)new ChatComponentTranslation("stat.entityKill", new Object[]{new ChatComponentTranslation("entity." + name + ".name", new Object[0])})).func_75971_g();
            this.killedByStat = new StatBase("stat.entityKilledBy." + name, (IChatComponent)new ChatComponentTranslation("stat.entityKilledBy", new Object[]{new ChatComponentTranslation("entity." + name + ".name", new Object[0])})).func_75971_g();
        }
    }
}

