/*
 * Decompiled with CFR 0.152.
 */
package tragicneko.tragicmc.util;

import java.util.UUID;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.BaseAttributeMap;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import tragicneko.tragicmc.TragicMC;
import tragicneko.tragicmc.items.amulet.ItemAmulet;

public class AmuletHelper {
    private static IAttribute[] attributes = new IAttribute[]{ItemAmulet.AmuletModifier.jumpHeight, ItemAmulet.AmuletModifier.luck, ItemAmulet.AmuletModifier.reach, ItemAmulet.AmuletModifier.resistance, SharedMonsterAttributes.field_111266_c, SharedMonsterAttributes.field_111264_e, SharedMonsterAttributes.field_111267_a, SharedMonsterAttributes.field_111263_d};
    public static UUID[] uuids = new UUID[]{UUID.fromString("8d325bc1-9b36-457f-a984-50cfed8331ed"), UUID.fromString("1f5a801c-312a-4b26-aa7b-3170e63df540"), UUID.fromString("829ea197-31bf-4360-912e-93f6775fedc1"), UUID.fromString("f1695e8a-87f1-4491-bc02-90f3671d299e"), UUID.fromString("b41f1b8d-a0e7-42ee-acb4-a0f9c198626f"), UUID.fromString("237ab9b5-459c-4dcb-bcb8-4e8068ce9135"), UUID.fromString("b06dedf7-fd45-442c-93b4-8fa70bc64d51"), UUID.fromString("1ab86156-baf5-4906-bb07-314a0e7faa59")};

    public static byte getAmuletWithHighestLevel(byte par1, byte par2, byte par3) {
        if (par3 != 0) {
            if (par1 > par2 && par1 > par3) {
                return par1;
            }
            if (par2 > par1 && par2 > par3) {
                return par2;
            }
            if (par3 > par1 && par3 > par2) {
                return par3;
            }
            if (par1 == par2 && par1 == par3) {
                return par1;
            }
        } else {
            if (par1 > par2) {
                return par1;
            }
            if (par2 > par1) {
                return par2;
            }
            if (par1 == par2) {
                return par1;
            }
        }
        return (byte)(par1 * par2 * par3 / 3);
    }

    public static byte getAmuletWithHighestLevel(byte par1, byte par2) {
        return AmuletHelper.getAmuletWithHighestLevel(par1, par2, (byte)0);
    }

    public static double getStackedEfficiency(int par1, int par2, int par3) {
        double d0 = par1 / 100;
        double d1 = par2 / 100;
        double d2 = par3 / 100;
        double d3 = (1.0 - d0) * d1;
        double d4 = (1.0 - (d0 + d3)) * d2;
        return d0 + d3 + d4;
    }

    public static int getSameAmulets(ItemAmulet amu1, ItemAmulet amu2, ItemAmulet amu3) {
        if (amu1 == null) {
            if (amu2 != null && amu3 != null && amu2 == amu3) {
                return 23;
            }
            return 0;
        }
        if (amu2 == null) {
            if (amu1 != null && amu3 != null && amu1 == amu3) {
                return 13;
            }
            return 0;
        }
        if (amu3 == null) {
            if (amu1 != null && amu2 != null && amu1 == amu2) {
                return 12;
            }
            return 0;
        }
        if (amu1 == amu2 && amu1 == amu3) {
            return 123;
        }
        if (amu1 == amu2 && amu1 != amu3) {
            return 12;
        }
        if (amu1 == amu3 && amu1 != amu2) {
            return 13;
        }
        if (amu2 == amu3 && amu1 != amu3) {
            return 23;
        }
        return 0;
    }

    public static byte getAmuletLevel(ItemStack stack) {
        return stack != null && stack.func_77942_o() && stack.func_77978_p().func_74764_b("amuletLevel") ? stack.func_77978_p().func_74771_c("amuletLevel") : (byte)0;
    }

    public static AttributeModifier getRandomModifier(IAttribute attr) {
        double d0 = 0.0;
        UUID uuid = null;
        if (attr == SharedMonsterAttributes.field_111264_e) {
            d0 = 0.25 + (double)TragicMC.rand.nextInt(20) * 0.125;
            uuid = uuids[5];
        } else if (attr == SharedMonsterAttributes.field_111266_c) {
            d0 = 0.2 + (double)TragicMC.rand.nextInt(20) * 0.1;
            uuid = uuids[4];
        } else if (attr == SharedMonsterAttributes.field_111267_a) {
            d0 = 0.5 + (double)TragicMC.rand.nextInt(10) * 0.5;
            uuid = uuids[6];
        } else if (attr == SharedMonsterAttributes.field_111263_d) {
            d0 = 0.02 + (double)TragicMC.rand.nextInt(20) * 0.01;
            uuid = uuids[7];
        } else if (attr == ItemAmulet.AmuletModifier.reach) {
            d0 = 0.05 + (double)TragicMC.rand.nextInt(20) * 0.05;
            uuid = uuids[2];
        } else if (attr == ItemAmulet.AmuletModifier.jumpHeight) {
            d0 = 0.25 + (double)TragicMC.rand.nextInt(10) * 0.125;
            uuid = uuids[0];
        } else if (attr == ItemAmulet.AmuletModifier.resistance) {
            d0 = 1 + TragicMC.rand.nextInt(10);
            uuid = uuids[3];
        } else if (attr == ItemAmulet.AmuletModifier.luck) {
            d0 = 0.01 + (double)TragicMC.rand.nextInt(75) * 0.01;
            uuid = uuids[1];
        }
        d0 = attr.func_111109_a(d0);
        return uuid == null ? null : new AttributeModifier(uuid, attr.func_111108_a(), d0, 0);
    }

    public static IAttribute getRandomAttribute() {
        return attributes[TragicMC.rand.nextInt(attributes.length)];
    }

    public static NBTTagCompound writeAttributeModifierToNBT(String atrName, AttributeModifier modif) {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        nbttagcompound.func_74778_a("Name", modif.func_111166_b());
        nbttagcompound.func_74780_a("Amount", modif.func_111164_d());
        nbttagcompound.func_74768_a("Operation", modif.func_111169_c());
        nbttagcompound.func_74772_a("UUIDMost", modif.func_111167_a().getMostSignificantBits());
        nbttagcompound.func_74772_a("UUIDLeast", modif.func_111167_a().getLeastSignificantBits());
        nbttagcompound.func_74778_a("AttributeName", atrName);
        return nbttagcompound;
    }

    public static IAttribute getAttributeFromMap(BaseAttributeMap map, String s) {
        return AmuletHelper.getAttributeInstanceFromMap(map, s) != null ? AmuletHelper.getAttributeInstanceFromMap(map, s).func_111123_a() : null;
    }

    public static IAttribute getAttributeFromEntity(EntityLivingBase entity, String s) {
        return AmuletHelper.getAttributeFromMap(entity.func_110140_aT(), s);
    }

    public static IAttributeInstance getAttributeInstanceFromMap(BaseAttributeMap map, String s) {
        return map != null ? map.func_111152_a(s) : null;
    }
}

