/*
 * Decompiled with CFR 0.152.
 */
package tragicneko.tragicmc.items;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBreakable;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.BlockOldLeaf;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenBigTree;
import net.minecraft.world.gen.feature.WorldGenCanopyTree;
import net.minecraft.world.gen.feature.WorldGenForest;
import net.minecraft.world.gen.feature.WorldGenMegaJungle;
import net.minecraft.world.gen.feature.WorldGenMegaPineTree;
import net.minecraft.world.gen.feature.WorldGenSavannaTree;
import net.minecraft.world.gen.feature.WorldGenTaiga2;
import net.minecraft.world.gen.feature.WorldGenTrees;
import tragicneko.tragicmc.TragicBlocks;
import tragicneko.tragicmc.TragicConfig;
import tragicneko.tragicmc.TragicMC;
import tragicneko.tragicmc.entity.EntityDirectedLightning;
import tragicneko.tragicmc.util.WorldHelper;
import tragicneko.tragicmc.worldgen.WorldGenCustomHugeJungleTree;
import tragicneko.tragicmc.worldgen.WorldGenCustomLollipopTree;
import tragicneko.tragicmc.worldgen.WorldGenCustomOakTree;
import tragicneko.tragicmc.worldgen.WorldGenCustomSavannaTree;

public class ItemGenerator
extends Item {
    private String[] subNames = new String[]{"VoidPitGenerator", "SpikeGenerator", "StarCrystalGenerator", "SphereGenerator", "SphereEraser", "LiquidRemover", "TreeGenerator", "LightningSummoner", "ExplosionGenerator", "IsleGenerator", "DirectedLightningSummoner", "PitGenerator"};
    private String[] textureNames = new String[]{"voidPitGenerator", "spikeGenerator", "starCrystalGenerator", "sphereGenerator", "sphereEraser", "liquidRemover", "treeGenerator", "lightningSummoner", "explosionGenerator", "isleGenerator", "directedLightningSummoner", "pitGenerator"};
    private static final IBlockState jungleLog = Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)BlockPlanks.EnumType.JUNGLE);
    private static final IBlockState jungleLeaves = Blocks.field_150362_t.func_176223_P().func_177226_a((IProperty)BlockOldLeaf.field_176239_P, (Comparable)BlockPlanks.EnumType.JUNGLE).func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false));

    public ItemGenerator() {
        this.func_77637_a(TragicMC.Creative);
        this.func_77656_e(0);
        this.func_77627_a(true);
        this.func_77655_b("tragicmc.worldGen");
    }

    public void func_77624_a(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List par2List, boolean par4) {
        par2List.add("Generate some of the WorldGen features!");
        par2List.add("Some of this is really CPU intensive.");
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (world.field_72995_K) {
            return stack;
        }
        Random random = world.field_73012_v;
        int meta = stack.func_77952_i();
        Vec3 vec = WorldHelper.getVecFromEntity((Entity)player, 100.0);
        int Xcoord = MathHelper.func_76128_c((double)vec.field_72450_a);
        int Ycoord = MathHelper.func_76128_c((double)vec.field_72448_b);
        int Zcoord = MathHelper.func_76128_c((double)vec.field_72449_c);
        block0 : switch (meta) {
            case 0: {
                String[] names = TragicConfig.getStringArray("voidPitFilter");
                HashSet<Block> filter = new HashSet<Block>();
                for (String s : names) {
                    Block block = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(s));
                    if (block == null) continue;
                    filter.add(block);
                }
                if (!TragicConfig.getBoolean("voidPitUsesFilter")) {
                    filter.clear();
                }
                double size = TragicConfig.getDouble("voidPitSize");
                int pow = 0;
                while (pow + Ycoord >= 0 && pow + Ycoord <= 256) {
                    BlockPos coords;
                    int mapping;
                    ArrayList<BlockPos> list;
                    if (size >= 5.5) {
                        list = WorldHelper.getBlocksInCircularRange(world, size * 0.31773, Xcoord, Ycoord + pow, Zcoord);
                        for (mapping = 0; mapping < list.size(); ++mapping) {
                            coords = list.get(mapping);
                            if (random.nextInt(4) == 0 || filter.contains(world.func_180495_p(coords).func_177230_c())) continue;
                            world.func_175698_g(coords);
                        }
                    }
                    list = WorldHelper.getBlocksInCircularRange(world, size * 0.64773, Xcoord, Ycoord + pow, Zcoord);
                    for (mapping = 0; mapping < list.size(); ++mapping) {
                        coords = list.get(mapping);
                        if (random.nextInt(3) == 0 || filter.contains(world.func_180495_p(coords).func_177230_c())) continue;
                        world.func_175698_g(coords);
                    }
                    list = WorldHelper.getBlocksInCircularRange(world, size, Xcoord, Ycoord + pow, Zcoord);
                    for (mapping = 0; mapping < list.size(); ++mapping) {
                        coords = list.get(mapping);
                        if (!random.nextBoolean() || filter.contains(world.func_180495_p(coords).func_177230_c())) continue;
                        world.func_175698_g(coords);
                    }
                    --pow;
                }
                player.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.ITALIC + "Void pit generated with size of " + size));
                break;
            }
            case 3: {
                String[] names = TragicConfig.getStringArray("sphereFilter");
                HashSet<Block> filter = new HashSet<Block>();
                for (String s : names) {
                    Block block = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(s));
                    if (block == Blocks.field_150350_a) continue;
                    filter.add(block);
                }
                double size = TragicConfig.getDouble("sphereSize");
                ArrayList<BlockPos> list = WorldHelper.getBlocksInSphericalRange(world, size, Xcoord, Ycoord, Zcoord);
                Block ablock = TragicConfig.getBoolean("sphereGenUsesFilter") && filter.size() > 0 ? (Block)filter.toArray()[field_77697_d.nextInt(filter.size())] : Block.func_149729_e((int)random.nextInt(4096));
                int attempts = 0;
                if (!TragicConfig.getBoolean("sphereGenUsesFilter")) {
                    while (!ablock.func_149662_c() && !(ablock instanceof BlockBreakable) || ablock.hasTileEntity(ablock.func_176223_P()) || ablock instanceof BlockFalling) {
                        ablock = Block.func_149729_e((int)random.nextInt(4096));
                        if ((attempts = (int)((byte)(attempts + 1))) <= 40) continue;
                    }
                    if (!ablock.func_149662_c() && !(ablock instanceof BlockBreakable) || ablock.hasTileEntity(ablock.func_176223_P()) || ablock instanceof BlockFalling) {
                        ablock = Blocks.field_150335_W;
                    }
                }
                for (int i = 0; i < list.size(); ++i) {
                    BlockPos coords = list.get(i);
                    world.func_175656_a(coords, ablock.func_176223_P());
                }
                if (list.isEmpty() || ablock == null) break;
                String s = ablock.func_149739_a();
                player.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.ITALIC + "Sphere generated with size of " + size + " made of " + StatCollector.func_74838_a((String)(s + ".name"))));
                break;
            }
            case 4: {
                String[] names = TragicConfig.getStringArray("eraserFilter");
                HashSet<Block> filter = new HashSet<Block>();
                for (String s : names) {
                    Block block = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(s));
                    if (block == Blocks.field_150350_a) continue;
                    filter.add(block);
                }
                ArrayList<BlockPos> list = WorldHelper.getBlocksInSphericalRange(world, TragicConfig.getDouble("eraserSize"), Xcoord, Ycoord, Zcoord);
                for (int i = 0; i < list.size(); ++i) {
                    BlockPos coords = list.get(i);
                    if (TragicConfig.getBoolean("eraserUsesFilter") && filter.contains(world.func_180495_p(coords).func_177230_c())) continue;
                    world.func_175698_g(coords);
                }
                if (list.isEmpty()) break;
                player.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.ITALIC + "Spherical area erased."));
                break;
            }
            case 5: {
                ArrayList<BlockPos> list = WorldHelper.getBlocksInSphericalRange(world, TragicConfig.getDouble("eraserSize"), Xcoord, Ycoord, Zcoord);
                for (int i = 0; i < list.size(); ++i) {
                    BlockPos coords = list.get(i);
                    if (!(world.func_180495_p(coords).func_177230_c() instanceof BlockLiquid)) continue;
                    world.func_175698_g(coords);
                }
                if (list.isEmpty()) break;
                player.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.ITALIC + "Spherical area of liquid removed."));
                break;
            }
            case 6: {
                Object object;
                switch (random.nextInt(14)) {
                    default: {
                        object = new WorldGenForest(true, false);
                        break;
                    }
                    case 0: {
                        object = new WorldGenBigTree(true);
                        break;
                    }
                    case 1: {
                        object = new WorldGenSavannaTree(true);
                        break;
                    }
                    case 2: {
                        object = new WorldGenCanopyTree(true);
                        break;
                    }
                    case 3: {
                        object = new WorldGenMegaJungle(true, 10, 20, 4, 8);
                        break;
                    }
                    case 4: {
                        object = new WorldGenMegaPineTree(false, random.nextBoolean());
                        break;
                    }
                    case 5: {
                        object = new WorldGenTaiga2(true);
                        break;
                    }
                    case 6: {
                        object = new WorldGenTrees(true);
                        break;
                    }
                    case 7: {
                        object = new WorldGenCustomLollipopTree(TragicBlocks.BleachedWood.func_176223_P(), TragicBlocks.BleachedLeaves.func_176223_P());
                        break;
                    }
                    case 8: {
                        object = new WorldGenCustomSavannaTree(random.nextBoolean(), TragicBlocks.AshenWood.func_176223_P(), TragicBlocks.AshenLeaves.func_176223_P());
                        break;
                    }
                    case 9: {
                        object = new WorldGenCustomHugeJungleTree(true, random.nextInt(3) + 4, 10, TragicBlocks.PaintedLeaves.func_176223_P(), TragicBlocks.PaintedWood.func_176223_P(), TragicBlocks.Glowvine.func_176223_P());
                        break;
                    }
                    case 10: {
                        object = new WorldGenCustomOakTree(true, 6, TragicBlocks.PaintedWood.func_176223_P(), TragicBlocks.PaintedLeaves.func_176223_P());
                    }
                }
                for (int y1 = 1; y1 < 4; ++y1) {
                    for (int z1 = -1; z1 < 2; ++z1) {
                        for (int x1 = -1; x1 < 2; ++x1) {
                            world.func_175698_g(new BlockPos(Xcoord + x1, Ycoord + y1, Zcoord + z1));
                        }
                    }
                }
                if (object.func_180709_b(world, random, new BlockPos(Xcoord, Ycoord, Zcoord))) {
                    player.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.ITALIC + "Tree generated successfully"));
                    break;
                }
                player.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.ITALIC + "Tree generation failed."));
                break;
            }
            case 1: {
                String[] names = TragicConfig.getStringArray("spikeFilter");
                HashSet<Block> filter = new HashSet<Block>();
                for (String s : names) {
                    Block block = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(s));
                    if (block == Blocks.field_150350_a) continue;
                    filter.add(block);
                }
                if (!TragicConfig.getBoolean("spikeGenUsesFilter")) {
                    filter.clear();
                }
                double size = TragicConfig.getDouble("spikeSize");
                Block spike = filter.isEmpty() ? TragicBlocks.DarkStone : (Block)filter.toArray()[field_77697_d.nextInt(filter.size())];
                int blockMeta = TragicConfig.getBoolean("spikeGenUsesFilter") && !filter.isEmpty() ? 0 : 14;
                int spikeType = random.nextInt(2);
                boolean flag = false;
                player.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.ITALIC + "Spike of type " + spikeType + " and size of " + size + " generated."));
                for (int y1 = 0; y1 < 256; ++y1) {
                    if (random.nextBoolean()) {
                        size *= TragicConfig.getDouble("spikeRegression");
                        if (random.nextInt(3) == 0 && size >= 0.4888233) {
                            Xcoord += random.nextInt(2) - random.nextInt(2);
                            Zcoord += random.nextInt(2) - random.nextInt(2);
                        }
                        if (spikeType == 1 && !flag && y1 >= 35 && y1 <= 70 && random.nextBoolean() && size <= 0.774446314) {
                            size *= 2.86333567;
                            flag = true;
                        }
                    }
                    if (size < TragicConfig.getDouble("spikeCutoff") || Ycoord + y1 > 256) break block0;
                    ArrayList<BlockPos> list = WorldHelper.getBlocksInSphericalRange(world, size, Xcoord, Ycoord + y1, Zcoord);
                    for (int j = 0; j < list.size(); ++j) {
                        BlockPos coords = list.get(j);
                        world.func_180501_a(coords, spike.func_176203_a(blockMeta), 2);
                    }
                }
                break;
            }
            case 2: {
                double size = 0.35 * random.nextDouble() + 0.75;
                int blockMeta2 = random.nextInt(16);
                player.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.ITALIC + "Star Crystal with size of " + size + " generated."));
                for (int y1 = 0; y1 < 12 && !((size *= 0.91377745) < 0.444443755) && Ycoord + y1 <= 256; ++y1) {
                    ArrayList<BlockPos> list = WorldHelper.getBlocksInSphericalRange(world, size, Xcoord, (double)(Ycoord + y1) + size * 0.5, Zcoord);
                    for (int j = 0; j < list.size(); ++j) {
                        BlockPos coords = list.get(j);
                        world.func_180501_a(coords, TragicBlocks.StarCrystal.func_176203_a(blockMeta2), 2);
                    }
                }
                break;
            }
            case 7: {
                world.func_72942_c((Entity)new EntityLightningBolt(world, (double)Xcoord, (double)Ycoord, (double)Zcoord));
                player.func_145747_a((IChatComponent)new ChatComponentText("Lightning created."));
                break;
            }
            case 8: {
                float f = (float)TragicConfig.getDouble("explosionBaseSize") + (float)TragicConfig.getDouble("explosionSizeVariation") * field_77697_d.nextFloat();
                world.func_72876_a((Entity)player, (double)Xcoord, (double)Ycoord, (double)Zcoord, f, WorldHelper.getMobGriefing(world));
                player.func_145747_a((IChatComponent)new ChatComponentText("Explosion created with size of " + f));
                break;
            }
            case 9: {
                double regression = 0.88977745;
                double cutoff = 0.48943755;
                ArrayList<BlockPos> cands = new ArrayList<BlockPos>();
                double size = random.nextDouble() * 3.5 + 1.5;
                int yMax = Ycoord = world.func_175672_r(new BlockPos(Xcoord += random.nextInt(8) - random.nextInt(8), 0, Zcoord += random.nextInt(8) - random.nextInt(8))).func_177956_o() + 1 + random.nextInt(18) + 10;
                for (int y1 = 0; y1 > -32 && !(size < cutoff); --y1) {
                    size *= regression;
                    if (random.nextBoolean() && random.nextInt(6) == 0) {
                        Xcoord += random.nextInt(2) - random.nextInt(2);
                        Zcoord += random.nextInt(2) - random.nextInt(2);
                    }
                    ArrayList<BlockPos> list = WorldHelper.getBlocksInCircularRange(world, size, Xcoord, Ycoord + y1, Zcoord);
                    for (BlockPos coords2 : list) {
                        Block block = world.func_180495_p(coords2).func_177230_c();
                        if (cands.contains(coords2)) continue;
                        if (yMax < coords2.func_177956_o()) {
                            yMax = coords2.func_177956_o();
                        }
                        cands.add(coords2);
                    }
                }
                int rand = random.nextInt(4) + 2;
                for (BlockPos coords2 : cands) {
                    if (coords2.func_177956_o() >= yMax) {
                        world.func_180501_a(coords2, TragicBlocks.ErodedStone.func_176223_P(), 2);
                        continue;
                    }
                    if (coords2.func_177956_o() >= yMax - rand - random.nextInt(2)) {
                        world.func_180501_a(coords2, TragicBlocks.DeadDirt.func_176223_P(), 2);
                        continue;
                    }
                    world.func_180501_a(coords2, TragicBlocks.DarkStone.func_176223_P(), 2);
                }
                break;
            }
            case 10: {
                EntityDirectedLightning lightning = new EntityDirectedLightning(world, Xcoord, Ycoord, Zcoord, (Entity)player);
                lightning.func_70107_b(Xcoord, Ycoord, Zcoord);
                world.func_72838_d((Entity)lightning);
                player.func_145747_a((IChatComponent)new ChatComponentText("Directed Lightning created!"));
                break;
            }
            case 11: {
                int depth = Ycoord - 10 - random.nextInt(10);
                double size = 3.0 * random.nextDouble() + 3.0;
                ArrayList<BlockPos> cands = new ArrayList<BlockPos>();
                int pow = 0;
                while (pow + Ycoord >= depth && pow + Ycoord >= 0 && pow + Ycoord <= 256) {
                    BlockPos coords;
                    int mapping;
                    ArrayList<BlockPos> list;
                    if (size >= 5.5) {
                        list = WorldHelper.getBlocksInCircularRange(world, size * 0.31773, Xcoord, Ycoord + pow, Zcoord);
                        for (mapping = 0; mapping < list.size(); ++mapping) {
                            coords = list.get(mapping);
                            if (!random.nextBoolean() || cands.contains(coords)) continue;
                            cands.add(coords);
                        }
                    }
                    list = WorldHelper.getBlocksInCircularRange(world, size * 0.64773, Xcoord, Ycoord + pow, Zcoord);
                    for (mapping = 0; mapping < list.size(); ++mapping) {
                        coords = list.get(mapping);
                        if (!random.nextBoolean() || cands.contains(coords)) continue;
                        cands.add(coords);
                    }
                    list = WorldHelper.getBlocksInCircularRange(world, size, Xcoord, Ycoord + pow, Zcoord);
                    for (mapping = 0; mapping < list.size(); ++mapping) {
                        coords = list.get(mapping);
                        if (!random.nextBoolean() || cands.contains(coords)) continue;
                        cands.add(coords);
                    }
                    if (size >= 3.0 && random.nextInt(4) == 0) {
                        size *= 0.987425;
                    }
                    --pow;
                }
                Block block = random.nextBoolean() ? TragicBlocks.IceSpike : (random.nextBoolean() ? Blocks.field_150356_k : (random.nextBoolean() ? TragicBlocks.RadiatedGas : TragicBlocks.Quicksand));
                int m = block == TragicBlocks.Quicksand && random.nextBoolean() ? 3 : 0;
                for (BlockPos coords2 : cands) {
                    if (coords2.func_177956_o() > depth + 1) {
                        world.func_175698_g(coords2);
                        continue;
                    }
                    world.func_180501_a(coords2, block.func_176203_a(m), 3);
                }
                player.func_145747_a((IChatComponent)new ChatComponentText("Pit generated using " + block.func_149739_a() + " as the bottom."));
            }
        }
        return stack;
    }

    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        for (int i = 0; i < this.subNames.length; ++i) {
            list.add(new ItemStack(item, 1, i));
        }
    }

    public String func_77667_c(ItemStack itemstack) {
        int damage = itemstack.func_77952_i();
        if (damage >= this.subNames.length) {
            damage = this.subNames.length - 1;
        }
        return this.func_77658_a() + "." + this.textureNames[damage];
    }
}

