/*
 * Decompiled with CFR 0.152.
 */
package tragicneko.tragicmc.entity.mob;

import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IMerchant;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatBase;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import tragicneko.tragicmc.TragicAchievements;
import tragicneko.tragicmc.TragicBlocks;
import tragicneko.tragicmc.TragicConfig;
import tragicneko.tragicmc.TragicItems;
import tragicneko.tragicmc.entity.mob.EntityNeko;

public class EntityTraderNeko
extends EntityNeko
implements IMerchant {
    public MerchantRecipeList tradingList;
    public EntityPlayer buyer;
    private static final EntityVillager.ITradeList[][] TRADE_LIST = new EntityVillager.ITradeList[][]{{new NekiteForItem(TragicItems.NekoMindControlDevice, new EntityVillager.PriceInfo(1, 1)).setNekitePrice(8, 20), new NekiteForItem(new ItemStack(TragicBlocks.TragicSapling, 1, 5), new EntityVillager.PriceInfo(1, 1)).setNekitePrice(2, 6), new NekiteForItem(new ItemStack(TragicBlocks.NekiteWire), new EntityVillager.PriceInfo(3, 6)).setNekitePrice(5, 10), new NekiteForItem(TragicItems.WarpDrive, new EntityVillager.PriceInfo(1, 1)).setNekitePrice(22, 48), new NekiteForItem(TragicItems.InfallibleMetal, new EntityVillager.PriceInfo(6, 16)).setNekitePrice(12, 32), new NekiteForItem(Items.field_151114_aO, new EntityVillager.PriceInfo(3, 8)).setNekitePrice(2, 4)}, {new NekiteAndItemForItem(new ItemStack(TragicItems.WovenSilk), new EntityVillager.PriceInfo(4, 8), new ItemStack(TragicBlocks.NekiteWire), new EntityVillager.PriceInfo(2, 6)).setNekitePrice(4, 8), new NekiteAndItemForItem(TragicItems.Sushi, new EntityVillager.PriceInfo(3, 6), TragicItems.GoldenSushi, new EntityVillager.PriceInfo(1, 3)).setNekitePrice(12, 24), new NekiteAndItemForItem(new ItemStack(Items.field_151114_aO), new EntityVillager.PriceInfo(2, 5), new ItemStack(TragicBlocks.NekitePlate, 1, 0), new EntityVillager.PriceInfo(1, 3)).setNekitePrice(2, 5)}, {new NekiteForItem(TragicItems.GoldenSushi, new EntityVillager.PriceInfo(1, 3)).setNekitePrice(16, 32), new NekiteForItem(Items.field_151045_i, new EntityVillager.PriceInfo(1, 3)).setNekitePrice(12, 28), new NekiteForItem(Items.field_151166_bC, new EntityVillager.PriceInfo(1, 3)).setNekitePrice(16, 34), new NekiteForItem(Items.field_151074_bl, new EntityVillager.PriceInfo(3, 8)).setNekitePrice(12, 32), new NekiteForItem(TragicItems.Ruby, new EntityVillager.PriceInfo(1, 3)).setNekitePrice(20, 48), new NekiteForItem(TragicItems.Sapphire, new EntityVillager.PriceInfo(1, 3)).setNekitePrice(20, 48)}, {new ItemForNekite(TragicItems.GoldenSushi, new EntityVillager.PriceInfo(1, 3)).setNekitePrice(6, 15), new ItemForNekite(TragicItems.Sushi, new EntityVillager.PriceInfo(4, 8)).setNekitePrice(3, 12), new ItemForNekite(Items.field_151016_H, new EntityVillager.PriceInfo(12, 32)).setNekitePrice(2, 4), new ItemForNekite(new ItemStack(Blocks.field_150335_W), new EntityVillager.PriceInfo(1, 4)).setNekitePrice(16, 32)}, {new ItemForNekite(TragicItems.UnstableIsotope, new EntityVillager.PriceInfo(2, 6)).setNekitePrice(6, 22), new ItemForNekite(TragicItems.ComplexCircuitry, new EntityVillager.PriceInfo(2, 6)).setNekitePrice(6, 22), new ItemForNekite(TragicItems.NekoMindControlDevice, new EntityVillager.PriceInfo(1, 1)).setNekitePrice(4, 8)}, {new NekiteAndItemForItem(new ItemStack(TragicBlocks.NekitePlate, 1, 4), new EntityVillager.PriceInfo(4, 8), new ItemStack(Items.field_151074_bl), new EntityVillager.PriceInfo(5, 10)).setNekitePrice(4, 8), new NekiteAndItemForItem(TragicItems.Wrench, new EntityVillager.PriceInfo(1, 3), Items.field_151042_j, new EntityVillager.PriceInfo(1, 3)).setNekitePrice(4, 8), new NekiteAndItemForItem(new ItemStack(TragicBlocks.NekitePlate, 1, 0), new EntityVillager.PriceInfo(1, 3), new ItemStack(Items.field_151045_i), new EntityVillager.PriceInfo(1, 3)).setNekitePrice(2, 6), new NekiteAndItemForItem(new ItemStack(TragicBlocks.NekitePlate, 1, 0), new EntityVillager.PriceInfo(1, 3), new ItemStack(Items.field_151166_bC), new EntityVillager.PriceInfo(1, 3)).setNekitePrice(2, 6), new NekiteAndItemForItem(new ItemStack(TragicBlocks.NekitePlate, 1, 0), new EntityVillager.PriceInfo(1, 3), new ItemStack(TragicItems.Ruby), new EntityVillager.PriceInfo(1, 3)).setNekitePrice(2, 6), new NekiteAndItemForItem(new ItemStack(TragicBlocks.NekitePlate, 1, 0), new EntityVillager.PriceInfo(1, 3), new ItemStack(TragicItems.Sapphire), new EntityVillager.PriceInfo(1, 3)).setNekitePrice(2, 6)}, {new NekiteAndItemForItem(Items.field_151079_bi, new EntityVillager.PriceInfo(1, 3), TragicItems.WarpDrive, new EntityVillager.PriceInfo(1, 1)).setNekitePrice(6, 12), new NekiteAndItemForItem(new ItemStack(TragicItems.NekoidStrain), new EntityVillager.PriceInfo(1, 2), new ItemStack(Items.field_151153_ao, 1, 1), new EntityVillager.PriceInfo(1, 3)).setNekitePrice(4, 16)}};
    public static final int DW_TEXTURE = 25;

    public EntityTraderNeko(World par1World) {
        super(par1World);
        this.field_70728_aV = 25;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(25, (Object)0);
    }

    public int getTextureId() {
        return this.field_70180_af.func_75679_c(25);
    }

    private void setTextureId(int i) {
        this.field_70180_af.func_75692_b(25, (Object)i);
    }

    @Override
    public IEntityLivingData func_180482_a(DifficultyInstance ins, IEntityLivingData data) {
        if (!this.field_70170_p.field_72995_K) {
            this.setTextureId(this.field_70146_Z.nextInt(7));
        }
        return super.func_180482_a(ins, data);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        double[] traderNekoStats = TragicConfig.getMobStat("traderNekoStats").getStats();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(traderNekoStats[0]);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(traderNekoStats[1]);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(traderNekoStats[2]);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(traderNekoStats[3]);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(traderNekoStats[4]);
    }

    public int func_70658_aO() {
        return TragicConfig.getMobStat("traderNekoStats").getArmorValue();
    }

    @Override
    protected void updateNekoTasks() {
        this.field_70714_bg.func_85156_a(this.attackOnCollide);
        this.field_70714_bg.func_85156_a(this.moveTowardsTarget);
        this.field_70715_bh.func_85156_a(this.hurtByNekos);
        this.field_70715_bh.func_85156_a(this.targetPlayers);
        this.field_70715_bh.func_85156_a(this.targetUnreleasedNekos);
        this.field_70715_bh.func_85156_a(this.targetNekoid);
    }

    @Override
    public int getDropAmount() {
        return 1;
    }

    public void func_70932_a_(EntityPlayer player) {
        this.buyer = player;
    }

    public EntityPlayer func_70931_l_() {
        return this.buyer;
    }

    public MerchantRecipeList func_70934_b(EntityPlayer player) {
        if (this.tradingList == null || this.tradingList.size() < 1) {
            this.populateTradingList();
        }
        return this.tradingList;
    }

    public void func_70930_a(MerchantRecipeList recipeList) {
    }

    public void func_70933_a(MerchantRecipe recipe) {
        if (!this.field_70170_p.field_72995_K && this.buyer != null) {
            if (TragicConfig.getBoolean("allowAchievements")) {
                this.buyer.func_71029_a((StatBase)TragicAchievements.tragicNekoTrader);
            }
            if (!TragicConfig.getBoolean("allowMobSounds") || this.field_70757_a > -80) {
                return;
            }
            this.field_70757_a -= this.func_70627_aG();
            this.field_70170_p.func_72956_a((Entity)this, "tragicmc:mob.traderneko.tradeaccept", 1.0f, 1.0f);
        }
    }

    public void func_110297_a_(ItemStack stack) {
        if (!this.field_70170_p.field_72995_K && stack == null && TragicConfig.getBoolean("allowMobSounds") && this.field_70146_Z.nextInt(4) == 0 && this.field_70757_a > -160) {
            this.field_70757_a -= this.func_70627_aG();
            this.field_70170_p.func_72956_a((Entity)this, "tragicmc:mob.traderneko.tradedecline", 1.0f, 1.0f);
        }
    }

    public boolean canTrade() {
        return this.buyer == null && (this.isReleased() && TragicConfig.getBoolean("traderNekoReleaseTrading") || !TragicConfig.getBoolean("traderNekoReleaseTrading")) && TragicConfig.getBoolean("traderNekoTrading");
    }

    @Override
    public boolean func_70085_c(EntityPlayer player) {
        boolean flag;
        ItemStack itemstack = player.field_71071_by.func_70448_g();
        boolean bl = flag = itemstack != null && (itemstack.func_77973_b() == Items.field_151063_bx || itemstack.func_77973_b() == Items.field_151058_ca);
        if (!flag && this.func_70089_S() && !player.func_70093_af() && (this.canTrade() || player.field_71075_bZ.field_75098_d)) {
            if (!(this.field_70170_p.field_72995_K || this.tradingList != null && this.tradingList.size() <= 0)) {
                this.func_70932_a_(player);
                player.func_180472_a((IMerchant)this);
            }
            return true;
        }
        if (!this.field_70170_p.field_72995_K && this.buyer != null && this.buyer != player) {
            player.func_145747_a((IChatComponent)new ChatComponentText(this.func_145748_c_() + " is currently trading with " + this.buyer.func_145748_c_()));
        }
        return super.func_70085_c(player);
    }

    private void populateTradingList() {
        if (this.tradingList == null) {
            this.tradingList = new MerchantRecipeList();
        }
        int k = this.field_70146_Z.nextInt(TRADE_LIST.length - this.field_70146_Z.nextInt(4)) + 4;
        for (int j = 0; j < k && j < TRADE_LIST.length; ++j) {
            EntityVillager.ITradeList[] list = TRADE_LIST[j];
            EntityVillager.ITradeList entry = list[this.field_70146_Z.nextInt(list.length)];
            if (entry == null) continue;
            entry.func_179401_a(this.tradingList, this.field_70146_Z);
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        if (this.tradingList != null) {
            tagCompound.func_74782_a("Trades", (NBTBase)this.tradingList.func_77202_a());
        }
        tagCompound.func_74768_a("textureID", this.getTextureId());
    }

    @Override
    public void func_70037_a(NBTTagCompound tagCompound) {
        super.func_70037_a(tagCompound);
        if (tagCompound.func_150297_b("Trades", 10)) {
            NBTTagCompound nbttagcompound = tagCompound.func_74775_l("Trades");
            this.tradingList = new MerchantRecipeList(nbttagcompound);
        }
        if (tagCompound.func_74764_b("textureID")) {
            this.setTextureId(tagCompound.func_74762_e("textureID"));
        }
    }

    @Override
    protected boolean func_70692_ba() {
        return false;
    }

    @Override
    public String func_70639_aQ() {
        return TragicConfig.getBoolean("allowMobSounds") && this.buyer == null ? "tragicmc:mob.traderneko.idle" : null;
    }

    @Override
    public String func_70621_aR() {
        return TragicConfig.getBoolean("allowMobSounds") && this.field_70146_Z.nextInt(4) == 0 ? "tragicmc:mob.traderneko.hurt" : super.func_70621_aR();
    }

    @Override
    public String func_70673_aS() {
        return TragicConfig.getBoolean("allowMobSounds") ? "tragicmc:mob.traderneko.death" : null;
    }

    @Override
    public float func_70647_i() {
        return 1.0f;
    }

    @Override
    public float func_70599_aP() {
        return 1.0f;
    }

    @Override
    public boolean isBuffExempt() {
        return true;
    }

    public static class ItemForNekite
    implements EntityVillager.ITradeList {
        public ItemStack itemToBuy;
        public EntityVillager.PriceInfo priceInfo;
        public EntityVillager.PriceInfo nekitePriceInfo;

        public ItemForNekite(Item par1Item, EntityVillager.PriceInfo priceInfo) {
            this.itemToBuy = new ItemStack(par1Item);
            this.priceInfo = priceInfo;
        }

        public ItemForNekite(ItemStack stack, EntityVillager.PriceInfo priceInfo) {
            this.itemToBuy = stack;
            this.priceInfo = priceInfo;
        }

        public ItemForNekite setNekitePrice(int i, int j) {
            this.nekitePriceInfo = new EntityVillager.PriceInfo(i, j);
            return this;
        }

        public void func_179401_a(MerchantRecipeList recipeList, Random random) {
            int i = 1;
            if (this.priceInfo != null) {
                i = this.priceInfo.func_179412_a(random);
            }
            int j = 1;
            if (this.nekitePriceInfo != null) {
                j = this.nekitePriceInfo.func_179412_a(random);
            }
            recipeList.add((Object)new MerchantRecipe(new ItemStack(this.itemToBuy.func_77973_b(), i, this.itemToBuy.func_77960_j()), new ItemStack(TragicItems.Nekite, j, 0)));
        }
    }

    public static class NekiteForItem
    implements EntityVillager.ITradeList {
        public ItemStack sellItem;
        public EntityVillager.PriceInfo price;
        public EntityVillager.PriceInfo nekitePrice;

        public NekiteForItem(Item itemIn, EntityVillager.PriceInfo priceIn) {
            this.sellItem = new ItemStack(itemIn);
            this.price = priceIn;
        }

        public NekiteForItem(ItemStack stack, EntityVillager.PriceInfo price) {
            this.sellItem = stack;
            this.price = price;
        }

        public NekiteForItem setNekitePrice(int i, int j) {
            this.nekitePrice = new EntityVillager.PriceInfo(i, j);
            return this;
        }

        public void func_179401_a(MerchantRecipeList recipeList, Random random) {
            int i = 1;
            if (this.price != null) {
                i = this.price.func_179412_a(random);
            }
            int j = 1;
            if (this.nekitePrice != null) {
                j = this.nekitePrice.func_179412_a(random);
            }
            recipeList.add((Object)new MerchantRecipe(new ItemStack(TragicItems.Nekite, j, 0), new ItemStack(this.sellItem.func_77973_b(), i, this.sellItem.func_77960_j())));
        }
    }

    public static class NekiteAndItemForItem
    implements EntityVillager.ITradeList {
        public ItemStack buyingItemStack;
        public EntityVillager.PriceInfo buyingPriceInfo;
        public ItemStack sellingItemstack;
        public EntityVillager.PriceInfo sellingPriceInfo;
        public EntityVillager.PriceInfo nekitePriceInfo;

        public NekiteAndItemForItem(Item item, EntityVillager.PriceInfo priceInfo, Item item2, EntityVillager.PriceInfo priceInfo2) {
            this.buyingItemStack = new ItemStack(item);
            this.buyingPriceInfo = priceInfo;
            this.sellingItemstack = new ItemStack(item2);
            this.sellingPriceInfo = priceInfo2;
        }

        public NekiteAndItemForItem(ItemStack item, EntityVillager.PriceInfo priceInfo, ItemStack item2, EntityVillager.PriceInfo priceInfo2) {
            this.buyingItemStack = item;
            this.buyingPriceInfo = priceInfo;
            this.sellingItemstack = item2;
            this.sellingPriceInfo = priceInfo2;
        }

        public NekiteAndItemForItem setNekitePrice(int i, int j) {
            this.nekitePriceInfo = new EntityVillager.PriceInfo(i, j);
            return this;
        }

        public void func_179401_a(MerchantRecipeList recipeList, Random random) {
            int i = 1;
            if (this.buyingPriceInfo != null) {
                i = this.buyingPriceInfo.func_179412_a(random);
            }
            int j = 1;
            if (this.sellingPriceInfo != null) {
                j = this.sellingPriceInfo.func_179412_a(random);
            }
            int k = 1;
            if (this.nekitePriceInfo != null) {
                k = this.nekitePriceInfo.func_179412_a(random);
            }
            recipeList.add((Object)new MerchantRecipe(new ItemStack(this.buyingItemStack.func_77973_b(), i, this.buyingItemStack.func_77960_j()), new ItemStack(TragicItems.Nekite, k), new ItemStack(this.sellingItemstack.func_77973_b(), j, this.sellingItemstack.func_77960_j())));
        }
    }
}

