/*
 * Decompiled with CFR 0.152.
 */
package tragicneko.tragicmc.entity.mob;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFleeSun;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockPos;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import tragicneko.tragicmc.TragicConfig;
import tragicneko.tragicmc.TragicEntities;
import tragicneko.tragicmc.entity.mob.TragicMob;
import tragicneko.tragicmc.entity.projectile.EntityPumpkinbomb;
import tragicneko.tragicmc.util.WorldHelper;

public class EntityPumpkinhead
extends TragicMob {
    public static final int DW_MOD_VALUE = 20;
    public static final int DW_HOME_COORD_X = 21;
    public static final int DW_HOME_COORD_Y = 22;
    public static final int DW_HOME_COORD_Z = 23;
    public static final int DW_ANGER_TICKS = 24;

    public EntityPumpkinhead(World par1World) {
        super(par1World);
        this.func_70105_a(0.675f, 2.215f);
        this.field_70728_aV = 50;
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIFleeSun((EntityCreature)this, 1.2));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityLivingBase.class, 32.0f));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, EntityLivingBase.class, 1.0, true));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIMoveTowardsTarget((EntityCreature)this, 1.0, 32.0f));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.65));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
    }

    @Override
    public boolean canCorrupt() {
        return false;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(20, (Object)Float.valueOf(2.0f));
        this.field_70180_af.func_75682_a(21, (Object)0);
        this.field_70180_af.func_75682_a(22, (Object)0);
        this.field_70180_af.func_75682_a(23, (Object)0);
        this.field_70180_af.func_75682_a(24, (Object)0);
    }

    public float getModValue() {
        return this.field_70180_af.func_111145_d(20);
    }

    private void setModValue(float f) {
        this.field_70180_af.func_75692_b(20, (Object)Float.valueOf(f));
    }

    private void resetModValue() {
        this.field_70180_af.func_75692_b(20, (Object)Float.valueOf(2.0f));
    }

    public BlockPos getHomeCoordinates() {
        return new BlockPos(this.field_70180_af.func_75679_c(21), this.field_70180_af.func_75679_c(22), this.field_70180_af.func_75679_c(23));
    }

    private void setHomeCoordinates(BlockPos pos) {
        this.field_70180_af.func_75692_b(21, (Object)pos.func_177958_n());
        this.field_70180_af.func_75692_b(22, (Object)pos.func_177956_o());
        this.field_70180_af.func_75692_b(23, (Object)pos.func_177952_p());
        this.func_175449_a(pos, 12);
    }

    public boolean hasHomePumpkin() {
        BlockPos coords = this.getHomeCoordinates();
        return this.field_70170_p.func_180495_p(coords).func_177230_c() == Blocks.field_150423_aK || this.field_70170_p.func_180495_p(coords).func_177230_c() == Blocks.field_150428_aP;
    }

    public int getAngerTicks() {
        return this.field_70180_af.func_75679_c(24);
    }

    private void setAngerTicks(int i) {
        this.field_70180_af.func_75692_b(24, (Object)i);
    }

    private void incrementAngerTicks() {
        int pow = this.getAngerTicks();
        this.setAngerTicks(++pow);
    }

    public boolean isAngry() {
        return this.getAngerTicks() > 0;
    }

    public EnumCreatureAttribute func_70668_bt() {
        return TragicEntities.Natural;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        double[] pumpkinheadStats = TragicConfig.getMobStat("pumpkinheadStats").getStats();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(pumpkinheadStats[0]);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(pumpkinheadStats[1]);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(pumpkinheadStats[2]);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(pumpkinheadStats[3]);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(pumpkinheadStats[4]);
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70170_p.field_72995_K) {
            if (this.hasHomePumpkin() && this.field_70146_Z.nextBoolean()) {
                if (this.field_70146_Z.nextBoolean()) {
                    double d0 = (double)this.getHomeCoordinates().func_177958_n() - this.field_70165_t + 0.5;
                    double d1 = (double)this.getHomeCoordinates().func_177956_o() - this.field_70163_u - 0.5;
                    double d2 = (double)this.getHomeCoordinates().func_177952_p() - this.field_70161_v + 0.5;
                    for (int i = 0; i < 4; ++i) {
                        double d3 = 0.23 * (double)i + this.field_70146_Z.nextDouble() * 0.25;
                        this.field_70170_p.func_175688_a(EnumParticleTypes.FLAME, this.field_70165_t + d0 * d3, this.field_70163_u + d1 * d3 + 1.45, this.field_70161_v + d2 * d3, 0.0, 0.0, 0.0, new int[0]);
                    }
                }
                for (int i = 0; i < 2; ++i) {
                    this.field_70170_p.func_175688_a(EnumParticleTypes.FLAME, this.field_70165_t + this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble(), this.field_70163_u, this.field_70161_v + this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble(), 0.0, this.field_70146_Z.nextDouble() * 0.175, 0.0, new int[0]);
                }
            }
            return;
        }
        if (!this.hasHomePumpkin() && this.field_70173_aa % 120 == 0 && this.isPumpkinNearby()) {
            this.setHomeCoordinates(this.getNearbyPumpkin());
        }
        if (this.func_70027_ad()) {
            this.func_70097_a(DamageSource.field_76370_b, 1.0f);
        } else if (this.field_70173_aa % 60 == 0 && this.func_110143_aJ() < this.func_110138_aP()) {
            this.func_70691_i(3.0f);
        }
        if (this.func_70638_az() != null) {
            this.incrementAngerTicks();
        } else {
            this.setAngerTicks(0);
            this.resetModValue();
        }
        if (!this.hasHomePumpkin()) {
            this.func_110177_bN();
            this.setAngerTicks(0);
            this.resetModValue();
        }
        if (TragicConfig.getBoolean("pumpkinheadHaste")) {
            AttributeModifier mod = new AttributeModifier(UUID.fromString("2042ddcd-b29a-474f-acda-00ec1a2b4a2e"), "pumpkinheadHaste", (double)this.getModValue(), 0);
            this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111124_b(mod);
            this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111121_a(mod);
            if (this.getAngerTicks() % 100 == 0 && this.isAngry() && this.hasHomePumpkin()) {
                this.setModValue(this.getModValue() + 2.0f);
            }
        }
        if (this.func_110143_aJ() <= this.func_110138_aP() / 4.0f && this.hasHomePumpkin() && this.field_70146_Z.nextInt(4) == 0 && this.field_70173_aa % 10 == 0 && TragicConfig.getBoolean("pumpkinheadPumpkinbombs")) {
            for (int x = 0; x < 6; x = (int)((byte)(x + 1))) {
                EntityPumpkinbomb bomb = new EntityPumpkinbomb(this.field_70170_p, (EntityLivingBase)this);
                bomb.field_70159_w = bomb.field_70179_y = this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble();
                bomb.field_70181_x = this.field_70146_Z.nextDouble() * 1.15;
                bomb.func_70107_b(this.field_70165_t + bomb.field_70159_w * 0.115, this.field_70163_u + 1.5 + bomb.field_70181_x * 0.115, this.field_70161_v + bomb.field_70179_y * 0.115);
                this.field_70170_p.func_72838_d((Entity)bomb);
            }
        }
    }

    public int func_70658_aO() {
        int i = TragicConfig.getMobStat("pumpkinheadStats").getArmorValue();
        return this.hasHomePumpkin() ? i : MathHelper.func_76128_c((double)(i / 3));
    }

    public boolean isPumpkinNearby() {
        ArrayList<BlockPos> list = WorldHelper.getBlocksInSphericalRange(this.field_70170_p, 6.0, this.field_70165_t, this.field_70163_u, this.field_70161_v);
        for (int i = 0; i < list.size(); ++i) {
            BlockPos coords = list.get(i);
            if (this.field_70170_p.func_180495_p(coords).func_177230_c() != Blocks.field_150423_aK && this.field_70170_p.func_180495_p(coords).func_177230_c() != Blocks.field_150428_aP) continue;
            return true;
        }
        return false;
    }

    public BlockPos getNearbyPumpkin() {
        ArrayList<BlockPos> list = WorldHelper.getBlocksInSphericalRange(this.field_70170_p, 6.0, this.field_70165_t, this.field_70163_u, this.field_70161_v);
        for (int i = 0; i < list.size(); ++i) {
            BlockPos coords = list.get(i);
            if (this.field_70170_p.func_180495_p(coords).func_177230_c() != Blocks.field_150423_aK && this.field_70170_p.func_180495_p(coords).func_177230_c() != Blocks.field_150428_aP) continue;
            return coords;
        }
        return null;
    }

    public void createHomePumpkin() {
        if (!TragicConfig.getBoolean("pumpkinheadPumpkinSpawn")) {
            return;
        }
        ArrayList<BlockPos> list = WorldHelper.getBlocksInSphericalRange(this.field_70170_p, 6.0, this.field_70165_t, this.field_70163_u, this.field_70161_v);
        for (int i = 0; i < list.size(); ++i) {
            BlockPos coords = list.get(i);
            Block block = this.field_70170_p.func_180495_p(coords).func_177230_c();
            if (!block.canBeReplacedByLeaves((IBlockAccess)this.field_70170_p, coords) || !World.func_175683_a((IBlockAccess)this.field_70170_p, (BlockPos)coords.func_177977_b())) continue;
            this.field_70170_p.func_175656_a(coords, Blocks.field_150428_aP.func_176223_P());
            this.setHomeCoordinates(coords);
            break;
        }
    }

    @Override
    public boolean func_70097_a(DamageSource par1DamageSource, float par2) {
        if (this.field_70170_p.field_72995_K) {
            return false;
        }
        boolean result = super.func_70097_a(par1DamageSource, par2);
        if (result && par1DamageSource.func_76346_g() != null && par1DamageSource.func_76346_g() instanceof EntityLivingBase && this.field_70146_Z.nextBoolean() && !par1DamageSource.func_82725_o()) {
            List list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72314_b(12.0, 12.0, 12.0));
            for (int i = 0; i < list.size(); ++i) {
                if (!(list.get(i) instanceof EntityPumpkinhead)) continue;
                EntityPumpkinhead mob = (EntityPumpkinhead)((Object)list.get(i));
                if (mob.func_70638_az() == null && this.func_70638_az() != null) {
                    mob.func_70624_b(this.func_70638_az());
                }
                if (mob.getHomeCoordinates() != this.getHomeCoordinates() || !mob.hasHomePumpkin() || !this.hasHomePumpkin()) continue;
                mob.func_70097_a(DamageSource.field_76376_m, 1.0f);
            }
        }
        return result;
    }

    @Override
    public IEntityLivingData func_180482_a(DifficultyInstance ins, IEntityLivingData data) {
        if (!this.isPumpkinNearby()) {
            if (this.field_70146_Z.nextInt(32) == 0 && this.getMobGriefing()) {
                this.createHomePumpkin();
            }
        } else {
            this.setHomeCoordinates(this.getNearbyPumpkin());
        }
        return super.func_180482_a(ins, data);
    }

    @Override
    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        if (tag.func_74764_b("homeCoords")) {
            this.setHomeCoordinates(EntityPumpkinhead.convertArrayToPos(tag.func_74759_k("homeCoords")));
        }
        if (tag.func_74764_b("angerTicks")) {
            this.setAngerTicks(tag.func_74762_e("angerTicks"));
        }
        if (tag.func_74764_b("modValue")) {
            this.setModValue(tag.func_74760_g("modValue"));
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        if (this.hasHomePumpkin()) {
            tag.func_74783_a("homeCoords", EntityPumpkinhead.convertPosToArray(this.getHomeCoordinates()));
        }
        tag.func_74768_a("angerTicks", this.getAngerTicks());
        tag.func_74776_a("modValue", this.getModValue());
    }

    @Override
    protected boolean isChangeAllowed() {
        return false;
    }

    public int func_70641_bl() {
        return 1;
    }

    public String func_70639_aQ() {
        return TragicConfig.getBoolean("allowMobSounds") ? (this.isAngry() ? "tragicmc:mob.pumpkinhead.angry" : "tragicmc:mob.pumpkinhead.living") : null;
    }

    public String func_70621_aR() {
        return TragicConfig.getBoolean("allowMobSounds") ? "tragicmc:mob.pumpkinhead.hiss" : super.func_70621_aR();
    }

    public String func_70673_aS() {
        return TragicConfig.getBoolean("allowMobSounds") ? "tragicmc:mob.pumpkinhead.death" : null;
    }

    public float func_70647_i() {
        return 0.8f;
    }

    public float func_70599_aP() {
        return 0.4f + this.field_70146_Z.nextFloat() * 0.2f;
    }

    public int func_70627_aG() {
        return this.isAngry() ? 40 : 320;
    }

    public static int[] convertPosToArray(BlockPos pos) {
        return new int[]{pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()};
    }

    public static BlockPos convertArrayToPos(int[] array) {
        return new BlockPos(array[0], array[1], array[2]);
    }
}

