/*
 * Decompiled with CFR 0.152.
 */
package tragicneko.tragicmc.entity.mob;

import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.stats.StatBase;
import net.minecraft.util.BlockPos;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import tragicneko.tragicmc.TragicAchievements;
import tragicneko.tragicmc.TragicConfig;
import tragicneko.tragicmc.TragicPotion;
import tragicneko.tragicmc.entity.mob.TragicMob;
import tragicneko.tragicmc.entity.projectile.EntityDarkMortor;

public class EntityPsygote
extends TragicMob {
    public static final int DW_FIRING_TICKS = 20;
    public static final int DW_SWITCH_TICKS = 21;
    public static final int DW_HURT_TIME = 22;
    private AttributeModifier mod = new AttributeModifier(UUID.fromString("1e8bc939-443c-46b6-8158-0d53513a47e6"), "psygoteSpeedDebuff", TragicConfig.modifier[8], 0);
    private boolean hasTeleported = false;

    public EntityPsygote(World par1World) {
        super(par1World);
        this.func_70105_a(0.72f, 1.45f);
        this.field_70138_W = 2.0f;
        this.field_70728_aV = 100;
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.75));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityLivingBase.class, 16.0f));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIMoveTowardsTarget((EntityCreature)this, 1.0, 32.0f));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, playerTarget, 8.0f, 1.6, 2.2));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true, false, playerTarget));
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(20, (Object)0);
        this.field_70180_af.func_75682_a(21, (Object)0);
        this.field_70180_af.func_75682_a(22, (Object)0);
    }

    public int getFiringTicks() {
        return this.field_70180_af.func_75679_c(20);
    }

    private void setFiringTicks(int i) {
        this.field_70180_af.func_75692_b(20, (Object)i);
    }

    private void decrementFiringTicks() {
        this.setFiringTicks(this.getFiringTicks() - 1);
    }

    public int getSwitchTicks() {
        return this.field_70180_af.func_75679_c(21);
    }

    private void setSwitchTicks(int i) {
        this.field_70180_af.func_75692_b(21, (Object)i);
    }

    private void decrementSwitchTicks() {
        this.setSwitchTicks(this.getSwitchTicks() - 1);
    }

    public int getHurtTime() {
        return this.field_70180_af.func_75679_c(22);
    }

    private void setHurtTime(int i) {
        this.field_70180_af.func_75692_b(22, (Object)i);
    }

    private void decrementHurtTime() {
        this.setHurtTime(this.getHurtTime() - 1);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        double[] psygoteStats = TragicConfig.getMobStat("psygoteStats").getStats();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(psygoteStats[0]);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(psygoteStats[1]);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(psygoteStats[2]);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(psygoteStats[3]);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(psygoteStats[4]);
    }

    @Override
    public void func_70636_d() {
        if (!this.field_70170_p.field_72995_K && this.func_82165_m(Potion.field_82731_v.field_76415_H)) {
            this.func_82170_o(Potion.field_82731_v.field_76415_H);
        }
        super.func_70636_d();
        if (!this.field_70122_E && this.field_70181_x < 0.0) {
            this.field_70181_x *= 0.58;
        }
        this.field_70143_R = 0.0f;
        if (this.field_70170_p.field_72995_K) {
            for (int l = 0; l < 2; ++l) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, this.field_70165_t + (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble()) * (double)this.field_70130_N * 1.5, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble()) * (double)this.field_70130_N * 1.5, (this.field_70146_Z.nextDouble() - 0.6) * 0.1, this.field_70146_Z.nextDouble() * 0.1, (this.field_70146_Z.nextDouble() - 0.6) * 0.1, new int[0]);
                if (this.getSwitchTicks() <= 0) continue;
                this.field_70170_p.func_175688_a(EnumParticleTypes.PORTAL, this.field_70165_t + (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble()) * (double)this.field_70130_N * 1.5, this.field_70163_u + this.field_70146_Z.nextDouble() + (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble()) * (double)this.field_70130_N * 1.5, (this.field_70146_Z.nextDouble() - 0.6) * 0.1, this.field_70146_Z.nextDouble() * -0.8 - 2.4, (this.field_70146_Z.nextDouble() - 0.6) * 0.1, new int[0]);
                if (this.getSwitchTicks() != 3) continue;
                this.func_85030_a("tragicmc:mob.psygote.coo", 0.6f, 1.0f);
            }
            return;
        }
        if (this.getFiringTicks() > 0) {
            this.decrementFiringTicks();
        }
        if (this.getSwitchTicks() > 0) {
            this.decrementSwitchTicks();
        }
        if (this.getHurtTime() > 0) {
            this.decrementHurtTime();
        }
        if (this.func_70638_az() == null || (double)this.func_70032_d((Entity)this.func_70638_az()) <= 8.0) {
            if (this.getFiringTicks() > 0) {
                this.setFiringTicks(0);
            }
            if (this.getSwitchTicks() > 0) {
                this.setSwitchTicks(0);
            }
            if (this.func_70638_az() != null && this.field_70173_aa % 10 == 0 && TragicConfig.getBoolean("psygoteProjectiles")) {
                this.fireOneMortor();
            }
        }
        if (this.getSwitchTicks() > 0) {
            this.setFiringTicks(0);
        }
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111124_b(this.mod);
        if (this.getFiringTicks() >= 40 || this.getSwitchTicks() > 0) {
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111121_a(this.mod);
        }
        if (this.func_70638_az() != null && this.func_70032_d((Entity)this.func_70638_az()) >= 6.0f && this.field_70146_Z.nextInt(48) == 0 && this.getFiringTicks() == 0 && this.getSwitchTicks() == 0) {
            this.setFiringTicks(100);
        }
        if (this.getFiringTicks() == 0 && this.func_70638_az() != null && this.func_70032_d((Entity)this.func_70638_az()) >= 8.0f && this.getFiringTicks() == 0 && this.getSwitchTicks() == 0 && this.field_70146_Z.nextInt(48) == 0) {
            this.setSwitchTicks(60);
        }
        if (this.getFiringTicks() >= 60 && this.field_70173_aa % 5 == 0 && this.func_70638_az() != null && TragicConfig.getBoolean("psygoteProjectiles")) {
            this.shootProjectiles();
        }
        if (this.getSwitchTicks() == 2 && this.func_70638_az() != null && TragicConfig.getBoolean("psygoteSwapTeleport")) {
            this.switchPlaces();
        }
        if (this.field_70173_aa % 20 == 0 && this.func_110143_aJ() < this.func_110138_aP() && TragicConfig.getBoolean("psygoteRegeneration")) {
            this.func_70691_i(3.0f);
        }
        if (this.field_70173_aa % 5 == 0 && this.func_70638_az() != null && this.field_70146_Z.nextInt(128) == 0 && TragicConfig.getBoolean("allowInhibit") && this.func_70685_l((Entity)this.func_70638_az())) {
            this.func_70638_az().func_70690_d(new PotionEffect(TragicPotion.Inhibit.field_76415_H, 120));
        }
        if (this.field_70173_aa % 5 == 0 && this.func_70638_az() != null && this.field_70146_Z.nextInt(32) == 0 && this.func_70032_d((Entity)this.func_70638_az()) <= 8.0f && this.func_70685_l((Entity)this.func_70638_az())) {
            this.func_70638_az().func_70690_d(new PotionEffect(Potion.field_76440_q.field_76415_H, 120));
        }
    }

    private void switchPlaces() {
        double x = this.func_70638_az().field_70165_t;
        double y = this.func_70638_az().field_70163_u;
        double z = this.func_70638_az().field_70161_v;
        double x2 = this.field_70165_t;
        double y2 = this.field_70163_u;
        double z2 = this.field_70161_v;
        if (this.func_70638_az() instanceof EntityPlayerMP) {
            if (this.teleportPlayer((EntityPlayerMP)this.func_70638_az())) {
                this.func_70638_az().func_70690_d(new PotionEffect(Potion.field_76440_q.field_76415_H, 200, 0));
            }
        } else {
            this.func_70638_az().func_70107_b(x2, y2, z2);
            int short1 = 128;
            for (int l = 0; l < short1; ++l) {
                double d6 = (double)l / ((double)short1 - 1.0);
                float f = (this.field_70146_Z.nextFloat() - 0.5f) * 0.2f;
                float f1 = (this.field_70146_Z.nextFloat() - 0.5f) * 0.2f;
                float f2 = (this.field_70146_Z.nextFloat() - 0.5f) * 0.2f;
                double d7 = x + (x2 - x) * d6 + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N * 2.0;
                double d8 = y + (y2 - y) * d6 + this.field_70146_Z.nextDouble() * (double)this.field_70131_O;
                double d9 = z + (z2 - z) * d6 + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N * 2.0;
                this.field_70170_p.func_175688_a(this.getTeleportParticle(), d7, d8, d9, (double)f, (double)f1, (double)f2, new int[0]);
            }
            this.field_70170_p.func_72956_a((Entity)this.func_70638_az(), this.getTeleportSound(), 0.4f, 0.4f);
            this.func_70638_az().func_70690_d(new PotionEffect(Potion.field_76440_q.field_76415_H, 60, 0));
        }
        this.func_70107_b(x, y, z);
        this.hasTeleported = true;
    }

    private void shootProjectiles() {
        double d0 = this.field_70146_Z.nextInt(2) - this.field_70146_Z.nextInt(2);
        double d1 = this.field_70146_Z.nextInt(4);
        double d2 = this.field_70146_Z.nextInt(2) - this.field_70146_Z.nextInt(2);
        float f1 = MathHelper.func_76129_c((float)this.func_70032_d((Entity)this.func_70638_az())) * 0.975f;
        EntityDarkMortor mortor = new EntityDarkMortor(this.field_70170_p, (EntityLivingBase)this, d0 + this.field_70146_Z.nextGaussian() * (double)f1, d1, d2 + this.field_70146_Z.nextGaussian() * (double)f1);
        mortor.field_70163_u = this.field_70163_u + (double)this.field_70131_O + 0.5;
        mortor.field_70165_t += d0 * 0.04335;
        mortor.field_70161_v += d2 * 0.04335;
        mortor.field_70181_x += 0.36 * (double)f1;
        this.field_70170_p.func_72838_d((Entity)mortor);
    }

    private void fireOneMortor() {
        double d0 = this.func_70638_az().field_70165_t - this.field_70165_t;
        double d1 = this.func_70638_az().field_70163_u - this.field_70163_u;
        double d2 = this.func_70638_az().field_70161_v - this.field_70161_v;
        float f1 = MathHelper.func_76129_c((float)this.func_70032_d((Entity)this.func_70638_az())) * 0.25f;
        EntityDarkMortor mortor = new EntityDarkMortor(this.field_70170_p, (EntityLivingBase)this, d0 + this.field_70146_Z.nextGaussian() * (double)f1, d1, d2 + this.field_70146_Z.nextGaussian() * (double)f1);
        mortor.field_70165_t = this.field_70165_t + 0.115 * d0;
        mortor.field_70163_u = this.field_70163_u + (double)(this.field_70131_O * 2.0f / 3.0f);
        mortor.field_70161_v = this.field_70161_v + 0.115 * d2;
        this.field_70170_p.func_72838_d((Entity)mortor);
    }

    public void func_180430_e(float dist, float multi) {
    }

    @Override
    public boolean func_70097_a(DamageSource par1DamageSource, float par2) {
        if (this.field_70170_p.field_72995_K) {
            return false;
        }
        if (this.getHurtTime() == 0) {
            this.setHurtTime(10);
        }
        return super.func_70097_a(par1DamageSource, par2);
    }

    public int func_70658_aO() {
        return TragicConfig.getMobStat("psygoteStats").getArmorValue();
    }

    @Override
    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        if (tag.func_74764_b("hurtTime")) {
            this.setHurtTime(tag.func_74762_e("hurtTime"));
        }
        if (tag.func_74764_b("firingTicks")) {
            this.setFiringTicks(tag.func_74762_e("firingTicks"));
        }
        if (tag.func_74764_b("switchTicks")) {
            this.setSwitchTicks(tag.func_74762_e("switchTicks"));
        }
        if (tag.func_74764_b("hasTeleported")) {
            this.hasTeleported = tag.func_74767_n("hasTeleported");
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        tag.func_74768_a("hurtTime", this.getHurtTime());
        tag.func_74768_a("firingTicks", this.getFiringTicks());
        tag.func_74768_a("switchTicks", this.getSwitchTicks());
        tag.func_74757_a("hasTeleported", this.hasTeleported);
    }

    @Override
    protected boolean isChangeAllowed() {
        return false;
    }

    public String func_70639_aQ() {
        return TragicConfig.getBoolean("allowMobSounds") ? (this.func_70638_az() == null ? "tragicmc:mob.psygote.coo" : "tragicmc:mob.psygote.cry") : null;
    }

    public String func_70621_aR() {
        return TragicConfig.getBoolean("allowMobSounds") ? "tragicmc:mob.psygote.shriek" : super.func_70621_aR();
    }

    public String func_70673_aS() {
        return TragicConfig.getBoolean("allowMobSounds") ? "tragicmc:mob.psygote.shriek" : null;
    }

    public float func_70647_i() {
        return 1.0f;
    }

    public float func_70599_aP() {
        return 0.6f + this.field_70146_Z.nextFloat() * 0.2f;
    }

    protected void func_180429_a(BlockPos pos, Block block) {
    }

    @Override
    public void func_70645_a(DamageSource src) {
        super.func_70645_a(src);
        if (src.func_76346_g() instanceof EntityPlayerMP && TragicConfig.getBoolean("allowAchievements") && !this.hasTeleported) {
            ((EntityPlayerMP)src.func_76346_g()).func_71029_a((StatBase)TragicAchievements.psygote);
        }
    }

    @Override
    protected EnumParticleTypes getTeleportParticle() {
        return EnumParticleTypes.SMOKE_NORMAL;
    }
}

