/*
 * Decompiled with CFR 0.152.
 */
package tragicneko.tragicmc.entity.mob;

import com.google.common.base.Predicate;
import java.util.Calendar;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.item.EntityFireworkRocket;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.stats.StatBase;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import tragicneko.tragicmc.TragicAchievements;
import tragicneko.tragicmc.TragicConfig;
import tragicneko.tragicmc.TragicItems;
import tragicneko.tragicmc.dimension.NekoHomeworldProvider;
import tragicneko.tragicmc.entity.EntityMechaExo;
import tragicneko.tragicmc.entity.boss.EntityProfessorNekoid;
import tragicneko.tragicmc.entity.mob.TragicMob;
import tragicneko.tragicmc.entity.projectile.EntityNekoClusterBomb;
import tragicneko.tragicmc.entity.projectile.EntityNekoMiniBomb;
import tragicneko.tragicmc.entity.projectile.EntityNekoRocket;
import tragicneko.tragicmc.entity.projectile.EntityNekoStickyBomb;
import tragicneko.tragicmc.properties.PropertyMisc;

public abstract class EntityNeko
extends TragicMob {
    public static final int DW_FIRING_TICKS = 20;
    public static final int DW_THROWING_TICKS = 21;
    public static final int DW_ATTACK_TIME = 22;
    public static final int DW_FLICK_TIME = 23;
    public static final int DW_RELEASED = 24;
    public AttributeModifier mod = new AttributeModifier(UUID.fromString("ef7bc471-3df8-4d0d-8aa6-8f52ae0a6045"), "tragicNekoSpeedDebuff", TragicConfig.modifier[9], 0);
    public static final Predicate nekoTarget = new Predicate(){

        public boolean apply(Object input) {
            return this.canApply((Entity)input);
        }

        public boolean canApply(Entity entity) {
            return entity instanceof EntityNeko && !((EntityNeko)entity).isReleased();
        }
    };
    public static final Predicate nekoidTarget = new Predicate(){

        public boolean apply(Object input) {
            return this.canApply((Entity)input);
        }

        public boolean canApply(Entity entity) {
            return entity instanceof EntityProfessorNekoid;
        }
    };
    public final EntityAIBase attackOnCollide = new EntityAIAttackOnCollide((EntityCreature)this, EntityLivingBase.class, 1.0, true);
    public final EntityAIBase hurtByNekos = new EntityAIHurtByTarget((EntityCreature)this, true, new Class[]{EntityNeko.class});
    public final EntityAIBase moveTowardsTarget = new EntityAIMoveTowardsTarget((EntityCreature)this, 0.85, 32.0f);
    public final EntityAIBase targetPlayers = new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true, false, playerTarget);
    public final EntityAIBase targetUnreleasedNekos = new EntityAINearestAttackableTarget((EntityCreature)this, EntityNeko.class, 0, true, false, nekoTarget);
    public final EntityAIBase targetNekoid = new EntityAINearestAttackableTarget((EntityCreature)this, EntityProfessorNekoid.class, 0, true, false, nekoidTarget);

    public EntityNeko(World par1World) {
        super(par1World);
        this.func_70105_a(0.475f, 1.895f);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        if (!this.isProperDate()) {
            this.field_70714_bg.func_75776_a(0, this.attackOnCollide);
        }
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.65));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityLivingBase.class, 32.0f));
        if (!this.isProperDate()) {
            this.field_70714_bg.func_75776_a(1, this.moveTowardsTarget);
        }
        if (!this.isReleased()) {
            this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        } else {
            this.field_70715_bh.func_75776_a(2, this.hurtByNekos);
        }
        if (!this.isProperDate() && !this.isReleased()) {
            this.field_70715_bh.func_75776_a(3, this.targetPlayers);
        }
        if (this.isReleased()) {
            this.field_70715_bh.func_75776_a(3, this.targetUnreleasedNekos);
        }
        if (this.isReleased()) {
            this.field_70715_bh.func_75776_a(4, this.targetNekoid);
        }
        this.updateNekoTasks();
    }

    @Override
    public boolean canCorrupt() {
        return false;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(20, (Object)0);
        this.field_70180_af.func_75682_a(21, (Object)0);
        this.field_70180_af.func_75682_a(22, (Object)0);
        this.field_70180_af.func_75682_a(23, (Object)0);
        this.field_70180_af.func_75682_a(24, (Object)0);
    }

    public int getFiringTicks() {
        return this.field_70180_af.func_75679_c(20);
    }

    protected void setFiringTicks(int i) {
        this.field_70180_af.func_75692_b(20, (Object)i);
    }

    protected void incrementFiringTicks() {
        int pow = this.getFiringTicks();
        this.setFiringTicks(++pow);
    }

    public boolean isAboutToFire() {
        return this.getFiringTicks() > 0 && this.getFiringTicks() <= 40;
    }

    public boolean hasFired() {
        return this.getFiringTicks() > 40;
    }

    public boolean canFire() {
        return this.getFiringTicks() >= 80;
    }

    public int getThrowingTicks() {
        return this.field_70180_af.func_75679_c(21);
    }

    protected void setThrowingTicks(int i) {
        this.field_70180_af.func_75692_b(21, (Object)i);
    }

    protected void decrementThrowingTicks() {
        int pow = this.getThrowingTicks();
        this.setThrowingTicks(--pow);
    }

    public int getAttackTime() {
        return this.field_70180_af.func_75679_c(22);
    }

    protected void setAttackTime(int i) {
        this.field_70180_af.func_75692_b(22, (Object)i);
    }

    protected void decrementAttackTime() {
        int pow = this.getAttackTime();
        this.setAttackTime(--pow);
    }

    public int getFlickTime() {
        return this.field_70180_af.func_75679_c(23);
    }

    protected void setFlickTime(int i) {
        this.field_70180_af.func_75692_b(23, (Object)i);
    }

    protected void decrementFlickTime() {
        int pow = this.getFlickTime();
        this.setFlickTime(--pow);
    }

    public boolean isReleased() {
        return this.field_70180_af.func_75683_a(24) == 1;
    }

    protected void setReleased(boolean flag) {
        this.field_70180_af.func_75692_b(24, (Object)(flag ? (byte)1 : 0));
    }

    public void releaseNeko(EntityPlayer player) {
        if (this.isReleased()) {
            return;
        }
        if (this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 8; i = (int)((byte)(i + 1))) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.HEART, this.field_70165_t + this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble(), this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble(), 1.0, 1.0, 1.0, new int[0]);
            }
        } else {
            PropertyMisc misc;
            if (this.field_70146_Z.nextInt(8) == 0) {
                if (player != null) {
                    player.func_146105_b((IChatComponent)new ChatComponentText("Thanks for releasing me from that mind control~! Have a copy of one of my favorite songs!"));
                }
                if (this.getAllowLoot()) {
                    Item[] items = new Item[]{TragicItems.Starstruck, TragicItems.Faultless, TragicItems.Transmissions, TragicItems.Atrophy, TragicItems.Archaic, TragicItems.System, TragicItems.Mirrors, TragicItems.Untitled, TragicItems.Untitled2};
                    this.func_70099_a(new ItemStack(items[this.field_70146_Z.nextInt(items.length)]), 0.4f);
                }
            }
            if (player != null && TragicConfig.getBoolean("allowAchievements") && (misc = PropertyMisc.get((EntityLivingBase)player)) != null && misc.nekosReleased++ >= 100) {
                player.func_71029_a((StatBase)TragicAchievements.tragicNeko100Release);
            }
            this.func_70624_b(null);
            this.setReleased(true);
            this.updateNekoTasks();
            if (TragicConfig.getBoolean("allowAchievements") && player instanceof EntityPlayerMP) {
                player.func_71029_a((StatBase)TragicAchievements.tragicNekoRelease);
            }
        }
    }

    public int func_70641_bl() {
        return 1;
    }

    public void func_70110_aj() {
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70170_p.field_72995_K) {
            if ((this.isReleased() || this.isProperDate()) && this.field_70173_aa % 10 == 0) {
                for (int i = 0; i < 2; i = (int)((byte)(i + 1))) {
                    this.field_70170_p.func_175688_a(EnumParticleTypes.HEART, this.field_70165_t + this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble(), this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble(), 1.0, 1.0, 1.0, new int[0]);
                }
            }
            return;
        }
        if (this.func_70638_az() != null) {
            this.incrementFiringTicks();
        }
        if (this.getThrowingTicks() > 0) {
            this.decrementThrowingTicks();
        }
        if (this.getAttackTime() > 0) {
            this.decrementAttackTime();
        }
        if (this.getFlickTime() > 0) {
            this.decrementFlickTime();
        }
        if (this.isReleased() && this.func_70638_az() != null && this.func_70638_az() instanceof EntityNeko && ((EntityNeko)this.func_70638_az()).isReleased()) {
            this.func_70624_b(null);
        }
        if (this.isReleased() && this.func_70638_az() != null && this.func_70638_az() instanceof EntityPlayer) {
            this.func_70624_b(null);
        }
        if (!this.isReleased() && this.func_70638_az() != null && this.func_70638_az() instanceof EntityProfessorNekoid) {
            this.func_70624_b(null);
        }
        if (!this.isReleased() && this.func_70638_az() != null && this.func_70638_az() instanceof EntityNeko && !((EntityNeko)this.func_70638_az()).isReleased()) {
            this.func_70624_b(null);
        }
        if (this.func_70638_az() instanceof EntityMechaExo && this.func_70638_az().field_70153_n instanceof EntityProfessorNekoid && !this.isReleased()) {
            this.func_70624_b(null);
        }
        if (this.func_70638_az() == null) {
            if (this.field_70173_aa % 6 == 0 && this.field_70146_Z.nextInt(16) == 0) {
                this.setFlickTime(10);
            }
            this.setFiringTicks(35);
        }
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111124_b(this.mod);
        if (this.isAboutToFire() || this.getThrowingTicks() > 0) {
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111121_a(this.mod);
        }
    }

    protected void updateNekoTasks() {
        if (this.isProperDate()) {
            this.field_70714_bg.func_85156_a(this.attackOnCollide);
            this.field_70714_bg.func_85156_a(this.moveTowardsTarget);
            this.field_70715_bh.func_85156_a(this.hurtByNekos);
            this.field_70715_bh.func_85156_a(this.targetPlayers);
            this.field_70715_bh.func_85156_a(this.targetUnreleasedNekos);
        }
        if (this.isReleased()) {
            this.field_70715_bh.func_85156_a(this.targetPlayers);
            if (!this.field_70715_bh.field_75782_a.contains(this.targetUnreleasedNekos)) {
                this.field_70715_bh.func_75776_a(3, this.targetUnreleasedNekos);
            }
            if (!this.field_70715_bh.field_75782_a.contains(this.hurtByNekos)) {
                this.field_70715_bh.func_75776_a(2, this.hurtByNekos);
            }
            if (!this.field_70715_bh.field_75782_a.contains(this.targetNekoid)) {
                this.field_70715_bh.func_75776_a(4, this.targetNekoid);
            }
        }
    }

    @Override
    public void func_70645_a(DamageSource par1DamageSource) {
        super.func_70645_a(par1DamageSource);
        if (!this.field_70170_p.field_72995_K) {
            this.setThrowingTicks(20);
        }
    }

    protected void doMissleAttack() {
        EntityLivingBase entity = this.func_70638_az();
        double d0 = entity.field_70165_t - this.field_70165_t;
        double d1 = entity.func_174813_aQ().field_72338_b + (double)entity.field_70131_O / 2.0 - this.field_70163_u - 0.65;
        double d2 = entity.field_70161_v - this.field_70161_v;
        EntityNekoRocket rocket = new EntityNekoRocket(this.field_70170_p, (EntityLivingBase)this, d0, d1, d2);
        rocket.shootingEntity = this;
        rocket.target = entity;
        rocket.field_70163_u = this.field_70163_u + 0.65;
        rocket.field_70165_t = this.field_70165_t - Math.sin(this.field_70177_z * (float)Math.PI / 180.0f) * 0.025;
        rocket.field_70161_v = this.field_70161_v - Math.cos(this.field_70177_z * (float)Math.PI / 180.0f) * 0.025;
        this.field_70170_p.func_72838_d((Entity)rocket);
        this.field_70170_p.func_72956_a((Entity)this, "tragicmc:random.rocketlaunch", 1.0f, 1.0f);
        this.field_70170_p.func_72956_a((Entity)this, "tragicmc:random.rocketflying", 1.0f, 1.0f);
    }

    protected void throwRandomProjectile() {
        EntityThrowable theProjectile = null;
        switch (this.field_70146_Z.nextInt(5)) {
            case 1: 
            case 4: {
                if (!TragicConfig.getBoolean("tragicNekoStickyBombs")) break;
                theProjectile = new EntityNekoStickyBomb(this.field_70170_p, (EntityLivingBase)this);
                break;
            }
            case 2: {
                if (!TragicConfig.getBoolean("tragicNekoClusterBomb")) break;
                theProjectile = new EntityNekoClusterBomb(this.field_70170_p, (EntityLivingBase)this);
                break;
            }
            default: {
                if (!TragicConfig.getBoolean("tragicNekoClusterBomb")) break;
                theProjectile = new EntityNekoMiniBomb(this.field_70170_p, (EntityLivingBase)this);
            }
        }
        if (theProjectile == null) {
            return;
        }
        theProjectile.field_70159_w = (this.func_70638_az().field_70165_t - this.field_70165_t) * 0.335;
        theProjectile.field_70179_y = (this.func_70638_az().field_70161_v - this.field_70161_v) * 0.335;
        theProjectile.field_70181_x = (this.func_70638_az().field_70163_u - this.field_70163_u) * 0.335;
        this.field_70170_p.func_72838_d((Entity)theProjectile);
    }

    public boolean func_70601_bi() {
        if (MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b) <= this.field_70170_p.field_73011_w.func_76557_i()) {
            return false;
        }
        return super.func_70601_bi() || this.isProperDate();
    }

    public boolean isProperDate() {
        if (!TragicConfig.getBoolean("tragicNekoCelebration")) {
            return false;
        }
        Calendar calendar = this.field_70170_p.func_83015_S();
        return calendar.get(2) + 1 == 9 && calendar.get(5) < 8;
    }

    @Override
    public boolean func_70097_a(DamageSource par1DamageSource, float par2) {
        boolean result;
        if (par1DamageSource.func_94541_c() || this.field_70170_p.field_72995_K) {
            return false;
        }
        if (this.getFiringTicks() < 60) {
            this.setFiringTicks(61);
        }
        if (result = super.func_70097_a(par1DamageSource, par2)) {
            this.setAttackTime(10);
        }
        return result;
    }

    @Override
    public boolean func_70652_k(Entity par1Entity) {
        boolean result;
        if (this.getThrowingTicks() > 0) {
            return false;
        }
        if (this.getFiringTicks() < 60) {
            this.setFiringTicks(61);
        }
        if (result = super.func_70652_k(par1Entity)) {
            this.setAttackTime(10);
        }
        return result;
    }

    @Override
    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        if (tag.func_74764_b("attackTime")) {
            this.setAttackTime(tag.func_74762_e("attackTime"));
        }
        if (tag.func_74764_b("firingTicks")) {
            this.setFiringTicks(tag.func_74762_e("firingTicks"));
        }
        if (tag.func_74764_b("throwingTicks")) {
            this.setThrowingTicks(tag.func_74762_e("throwingTicks"));
        }
        if (tag.func_74764_b("flickTime")) {
            this.setFlickTime(tag.func_74762_e("flickTime"));
        }
        if (tag.func_74764_b("isReleased")) {
            this.setReleased(tag.func_74767_n("isReleased"));
        }
        this.updateNekoTasks();
    }

    @Override
    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        tag.func_74768_a("attackTime", this.getAttackTime());
        tag.func_74768_a("firingTicks", this.getFiringTicks());
        tag.func_74768_a("throwingTicks", this.getThrowingTicks());
        tag.func_74768_a("flickTime", this.getFlickTime());
        tag.func_74757_a("isReleased", this.isReleased());
    }

    @Override
    protected boolean isChangeAllowed() {
        return false;
    }

    public String func_70639_aQ() {
        return null;
    }

    public String func_70621_aR() {
        return super.func_70621_aR();
    }

    public String func_70673_aS() {
        return null;
    }

    public float func_70647_i() {
        return 1.0f;
    }

    public float func_70599_aP() {
        return 0.6f;
    }

    public int func_70627_aG() {
        return 380;
    }

    @Override
    public int getDropAmount() {
        return 2;
    }

    public boolean func_70085_c(EntityPlayer player) {
        if (player.func_71045_bC() != null) {
            ItemStack item = player.func_71045_bC();
            if (this.isProperDate() && (item.func_77973_b() == Items.field_151105_aU || item.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150335_W))) {
                if (this.field_70170_p.field_72995_K) {
                    for (int i = 0; i < 16; i = (int)((byte)(i + 1))) {
                        this.field_70170_p.func_175688_a(EnumParticleTypes.HEART, this.field_70165_t + this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble(), this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble(), 1.0, 1.0, 1.0, new int[0]);
                    }
                } else {
                    ItemStack stack = new ItemStack(Items.field_151152_bP, 1, 0);
                    NBTTagCompound tag = new NBTTagCompound();
                    NBTTagCompound newTag = new NBTTagCompound();
                    newTag.func_74774_a("Flight", (byte)0);
                    NBTTagList tagList = new NBTTagList();
                    NBTTagCompound explosion = new NBTTagCompound();
                    explosion.func_74774_a("Type", (byte)2);
                    explosion.func_74774_a("Fade", (byte)1);
                    explosion.func_74774_a("Flicker", (byte)1);
                    explosion.func_74783_a("Colors", new int[]{0xFF0000, 65280, 2324735});
                    explosion.func_74783_a("FadeColors", new int[]{0xFFFFFF, 0xFFFFFF, 0xFFFFFF});
                    tagList.func_74742_a((NBTBase)explosion);
                    NBTTagCompound explosion2 = new NBTTagCompound();
                    explosion2.func_74774_a("Type", (byte)4);
                    explosion2.func_74774_a("Trail", (byte)1);
                    explosion2.func_74783_a("Colors", new int[]{65280, 0x4488FF, 0x45FF54});
                    explosion2.func_74783_a("FadeColors", new int[]{65280, 0x4488FF, 0x45FF54});
                    tagList.func_74742_a((NBTBase)explosion2);
                    NBTTagCompound explosion3 = new NBTTagCompound();
                    explosion3.func_74774_a("Type", (byte)3);
                    explosion3.func_74783_a("Colors", new int[]{16711715, 17408, 2324735});
                    explosion3.func_74783_a("FadeColors", new int[]{65280, 65280, 65280});
                    tagList.func_74742_a((NBTBase)explosion3);
                    NBTTagCompound explosion4 = new NBTTagCompound();
                    explosion4.func_74774_a("Type", (byte)0);
                    explosion4.func_74774_a("Trail", (byte)1);
                    explosion4.func_74783_a("Colors", new int[]{0, 0, 0});
                    explosion4.func_74783_a("FadeColors", new int[]{0xFF0000, 0xFF0000, 0xFF0000});
                    tagList.func_74742_a((NBTBase)explosion4);
                    NBTTagCompound explosion5 = new NBTTagCompound();
                    explosion5.func_74774_a("Type", (byte)1);
                    explosion5.func_74783_a("Colors", new int[]{16711715, 0xFF4400, 16742468});
                    explosion5.func_74783_a("FadeColors", new int[]{4628723, 11473646, 4617727});
                    tagList.func_74742_a((NBTBase)explosion5);
                    NBTTagCompound explosion6 = new NBTTagCompound();
                    explosion6.func_74774_a("Type", (byte)0);
                    explosion6.func_74783_a("Colors", new int[]{4470527, 2246399, 0x3311FF});
                    explosion6.func_74783_a("FadeColors", new int[]{65280, 14079, 255});
                    tagList.func_74742_a((NBTBase)explosion6);
                    newTag.func_74782_a("Explosions", (NBTBase)tagList);
                    tag.func_74782_a("Fireworks", (NBTBase)newTag);
                    stack.func_77982_d(tag);
                    for (int i = 0; i < 3; i = (int)((byte)(i + 1))) {
                        this.field_70170_p.func_72838_d((Entity)new EntityFireworkRocket(this.field_70170_p, this.field_70165_t + this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble(), this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble(), stack));
                    }
                    player.func_146105_b((IChatComponent)new ChatComponentText("Thanks for celebrating my birthday with me~!"));
                }
                if (TragicConfig.getBoolean("allowAchievements") && player instanceof EntityPlayerMP) {
                    player.func_71029_a((StatBase)TragicAchievements.tragicNeko);
                }
                if (!player.field_71075_bZ.field_75098_d) {
                    --player.func_71045_bC().field_77994_a;
                }
                return true;
            }
            if (item.func_77973_b() == TragicItems.NekoMindControlDevice) {
                this.releaseNeko(player);
                if (!player.field_71075_bZ.field_75098_d) {
                    --player.func_71045_bC().field_77994_a;
                }
                return true;
            }
        }
        return false;
    }

    protected boolean func_70692_ba() {
        return TragicConfig.getBoolean("allowStructureGen") && this.field_70170_p.field_73011_w instanceof NekoHomeworldProvider ? false : super.func_70692_ba();
    }

    public void func_70642_aH() {
        super.func_70642_aH();
        if (this.field_70757_a > this.func_70627_aG() - 60) {
            this.field_70757_a -= this.func_70627_aG();
        }
    }
}

