/*
 * Decompiled with CFR 0.152.
 */
package tragicneko.tragicmc.entity.mob;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import tragicneko.tragicmc.TragicConfig;
import tragicneko.tragicmc.entity.mob.EntityNeko;

public class EntityAssaultNeko
extends EntityNeko {
    private static final int DW_CHARGE_TICKS = 25;
    private static final int DW_SHIELD_TICKS = 26;
    private int shieldBuffer = 100;
    private float shieldHealth = 100.0f;

    public EntityAssaultNeko(World par1World) {
        super(par1World);
        this.func_70105_a(0.772875f, 1.995f);
        this.field_70728_aV = 50;
        this.field_70138_W = 1.0f;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(25, (Object)0);
        this.field_70180_af.func_75682_a(26, (Object)0);
    }

    public int getChargeTicks() {
        return this.field_70180_af.func_75679_c(25);
    }

    private void setChargeTicks(int i) {
        this.field_70180_af.func_75692_b(25, (Object)i);
    }

    public int getShieldTicks() {
        return this.field_70180_af.func_75679_c(26);
    }

    private void setShieldTicks(int i) {
        this.field_70180_af.func_75692_b(26, (Object)i);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        double[] assaultNekoStats = TragicConfig.getMobStat("assaultNekoStats").getStats();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(assaultNekoStats[0]);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(assaultNekoStats[1]);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(assaultNekoStats[2]);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(assaultNekoStats[3]);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(assaultNekoStats[4]);
    }

    public int func_70658_aO() {
        return TragicConfig.getMobStat("assaultNekoStats").getArmorValue();
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (this.getShieldTicks() > 0) {
            this.setShieldTicks(this.getShieldTicks() - 1);
            this.shieldBuffer = 100;
            if (this.getShieldTicks() % 20 == 0 && TragicConfig.getBoolean("allowMobSounds")) {
                String s = this.shieldHealth < 40.0f || this.getShieldTicks() <= 40 ? "tragicmc:mob.assaultneko.shieldlow" : "tragicmc:mob.assaultneko.shield";
                this.field_70170_p.func_72956_a((Entity)this, s, 0.6f, 1.0f);
            }
        }
        if (this.getChargeTicks() > 0) {
            this.setChargeTicks(this.getChargeTicks() - 1);
        }
        if (this.shieldBuffer > 0) {
            --this.shieldBuffer;
        }
        if (this.func_70638_az() != null && !this.isProperDate()) {
            if (this.getFlickTime() > 0) {
                this.setFlickTime(0);
            }
            if (this.field_70173_aa % 5 == 0 && this.getChargeTicks() == 0 && this.func_70032_d((Entity)this.func_70638_az()) > 6.0f && this.field_70122_E && this.field_70146_Z.nextInt(8) == 0 && TragicConfig.getBoolean("assaultNekoChargeAttack")) {
                this.setChargeTicks(100);
            }
            if (this.field_70173_aa % 7 == 0 && this.getShieldTicks() == 0 && this.shieldBuffer == 0 && this.func_70032_d((Entity)this.func_70638_az()) < 16.0f && this.func_110143_aJ() < this.func_110138_aP() && TragicConfig.getBoolean("assaultNekoShield")) {
                this.setShieldTicks(120);
                this.shieldHealth = 100.0f;
            }
            if (this.getChargeTicks() > 0 && this.field_70122_E && TragicConfig.getBoolean("assaultNekoChargeAttack")) {
                double d0 = this.func_70638_az().field_70165_t - this.field_70165_t;
                double d1 = this.func_70638_az().field_70161_v - this.field_70161_v;
                float f2 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1));
                this.field_70159_w += d0 / (double)f2 * 0.14 * 0.1100000011920929 + this.field_70159_w * 0.2400000298023224;
                this.field_70179_y += d1 / (double)f2 * 0.14 * 0.1100000011920929 + this.field_70179_y * 0.2400000298023224;
                this.field_70181_x = -0.1;
            }
        }
    }

    @Override
    protected void doMissleAttack() {
    }

    @Override
    protected void throwRandomProjectile() {
    }

    @Override
    public boolean func_70097_a(DamageSource par1DamageSource, float par2) {
        if (this.field_70170_p.field_72995_K) {
            return false;
        }
        if (this.getShieldTicks() > 0 && this.shieldHealth > 0.0f && TragicConfig.getBoolean("assaultNekoShield")) {
            this.shieldHealth -= par2;
            if (this.shieldHealth > 0.0f) {
                if (TragicConfig.getBoolean("allowMobSounds")) {
                    this.field_70170_p.func_72956_a((Entity)this, "tragicmc:mob.assaultneko.absorb", 1.0f, 1.0f);
                }
                return false;
            }
            par2 += this.shieldHealth;
        }
        return super.func_70097_a(par1DamageSource, par2);
    }

    @Override
    public boolean func_70652_k(Entity par1Entity) {
        if (this.field_70170_p.field_72995_K) {
            return false;
        }
        if (this.getChargeTicks() == 0) {
            this.setAttackTime(10);
            if (!TragicConfig.getBoolean("assaultNekoLaserSword")) {
                return super.func_70652_k(par1Entity);
            }
            float f = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
            this.field_70170_p.func_72956_a((Entity)this, "tragicmc:boss.overlordcombat.shink", 1.4f, 1.9f);
            return par1Entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this).func_76348_h(), f);
        }
        if (TragicConfig.getBoolean("assaultNekoChargeAttack")) {
            this.setChargeTicks(0);
            float f = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e() * 1.5f;
            boolean flag = par1Entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), f);
            if (flag) {
                par1Entity.field_70159_w += this.field_70159_w;
                par1Entity.field_70179_y += this.field_70179_y;
            }
            return flag;
        }
        return super.func_70652_k(par1Entity);
    }

    @Override
    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        if (tag.func_74764_b("shieldBuffer")) {
            this.shieldBuffer = tag.func_74762_e("shieldBuffer");
        }
        if (tag.func_74764_b("chargeTicks")) {
            this.setChargeTicks(tag.func_74762_e("chargeTicks"));
        }
        if (tag.func_74764_b("shieldTicks")) {
            this.setShieldTicks(tag.func_74762_e("shieldTicks"));
        }
        if (tag.func_74764_b("shieldHealth")) {
            this.shieldHealth = tag.func_74760_g("shieldHealth");
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        tag.func_74768_a("shieldBuffer", this.shieldBuffer);
        tag.func_74768_a("chargeTicks", this.getChargeTicks());
        tag.func_74768_a("shieldTicks", this.getShieldTicks());
        tag.func_74776_a("shieldHealth", this.shieldHealth);
    }

    @Override
    public String func_70639_aQ() {
        return TragicConfig.getBoolean("allowMobSounds") ? "tragicmc:mob.assaultneko.living" : null;
    }

    @Override
    public String func_70621_aR() {
        return TragicConfig.getBoolean("allowMobSounds") && this.field_70146_Z.nextInt(5) == 0 ? "tragicmc:mob.assaultneko.hurt" : super.func_70621_aR();
    }

    @Override
    public String func_70673_aS() {
        return TragicConfig.getBoolean("allowMobSounds") ? "tragicmc:mob.assaultneko.death" : null;
    }

    @Override
    public float func_70647_i() {
        return 1.0f;
    }

    @Override
    public float func_70599_aP() {
        return 0.65f;
    }

    @Override
    public int func_70627_aG() {
        return 320 + this.field_70146_Z.nextInt(120);
    }
}

