/*
 * Decompiled with CFR 0.152.
 */
package tragicneko.tragicmc.entity.mob;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemSword;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import tragicneko.tragicmc.TragicConfig;
import tragicneko.tragicmc.TragicEntities;
import tragicneko.tragicmc.entity.mob.TragicMob;

public class EntityAbomination
extends TragicMob {
    public static final int DW_ATTACK_TIME = 20;
    public static final int DW_CELEBRATION_TICKS = 21;

    public EntityAbomination(World par1World) {
        super(par1World);
        this.func_70105_a(0.775f, 2.05f);
        this.field_70138_W = 1.0f;
        this.field_70728_aV = 50;
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, EntityLivingBase.class, 1.0, true));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.55));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityLivingBase.class, 32.0f));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIMoveTowardsTarget((EntityCreature)this, 1.0, 32.0f));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
    }

    @Override
    public boolean canCorrupt() {
        return false;
    }

    @Override
    public void func_70074_a(EntityLivingBase entity) {
        super.func_70074_a(entity);
        int ticks = (int)entity.func_110138_aP();
        if (ticks < 40) {
            ticks = 40;
        }
        this.setCelebrationTicks(ticks + this.field_70146_Z.nextInt(10));
        List list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72314_b(12.0, 12.0, 12.0));
        for (int i = 0; i < list.size(); ++i) {
            EntityAbomination mob;
            if (!(list.get(i) instanceof EntityAbomination) || (mob = (EntityAbomination)((Object)list.get(i))).func_70638_az() != entity) continue;
            mob.setCelebrationTicks(ticks + this.field_70146_Z.nextInt(10));
        }
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(21, (Object)0);
        this.field_70180_af.func_75682_a(20, (Object)0);
    }

    public EnumCreatureAttribute func_70668_bt() {
        return TragicEntities.Beast;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        double[] abominationStats = TragicConfig.getMobStat("abominationStats").getStats();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(abominationStats[0]);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(abominationStats[1]);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(abominationStats[2]);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(abominationStats[3]);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(abominationStats[4]);
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (this.getAttackTime() > 0) {
            this.decrementAttackTime();
        }
        if (this.isCelebrating()) {
            this.decrementCelebrationTicks();
            if (this.getAttackTime() == 0 && this.getCelebrationTicks() >= 10) {
                this.setAttackTime(10);
            }
            if (this.getCelebrationTicks() % 20 == 0) {
                this.func_70664_aZ();
            }
        }
    }

    public void func_70091_d(double d0, double d1, double d2) {
        if (this.isCelebrating()) {
            super.func_70091_d(0.0, d1, 0.0);
        } else {
            super.func_70091_d(d0, d1, d2);
        }
    }

    public boolean isCelebrating() {
        return this.field_70180_af.func_75679_c(21) > 0;
    }

    public int getCelebrationTicks() {
        return this.field_70180_af.func_75679_c(21);
    }

    private void setCelebrationTicks(int i) {
        this.field_70180_af.func_75692_b(21, (Object)i);
    }

    private void decrementCelebrationTicks() {
        int pow = this.field_70180_af.func_75679_c(21);
        this.field_70180_af.func_75692_b(21, (Object)(--pow));
    }

    public int getAttackTime() {
        return this.field_70180_af.func_75679_c(20);
    }

    private void decrementAttackTime() {
        int pow = this.field_70180_af.func_75679_c(20);
        this.field_70180_af.func_75692_b(20, (Object)(--pow));
    }

    private void setAttackTime(int i) {
        this.field_70180_af.func_75692_b(20, (Object)i);
    }

    @Override
    public boolean func_70097_a(DamageSource par1DamageSource, float par2) {
        EntityPlayer player;
        if (this.field_70170_p.field_72995_K) {
            return false;
        }
        if (this.isCelebrating()) {
            this.setCelebrationTicks(0);
        }
        if (par1DamageSource.func_76347_k()) {
            par2 = par2 * 2.275f - 1.0f;
        }
        if (par1DamageSource.func_76346_g() != null && par1DamageSource.func_76346_g() instanceof EntityPlayer && ((player = (EntityPlayer)par1DamageSource.func_76346_g()).func_71045_bC() == null || player.func_71045_bC() != null && !(player.func_71045_bC().func_77973_b() instanceof ItemSword))) {
            par2 *= 0.725f;
        }
        if (par1DamageSource.func_76346_g() != null && par1DamageSource.func_76346_g() instanceof EntityLivingBase && this.field_70146_Z.nextBoolean() && TragicConfig.getBoolean("abominationHelpCall")) {
            List list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72314_b(12.0, 12.0, 12.0));
            for (int i = 0; i < list.size(); ++i) {
                EntityAbomination mob;
                if (!(list.get(i) instanceof EntityAbomination) || (mob = (EntityAbomination)((Object)list.get(i))).func_70638_az() != null) continue;
                mob.func_70624_b(this.func_70638_az());
            }
        }
        return super.func_70097_a(par1DamageSource, par2);
    }

    @Override
    public boolean func_70652_k(Entity par1Entity) {
        if (this.field_70170_p.field_72995_K || this.isCelebrating()) {
            return false;
        }
        boolean result = super.func_70652_k(par1Entity);
        if (result) {
            par1Entity.field_70181_x += 0.34;
            par1Entity.field_70159_w *= 1.11;
            par1Entity.field_70179_y *= 1.11;
            this.setAttackTime(10);
        }
        return result;
    }

    public int func_70658_aO() {
        return TragicConfig.getMobStat("abominationStats").getArmorValue();
    }

    @Override
    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        if (tag.func_74764_b("attackTime")) {
            this.setAttackTime(tag.func_74762_e("attackTime"));
        }
        if (tag.func_74764_b("celebrationTime")) {
            this.setCelebrationTicks(tag.func_74762_e("celebrationTime"));
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        tag.func_74768_a("attackTime", this.getAttackTime());
        tag.func_74768_a("celebrationTime", this.getCelebrationTicks());
    }

    @Override
    protected boolean isChangeAllowed() {
        return false;
    }

    public String func_70639_aQ() {
        return TragicConfig.getBoolean("allowMobSounds") ? "tragicmc:mob.abomination.living" : null;
    }

    public String func_70621_aR() {
        return TragicConfig.getBoolean("allowMobSounds") ? "tragicmc:mob.abomination.hurt" : super.func_70621_aR();
    }

    public String func_70673_aS() {
        return TragicConfig.getBoolean("allowMobSounds") ? "tragicmc:mob.abomination.death" : null;
    }

    public float func_70647_i() {
        return 1.0f;
    }

    public float func_70599_aP() {
        return 0.8f + this.field_70146_Z.nextFloat() * 0.2f;
    }

    public int func_70627_aG() {
        return super.func_70627_aG();
    }
}

