/*
 * Decompiled with CFR 0.152.
 */
package tragicneko.tragicmc.entity.boss;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityGolem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.stats.StatBase;
import net.minecraft.util.BlockPos;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import tragicneko.tragicmc.TragicAchievements;
import tragicneko.tragicmc.TragicConfig;
import tragicneko.tragicmc.TragicItems;
import tragicneko.tragicmc.TragicPotion;
import tragicneko.tragicmc.entity.EntityAIWatchTarget;
import tragicneko.tragicmc.entity.EntityDarkCrystal;
import tragicneko.tragicmc.entity.EntityDirectedLightning;
import tragicneko.tragicmc.entity.boss.EntityPart;
import tragicneko.tragicmc.entity.boss.IMultiPart;
import tragicneko.tragicmc.entity.boss.TragicBoss;
import tragicneko.tragicmc.entity.projectile.EntityDarkEnergy;
import tragicneko.tragicmc.entity.projectile.EntityDarkLightning;
import tragicneko.tragicmc.util.DamageHelper;
import tragicneko.tragicmc.util.WorldHelper;

public class EntityEnyvil
extends TragicBoss
implements IMultiPart {
    public static final int DW_ATTACK_TIME = 20;
    public static final int DW_HURT_TIME = 21;
    public static final int DW_LIGHTNING_TICKS = 22;
    public static final int DW_DARK_ENERGY_TICKS = 23;
    public static final int DW_TRACTOR_BEAM_TICKS = 24;
    public static final int DW_LASER_TICKS = 25;
    public static final int DW_THUNDERSTORM_TICKS = 26;
    public static final int DW_CRYSTAL_ID = 27;
    public static final int DW_SLAM_TICKS = 28;
    public static final int DW_TARGET_ID = 29;
    public EntityPart[] enyvilParts;
    public EntityPart enyvilEye = new EntityPart(this, "enyvilEye", 1.0f, 1.0f);
    public EntityPart enyvilShell = new EntityPart(this, "enyvilShell", 2.5f, 1.5f);
    public EntityPart enyvilShell2 = new EntityPart(this, "enyvilShell2", 2.5f, 1.0f);
    public EntityPart enyvilShell3;
    public EntityPart enyvilClaw = new EntityPart(this, "enyvilClaw", 1.0f, 1.0f);
    public EntityPart enyvilClaw2 = new EntityPart(this, "enyvilClaw2", 1.0f, 1.0f);
    public EntityDarkCrystal crystal;
    public int crystalBuffer;
    public static final Predicate nonSpeciesTarget = new Predicate(){

        public boolean apply(Object o) {
            return this.canApply((Entity)o);
        }

        public boolean canApply(Entity entity) {
            return !(entity instanceof EntityEnyvil);
        }
    };

    public EntityEnyvil(World par1World) {
        super(par1World);
        this.enyvilShell3 = new EntityPart(this, "enyvilShell3", 1.5f, 2.5f);
        this.enyvilParts = new EntityPart[]{this.enyvilEye, this.enyvilShell, this.enyvilShell2, this.enyvilClaw, this.enyvilClaw2, this.enyvilShell3};
        this.func_70105_a(5.5f, 5.5f);
        this.func_70606_j(this.func_110138_aP());
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, EntityLivingBase.class, 1.0, true));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.75));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchTarget((EntityLiving)this, 32.0f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIMoveTowardsTarget((EntityCreature)this, 1.0, 32.0f));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true, false, null));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityGolem.class, 0, true, false, null));
        this.field_70715_bh.func_75776_a(5, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLivingBase.class, 0, true, false, nonSpeciesTarget));
        this.field_70178_ae = true;
        this.field_70138_W = 2.5f;
        this.field_70728_aV = 1200;
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.UNDEAD;
    }

    public boolean func_90999_ad() {
        return false;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(20, (Object)0);
        this.field_70180_af.func_75682_a(21, (Object)0);
        this.field_70180_af.func_75682_a(22, (Object)0);
        this.field_70180_af.func_75682_a(23, (Object)0);
        this.field_70180_af.func_75682_a(24, (Object)0);
        this.field_70180_af.func_75682_a(25, (Object)0);
        this.field_70180_af.func_75682_a(26, (Object)0);
        this.field_70180_af.func_75682_a(27, (Object)0);
        this.field_70180_af.func_75682_a(28, (Object)0);
        this.field_70180_af.func_75682_a(29, (Object)0);
    }

    public int getAttackTime() {
        return this.field_70180_af.func_75679_c(20);
    }

    private void setAttackTime(int i) {
        this.field_70180_af.func_75692_b(20, (Object)i);
    }

    private void decrementAttackTime() {
        int pow = this.getAttackTime();
        this.setAttackTime(--pow);
    }

    public int getHurtTime() {
        return this.field_70180_af.func_75679_c(21);
    }

    private void setHurtTime(int i) {
        this.field_70180_af.func_75692_b(21, (Object)i);
    }

    private void decrementHurtTime() {
        int pow = this.getHurtTime();
        this.setHurtTime(--pow);
    }

    public int getLightningTicks() {
        return this.field_70180_af.func_75679_c(22);
    }

    private void setLightningTicks(int i) {
        this.field_70180_af.func_75692_b(22, (Object)i);
    }

    private void decrementLightningTicks() {
        int pow = this.getLightningTicks();
        this.setLightningTicks(--pow);
    }

    public int getDarkEnergyTicks() {
        return this.field_70180_af.func_75679_c(23);
    }

    private void setDarkEnergyTicks(int i) {
        this.field_70180_af.func_75692_b(23, (Object)i);
    }

    private void decrementDarkEnergyTicks() {
        int pow = this.getDarkEnergyTicks();
        this.setDarkEnergyTicks(--pow);
    }

    public int getTractorBeamTicks() {
        return this.field_70180_af.func_75679_c(24);
    }

    private void setTractorBeamTicks(int i) {
        this.field_70180_af.func_75692_b(24, (Object)i);
    }

    private void decrementTractorBeamTicks() {
        int pow = this.getTractorBeamTicks();
        this.setTractorBeamTicks(--pow);
    }

    public int getLaserTicks() {
        return this.field_70180_af.func_75679_c(25);
    }

    private void setLaserTicks(int i) {
        this.field_70180_af.func_75692_b(25, (Object)i);
    }

    private void decrementLaserTicks() {
        int pow = this.getLaserTicks();
        this.setLaserTicks(--pow);
    }

    public int getThunderstormTicks() {
        return this.field_70180_af.func_75679_c(26);
    }

    private void setThunderstormTicks(int i) {
        this.field_70180_af.func_75692_b(26, (Object)i);
    }

    private void decrementThunderstormTicks() {
        int pow = this.getThunderstormTicks();
        this.setThunderstormTicks(--pow);
    }

    public int getCrystalID() {
        return this.field_70180_af.func_75679_c(27);
    }

    private void setCrystalID(int i) {
        this.field_70180_af.func_75692_b(27, (Object)i);
    }

    private boolean hasCrystal() {
        return this.crystal != null && !this.crystal.field_70128_L || !TragicConfig.getBoolean("enyvilDarkCrystals");
    }

    public int getSlamTicks() {
        return this.field_70180_af.func_75679_c(28);
    }

    private void setSlamTicks(int i) {
        this.field_70180_af.func_75692_b(28, (Object)i);
    }

    private void decrementSlamTicks() {
        int pow = this.getSlamTicks();
        this.setSlamTicks(--pow);
    }

    public int getAttackTargetID() {
        return this.field_70180_af.func_75679_c(29);
    }

    private void setAttackTargetID(int i) {
        this.field_70180_af.func_75692_b(29, (Object)i);
    }

    public EntityLivingBase getClientSideTarget() {
        Entity entity = this.field_70170_p.func_73045_a(this.getAttackTargetID());
        return (EntityLivingBase)(entity instanceof EntityLivingBase ? entity : null);
    }

    private boolean canUseNewAbility() {
        return this.hasCrystal() && this.getLightningTicks() == 0 && this.getDarkEnergyTicks() == 0 && this.getTractorBeamTicks() == 0 && this.getLaserTicks() == 0 && this.getThunderstormTicks() == 0 && this.getSlamTicks() == 0;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        double[] enyvilStats = TragicConfig.getMobStat("enyvilStats").getStats();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(enyvilStats[0]);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(enyvilStats[1]);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(enyvilStats[2]);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(enyvilStats[3]);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(enyvilStats[4]);
    }

    public int func_70658_aO() {
        return TragicConfig.getMobStat("enyvilStats").getArmorValue();
    }

    @Override
    public void func_70645_a(DamageSource src) {
        super.func_70645_a(src);
        if (!this.field_70170_p.field_72995_K) {
            List list = this.field_70170_p.func_72872_a(EntityDarkCrystal.class, this.func_174813_aQ().func_72314_b(128.0, 128.0, 128.0));
            for (EntityDarkCrystal crystal : list) {
                crystal.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), 10000.0f);
            }
        }
        if (src.func_76346_g() instanceof EntityPlayerMP && TragicConfig.getBoolean("allowAchievements")) {
            ((EntityPlayerMP)src.func_76346_g()).func_71029_a((StatBase)TragicAchievements.enyvil);
        }
    }

    @Override
    protected void func_70628_a(boolean flag, int l) {
        super.func_70628_a(flag, l);
        if (!this.field_70170_p.field_72995_K && TragicConfig.getBoolean("allowMobStatueDrops") && this.field_70146_Z.nextInt(100) <= TragicConfig.getInt("mobStatueDropChance") && this.getAllowLoot()) {
            this.capturedDrops.add(new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, new ItemStack(TragicItems.MobStatue, 1, 14)));
        }
    }

    public IEntityLivingData func_180482_a(DifficultyInstance ins, IEntityLivingData data) {
        if (!this.field_70170_p.field_72995_K) {
            this.createNewCrystals();
        }
        return super.func_180482_a(ins, data);
    }

    @Override
    public void func_70636_d() {
        this.field_70143_R = 0.0f;
        super.func_70636_d();
        if (this.crystalBuffer > 0) {
            --this.crystalBuffer;
        }
        if (!this.canUseNewAbility()) {
            this.field_70179_y = 0.0;
            this.field_70181_x = 0.0;
            this.field_70159_w = 0.0;
        }
        if (!this.canUseNewAbility()) {
            this.field_70181_x = -0.1;
        }
        if (this.getTractorBeamTicks() > 0) {
            this.tractorBeamEntity();
        }
        if (this.getLaserTicks() > 0 && this.getLaserTicks() % 50 == 0) {
            this.useLasers();
        }
        float f1 = this.field_70177_z * (float)Math.PI / 180.0f;
        float f2 = MathHelper.func_76126_a((float)f1);
        float f3 = MathHelper.func_76134_b((float)f1);
        this.enyvilEye.field_70131_O = 1.0f;
        this.enyvilEye.field_70130_N = 1.0f;
        this.enyvilShell2.field_70130_N = 1.65f;
        this.enyvilShell.field_70130_N = 1.65f;
        this.enyvilShell2.field_70131_O = 1.05f;
        this.enyvilShell.field_70131_O = 1.05f;
        this.enyvilShell3.field_70131_O = 1.35f;
        this.enyvilShell3.field_70130_N = 2.25f;
        this.enyvilClaw2.field_70131_O = 1.0f;
        this.enyvilClaw2.field_70130_N = 1.0f;
        this.enyvilClaw.field_70131_O = 1.0f;
        this.enyvilClaw.field_70130_N = 1.0f;
        this.enyvilEye.func_70012_b(this.field_70165_t - (double)f2 * 0.025, this.field_70163_u + 3.5, this.field_70161_v - (double)f3 * 0.025, 0.0f, 0.0f);
        this.enyvilShell.func_70012_b(this.field_70165_t - (double)f2 * 0.25, this.field_70163_u + 4.5, this.field_70161_v + (double)f3 * 0.25, 0.0f, 0.0f);
        this.enyvilShell2.func_70012_b(this.field_70165_t - (double)f2 * 0.25, this.field_70163_u + 2.0, this.field_70161_v + (double)f3 * 0.25, 0.0f, 0.0f);
        this.enyvilShell3.func_70012_b(this.field_70165_t - (double)f2 * 0.95, this.field_70163_u + 2.5, this.field_70161_v - (double)f3 * 0.95, 0.0f, 0.0f);
        this.enyvilClaw.func_70012_b(this.field_70165_t + (double)f3 * 0.875, this.field_70163_u + 0.5, this.field_70161_v + (double)f2 * 0.875, 0.0f, 0.0f);
        this.enyvilClaw2.func_70012_b(this.field_70165_t - (double)f3 * 0.875, this.field_70163_u + 0.5, this.field_70161_v - (double)f2 * 0.875, 0.0f, 0.0f);
        for (EntityPart enyvilPart : this.enyvilParts) {
            if (enyvilPart.func_70027_ad()) {
                enyvilPart.func_70066_B();
            }
            enyvilPart.func_70071_h_();
        }
        if (this.field_70170_p.field_72995_K) {
            if (this.hasCrystal()) {
                int i;
                for (i = 0; i < 3; ++i) {
                    this.field_70170_p.func_175688_a(EnumParticleTypes.SPELL_WITCH, this.field_70165_t + (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble()) * 1.455, this.field_70163_u + 2.415 + this.field_70146_Z.nextDouble(), this.field_70161_v + (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble()) * 1.455, 0.0, (double)(0.155f * this.field_70146_Z.nextFloat()), 0.0, new int[0]);
                }
                if (this.getSlamTicks() > 0) {
                    for (i = 0; i < 12; ++i) {
                        this.field_70170_p.func_175688_a(EnumParticleTypes.PORTAL, this.field_70165_t + (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble()) * 4.455, this.field_70163_u + 2.415 + this.field_70146_Z.nextDouble(), this.field_70161_v + (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble()) * 4.455, 0.0, (double)(0.155f * this.field_70146_Z.nextFloat()), 0.0, new int[0]);
                    }
                    if (this.getSlamTicks() == 5) {
                        for (i = 0; i < 12; ++i) {
                            this.field_70170_p.func_175688_a(EnumParticleTypes.PORTAL, this.field_70165_t + (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble()) * 4.455, this.field_70163_u + 2.415 + this.field_70146_Z.nextDouble(), this.field_70161_v + (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble()) * 4.455, (double)(this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()), (double)(0.155f * this.field_70146_Z.nextFloat()), (double)(this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()), new int[0]);
                        }
                    }
                }
            }
            return;
        }
        this.decrementValues();
        if (TragicConfig.getBoolean("enyvilDarkCrystals")) {
            this.updateCrystal();
        }
        this.updateTargetInfo();
        if (this.func_70638_az() == null) {
            if (this.getLightningTicks() > 0) {
                this.setLightningTicks(0);
            }
            if (this.getDarkEnergyTicks() > 0) {
                this.setDarkEnergyTicks(0);
            }
            if (this.getTractorBeamTicks() > 0) {
                this.setTractorBeamTicks(0);
            }
            if (this.getLaserTicks() > 0) {
                this.setLaserTicks(0);
            }
            if (this.getThunderstormTicks() > 0) {
                this.setThunderstormTicks(0);
            }
        } else {
            double d5 = this.func_70638_az().field_70165_t - this.field_70165_t;
            double d7 = this.func_70638_az().field_70161_v - this.field_70161_v;
            this.field_70761_aq = this.field_70177_z = -((float)Math.atan2(d5, d7)) * 180.0f / (float)Math.PI;
            if (this.canUseNewAbility() && this.isEntityInRange((Entity)this.func_70638_az(), 6.0f, 20.0f) && this.field_70146_Z.nextInt(48) == 0 && TragicConfig.getBoolean("enyvilDarkLightning")) {
                this.setLightningTicks(100);
            }
            if (this.getLightningTicks() > 0 && this.getLightningTicks() % 20 == 0 && TragicConfig.getBoolean("enyvilDarkLightning")) {
                this.useDarkLightning();
            }
            if (this.canUseNewAbility() && this.isEntityInRange((Entity)this.func_70638_az(), 5.0f, 16.0f) && this.field_70146_Z.nextInt(96) == 0 && TragicConfig.getBoolean("enyvilDarkEnergySpray")) {
                this.setDarkEnergyTicks(160);
                if (TragicConfig.getBoolean("allowMobSounds")) {
                    this.func_85030_a("tragicmc:boss.enyvil.spray", 1.8f, 1.0f);
                }
            }
            if (this.getDarkEnergyTicks() > 0 && this.getDarkEnergyTicks() % 5 == 0 && TragicConfig.getBoolean("enyvilDarkEnergySpray")) {
                this.useDarkEnergySpray();
            }
            if (this.canUseNewAbility() && this.isEntityInRange((Entity)this.func_70638_az(), 12.0f, 28.0f) && this.field_70146_Z.nextInt(128) == 0 && this.func_70685_l((Entity)this.func_70638_az()) && TragicConfig.getBoolean("enyvilTractorBeam")) {
                this.setTractorBeamTicks(200);
                if (TragicConfig.getBoolean("allowMobSounds")) {
                    this.func_85030_a("tragicmc:boss.enyvil.come", 1.8f, 1.0f);
                }
            }
            if (this.canUseNewAbility() && this.isEntityInRange((Entity)this.func_70638_az(), 8.0f, 24.0f) && this.field_70146_Z.nextInt(64) == 0 && !this.func_70685_l((Entity)this.func_70638_az()) && TragicConfig.getBoolean("enyvilCrystalLaser")) {
                this.setLaserTicks(200);
            }
            if (this.canUseNewAbility() && this.isEntityInRange((Entity)this.func_70638_az(), 6.0f, 18.0f) && this.field_70146_Z.nextInt(256) == 0 && TragicConfig.getBoolean("enyvilThunderstorm")) {
                this.setThunderstormTicks(120);
                if (TragicConfig.getBoolean("allowMobSounds")) {
                    this.func_85030_a("tragicmc:boss.enyvil.calling", 1.8f, 1.0f);
                }
            }
            if (this.getThunderstormTicks() > 0 && this.getThunderstormTicks() % 10 == 0 && TragicConfig.getBoolean("enyvilThunderstorm")) {
                this.createThunderstorm();
            }
            if (this.canUseNewAbility() && this.func_70032_d((Entity)this.func_70638_az()) <= 8.0f && this.field_70146_Z.nextInt(32) == 0 && this.field_70122_E && TragicConfig.getBoolean("enyvilSlam")) {
                this.setSlamTicks(40);
                if (TragicConfig.getBoolean("allowMobSounds")) {
                    this.func_85030_a("tragicmc:boss.enyvil.slam", 1.8f, 1.0f);
                }
            }
            if (this.getSlamTicks() == 4 && TragicConfig.getBoolean("enyvilSlam")) {
                this.useSlam();
            }
            if (this.field_70173_aa % 60 == 0 && this.field_70146_Z.nextInt(4) == 0 && this.func_70032_d((Entity)this.func_70638_az()) <= 20.0f && TragicConfig.getBoolean("enyvilThunderstorm")) {
                for (int meow = 0; meow < 4 + this.field_70146_Z.nextInt(3); ++meow) {
                    double d0 = this.field_70165_t + (double)this.getIntegerInRange(6, 22);
                    double d1 = this.field_70161_v + (double)this.getIntegerInRange(6, 22);
                    double d2 = this.field_70170_p.func_175672_r(new BlockPos((int)d0, 0, (int)d1)).func_177956_o();
                    this.field_70170_p.func_72838_d((Entity)new EntityDirectedLightning(this.field_70170_p, d0, d2, d1, (Entity)this));
                    this.field_70170_p.func_72876_a((Entity)this, d0, d2, d1, this.field_70146_Z.nextFloat() * 3.0f + 1.5f, this.getMobGriefing());
                }
            }
        }
        if (this.field_70123_F && this.getMobGriefing() && TragicConfig.getBoolean("enyvilDestroyBlocks")) {
            this.destroyBlocks();
        }
    }

    private void destroyBlocks() {
        ArrayList<BlockPos> list = WorldHelper.getBlocksInSphericalRange(this.field_70170_p, (double)this.field_70130_N - 0.725, this.field_70165_t, this.field_70163_u + (double)this.field_70131_O / 2.0 + 1.2, this.field_70161_v);
        for (BlockPos coords : list) {
            Block block = this.field_70170_p.func_180495_p(coords).func_177230_c();
            if (block.isAir((IBlockAccess)this.field_70170_p, coords) || !block.canEntityDestroy((IBlockAccess)this.field_70170_p, coords, (Entity)new EntityWither(this.field_70170_p))) continue;
            this.field_70170_p.func_175655_b(coords, true);
        }
    }

    private void updateTargetInfo() {
        if (this.func_70638_az() == null) {
            this.setAttackTargetID(0);
        } else if (!this.func_70638_az().field_70128_L) {
            this.setAttackTargetID(this.func_70638_az().func_145782_y());
        } else {
            this.setAttackTargetID(0);
        }
    }

    private void decrementValues() {
        if (this.getAttackTime() > 0) {
            this.decrementAttackTime();
        }
        if (this.getHurtTime() > 0) {
            this.decrementHurtTime();
        }
        if (this.getLightningTicks() > 0) {
            this.decrementLightningTicks();
        }
        if (this.getDarkEnergyTicks() > 0) {
            this.decrementDarkEnergyTicks();
        }
        if (this.getTractorBeamTicks() > 0) {
            this.decrementTractorBeamTicks();
        }
        if (this.getLaserTicks() > 0) {
            this.decrementLaserTicks();
        }
        if (this.getThunderstormTicks() > 0) {
            this.decrementThunderstormTicks();
        }
        if (this.getSlamTicks() > 0) {
            this.decrementSlamTicks();
        }
    }

    private void updateCrystal() {
        Entity entity = this.field_70170_p.func_73045_a(this.getCrystalID());
        this.crystal = entity != null && entity instanceof EntityDarkCrystal && !entity.field_70128_L ? (EntityDarkCrystal)entity : null;
        if (this.hasCrystal()) {
            if (this.field_70173_aa % 10 == 0 && this.func_110143_aJ() < this.func_110138_aP() && TragicConfig.getBoolean("enyvilRegeneration")) {
                this.func_70691_i(1.0f);
            }
            this.crystal.field_70159_w = this.field_70159_w;
            this.crystal.field_70179_y = this.field_70179_y;
            if (this.func_70032_d(this.crystal) >= 14.0f) {
                this.crystal.func_70107_b(this.field_70165_t + (double)this.getIntegerInRange(4, 8), this.field_70163_u + (double)Math.abs(this.getIntegerInRange(4, 8)), this.field_70161_v + (double)this.getIntegerInRange(4, 8));
                this.crystal.func_85030_a("mob.endermen.portal", 0.4f, 0.4f);
            }
            float f = 64.0f;
            List list = this.field_70170_p.func_72872_a(EntityDarkCrystal.class, this.func_174813_aQ().func_72314_b((double)f, (double)f, (double)f));
            for (EntityDarkCrystal crystal1 : list) {
                float fw;
                if (crystal1.getOwnerID() != this.func_145782_y() || !((fw = this.func_70032_d(crystal1)) >= 20.0f)) continue;
                crystal1.func_70107_b(this.field_70165_t + (double)this.getIntegerInRange(4, 8), this.field_70163_u + (double)Math.abs(this.getIntegerInRange(4, 8)), this.field_70161_v + (double)this.getIntegerInRange(4, 8));
                crystal1.func_85030_a("mob.endermen.portal", 0.4f, 0.4f);
            }
        } else {
            float f = 32.0f;
            List list = this.field_70170_p.func_72872_a(EntityDarkCrystal.class, this.func_174813_aQ().func_72314_b((double)f, (double)f, (double)f));
            EntityDarkCrystal crystal = null;
            double d0 = Double.MAX_VALUE;
            for (EntityDarkCrystal crystal1 : list) {
                double d1 = crystal1.func_70068_e((Entity)this);
                if (d1 < d0) {
                    d0 = d1;
                    crystal = crystal1;
                }
                crystal1.field_70159_w = this.field_70159_w;
                crystal1.field_70179_y = this.field_70179_y;
            }
            this.crystal = crystal;
            if (crystal != null) {
                this.setCrystalID(crystal.func_145782_y());
            }
            if (!this.hasCrystal() && this.crystalBuffer == 0) {
                this.createNewCrystals();
            }
        }
    }

    public void createNewCrystals() {
        if (this.crystalBuffer > 0 || !TragicConfig.getBoolean("enyvilDarkCrystals")) {
            return;
        }
        List list = this.field_70170_p.func_72872_a(EntityDarkCrystal.class, this.func_174813_aQ().func_72314_b(64.0, 64.0, 64.0));
        if (list.size() >= 5) {
            return;
        }
        if (!this.field_70170_p.field_72995_K && TragicConfig.getBoolean("allowMobSounds")) {
            this.func_85030_a("tragicmc:boss.enyvil.summon", 0.6f, 1.0f);
        }
        int amt = this.field_70146_Z.nextInt(this.field_70170_p.func_175659_aa().func_151525_a() + 1) + 2;
        for (int i = 0; i < amt; ++i) {
            EntityDarkCrystal crystal = new EntityDarkCrystal(this.field_70170_p, this);
            crystal.func_70107_b(this.field_70165_t + (double)this.getIntegerInRange(4, 12), this.field_70163_u + (double)Math.abs(this.getIntegerInRange(4, 12)), this.field_70161_v + (double)this.getIntegerInRange(4, 12));
            this.field_70170_p.func_72838_d((Entity)crystal);
        }
    }

    private void useDarkLightning() {
        if (!this.func_70685_l((Entity)this.func_70638_az())) {
            return;
        }
        double d0 = this.func_70638_az().field_70165_t - this.field_70165_t;
        double d1 = this.func_70638_az().func_174813_aQ().field_72338_b + (double)(this.func_70638_az().field_70131_O / 3.0f) - (this.field_70163_u + (double)(this.field_70131_O / 2.0f));
        double d2 = this.func_70638_az().field_70161_v - this.field_70161_v;
        float f = MathHelper.func_76129_c((float)this.func_70032_d((Entity)this.func_70638_az())) * 0.4875f;
        EntityDarkLightning lightning = new EntityDarkLightning(this.field_70170_p, (EntityLivingBase)this, d0 + this.field_70146_Z.nextGaussian() * (double)f, d1, d2 + this.field_70146_Z.nextGaussian() * (double)f);
        lightning.field_70165_t = this.field_70165_t + d0 * 0.115;
        lightning.field_70163_u = this.field_70163_u + 3.75;
        lightning.field_70161_v = this.field_70161_v + d0 * 0.115;
        this.field_70170_p.func_72838_d((Entity)lightning);
    }

    private void useDarkEnergySpray() {
        for (int i = 0; i < this.field_70146_Z.nextInt(4) + 3; ++i) {
            double d0 = this.func_70638_az().field_70165_t - this.field_70165_t;
            double d1 = this.func_70638_az().func_174813_aQ().field_72338_b + (double)(this.func_70638_az().field_70131_O / 3.0f) - (this.field_70163_u + (double)(this.field_70131_O / 2.0f));
            double d2 = this.func_70638_az().field_70161_v - this.field_70161_v;
            float f = MathHelper.func_76129_c((float)this.func_70032_d((Entity)this.func_70638_az())) * 0.1875f;
            EntityDarkEnergy energy = new EntityDarkEnergy(this.field_70170_p, (EntityLivingBase)this, d0 + this.field_70146_Z.nextGaussian() * (double)f, d1, d2 + this.field_70146_Z.nextGaussian() * (double)f);
            energy.field_70165_t = this.field_70165_t + d0 * 0.115;
            energy.field_70163_u = this.field_70163_u + 3.75;
            energy.field_70161_v = this.field_70161_v + d0 * 0.115;
            this.field_70170_p.func_72838_d((Entity)energy);
        }
    }

    public void tractorBeamEntity() {
        double d4;
        float f2;
        double d3;
        double d2;
        double d1;
        EntityLivingBase entity;
        if (this.field_70170_p.field_72995_K && this.getClientSideTarget() == null || !this.field_70170_p.field_72995_K && this.func_70638_az() == null) {
            return;
        }
        EntityLivingBase entityLivingBase = entity = this.field_70170_p.field_72995_K ? this.getClientSideTarget() : this.func_70638_az();
        if (entity != null && !this.func_70685_l((Entity)entity)) {
            return;
        }
        if (!this.field_70170_p.field_72995_K && this.getTractorBeamTicks() % 10 == 0 && TragicConfig.getBoolean("allowMobSounds")) {
            this.func_85030_a("tragicmc:boss.enyvil.tractor", 0.6f, 1.0f);
            this.func_70638_az().func_85030_a("tragicmc:boss.enyvil.tractor", 0.6f, 1.0f);
        }
        if (entity instanceof EntityPlayer) {
            if (!((EntityPlayer)entity).field_71075_bZ.field_75098_d) {
                d1 = entity.field_70165_t - this.field_70165_t;
                d2 = entity.field_70161_v - this.field_70161_v;
                d3 = entity.field_70163_u - this.field_70163_u;
                f2 = MathHelper.func_76133_a((double)(d1 * d1 + d2 * d2 + d3 * d3));
                d4 = 0.25;
                entity.field_70159_w = -d1 / (double)f2 * d4 * 0.200000011920929 + entity.field_70159_w * 0.3000000029802322;
                entity.field_70179_y = -d2 / (double)f2 * d4 * 0.200000011920929 + entity.field_70179_y * 0.3000000029802322;
                entity.field_70181_x = -d3 / (double)f2 * d4 * 0.140000011920929 + entity.field_70179_y * 0.3000000029802322;
                entity.func_70091_d(entity.field_70159_w, entity.field_70181_x, entity.field_70179_y);
            }
        } else {
            d1 = entity.field_70165_t - this.field_70165_t;
            d2 = entity.field_70161_v - this.field_70161_v;
            d3 = entity.field_70163_u - this.field_70163_u;
            f2 = MathHelper.func_76133_a((double)(d1 * d1 + d2 * d2 + d3 * d3));
            d4 = 0.5;
            entity.field_70159_w = -d1 / (double)f2 * d4 * 0.200000011920929 + entity.field_70159_w * 0.3000000029802322;
            entity.field_70179_y = -d2 / (double)f2 * d4 * 0.200000011920929 + entity.field_70179_y * 0.3000000029802322;
            entity.field_70181_x = -d3 / (double)f2 * d4 * 0.100000011920929 + entity.field_70179_y * 0.3000000029802322;
        }
        if (this.field_70170_p.field_72995_K && this.getClientSideTarget() != null) {
            double d32 = this.getClientSideTarget().field_70165_t - this.field_70165_t + 0.5;
            double d42 = this.getClientSideTarget().field_70163_u - this.field_70163_u - 1.85;
            double d5 = this.getClientSideTarget().field_70161_v - this.field_70161_v + 0.5;
            for (int i = 0; i < 8; ++i) {
                double d6 = 0.12 * (double)i + this.field_70146_Z.nextDouble() * 0.25;
                this.field_70170_p.func_175688_a(EnumParticleTypes.SPELL_WITCH, this.field_70165_t + d32 * d6, this.field_70163_u + d42 * d6 + 2.45, this.field_70161_v + d5 * d6, 0.0, 0.0, 0.0, new int[0]);
            }
        }
    }

    private void useLasers() {
        if (this.field_70170_p.field_72995_K && this.getClientSideTarget() == null || !this.field_70170_p.field_72995_K && this.func_70638_az() == null) {
            return;
        }
        float f = 32.0f;
        List list = this.field_70170_p.func_72872_a(EntityDarkCrystal.class, this.func_174813_aQ().func_72314_b((double)f, (double)f, (double)f));
        EntityDarkCrystal crystal2 = null;
        for (EntityDarkCrystal crystal2 : list) {
            if (!(this.field_70170_p.field_72995_K ? this.getClientSideTarget().func_70685_l((Entity)crystal2) : this.func_70638_az().func_70685_l((Entity)crystal2))) continue;
        }
        if (crystal2 != null && !crystal2.field_70128_L) {
            if (!this.field_70170_p.field_72995_K && crystal2.func_70032_d((Entity)this.func_70638_az()) <= 16.0f) {
                if (!this.field_70170_p.field_72995_K && TragicConfig.getBoolean("allowMobSounds")) {
                    crystal2.func_85030_a("tragicmc:boss.enyvil.laser", 1.0f, 1.0f);
                }
                this.func_70638_az().func_70097_a(DamageHelper.causeModMagicDamageToEntity((EntityLivingBase)this), 2.5f * this.field_70146_Z.nextFloat() + 1.0f);
                this.func_70638_az().func_70015_d(4);
            } else if (this.field_70170_p.field_72995_K) {
                double d0 = crystal2.field_70165_t - this.field_70165_t + 0.5;
                double d1 = crystal2.field_70163_u - this.field_70163_u + 2.45;
                double d2 = crystal2.field_70161_v - this.field_70161_v + 0.5;
                for (int i = 0; i < 8; ++i) {
                    double d3 = 0.12 * (double)i + this.field_70146_Z.nextDouble() * 0.25;
                    this.field_70170_p.func_175688_a(EnumParticleTypes.FLAME, this.field_70165_t + d0 * d3, this.field_70163_u + d1 * d3 + 0.45, this.field_70161_v + d2 * d3, 0.0, 0.0, 0.0, new int[0]);
                }
            }
        }
    }

    private void createThunderstorm() {
        boolean flag = TragicConfig.getBoolean("enyvilLightningExplosions");
        for (int i = 0; i < 3 + this.field_70146_Z.nextInt(3); i = (int)((byte)(i + 1))) {
            double d0 = this.field_70165_t + (double)this.getIntegerInRange(4, 16) + this.field_70146_Z.nextDouble();
            double d1 = this.field_70161_v + (double)this.getIntegerInRange(4, 16) + this.field_70146_Z.nextDouble();
            double d2 = this.field_70163_u - (double)WorldHelper.getDistanceToGround((Entity)this);
            this.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.field_70170_p, d0, d2, d1));
            if (!flag) continue;
            this.field_70170_p.func_72876_a((Entity)this, d0, d2, d1, this.field_70146_Z.nextFloat() * 2.0f + 0.5f, this.getMobGriefing());
        }
    }

    private void useSlam() {
        List list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72314_b(5.0, 5.0, 5.0));
        if (!list.isEmpty()) {
            this.attackEntitiesInList(list);
            this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70146_Z.nextFloat() * 2.0f + 3.5f, false);
        }
    }

    public boolean func_70067_L() {
        return false;
    }

    @Override
    public boolean func_70097_a(DamageSource source, float damage) {
        if (source.func_76346_g() != null && !(source.func_76346_g() instanceof EntityPlayer)) {
            return this.attackEntityFromPart(this.getDefaultPart(), source, damage);
        }
        return false;
    }

    @Override
    public World getWorld() {
        return this.field_70170_p;
    }

    @Override
    public boolean attackEntityFromPart(EntityPart entity, DamageSource source, float damage) {
        if (this.field_70170_p.field_72995_K || source.func_94541_c() || source == DamageSource.field_76369_e) {
            return false;
        }
        if (source == DamageSource.field_76368_d) {
            if (this.getMobGriefing() && TragicConfig.getBoolean("enyvilDestroyBlocks")) {
                this.destroyBlocks();
            }
            return false;
        }
        if (!this.hasCrystal()) {
            damage *= 2.0f;
        }
        if (entity == this.enyvilEye) {
            if (super.func_70097_a(source, damage) && !source.func_82725_o() && this.field_70146_Z.nextInt(4) == 0 && !this.hasCrystal()) {
                this.createNewCrystals();
            }
            if (this.getHurtTime() == 0) {
                this.setHurtTime(10);
            }
        } else {
            super.func_70097_a(source, damage / 6.0f + 1.0f);
        }
        return true;
    }

    public Entity[] func_70021_al() {
        return this.enyvilParts;
    }

    public void func_70690_d(PotionEffect effect) {
    }

    public void func_70015_d(int i) {
    }

    public void func_180430_e(float dist, float multi) {
    }

    public void func_70077_a(EntityLightningBolt bolt) {
    }

    private void attackEntitiesInList(List list) {
        for (int i = 0; i < list.size(); ++i) {
            Entity entity = (Entity)list.get(i);
            if (!(entity instanceof EntityLivingBase)) continue;
            float f = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
            entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), f / 2.0f);
            if (TragicConfig.getBoolean("allowFear")) {
                ((EntityLivingBase)entity).func_70690_d(new PotionEffect(TragicPotion.Fear.field_76415_H, 60 + this.field_70146_Z.nextInt(160), 1));
            }
            entity.field_70159_w *= 3.225;
            entity.field_70179_y *= 3.225;
            entity.field_70181_x += 0.225;
        }
    }

    @Override
    public boolean func_70652_k(Entity par1Entity) {
        if (this.field_70170_p.field_72995_K || this.func_70032_d(par1Entity) > 6.0f) {
            return false;
        }
        boolean result = super.func_70652_k(par1Entity);
        if (result) {
            par1Entity.field_70159_w *= 4.225;
            par1Entity.field_70179_y *= 4.225;
            par1Entity.field_70181_x += 0.625;
            if (this.getAttackTime() == 0) {
                this.setAttackTime(10);
            }
            if (this.getTractorBeamTicks() > 0) {
                par1Entity.field_70159_w *= 2.0;
                par1Entity.field_70179_y *= 2.0;
                this.setTractorBeamTicks(0);
                if (TragicConfig.getBoolean("allowMobSounds")) {
                    this.func_85030_a("tragicmc:boss.enyvil.laugh", 1.6f, 1.0f);
                }
            }
        }
        return result;
    }

    @Override
    public EntityPart getDefaultPart() {
        return this.enyvilShell;
    }

    @Override
    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        if (tag.func_74764_b("attackTime")) {
            this.setAttackTime(tag.func_74762_e("attackTime"));
        }
        if (tag.func_74764_b("hurtTime")) {
            this.setHurtTime(tag.func_74762_e("hurtTime"));
        }
        if (tag.func_74764_b("lightningTicks")) {
            this.setLightningTicks(tag.func_74762_e("lightningTicks"));
        }
        if (tag.func_74764_b("darkEnergyTicks")) {
            this.setDarkEnergyTicks(tag.func_74762_e("darkEnergyTicks"));
        }
        if (tag.func_74764_b("tractorBeamTicks")) {
            this.setTractorBeamTicks(tag.func_74762_e("tractorBeamTicks"));
        }
        if (tag.func_74764_b("laserTicks")) {
            this.setLaserTicks(tag.func_74762_e("laserTicks"));
        }
        if (tag.func_74764_b("thunderstormTicks")) {
            this.setThunderstormTicks(tag.func_74762_e("thunderstormTicks"));
        }
        if (tag.func_74764_b("crystalID")) {
            this.setCrystalID(tag.func_74762_e("crystalID"));
        }
        if (tag.func_74764_b("slamTicks")) {
            this.setSlamTicks(tag.func_74762_e("slamTicks"));
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        tag.func_74768_a("attackTime", this.getAttackTime());
        tag.func_74768_a("hurtTime", this.getHurtTime());
        tag.func_74768_a("lightningTicks", this.getLightningTicks());
        tag.func_74768_a("darkEnergyTicks", this.getDarkEnergyTicks());
        tag.func_74768_a("tractorBeamTicks", this.getTractorBeamTicks());
        tag.func_74768_a("laserTicks", this.getLaserTicks());
        tag.func_74768_a("thunderstormTicks", this.getThunderstormTicks());
        tag.func_74768_a("crystalID", this.getCrystalID());
        tag.func_74768_a("slamTicks", this.getSlamTicks());
    }

    public String func_70639_aQ() {
        return TragicConfig.getBoolean("allowMobSounds") ? "tragicmc:boss.enyvil.living" : null;
    }

    public String func_70621_aR() {
        return TragicConfig.getBoolean("allowMobSounds") ? (this.getHurtTime() > 0 ? "tragicmc:boss.enyvil.realhurt" : "tragicmc:boss.enyvil.hurt") : super.func_70621_aR();
    }

    public String func_70673_aS() {
        return TragicConfig.getBoolean("allowMobSounds") ? "tragicmc:boss.enyvil.death" : null;
    }

    public float func_70647_i() {
        return 1.0f;
    }

    public float func_70599_aP() {
        return 1.6f;
    }

    public int func_70627_aG() {
        return super.func_70627_aG() + 320;
    }
}

