/*
 * Decompiled with CFR 0.152.
 */
package tragicneko.tragicmc.entity;

import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import tragicneko.tragicmc.TragicMC;
import tragicneko.tragicmc.properties.PropertyMisc;

public class EntityPet
extends EntityCreature {
    private float level = 0.0f;
    private AbilityBase[] abilities = new AbilityBase[8];
    private boolean unlockAvailable = false;
    public EntityPlayer owner = null;
    private UUID ownerID = null;
    private boolean standby = false;
    private boolean follow = false;
    private Set<ItemFood> foods = new HashSet<ItemFood>();

    public EntityPet(World world) {
        super(world);
    }

    public void setOwner(EntityPlayer player) {
        this.owner = player;
        this.ownerID = player.getPersistentID();
    }

    public boolean isOwner(EntityPlayer player) {
        return this.hasOwner() && this.ownerID == player.getPersistentID();
    }

    public boolean hasOwner() {
        return this.ownerID != null;
    }

    public AbilityBase[] getAbilities() {
        return this.abilities;
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K && !this.standby) {
            for (AbilityBase ability : this.getAbilities()) {
                if (ability == null || !ability.isUnlocked() || !ability.isSelected()) continue;
                ability.onUpdate();
            }
        }
        if (this.owner != null) {
            PropertyMisc misc = PropertyMisc.get((EntityLivingBase)this.owner);
            if (misc != null && misc.getCurrentPet() != this) {
                this.owner = null;
            }
        } else {
            this.standby = false;
            if (false) {
                this.standby = true;
                this.onStandby();
            }
        }
    }

    public void onStandby() {
    }

    public void func_70074_a(EntityLivingBase entity) {
        super.func_70074_a(entity);
        if (entity instanceof EntityMob && this.getActualLevel() < this.getMaxLevel()) {
            this.addExperience(entity);
        }
    }

    public void addExperience(EntityLivingBase entity) {
        if (this.getActualLevel() >= this.getMaxLevel()) {
            return;
        }
        try {
            Field f = EntityLiving.class.getField("experienceValue");
            f.setAccessible(true);
            float j = f.getInt(entity);
            int i = this.getActualLevel();
            this.level += (j *= this.getExperienceRate());
            if (this.getActualLevel() > i) {
                TragicMC.logInfo("Pet has leveled up!");
            }
        }
        catch (Exception e) {
            TragicMC.logError("There was an error getting the experience value from a mob for leveling up a pet.", e);
        }
    }

    public float getExperienceRate() {
        return 1.0f - (float)this.getActualLevel() * this.getExperienceDeprecation();
    }

    public float getExperienceDeprecation() {
        return 0.1f;
    }

    public int getActualLevel() {
        return MathHelper.func_76128_c((double)(this.level / (float)this.getExperienceScale()));
    }

    public int getExperienceScale() {
        return 100;
    }

    public int getMaxLevel() {
        return this.abilities.length * 5;
    }

    public int getUnlockedTier() {
        return this.getActualLevel() > 15 ? 2 : (this.getActualLevel() > 10 ? 1 : 0);
    }

    protected boolean func_70085_c(EntityPlayer player) {
        if (this.hasOwner() && this.isOwner(player)) {
            ItemStack stack = player.func_71045_bC();
            if (stack == null) {
                if (player.func_70093_af()) {
                    this.standby = !this.standby;
                }
            } else if (this.foods.contains(stack.func_77973_b())) {
                this.func_70691_i(((ItemFood)stack.func_77973_b()).func_150905_g(stack));
            }
        } else if (this.hasOwner() && !this.isOwner(player)) {
            return false;
        }
        return super.func_70085_c(player);
    }

    public static class SampleAbility
    extends AbilityBase {
        public SampleAbility(EntityPet pet) {
            super(pet, (byte)2);
        }

        @Override
        public void onUpdate() {
            if (this.pet.owner != null && this.pet.owner.func_110143_aJ() < this.pet.owner.func_110138_aP() && this.pet.field_70173_aa % 5 == 0) {
                this.pet.owner.func_70691_i(1.0f);
            }
        }
    }

    public static abstract class AbilityBase {
        public final EntityPet pet;
        private boolean unlocked = false;
        private boolean selected = false;
        private final byte tier;

        public AbilityBase(EntityPet pet, byte tier) {
            this.pet = pet;
            this.tier = tier;
        }

        public abstract void onUpdate();

        public boolean isUnlocked() {
            return this.unlocked;
        }

        public void setUnlocked() {
            this.unlocked = true;
        }

        public byte getTier() {
            return this.tier;
        }

        public boolean isSelected() {
            return this.selected;
        }

        public void setSelected(boolean flag) {
            this.selected = flag;
        }

        public void saveToNBT(NBTTagCompound tag) {
            tag.func_74757_a("unlocked", this.unlocked);
            tag.func_74757_a("selected", this.selected);
        }

        public void readFromNBT(NBTTagCompound tag) {
            if (tag.func_74764_b("unlocked")) {
                this.unlocked = tag.func_74767_n("unlocked");
            }
            if (tag.func_74764_b("selected")) {
                this.selected = tag.func_74767_n("selected");
            }
        }
    }
}

