/*
 * Decompiled with CFR 0.152.
 */
package tragicneko.tragicmc.entity;

import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAIMoveTowardsTarget;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import tragicneko.tragicmc.TragicConfig;
import tragicneko.tragicmc.TragicItems;
import tragicneko.tragicmc.entity.EntityRidable;
import tragicneko.tragicmc.entity.boss.IMultiPart;
import tragicneko.tragicmc.entity.projectile.EntityNekoRocket;
import tragicneko.tragicmc.util.DamageHelper;
import tragicneko.tragicmc.util.WorldHelper;

public class EntityMechaExo
extends EntityRidable {
    private int cooldown = 100;
    public static final int DW_TARGET_ID = 20;
    public static final int DW_HAS_FIRED = 21;
    public static final int DW_THRUST_TICKS = 22;
    public static final int DW_ATTACK_TIME = 23;
    public static final int DW_VARIANT = 24;
    public final EntityAIBase attackOnCollide = new EntityAIAttackOnCollide((EntityCreature)this, EntityLivingBase.class, 1.0, true);
    public final EntityAIBase moveTowardsTarget = new EntityAIMoveTowardsTarget((EntityCreature)this, 1.0, 32.0f);
    public final EntityAIBase hurtByTarget = new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]);
    public final EntityAIBase wander = new EntityAIWander((EntityCreature)this, 0.65);
    public boolean titanfalled = false;
    private AttributeModifier mod = new AttributeModifier(UUID.fromString("8da6d3e6-6d80-4a77-8e15-e1c92892f449"), "exoDamageBoost", 4.0, 0);
    private AttributeModifier mod2 = new AttributeModifier(UUID.fromString("0f9522c5-44ad-4f1c-bf12-2efdda7fcdda"), "exoSpeedBoost", 0.1, 0);

    public EntityMechaExo(World par1World) {
        super(par1World);
        this.func_70105_a(2.45f, 2.45f);
        this.field_70138_W = 1.5f;
        this.field_70178_ae = true;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(20, (Object)0);
        this.field_70180_af.func_75682_a(21, (Object)0);
        this.field_70180_af.func_75682_a(22, (Object)0);
        this.field_70180_af.func_75682_a(23, (Object)0);
        this.field_70180_af.func_75682_a(24, (Object)0);
    }

    public int getTargetID() {
        return this.field_70180_af.func_75679_c(20);
    }

    private void setTargetID(int i) {
        this.field_70180_af.func_75692_b(20, (Object)i);
    }

    public boolean hasFired() {
        return this.field_70180_af.func_75683_a(21) == 1;
    }

    private void setFired(boolean flag, int i) {
        this.field_70180_af.func_75692_b(21, (Object)(flag ? (byte)1 : 0));
        this.setTargetID(flag ? i : 0);
    }

    public int getThrustTicks() {
        return this.field_70180_af.func_75679_c(22);
    }

    public void setThrustTicks(int i) {
        this.field_70180_af.func_75692_b(22, (Object)i);
    }

    public int getAttackTime() {
        return this.field_70180_af.func_75679_c(23);
    }

    public void setAttackTime(int i) {
        this.field_70180_af.func_75692_b(23, (Object)i);
    }

    public boolean isVariant() {
        return this.field_70180_af.func_75683_a(24) == 1;
    }

    public void setVariant(boolean flag) {
        this.field_70180_af.func_75692_b(24, (Object)((byte)(flag ? 1 : 0)));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        double[] mechaExoStats = TragicConfig.getMobStat("mechaExoStats").getStats();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(mechaExoStats[0]);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(mechaExoStats[1]);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(mechaExoStats[2]);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(mechaExoStats[3]);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(mechaExoStats[4]);
    }

    public int func_70658_aO() {
        return TragicConfig.getMobStat("mechaExoStats").getArmorValue();
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70170_p.field_72995_K) {
            int i;
            Entity entity = this.field_70170_p.func_73045_a(this.getTargetID());
            if (entity != null && this.hasFired()) {
                double d0 = entity.field_70165_t - this.field_70165_t;
                double d1 = entity.field_70163_u - this.field_70163_u - (double)this.field_70131_O + 0.225;
                double d2 = entity.field_70161_v - this.field_70161_v;
                for (int l = 0; l < 8; l = (int)((byte)(l + 1))) {
                    double d3 = 0.123 * (double)l + this.field_70146_Z.nextDouble() * 0.125;
                    this.field_70170_p.func_175688_a(EnumParticleTypes.FLAME, this.field_70165_t + d0 * d3, this.field_70163_u + d1 * d3 + (double)this.field_70131_O + 0.225, this.field_70161_v + d2 * d3, 0.0, 0.0, 0.0, new int[0]);
                }
            }
            if (this.getThrustTicks() > 0) {
                int l;
                for (l = 0; l < 10; l = (int)((byte)(l + 1))) {
                    this.field_70170_p.func_175688_a(EnumParticleTypes.CLOUD, this.field_70165_t - this.field_70159_w, this.field_70163_u + (double)this.field_70131_O - this.field_70181_x, this.field_70161_v - this.field_70179_y, 0.0, 0.0, 0.0, new int[0]);
                }
                for (l = 0; l < 5; l = (int)((byte)(l + 1))) {
                    this.field_70170_p.func_175688_a(EnumParticleTypes.FLAME, this.field_70165_t, this.field_70163_u + (double)this.field_70131_O, this.field_70161_v, 0.0, 0.0, 0.0, new int[0]);
                }
            }
            int n = i = this.func_110143_aJ() < this.func_110138_aP() / 3.0f ? 4 : 16;
            if (this.func_110143_aJ() < this.func_110138_aP() / 3.0f * 2.0f && this.field_70146_Z.nextInt(i) == 0) {
                for (int l = 0; l < 5; l = (int)((byte)(l + 1))) {
                    this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_LARGE, this.field_70165_t + (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble()) * 0.67, this.field_70163_u + (double)this.field_70131_O - (double)this.field_70131_O * this.field_70146_Z.nextDouble(), this.field_70161_v + (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble()) * 0.67, 0.0, 0.0, 0.0, new int[0]);
                }
            }
            return;
        }
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111124_b(this.mod);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111124_b(this.mod2);
        if (this.isVariant()) {
            this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111121_a(this.mod);
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111121_a(this.mod2);
        }
        if (this.hasFired() && this.cooldown <= 9) {
            this.setFired(false, 0);
        }
        if (this.cooldown > 0) {
            --this.cooldown;
        }
        if (this.getAttackTime() > 0) {
            this.setAttackTime(this.getAttackTime() - 1);
        }
        if (this.field_70153_n instanceof EntityLiving && this.func_70638_az() != ((EntityLiving)this.field_70153_n).func_70638_az()) {
            this.func_70624_b(((EntityLivingBase)this.field_70153_n).func_70643_av());
        }
        if (this.getThrustTicks() > 0 && this.field_70153_n != null) {
            double d2;
            double d0;
            Vec3 vec;
            this.setThrustTicks(this.getThrustTicks() - 1);
            this.field_70143_R = 0.0f;
            if (this.field_70153_n instanceof EntityPlayer) {
                vec = WorldHelper.getVecFromEntity(this.field_70153_n, 1.5);
                if (vec != null) {
                    d0 = vec.field_72450_a - this.field_70165_t;
                    d2 = vec.field_72449_c - this.field_70161_v;
                    this.field_70159_w = d0;
                    this.field_70179_y = d2;
                    this.field_70181_x = 0.05;
                    this.field_70177_z = -((float)Math.atan2(this.field_70159_w, this.field_70179_y)) * 180.0f / (float)Math.PI;
                }
            } else if (this.func_70638_az() != null && (vec = WorldHelper.getVecFromEntity((Entity)this, 1.5)) != null) {
                d0 = vec.field_72450_a - this.field_70165_t;
                d2 = vec.field_72449_c - this.field_70161_v;
                this.field_70159_w = d0;
                this.field_70179_y = d2;
                this.field_70181_x *= 1.1;
                this.field_70177_z = -((float)Math.atan2(this.field_70159_w, this.field_70179_y)) * 180.0f / (float)Math.PI;
            }
            List list = this.field_70170_p.func_72872_a(EntityLivingBase.class, this.func_174813_aQ().func_72314_b(2.0, 1.0, 2.0));
            for (int i = 0; i < list.size(); ++i) {
                EntityLivingBase e = (EntityLivingBase)list.get(i);
                if (e == this.field_70153_n || e == this || !(this.field_70153_n instanceof EntityLivingBase) || e instanceof EntityRidable) continue;
                this.func_70652_k((Entity)e);
            }
            if (this.func_70638_az() != null && this.func_70638_az().func_70055_a(Material.field_151586_h) && this.func_70032_d((Entity)this.func_70638_az()) > 6.0f && this.field_70153_n instanceof EntityLiving) {
                ((EntityLiving)this.field_70153_n).func_70624_b(null);
            }
            this.func_70031_b(true);
        } else if (this.getThrustTicks() <= 0) {
            this.func_70031_b(false);
        }
        if (this.func_70638_az() == this.field_70153_n || this.func_70638_az() != null && this.func_70638_az().field_70128_L) {
            this.func_70624_b(null);
        }
        if (this.func_110143_aJ() < this.func_110138_aP() / 3.0f && this.field_70173_aa % 20 == 0) {
            this.field_70170_p.func_72956_a((Entity)this, "tragicmc:random.beep", 0.2f, 1.6f);
        }
        if (this.titanfalled) {
            this.field_70181_x = -2.0;
        }
    }

    @Override
    public void useAttack(int attackType) {
        if (this.field_70153_n == null || !TragicConfig.getBoolean("allowRidableEntityAbilities")) {
            return;
        }
        Vec3 vec = WorldHelper.getVecFromEntity(this.field_70153_n, 30.0);
        if (vec == null) {
            return;
        }
        if (this.field_70153_n instanceof EntityLivingBase) {
            EntityLivingBase entity = (EntityLivingBase)this.field_70153_n;
            double d4 = vec.field_72450_a - entity.field_70165_t;
            double d5 = vec.field_72448_b - (entity.field_70163_u + (double)(entity.field_70131_O / 2.0f));
            double d6 = vec.field_72449_c - entity.field_70161_v;
            if (attackType == 0) {
                EntityNekoRocket rocket = new EntityNekoRocket(this.field_70170_p, entity, d4, d5, d6);
                rocket.field_70163_u = entity.field_70163_u + (double)entity.func_70047_e() - (double)0.45f;
                rocket.field_70165_t += d4 * 0.315;
                rocket.field_70161_v += d6 * 0.315;
                if (!this.field_70170_p.field_72995_K) {
                    this.cooldown = 20;
                    this.field_70170_p.func_72838_d((Entity)rocket);
                    this.field_70170_p.func_72956_a((Entity)this, "tragicmc:random.rocketflying", 0.8f, 1.6f);
                    this.field_70170_p.func_72956_a((Entity)this, "tragicmc:random.tinktink", 1.8f, 1.0f);
                }
            } else if (attackType == 1) {
                float f1 = entity.field_70127_C + (entity.field_70125_A - entity.field_70127_C);
                float f2 = entity.field_70126_B + (entity.field_70177_z - entity.field_70126_B);
                Vec3 vec3 = new Vec3(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
                float f3 = MathHelper.func_76134_b((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
                float f4 = MathHelper.func_76126_a((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
                float f5 = -MathHelper.func_76134_b((float)(-f1 * ((float)Math.PI / 180)));
                float f6 = MathHelper.func_76126_a((float)(-f1 * ((float)Math.PI / 180)));
                float f7 = f4 * f5;
                float f8 = f3 * f5;
                double box = 0.435;
                block0: for (double d = 0.0; d <= 30.0; d += 0.25) {
                    MovingObjectPosition mop;
                    Vec3 vec31 = vec3.func_72441_c((double)f7 * d, (double)f6 * d, (double)f8 * d);
                    if (d > 0.0 && (mop = WorldHelper.getMOPFromEntity((Entity)entity, d)) != null && mop.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) break;
                    AxisAlignedBB bb = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0).func_72314_b(box, box, box).func_72317_d(vec31.field_72450_a, vec31.field_72448_b + (double)entity.func_70047_e(), vec31.field_72449_c);
                    List list = this.field_70170_p.func_72839_b((Entity)entity, bb);
                    if (list.isEmpty()) continue;
                    for (Entity e : list) {
                        if (e == this || e == this.field_70154_o) continue;
                        if (e instanceof IMultiPart) {
                            ((IMultiPart)e).getDefaultPart().func_70097_a(DamageHelper.causeArmorPiercingDamageToEntity(entity), (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e());
                            if (TragicConfig.getBoolean("allowMobSounds")) {
                                this.field_70170_p.func_72956_a(e, "tragicmc:boss.aegar.laser", 0.4f, 1.8f);
                            }
                            this.setFired(true, e.func_145782_y());
                            this.cooldown = 10;
                            break block0;
                        }
                        if (e instanceof EntityItem || e instanceof EntityXPOrb || e instanceof EntityArrow || e == this || e == this.field_70153_n) continue;
                        e.func_70097_a(DamageHelper.causeArmorPiercingDamageToEntity(entity), (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e());
                        if (TragicConfig.getBoolean("allowMobSounds")) {
                            this.field_70170_p.func_72956_a(e, "tragicmc:boss.aegar.laser", 0.4f, 1.8f);
                        }
                        this.setFired(true, e.func_145782_y());
                        this.cooldown = 10;
                        break block0;
                    }
                }
                if (TragicConfig.getBoolean("allowMobSounds") && !this.field_70170_p.field_72995_K) {
                    this.field_70170_p.func_72956_a((Entity)this, "tragicmc:boss.aegar.laser", 0.4f, 1.8f);
                }
            } else {
                this.setThrustTicks(30);
                if (TragicConfig.getBoolean("allowMobSounds") && !this.field_70170_p.field_72995_K) {
                    this.field_70170_p.func_72956_a((Entity)this, "tragicmc:mob.exo.thruster", 1.8f, 1.0f);
                }
            }
        }
    }

    @Override
    public void useAttackViaMob(int attackType, EntityLivingBase target) {
        if (!TragicConfig.getBoolean("allowRidableEntityAbilitiesViaMob")) {
            return;
        }
        if (this.field_70153_n instanceof EntityLivingBase) {
            EntityLivingBase entity = (EntityLivingBase)this.field_70153_n;
            double d4 = target.field_70165_t - entity.field_70165_t;
            double d5 = target.field_70163_u - (entity.field_70163_u + (double)(entity.field_70131_O / 2.0f));
            double d6 = target.field_70161_v - entity.field_70161_v;
            if (attackType == 0) {
                EntityNekoRocket rocket = new EntityNekoRocket(this.field_70170_p, entity, d4, d5, d6);
                rocket.field_70163_u = this.field_70163_u + (double)this.func_70047_e() - (double)0.45f;
                rocket.field_70165_t += d4 * 0.315;
                rocket.field_70161_v += d6 * 0.315;
                if (!this.field_70170_p.field_72995_K) {
                    this.cooldown = 20;
                    this.field_70170_p.func_72838_d((Entity)rocket);
                    this.field_70170_p.func_72956_a((Entity)this, "tragicmc:random.rocketflying", 0.8f, 1.6f);
                    this.field_70170_p.func_72956_a((Entity)this, "tragicmc:random.tinktink", 1.8f, 1.0f);
                }
            } else if (attackType == 2) {
                this.setThrustTicks(15);
                if (TragicConfig.getBoolean("allowMobSounds") && !this.field_70170_p.field_72995_K) {
                    this.field_70170_p.func_72956_a((Entity)this, "tragicmc:mob.exo.thruster", 1.8f, 1.0f);
                }
            } else {
                if (this.func_70685_l((Entity)target)) {
                    target.func_70097_a(DamageHelper.causeArmorPiercingDamageToEntity((EntityLivingBase)this), (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e() / 2.0f);
                    this.setFired(true, target.func_145782_y());
                    this.cooldown = 10;
                }
                if (TragicConfig.getBoolean("allowMobSounds") && !this.field_70170_p.field_72995_K) {
                    this.field_70170_p.func_72956_a((Entity)this, "tragicmc:boss.aegar.laser", 0.4f, 1.8f);
                }
            }
        }
    }

    @Override
    public boolean canAttack() {
        return !this.field_70128_L && this.cooldown == 0 && this.getThrustTicks() == 0;
    }

    @Override
    public void onRiderChange() {
        if (this.previousRider instanceof EntityCreature && !(this.field_70153_n instanceof EntityCreature)) {
            this.field_70714_bg.func_85156_a(this.attackOnCollide);
            this.field_70714_bg.func_85156_a(this.moveTowardsTarget);
            this.field_70715_bh.func_85156_a(this.hurtByTarget);
            this.field_70714_bg.func_85156_a(this.wander);
        } else if (!(this.previousRider instanceof EntityCreature) && this.field_70153_n instanceof EntityCreature) {
            this.field_70714_bg.func_75776_a(0, this.attackOnCollide);
            this.field_70714_bg.func_75776_a(1, this.moveTowardsTarget);
            this.field_70714_bg.func_75776_a(6, this.wander);
            this.field_70715_bh.func_75776_a(2, this.hurtByTarget);
        }
    }

    public boolean func_70652_k(Entity entityIn) {
        if (this.field_70153_n == entityIn) {
            return false;
        }
        if (this.getAttackTime() > 0) {
            return false;
        }
        if (this.field_70153_n instanceof EntityLiving && entityIn instanceof EntityLivingBase && ((EntityLiving)this.field_70153_n).func_70638_az() == null) {
            ((EntityLiving)this.field_70153_n).func_70624_b((EntityLivingBase)entityIn);
        }
        if ((double)this.func_70032_d(entityIn) > 4.5) {
            return false;
        }
        boolean flag = entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e());
        if (flag) {
            entityIn.field_70159_w += this.field_70159_w * 2.0;
            entityIn.field_70179_y += this.field_70179_y * 2.0;
            entityIn.field_70181_x += 0.45;
            this.setAttackTime(10);
        }
        return flag;
    }

    public boolean func_70097_a(DamageSource src, float damage) {
        if (src == DamageSource.field_76379_h) {
            return false;
        }
        if (src.func_76346_g() != null && src.func_76346_g() == this.field_70153_n) {
            return false;
        }
        if (src.func_76346_g() instanceof EntityLiving && this.field_70153_n == null) {
            ((EntityLiving)src.func_76346_g()).func_70624_b(null);
        }
        if (src.func_76346_g() != this.func_70638_az() && this.field_70146_Z.nextInt(6) == 0 && this.field_70153_n instanceof EntityLiving && src.func_76346_g() instanceof EntityLivingBase && ((EntityLiving)this.field_70153_n).func_70643_av() != src.func_76346_g()) {
            ((EntityLiving)this.field_70153_n).func_70624_b((EntityLivingBase)src.func_76346_g());
        }
        return super.func_70097_a(src, damage);
    }

    public void func_180430_e(float dist, float multi) {
        if (!this.field_70170_p.field_72995_K && this.titanfalled && dist > 16.0f) {
            this.titanfalled = false;
            this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, 3.5f, false);
        }
    }

    @Override
    public boolean func_70085_c(EntityPlayer player) {
        Item item;
        if (player.func_71045_bC() != null && this.func_110143_aJ() > 0.0f && this.field_70153_n == null && ((item = player.func_71045_bC().func_77973_b()) == TragicItems.Wrench || Item.field_150901_e.func_177774_c((Object)item) != null && (((String)Item.field_150901_e.func_177774_c((Object)item)).contains("wrench") || ((String)Item.field_150901_e.func_177774_c((Object)item)).contains("Wrench")))) {
            if (!this.field_70170_p.field_72995_K && TragicConfig.getBoolean("allowNonMobItems")) {
                this.dropExoItem();
            } else {
                this.func_70656_aK();
            }
            this.func_70106_y();
            return true;
        }
        return super.func_70085_c(player);
    }

    private void dropExoItem() {
        ItemStack stack = new ItemStack(TragicItems.MechaExo, 1, MathHelper.func_76123_f((float)(this.func_110138_aP() - this.func_110143_aJ())));
        EntityItem item = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, stack);
        this.field_70170_p.func_72838_d((Entity)item);
    }

    protected void func_180429_a(BlockPos pos, Block block) {
        this.func_85030_a(block.field_149762_H.func_150498_e(), block.field_149762_H.func_150497_c() * 0.75f, block.field_149762_H.func_150494_d());
    }

    public String func_70639_aQ() {
        return null;
    }

    public String func_70621_aR() {
        return TragicConfig.getBoolean("allowMobSounds") ? "tragicmc:mob.exo.wrecked" : super.func_70621_aR();
    }

    public String func_70673_aS() {
        return TragicConfig.getBoolean("allowMobSounds") ? "tragicmc:mob.exo.hit" : null;
    }

    public float func_70647_i() {
        return 0.75f + this.field_70146_Z.nextFloat() * 0.5f;
    }

    public float func_70599_aP() {
        return 0.9f + this.field_70146_Z.nextFloat() * 0.2f;
    }

    public void func_70690_d(PotionEffect effect) {
    }

    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        if (tag.func_74764_b("targetID")) {
            this.setTargetID(tag.func_74762_e("targetID"));
        }
        if (tag.func_74764_b("thrustTicks")) {
            this.setThrustTicks(tag.func_74762_e("thrustTicks"));
        }
        if (tag.func_74764_b("attackTime")) {
            this.setAttackTime(tag.func_74762_e("attackTime"));
        }
        if (tag.func_74764_b("variant")) {
            this.setVariant(tag.func_74767_n("variant"));
        }
    }

    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        if (this.getTargetID() != 0) {
            tag.func_74768_a("targetID", this.getTargetID());
        }
        tag.func_74768_a("thrustTicks", this.getThrustTicks());
        tag.func_74768_a("attackTime", this.getAttackTime());
        tag.func_74757_a("variant", this.isVariant());
    }
}

