/*
 * Decompiled with CFR 0.152.
 */
package tragicneko.tragicmc.entity;

import com.google.common.base.Predicate;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.monster.EntityGolem;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityLargeFireball;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.BlockPos;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import tragicneko.tragicmc.TragicConfig;
import tragicneko.tragicmc.TragicEntities;
import tragicneko.tragicmc.TragicItems;
import tragicneko.tragicmc.TragicPotion;
import tragicneko.tragicmc.entity.EntityAIWatchTarget;

public class EntityKurayami
extends EntityGolem {
    public static final int DW_HURT_TIME = 20;
    public static final int DW_ATTACK_TIME = 21;
    public static final int DW_FIRING_TICKS = 22;
    public EntityPlayer owner;
    public int armorValue;
    private AttributeModifier mod = new AttributeModifier(UUID.fromString("c6334c3a-6cf4-4755-8fe5-d1b713c1f375"), "kitsuneSpeedDebuff", TragicConfig.modifier[1], 0);
    private int timeToLive;
    public static final Predicate mobTarget = new Predicate(){

        public boolean apply(Object input) {
            return this.canApply((Entity)input);
        }

        public boolean canApply(Entity entity) {
            return entity instanceof IMob;
        }
    };

    public EntityKurayami(World world) {
        super(world);
        this.func_70105_a(0.614625f, 1.439625f);
        this.field_70728_aV = 0;
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, EntityLivingBase.class, 1.0, true));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.75));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchTarget((EntityLiving)this, 32.0f));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIMoveTowardsTarget((EntityCreature)this, 1.0, 64.0f));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.field_70715_bh.func_75776_a(5, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLivingBase.class, 0, true, false, mobTarget));
        this.field_70178_ae = true;
        this.timeToLive = 1800;
    }

    public void setOwner(EntityPlayer player) {
        this.owner = player;
    }

    public void setKurayamiLevel(double d0) {
        double[] kurayamiStats = TragicConfig.getMobStat("kurayamiStats").getStats();
        this.armorValue = MathHelper.func_76143_f((double)(d0 * (double)TragicConfig.getMobStat("kurayamiStats").getArmorValue()));
        this.timeToLive = MathHelper.func_76143_f((double)(1800.0 * d0));
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(kurayamiStats[0] * d0);
        this.func_70606_j(this.func_110138_aP());
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(kurayamiStats[1]);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(kurayamiStats[2] * d0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(kurayamiStats[3] * d0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(kurayamiStats[4] * d0);
    }

    public EnumCreatureAttribute func_70668_bt() {
        return TragicEntities.Beast;
    }

    public boolean func_90999_ad() {
        return false;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        double[] kurayamiStats = TragicConfig.getMobStat("kurayamiStats").getStats();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(kurayamiStats[0]);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(kurayamiStats[1]);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(kurayamiStats[2]);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(kurayamiStats[3]);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(kurayamiStats[4]);
    }

    public int func_70658_aO() {
        return this.armorValue;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(20, (Object)0);
        this.field_70180_af.func_75682_a(21, (Object)0);
        this.field_70180_af.func_75682_a(22, (Object)0);
    }

    public int getHurtTime() {
        return this.field_70180_af.func_75679_c(20);
    }

    private void setHurtTime(int i) {
        this.field_70180_af.func_75692_b(20, (Object)i);
    }

    public int getAttackTime() {
        return this.field_70180_af.func_75679_c(21);
    }

    private void setAttackTime(int i) {
        this.field_70180_af.func_75692_b(21, (Object)i);
    }

    public int getFiringTicks() {
        return this.field_70180_af.func_75679_c(22);
    }

    private void setFiringTicks(int i) {
        this.field_70180_af.func_75692_b(22, (Object)i);
    }

    public void func_70636_d() {
        if (TragicConfig.getBoolean("allowCorruption") && this.func_70644_a(TragicPotion.Corruption)) {
            this.func_82170_o(TragicPotion.Corruption.field_76415_H);
        }
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K) {
            if (this.getHurtTime() > 0) {
                this.setHurtTime(this.getHurtTime() - 1);
            }
            if (this.getAttackTime() > 0) {
                this.setAttackTime(this.getAttackTime() - 1);
            }
            if (this.getFiringTicks() > 0) {
                this.setFiringTicks(this.getFiringTicks() - 1);
            }
            if (this.func_70638_az() == this.owner || this.func_70638_az() != null && this.func_70638_az().field_70128_L || this.func_70638_az() instanceof EntityKurayami) {
                this.func_70624_b(null);
            }
            if (this.func_70090_H()) {
                this.teleportRandomly();
            }
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111124_b(this.mod);
            if (this.getFiringTicks() > 0) {
                this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111121_a(this.mod);
            }
            if (this.func_70638_az() != null) {
                boolean flag;
                double d2;
                double d1;
                double d0;
                if (!this.func_70685_l((Entity)this.func_70638_az()) && (this.field_70146_Z.nextInt(56) == 0 || this.getHurtTime() > 0 && this.getHurtTime() % 20 == 0 && this.func_70032_d((Entity)this.func_70638_az()) > 4.0f || this.func_70032_d((Entity)this.func_70638_az()) >= 14.0f && this.field_70146_Z.nextInt(4) == 0)) {
                    this.teleportToEntity((Entity)this.func_70638_az());
                }
                if (this.getFiringTicks() > 0 && (this.func_70032_d((Entity)this.func_70638_az()) < 4.0f || this.func_70032_d((Entity)this.func_70638_az()) >= 14.0f)) {
                    this.setFiringTicks(0);
                } else if (this.field_70122_E && this.func_70032_d((Entity)this.func_70638_az()) < 4.0f && this.field_70146_Z.nextInt(32) == 0) {
                    d0 = this.func_70638_az().field_70165_t - this.field_70165_t;
                    d1 = this.func_70638_az().field_70161_v - this.field_70161_v;
                    d2 = this.func_70638_az().field_70163_u - this.field_70163_u;
                    float f2 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1 + d2 * d2));
                    this.field_70159_w = d0 / (double)f2 * 1.05 * 0.500000011920929 + this.field_70159_w * 0.40000000298023225;
                    this.field_70179_y = d1 / (double)f2 * 1.05 * 0.500000011920929 + this.field_70179_y * 0.40000000298023225;
                    this.field_70181_x = d1 / (double)f2 * 1.1 * 0.200000011920929 + this.field_70181_x * (double)0.2f;
                }
                if (this.field_70146_Z.nextInt(56) == 0 || this.getHurtTime() > 0 && this.getHurtTime() % 20 == 0 && this.func_70032_d((Entity)this.func_70638_az()) > 4.0f || this.func_70032_d((Entity)this.func_70638_az()) >= 14.0f && this.field_70146_Z.nextInt(4) == 0) {
                    this.teleportToEntity((Entity)this.func_70638_az());
                }
                if (this.isEntityInRange((Entity)this.func_70638_az(), 6.0f, 16.0f) && this.field_70146_Z.nextInt(4) == 0 && this.getFiringTicks() == 0 && this.func_70685_l((Entity)this.func_70638_az()) && this.field_70173_aa % 5 == 0) {
                    this.setFiringTicks(40);
                }
                if (this.isEntityInRange((Entity)this.func_70638_az(), 4.0f, 16.0f) && this.func_70685_l((Entity)this.func_70638_az()) && this.getFiringTicks() > 0 && this.getFiringTicks() % 25 == 0) {
                    d0 = this.func_70638_az().field_70165_t - this.field_70165_t;
                    d1 = this.func_70638_az().func_174813_aQ().field_72338_b + (double)(this.func_70638_az().field_70131_O / 2.0f) - (this.field_70163_u + (double)(this.field_70131_O / 2.0f));
                    d2 = this.func_70638_az().field_70161_v - this.field_70161_v;
                    EntityLargeFireball fireball = new EntityLargeFireball(this.field_70170_p, (EntityLivingBase)this, d0, d1, d2);
                    fireball.field_70163_u = this.field_70163_u + (double)(this.field_70131_O * 2.0f / 3.0f);
                    this.field_70170_p.func_72838_d((Entity)fireball);
                }
                if (this.func_70032_d((Entity)this.func_70638_az()) >= 12.0f && this.field_70146_Z.nextInt(36) == 0 && this.getFiringTicks() == 0 && !(flag = this.teleportToEntity((Entity)this.func_70638_az()))) {
                    this.teleportRandomly();
                }
            }
            if (this.owner == null || this.field_70173_aa > this.timeToLive) {
                this.func_70106_y();
            }
        }
    }

    public boolean isEntityInRange(Entity entity, float min, float max) {
        float f = this.func_70032_d(entity);
        return f >= min && f <= max;
    }

    public boolean func_70652_k(Entity entity) {
        boolean flag;
        if (this.field_70170_p.field_72995_K || TragicConfig.getBoolean("allowStun") && this.func_70644_a(TragicPotion.Stun) || this.getAttackTime() > 0) {
            return false;
        }
        boolean bl = flag = entity != this.owner && entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e());
        if (flag) {
            if (this.getFiringTicks() > 0) {
                this.setFiringTicks(0);
            }
            if (this.getAttackTime() == 0) {
                this.setAttackTime(20);
            }
            if (entity instanceof EntityLivingBase && this.field_70146_Z.nextBoolean()) {
                switch (this.field_70146_Z.nextInt(8)) {
                    default: {
                        ((EntityLivingBase)entity).func_70690_d(new PotionEffect(Potion.field_76440_q.field_76415_H, this.field_70146_Z.nextInt(200) + 320));
                        break;
                    }
                    case 1: {
                        ((EntityLivingBase)entity).func_70690_d(new PotionEffect(Potion.field_76419_f.field_76415_H, this.field_70146_Z.nextInt(200) + 320));
                        break;
                    }
                    case 2: {
                        if (!TragicConfig.getBoolean("allowDisorientation")) break;
                        ((EntityLivingBase)entity).func_70690_d(new PotionEffect(TragicPotion.Disorientation.field_76415_H, this.field_70146_Z.nextInt(200) + 320));
                    }
                }
            }
            if (this.field_70146_Z.nextInt(4) == 0) {
                entity.func_70015_d(4 + this.field_70146_Z.nextInt(8));
            }
        }
        return flag;
    }

    public boolean func_70097_a(DamageSource src, float dmg) {
        if (this.getHurtTime() > 0) {
            return false;
        }
        if (src.func_76346_g() instanceof EntityPlayer) {
            boolean flag;
            EntityPlayer player = (EntityPlayer)src.func_76346_g();
            boolean bl = player.func_71045_bC() == null ? false : (flag = player.func_71045_bC().func_77973_b() == TragicItems.BowOfJustice || player.func_71045_bC().func_77973_b() == TragicItems.SwordOfJustice);
            if (src.func_76346_g() == this.owner || flag && player.field_71075_bZ.field_75098_d) {
                return super.func_70097_a(src, dmg);
            }
        }
        return super.func_70097_a(src, dmg);
    }

    protected boolean teleportRandomly() {
        double d0 = this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * 24.0;
        double d1 = this.field_70163_u + (double)(this.field_70146_Z.nextInt(48) - 24);
        double d2 = this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * 24.0;
        return this.teleportTo(d0, d1, d2);
    }

    protected boolean teleportToEntity(Entity par1Entity) {
        Vec3 vec3 = new Vec3(this.field_70165_t - par1Entity.field_70165_t, this.func_174813_aQ().field_72338_b + (double)(this.field_70131_O / 2.0f) - par1Entity.field_70163_u + (double)par1Entity.func_70047_e(), this.field_70161_v - par1Entity.field_70161_v);
        vec3 = vec3.func_72432_b();
        double d0 = 16.0;
        double d1 = this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * 8.0 - vec3.field_72450_a * d0;
        double d2 = this.field_70163_u + (double)(this.field_70146_Z.nextInt(16) - 8) - vec3.field_72448_b * d0;
        double d3 = this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * 8.0 - vec3.field_72449_c * d0;
        return this.teleportTo(d1, d2, d3);
    }

    protected boolean teleportTo(double par1, double par3, double par5) {
        int k;
        int j;
        double d3 = this.field_70165_t;
        double d4 = this.field_70163_u;
        double d5 = this.field_70161_v;
        this.field_70165_t = par1;
        this.field_70163_u = par3;
        this.field_70161_v = par5;
        boolean flag = false;
        int i = MathHelper.func_76128_c((double)this.field_70165_t);
        if (this.field_70170_p.func_175697_a(new BlockPos(i, j = MathHelper.func_76128_c((double)this.field_70163_u), k = MathHelper.func_76128_c((double)this.field_70161_v)), 4)) {
            boolean flag1 = false;
            while (!flag1 && j > 0) {
                Block block = this.field_70170_p.func_180495_p(new BlockPos(i, j - 1, k)).func_177230_c();
                if (block.func_149688_o().func_76230_c()) {
                    flag1 = true;
                    continue;
                }
                this.field_70163_u -= 1.0;
                --j;
            }
            if (flag1) {
                this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                if (this.field_70170_p.func_72945_a((Entity)this, this.func_174813_aQ()).isEmpty() && !this.field_70170_p.func_72953_d(this.func_174813_aQ())) {
                    flag = true;
                }
            }
        }
        if (!flag) {
            this.func_70107_b(d3, d4, d5);
            return false;
        }
        int short1 = 128;
        for (int l = 0; l < short1; ++l) {
            double d6 = (double)l / ((double)short1 - 1.0);
            float f = (this.field_70146_Z.nextFloat() - 0.5f) * 0.2f;
            float f1 = (this.field_70146_Z.nextFloat() - 0.5f) * 0.2f;
            float f2 = (this.field_70146_Z.nextFloat() - 0.5f) * 0.2f;
            double d7 = d3 + (this.field_70165_t - d3) * d6 + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N * 2.0;
            double d8 = d4 + (this.field_70163_u - d4) * d6 + this.field_70146_Z.nextDouble() * (double)this.field_70131_O;
            double d9 = d5 + (this.field_70161_v - d5) * d6 + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N * 2.0;
            this.field_70170_p.func_175688_a(EnumParticleTypes.FLAME, d7, d8, d9, (double)f, (double)f1, (double)f2, new int[0]);
        }
        this.field_70170_p.func_72908_a(d3, d4, d5, "mob.endermen.portal", 1.0f, 1.0f);
        this.func_85030_a(this.func_70639_aQ() == null ? "mob.endermen.portal" : this.func_70639_aQ(), 1.0f, 1.0f);
        return true;
    }

    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        if (tag.func_74764_b("firingTicks")) {
            this.setFiringTicks(tag.func_74762_e("firingTicks"));
        }
        if (tag.func_74764_b("hurtTime")) {
            this.setHurtTime(tag.func_74762_e("hurtTime"));
        }
        if (tag.func_74764_b("attackTime")) {
            this.setAttackTime(tag.func_74762_e("attackTime"));
        }
        if (tag.func_74764_b("armorValue")) {
            this.armorValue = tag.func_74762_e("armorValue");
        }
    }

    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        tag.func_74768_a("firingTicks", this.getFiringTicks());
        tag.func_74768_a("hurtTime", this.getHurtTime());
        tag.func_74768_a("attackTime", this.getAttackTime());
        tag.func_74768_a("armorValue", this.armorValue);
    }

    public IEntityLivingData func_180482_a(DifficultyInstance ins, IEntityLivingData data) {
        if (this.owner == null) {
            this.setOwner(this.field_70170_p.func_72977_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, 16.0));
        }
        this.setKurayamiLevel(1.0);
        return super.func_180482_a(ins, data);
    }

    public String func_70639_aQ() {
        return TragicConfig.getBoolean("allowMobSounds") ? "tragicmc:boss.kitsune.living" : null;
    }

    public String func_70621_aR() {
        return TragicConfig.getBoolean("allowMobSounds") ? "tragicmc:boss.kitsune.hurt" : super.func_70621_aR();
    }

    public String func_70673_aS() {
        return TragicConfig.getBoolean("allowMobSounds") ? "tragicmc:boss.kitsune.hurt" : null;
    }

    public float func_70647_i() {
        return 1.4f + this.field_70146_Z.nextFloat() * 0.2f;
    }

    public float func_70599_aP() {
        return 0.6f;
    }

    public int func_70627_aG() {
        return super.func_70627_aG() / 2;
    }
}

