/*
 * Decompiled with CFR 0.152.
 */
package tragicneko.tragicmc.dimension;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ReportedException;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.BiomeCache;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.biome.WorldChunkManager;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.gen.layer.GenLayerVoronoiZoom;
import net.minecraft.world.gen.layer.GenLayerZoom;
import net.minecraft.world.gen.layer.IntCache;
import tragicneko.tragicmc.TragicBiome;
import tragicneko.tragicmc.TragicConfig;
import tragicneko.tragicmc.dimension.TragicBiomeGenLayer;

public class TragicWorldChunkManager
extends WorldChunkManager {
    private GenLayer genLayerBiomes;
    private GenLayer genLayerBiomeIndex;
    private BiomeCache biomeCache = new BiomeCache((WorldChunkManager)this);
    private List<BiomeGenBase> spawnBiomes = new ArrayList<BiomeGenBase>();

    public TragicWorldChunkManager(long seed, WorldType worldType) {
        this.addBiomes(this.spawnBiomes);
        GenLayer[] genLayers = TragicWorldChunkManager.getGenLayers(seed, worldType);
        this.genLayerBiomes = genLayers[0];
        this.genLayerBiomeIndex = genLayers[1];
    }

    public TragicWorldChunkManager(World world) {
        this(world.func_72905_C(), world.func_72912_H().func_76067_t());
    }

    public void addBiomes(List<BiomeGenBase> list) {
        list.add(TragicBiome.DecayingHills);
        list.add(TragicBiome.DecayingWasteland);
        list.add(TragicBiome.PaintedForest);
        list.add(TragicBiome.PaintedPlains);
        list.add(TragicBiome.AshenBadlands);
        list.add(TragicBiome.StarlitPrarie);
        list.add(TragicBiome.StarlitPlateaus);
        list.add(TragicBiome.TaintedLowlands);
        list.add(TragicBiome.HallowedPrarie);
        list.add(TragicBiome.HallowedForest);
    }

    public static GenLayer[] getGenLayers(long seed, WorldType worldType) {
        TragicBiomeGenLayer biomes = new TragicBiomeGenLayer(seed);
        biomes = GenLayerZoom.func_75915_a((long)100L, (GenLayer)biomes, (int)TragicConfig.getInt("collisionBiomeSize"));
        GenLayerVoronoiZoom zoom = new GenLayerVoronoiZoom(10L, (GenLayer)biomes);
        biomes.func_75905_a(seed);
        zoom.func_75905_a(seed);
        return new GenLayer[]{biomes, zoom};
    }

    public final List func_76932_a() {
        return this.spawnBiomes;
    }

    public BiomeGenBase func_180631_a(BlockPos pos) {
        return this.func_180300_a(pos, null);
    }

    public BiomeGenBase func_180300_a(BlockPos pos, BiomeGenBase biome) {
        return this.biomeCache.func_180284_a(pos.func_177958_n(), pos.func_177952_p(), biome);
    }

    public float[] func_76936_a(float[] store, int x, int z, int width, int height) {
        IntCache.func_76446_a();
        int len = width * height;
        if (store == null || store.length < len) {
            store = new float[len];
        }
        int[] ints = this.genLayerBiomeIndex.func_75904_a(x, z, width, height);
        for (int i = 0; i < len; ++i) {
            try {
                float f = (float)BiomeGenBase.func_150568_d((int)ints[i]).func_76744_g() / 65536.0f;
                if (f > 1.0f) {
                    f = 1.0f;
                }
                store[i] = f;
                continue;
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Invalid Biome id");
                CrashReportCategory crashreportcategory = crashreport.func_85058_a("DownfallBlock");
                crashreportcategory.func_71507_a("biome id", (Object)i);
                crashreportcategory.func_71507_a("downfalls[] size", (Object)store.length);
                crashreportcategory.func_71507_a("x", (Object)x);
                crashreportcategory.func_71507_a("z", (Object)z);
                crashreportcategory.func_71507_a("w", (Object)width);
                crashreportcategory.func_71507_a("h", (Object)height);
                throw new ReportedException(crashreport);
            }
        }
        return store;
    }

    public float func_76939_a(float temperature, int y) {
        return temperature;
    }

    public BiomeGenBase[] func_76937_a(BiomeGenBase[] store, int x, int z, int width, int height) {
        IntCache.func_76446_a();
        int len = width * height;
        if (store == null || store.length < len) {
            store = new BiomeGenBase[len];
        }
        int[] ints = this.genLayerBiomes.func_75904_a(x, z, width, height);
        for (int i = 0; i < len; ++i) {
            try {
                store[i] = BiomeGenBase.func_150568_d((int)ints[i]);
                continue;
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Invalid Biome id");
                CrashReportCategory crashreportcategory = crashreport.func_85058_a("RawBiomeBlock");
                crashreportcategory.func_71507_a("biomes[] size", (Object)store.length);
                crashreportcategory.func_71507_a("x", (Object)x);
                crashreportcategory.func_71507_a("z", (Object)z);
                crashreportcategory.func_71507_a("w", (Object)width);
                crashreportcategory.func_71507_a("h", (Object)height);
                throw new ReportedException(crashreport);
            }
        }
        return store;
    }

    public BiomeGenBase[] func_76933_b(BiomeGenBase[] store, int x, int z, int width, int height) {
        return this.func_76931_a(store, x, z, width, height, true);
    }

    public BiomeGenBase[] func_76931_a(BiomeGenBase[] store, int x, int z, int width, int height, boolean cache) {
        IntCache.func_76446_a();
        int len = width * height;
        if (store == null || store.length < len) {
            store = new BiomeGenBase[len];
        }
        if (cache && width == 16 && height == 16 && (x & 0xF) == 0 && (z & 0xF) == 0) {
            BiomeGenBase[] biomes = this.biomeCache.func_76839_e(x, z);
            System.arraycopy(biomes, 0, store, 0, len);
            return store;
        }
        int[] ints = this.genLayerBiomeIndex.func_75904_a(x, z, width, height);
        for (int i = 0; i < len; ++i) {
            store[i] = BiomeGenBase.func_150568_d((int)ints[i]);
        }
        return store;
    }

    public boolean func_76940_a(int x, int z, int range, List biomes) {
        IntCache.func_76446_a();
        int x1 = x - range >> 2;
        int z1 = z - range >> 2;
        int x2 = x + range >> 2;
        int z2 = z + range >> 2;
        int x3 = x2 - x1 + 1;
        int z3 = z2 - z1 + 1;
        int len = x3 * z3;
        int[] ints = this.genLayerBiomes.func_75904_a(x1, z1, x3, z3);
        try {
            for (int i = 0; i < len; ++i) {
                BiomeGenBase biomegenbase = BiomeGenBase.func_150568_d((int)ints[i]);
                if (biomes.contains(biomegenbase) && biomegenbase instanceof TragicBiome) continue;
                return false;
            }
            return true;
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Invalid Biome id");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("Layer");
            crashreportcategory.func_71507_a("Layer", (Object)this.genLayerBiomes.toString());
            crashreportcategory.func_71507_a("x", (Object)x);
            crashreportcategory.func_71507_a("z", (Object)z);
            crashreportcategory.func_71507_a("radius", (Object)range);
            crashreportcategory.func_71507_a("allowed", (Object)biomes);
            throw new ReportedException(crashreport);
        }
    }

    public BlockPos func_180630_a(int x, int z, int range, List biomes, Random random) {
        IntCache.func_76446_a();
        int l = x - range >> 2;
        int i1 = z - range >> 2;
        int j1 = x + range >> 2;
        int k1 = z + range >> 2;
        int l1 = j1 - l + 1;
        int i2 = k1 - i1 + 1;
        int[] aint = this.genLayerBiomes.func_75904_a(l, i1, l1, i2);
        BlockPos blockpos = null;
        int j2 = 0;
        for (int k2 = 0; k2 < l1 * i2; ++k2) {
            int l2 = l + k2 % l1 << 2;
            int i3 = i1 + k2 / l1 << 2;
            BiomeGenBase biomegenbase = BiomeGenBase.func_150568_d((int)aint[k2]);
            if (!biomes.contains(biomegenbase) || blockpos != null && random.nextInt(j2 + 1) != 0) continue;
            blockpos = new BlockPos(l2, 0, i3);
            ++j2;
        }
        return blockpos;
    }

    public final void func_76938_b() {
        this.biomeCache.func_76838_a();
    }
}

