/*
 * Decompiled with CFR 0.152.
 */
package tragicneko.tragicmc.dimension;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.LongHashMap;
import tragicneko.tragicmc.dimension.WildsChunkManager;
import tragicneko.tragicmc.worldgen.subbiome.TragicSubBiome;

public class SubBiomeCache {
    private final WildsChunkManager chunkManager;
    private long lastCleanupTime;
    private LongHashMap cacheMap = new LongHashMap();
    private List cache = Lists.newArrayList();

    public SubBiomeCache(WildsChunkManager chunkManagerIn) {
        this.chunkManager = chunkManagerIn;
    }

    public Block getBiomeCacheBlock(int x, int z) {
        long k = (long)(x >>= 4) & 0xFFFFFFFFL | ((long)(z >>= 4) & 0xFFFFFFFFL) << 32;
        Block block = (Block)this.cacheMap.func_76164_a(k);
        if (block == null) {
            block = new Block(x, z);
            this.cacheMap.func_76163_a(k, (Object)block);
            this.cache.add(block);
        }
        block.lastAccessTime = MinecraftServer.func_130071_aq();
        return block;
    }

    public TragicSubBiome func_180284_a(int x, int z, TragicSubBiome biome) {
        TragicSubBiome biomegenbase1 = this.getBiomeCacheBlock(x, z).getBiomeGenAt(x, z);
        return biomegenbase1 == null ? biome : biomegenbase1;
    }

    public void cleanupCache() {
        long i = MinecraftServer.func_130071_aq();
        long j = i - this.lastCleanupTime;
        if (j > 7500L || j < 0L) {
            this.lastCleanupTime = i;
            for (int k = 0; k < this.cache.size(); ++k) {
                Block block = (Block)this.cache.get(k);
                long l = i - block.lastAccessTime;
                if (l <= 30000L && l >= 0L) continue;
                this.cache.remove(k--);
                long i1 = (long)block.xPosition & 0xFFFFFFFFL | ((long)block.zPosition & 0xFFFFFFFFL) << 32;
                this.cacheMap.func_76159_d(i1);
            }
        }
    }

    public TragicSubBiome[] getCachedBiomes(int x, int z) {
        return this.getBiomeCacheBlock((int)x, (int)z).biomes;
    }

    public class Block {
        public float[] rainfallValues = new float[256];
        public TragicSubBiome[] biomes = new TragicSubBiome[256];
        public int xPosition;
        public int zPosition;
        public long lastAccessTime;

        public Block(int x, int z) {
            this.xPosition = x;
            this.zPosition = z;
            SubBiomeCache.this.chunkManager.func_76936_a(this.rainfallValues, x << 4, z << 4, 16, 16);
            SubBiomeCache.this.chunkManager.getBiomeGenAt(this.biomes, x << 4, z << 4, 16, 16, false);
        }

        public TragicSubBiome getBiomeGenAt(int x, int z) {
            return this.biomes[x & 0xF | (z & 0xF) << 4];
        }
    }
}

