/*
 * Decompiled with CFR 0.152.
 */
package tragicneko.tragicmc.config;

import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import tragicneko.tragicmc.TragicConfig;

public class ConfigHardcore
extends TragicConfig {
    /*
     * Opcode count of 27089 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    public static void load(Configuration config) {
        config.load();
        String s = "";
        ConfigHardcore.registerObject("allowNonMobItems", true);
        ConfigHardcore.registerObject("allowNonMobBlocks", true);
        ConfigHardcore.registerObject("allowNetwork", true);
        ConfigHardcore.registerObject("allowRecipes", true);
        ConfigHardcore.registerObject("allowSurvivalTab", true);
        ConfigCategory cat = config.getCategory("Blanket Configs");
        cat.setComment("These disable all options beneath them if set to false.");
        s = "allowAchievements";
        Property prop = config.get(cat.getName(), s, true);
        prop.comment = "Are Achievements and Achievement options allowed?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "allowAmulets";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Are Amulets, Amulet Modifiers, Amulet Guis and Amulet recipes allowed?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "allowDimensions";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Are the mod-exclusive Dimensions and Biomes allowed?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "allowDoom";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Are Doom, Doomsdays and non-Doomsday Weapon/Armor abilities allowed?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "allowEnchantments";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Are mod-exclusive Weapon and Armor Enchantments allowed?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "allowMobs";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Are mod-exclusive Mobs and Bosses allowed?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "allowPotions";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Are mod-exclusive Potion Effects allowed and can they be used by the mod's Mobs and various effects?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "allowVanillaChanges";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Are changes to Vanilla like increasing Vanilla mob health and giving extra abilities to Vanilla mobs allowed?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "allowWorldGen";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Is the mod able to execute any of it's non-Ore WorldGen?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        cat = config.getCategory("Amulets");
        cat.setComment("These allow you to toggle various aspects of Amulets.");
        prop = config.get(cat.getName(), "allowAmuletLeveling", true);
        prop.comment = "Are amulets able to be leveled up by combining them in a crafting recipe?";
        int m = 0;
        ConfigHardcore.amuletConfig[0] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "allowAmuletCrafting", true);
        prop.comment = "Can amulets be crafted via raw materials?";
        m = (byte)(m + 1);
        ConfigHardcore.amuletConfig[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "requireAmuletSlotUnlock", true);
        prop.comment = "Do you need to use an Amulet Release to unlock a new Amulet slot?";
        m = (byte)(m + 1);
        ConfigHardcore.amuletConfig[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "allowAmuletBossKillCharge", true);
        prop.comment = "Will your Amulets repair some durability after killing a Boss?";
        m = (byte)(m + 1);
        ConfigHardcore.amuletConfig[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "allowAmuletModifiers", true);
        prop.comment = "Will Amulets have random modifiers that affect their user while equipped?";
        m = (byte)(m + 1);
        ConfigHardcore.amuletConfig[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "allowAmuletDeathDrops", true);
        prop.comment = "Do Amulets drop off of you on death?";
        ConfigHardcore.amuletConfig[(byte)(m + 1)] = prop.getBoolean(true);
        s = "amuletMaxSlots";
        prop = config.get(cat.getName(), s, 1);
        prop.comment = "The maximum amount of slots you can have unlocked.";
        ConfigHardcore.registerObject(s, ConfigHardcore.clamp(prop.getInt(1), 0, 3));
        s = "amuletOverallRarity";
        prop = config.get(cat.getName(), s, 0);
        prop.comment = "The chance of you getting an Amulet in a chest, higher value is higher chance.";
        ConfigHardcore.registerObject(s, ConfigHardcore.clamp(prop.getInt(0), 1, 250));
        s = "amuletReleaseRarity";
        prop = config.get(cat.getName(), s, 5);
        prop.comment = "The chance of you getting an Amulet Release in a chest, higher value is higher chance.";
        ConfigHardcore.registerObject(s, ConfigHardcore.clamp(prop.getInt(5), 1, 250));
        s = "amuletModChance";
        prop = config.get(cat.getName(), s, 54);
        prop.comment = "Affects the chance of getting at least one Modifier on an Amulet. Lower value is higher chance.";
        ConfigHardcore.registerObject(s, ConfigHardcore.clamp(prop.getInt(54), 1, 100));
        s = "amuletModChance2";
        prop = config.get(cat.getName(), s, 79);
        prop.comment = "Affects the chance of getting a second Modifier on an Amulet. Lower value is higher chance.";
        ConfigHardcore.registerObject(s, ConfigHardcore.clamp(prop.getInt(79), 1, 100));
        s = "amuletModChance3";
        prop = config.get(cat.getName(), s, 89);
        prop.comment = "Affects the chance of getting a third Modifier on an Amulet. Lower value is higher chance.";
        ConfigHardcore.registerObject(s, ConfigHardcore.clamp(prop.getInt(89), 1, 100));
        s = "amuletStartSlots";
        prop = config.get(cat.getName(), s, 1);
        prop.comment = "The amount of slots you have unlocked at the start.";
        ConfigHardcore.registerObject(s, ConfigHardcore.clamp(prop.getInt(1), 0, 3));
        cat = config.getCategory("Amulet Effects");
        cat.setComment("Disable or enable certain Amulet Effects.");
        prop = config.get(cat.getName(), "peace", true);
        m = 0;
        ConfigHardcore.amuletEffects[0] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "yeti", true);
        m = (byte)(m + 1);
        ConfigHardcore.amuletEffects[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "claymation", true);
        m = (byte)(m + 1);
        ConfigHardcore.amuletEffects[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "chicken", true);
        m = (byte)(m + 1);
        ConfigHardcore.amuletEffects[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "blacksmith", true);
        m = (byte)(m + 1);
        ConfigHardcore.amuletEffects[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "creeper", true);
        m = (byte)(m + 1);
        ConfigHardcore.amuletEffects[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "zombie", true);
        m = (byte)(m + 1);
        ConfigHardcore.amuletEffects[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "skeleton", true);
        m = (byte)(m + 1);
        ConfigHardcore.amuletEffects[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "ice", true);
        m = (byte)(m + 1);
        ConfigHardcore.amuletEffects[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "snowGolem", true);
        m = (byte)(m + 1);
        ConfigHardcore.amuletEffects[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "ironGolem", true);
        m = (byte)(m + 1);
        ConfigHardcore.amuletEffects[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "spider", true);
        m = (byte)(m + 1);
        ConfigHardcore.amuletEffects[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "stin", true);
        m = (byte)(m + 1);
        ConfigHardcore.amuletEffects[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "supernatural", true);
        m = (byte)(m + 1);
        ConfigHardcore.amuletEffects[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "fusea", true);
        m = (byte)(m + 1);
        ConfigHardcore.amuletEffects[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "luck", true);
        m = (byte)(m + 1);
        ConfigHardcore.amuletEffects[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "kitsune", true);
        m = (byte)(m + 1);
        ConfigHardcore.amuletEffects[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "martyr", true);
        m = (byte)(m + 1);
        ConfigHardcore.amuletEffects[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "piercing", true);
        m = (byte)(m + 1);
        ConfigHardcore.amuletEffects[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "apis", true);
        m = (byte)(m + 1);
        ConfigHardcore.amuletEffects[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "sunken", true);
        m = (byte)(m + 1);
        ConfigHardcore.amuletEffects[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "enderman", true);
        m = (byte)(m + 1);
        ConfigHardcore.amuletEffects[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "polaris", true);
        m = (byte)(m + 1);
        ConfigHardcore.amuletEffects[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "lightning", true);
        m = (byte)(m + 1);
        ConfigHardcore.amuletEffects[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "consumption", true);
        m = (byte)(m + 1);
        ConfigHardcore.amuletEffects[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "undead", true);
        m = (byte)(m + 1);
        ConfigHardcore.amuletEffects[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "enderDragon", true);
        m = (byte)(m + 1);
        ConfigHardcore.amuletEffects[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "time", false);
        m = (byte)(m + 1);
        ConfigHardcore.amuletEffects[m] = prop.getBoolean(false);
        prop = config.get(cat.getName(), "wither", false);
        m = (byte)(m + 1);
        ConfigHardcore.amuletEffects[m] = prop.getBoolean(false);
        prop = config.get(cat.getName(), "overlord", false);
        m = (byte)(m + 1);
        ConfigHardcore.amuletEffects[m] = prop.getBoolean(false);
        prop = config.get(cat.getName(), "enyvil", false);
        ConfigHardcore.amuletEffects[(byte)(m + 1)] = prop.getBoolean(false);
        cat = config.getCategory("Creative Item Options");
        cat.setComment("Change various aspects of the Creative mode only items in the mod.");
        s = "sphereGenUsesFilter";
        prop = config.get(cat.getName(), s, false);
        prop.comment = "Does the Sphere Generator use your custom block filter?";
        ConfigHardcore.registerObject(s, prop.getBoolean(false));
        s = "sphereFilter";
        prop = config.get(cat.getName(), s, new String[]{"tnt", "stone", "cobblestone", "TragicMC:darkStone"});
        prop.comment = "The blocks that can be used in the Sphere Generator, must be the Vanilla blockname or must be appended with the mod id for use of modded blocks. This is not meta-sensitive.";
        ConfigHardcore.registerObject(s, prop.getStringList());
        s = "sphereSize";
        prop = config.get(cat.getName(), s, 6.5);
        prop.comment = "The radius of the sphere that the Sphere Generator uses.";
        ConfigHardcore.registerObject(s, prop.getDouble(6.5));
        s = "eraserUsesFilter";
        prop = config.get(cat.getName(), s, false);
        prop.comment = "Does the Sphere Eraser use your custom block filter?";
        ConfigHardcore.registerObject(s, prop.getBoolean(false));
        s = "eraserFilter";
        prop = config.get(cat.getName(), s, new String[]{"air"});
        prop.comment = "The blocks that are ignored by the Sphere Eraser, must be the Vanilla blockname or must be appended with the mod id for use of modded blocks. This is not meta-sensitive.";
        ConfigHardcore.registerObject(s, prop.getStringList());
        s = "eraserSize";
        prop = config.get(cat.getName(), s, 6.5);
        prop.comment = "The radius of the sphere that the Sphere Eraser uses.";
        ConfigHardcore.registerObject(s, prop.getDouble(6.5));
        s = "spikeGenUsesFilter";
        prop = config.get(cat.getName(), s, false);
        prop.comment = "Does the Spike Generator use your custom block filter?";
        ConfigHardcore.registerObject(s, prop.getBoolean(false));
        s = "spikeFilter";
        prop = config.get(cat.getName(), s, new String[]{"TragicMC:darkStone"});
        prop.comment = "The blocks that spikes can be generated out of in the Spike Generator, must be Vanilla blockname or must be appended with mod id for use of modded blocks. This is not meta-sensitive.";
        ConfigHardcore.registerObject(s, prop.getStringList());
        s = "spikeSize";
        prop = config.get(cat.getName(), s, 2.5);
        prop.comment = "The starting radius of a spike that the Spike Generator uses.";
        ConfigHardcore.registerObject(s, prop.getDouble(2.5));
        s = "spikeRegression";
        prop = config.get(cat.getName(), s, 0.96977745);
        prop.comment = "The rate the spike will regress as it gets generated higher up into the air, used by the Spike Generator.";
        ConfigHardcore.registerObject(s, prop.getDouble(0.96977745));
        s = "spikeCutoff";
        prop = config.get(cat.getName(), s, 0.36943755);
        prop.comment = "The minimum radius that the spike will stop generating at, used by the Spike Generator.";
        ConfigHardcore.registerObject(s, prop.getDouble(0.36943755));
        s = "voidPitUsesFilter";
        prop = config.get(cat.getName(), s, false);
        prop.comment = "Does the Void Pit Generator ignore any blocks when generated?";
        ConfigHardcore.registerObject(s, prop.getBoolean(false));
        s = "voidPitFilter";
        prop = config.get(cat.getName(), s, new String[]{"air"});
        prop.comment = "The blocks that void pits can delete during generation via the Void Pit Generator, must be Vanilla blockname or must be appended with mod id for use of modded blocks. This is not meta-sensitive.";
        ConfigHardcore.registerObject(s, prop.getStringList());
        s = "voidPitSize";
        prop = config.get(cat.getName(), s, 12.5);
        prop.comment = "The radius that the Void Pit Generator will use.";
        ConfigHardcore.registerObject(s, prop.getDouble(12.5));
        s = "explosionBaseSize";
        prop = config.get(cat.getName(), s, 3.5);
        prop.comment = "The base size of the explosions used by the Explosion Generator";
        ConfigHardcore.registerObject(s, prop.getDouble(3.5));
        s = "explosionSizeVariation";
        prop = config.get(cat.getName(), s, 5.0);
        prop.comment = "The variation applied to the base size of explosions created via the Explosion Generator";
        ConfigHardcore.registerObject(s, prop.getDouble(5.0));
        cat = config.getCategory("Dimension");
        cat.setComment("Change and toggle aspects of the mod-exclusive Dimensions.");
        prop = config.get(cat.getName(), "allowSynapse", true);
        prop.comment = "Is the Synapse Dimension allowed?";
        m = 0;
        ConfigHardcore.dimensionConfig[0] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "allowCollision", true);
        prop.comment = "Is the Collision Dimension allowed?";
        m = (byte)(m + 1);
        ConfigHardcore.dimensionConfig[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "allowCollisionRespawn", false);
        prop.comment = "Can you respawn in the Collision or will you be forced back to the Overworld?";
        m = (byte)(m + 1);
        ConfigHardcore.dimensionConfig[m] = prop.getBoolean(false);
        prop = config.get(cat.getName(), "allowSynapseRespawn", false);
        prop.comment = "Can you respawn in the Synapse or will you be forced back to the Overworld?";
        m = (byte)(m + 1);
        ConfigHardcore.dimensionConfig[m] = prop.getBoolean(false);
        prop = config.get(cat.getName(), "keepCollisionLoaded", false);
        prop.comment = "Will the Collision Dimension remain loaded when no one is there?";
        m = (byte)(m + 1);
        ConfigHardcore.dimensionConfig[m] = prop.getBoolean(false);
        prop = config.get(cat.getName(), "keepSynapseLoaded", false);
        prop.comment = "Will the Synapse Dimension remain loaded when no one is there?";
        m = (byte)(m + 1);
        ConfigHardcore.dimensionConfig[m] = prop.getBoolean(false);
        prop = config.get(cat.getName(), "allowSynapseVariants", true);
        prop.comment = "Can the Synapse generate with mini-Biomes?";
        m = (byte)(m + 1);
        ConfigHardcore.dimensionConfig[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "allowNekoHomeworld", true);
        prop.comment = "Is the Neko Homeworld Dimension allowed?";
        m = (byte)(m + 1);
        ConfigHardcore.dimensionConfig[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "allowNekoHomeworldRespawn", false);
        prop.comment = "Can you respawn in the Neko Homeworld or will you be forced back to the Overworld?";
        m = (byte)(m + 1);
        ConfigHardcore.dimensionConfig[m] = prop.getBoolean(false);
        prop = config.get(cat.getName(), "keepNekoHomeworldLoaded", false);
        prop.comment = "Will the Neko Homeworld Dimension remain loaded when no one is there?";
        ConfigHardcore.dimensionConfig[(byte)(m + 1)] = prop.getBoolean(false);
        s = "collisionID";
        prop = config.get(cat.getName(), s, 2);
        prop.comment = "The ID that the Collision Dimension will use.";
        ConfigHardcore.registerObject(s, prop.getInt(2));
        s = "collisionProviderID";
        prop = config.get(cat.getName(), s, 2);
        prop.comment = "The ID that the Collision's provider will use, if you don't know what this is, keep it the same as the Collision's Dimension ID.";
        ConfigHardcore.registerObject(s, prop.getInt(2));
        s = "synapseID";
        prop = config.get(cat.getName(), s, 3);
        prop.comment = "The ID that the Synapse Dimension will use.";
        ConfigHardcore.registerObject(s, prop.getInt(3));
        s = "synapseProviderID";
        prop = config.get(cat.getName(), s, 3);
        prop.comment = "The ID that the Synapse's provider will use, if you don't know what this is, keep it the same as the Synapse's Dimension ID.";
        ConfigHardcore.registerObject(s, prop.getInt(3));
        s = "collisionBiomeSize";
        prop = config.get(cat.getName(), s, 6);
        prop.comment = "How large the Collision's biomes generate.";
        ConfigHardcore.registerObject(s, prop.getInt(6));
        s = "synapseVariantChance";
        prop = config.get(cat.getName(), s, 128);
        prop.comment = "The chance that a Synapse mini-biome will generate, higher number is lower chance to generate.";
        ConfigHardcore.registerObject(s, prop.getInt(128));
        s = "nekoHomeworldID";
        prop = config.get(cat.getName(), s, 4);
        prop.comment = "The ID that the Neko Homeworld Dimension will use.";
        ConfigHardcore.registerObject(s, prop.getInt(4));
        s = "nekoHomeworldProviderID";
        prop = config.get(cat.getName(), s, 4);
        prop.comment = "The ID that the Neko Homeworld's provider will use, if you don't know what this is, keep it the same as the Neko Homeworld's Dimension ID.";
        ConfigHardcore.registerObject(s, prop.getInt(4));
        s = "nekoHomeworldBiomeSize";
        prop = config.get(cat.getName(), s, 8);
        prop.comment = "How large the Neko Homeworld's biomes generate.";
        ConfigHardcore.registerObject(s, prop.getInt(8));
        cat = config.getCategory("Dimension Biomes");
        cat.setComment("Set biome ids and generation weights, higher weight is greater chance to generate out of that biome group. Setting a weight to 0 effectively removes a biome from the possible biomes to generate.");
        s = "decayingHillsID";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, ConfigHardcore.findBiomeID(90)).getInt(ConfigHardcore.findBiomeID(90)));
        String s2 = s;
        s = "decayingValleyID";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, ConfigHardcore.findBiomeID(ConfigHardcore.getInt(s2) + 1)).getInt(ConfigHardcore.findBiomeID(ConfigHardcore.getInt(s2) + 1)));
        s2 = s;
        s = "decayingWastelandID";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, ConfigHardcore.findBiomeID(ConfigHardcore.getInt(s2) + 1)).getInt(ConfigHardcore.findBiomeID(ConfigHardcore.getInt(s2) + 1)));
        s2 = s;
        s = "decayingMountainsID";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, ConfigHardcore.findBiomeID(ConfigHardcore.getInt(s2) + 1)).getInt(ConfigHardcore.findBiomeID(ConfigHardcore.getInt(s2) + 1)));
        s2 = s;
        s = "paintedForestID";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, ConfigHardcore.findBiomeID(ConfigHardcore.getInt(s2) + 1)).getInt(ConfigHardcore.findBiomeID(ConfigHardcore.getInt(s2) + 1)));
        s2 = s;
        s = "paintedPlainsID";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, ConfigHardcore.findBiomeID(ConfigHardcore.getInt(s2) + 1)).getInt(ConfigHardcore.findBiomeID(ConfigHardcore.getInt(s2) + 1)));
        s2 = s;
        s = "paintedHillsID";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, ConfigHardcore.findBiomeID(ConfigHardcore.getInt(s2) + 1)).getInt(ConfigHardcore.findBiomeID(ConfigHardcore.getInt(s2) + 1)));
        s2 = s;
        s = "paintedClearingID";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, ConfigHardcore.findBiomeID(ConfigHardcore.getInt(s2) + 1)).getInt(ConfigHardcore.findBiomeID(ConfigHardcore.getInt(s2) + 1)));
        s2 = s;
        s = "ashenMountainsID";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, ConfigHardcore.findBiomeID(ConfigHardcore.getInt(s2) + 1)).getInt(ConfigHardcore.findBiomeID(ConfigHardcore.getInt(s2) + 1)));
        s2 = s;
        s = "ashenHillsID";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, ConfigHardcore.findBiomeID(ConfigHardcore.getInt(s2) + 1)).getInt(ConfigHardcore.findBiomeID(ConfigHardcore.getInt(s2) + 1)));
        s2 = s;
        s = "ashenBadlandsID";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, ConfigHardcore.findBiomeID(ConfigHardcore.getInt(s2) + 1)).getInt(ConfigHardcore.findBiomeID(ConfigHardcore.getInt(s2) + 1)));
        s2 = s;
        s = "starlitPrarieID";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, ConfigHardcore.findBiomeID(ConfigHardcore.getInt(s2) + 1)).getInt(ConfigHardcore.findBiomeID(ConfigHardcore.getInt(s2) + 1)));
        s2 = s;
        s = "starlitPlateausID";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, ConfigHardcore.findBiomeID(ConfigHardcore.getInt(s2) + 1)).getInt(ConfigHardcore.findBiomeID(ConfigHardcore.getInt(s2) + 1)));
        s2 = s;
        s = "starlitCliffsID";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, ConfigHardcore.findBiomeID(ConfigHardcore.getInt(s2) + 1)).getInt(ConfigHardcore.findBiomeID(ConfigHardcore.getInt(s2) + 1)));
        s2 = s;
        s = "starlitLowlandsID";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, ConfigHardcore.findBiomeID(ConfigHardcore.getInt(s2) + 1)).getInt(ConfigHardcore.findBiomeID(ConfigHardcore.getInt(s2) + 1)));
        s2 = s;
        s = "taintedSpikesID";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, ConfigHardcore.findBiomeID(ConfigHardcore.getInt(s2) + 1)).getInt(ConfigHardcore.findBiomeID(ConfigHardcore.getInt(s2) + 1)));
        s2 = s;
        s = "taintedLowlandsID";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, ConfigHardcore.findBiomeID(ConfigHardcore.getInt(s2) + 1)).getInt(ConfigHardcore.findBiomeID(ConfigHardcore.getInt(s2) + 1)));
        s2 = s;
        s = "taintedRisesID";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, ConfigHardcore.findBiomeID(ConfigHardcore.getInt(s2) + 1)).getInt(ConfigHardcore.findBiomeID(ConfigHardcore.getInt(s2) + 1)));
        s2 = s;
        s = "taintedScarlandsID";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, ConfigHardcore.findBiomeID(ConfigHardcore.getInt(s2) + 1)).getInt(ConfigHardcore.findBiomeID(ConfigHardcore.getInt(s2) + 1)));
        s2 = s;
        s = "taintedIslesID";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, ConfigHardcore.findBiomeID(ConfigHardcore.getInt(s2) + 1)).getInt(ConfigHardcore.findBiomeID(ConfigHardcore.getInt(s2) + 1)));
        s2 = s;
        s = "synapseBiomeID";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, ConfigHardcore.findBiomeID(ConfigHardcore.getInt(s2) + 1)).getInt(ConfigHardcore.findBiomeID(ConfigHardcore.getInt(s2) + 1)));
        s2 = s;
        s = "hallowedHillsID";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, ConfigHardcore.findBiomeID(ConfigHardcore.getInt(s2) + 1)).getInt(ConfigHardcore.findBiomeID(ConfigHardcore.getInt(s2) + 1)));
        s2 = s;
        s = "hallowedForestID";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, ConfigHardcore.findBiomeID(ConfigHardcore.getInt(s2) + 1)).getInt(ConfigHardcore.findBiomeID(ConfigHardcore.getInt(s2) + 1)));
        s2 = s;
        s = "hallowedPrarieID";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, ConfigHardcore.findBiomeID(ConfigHardcore.getInt(s2) + 1)).getInt(ConfigHardcore.findBiomeID(ConfigHardcore.getInt(s2) + 1)));
        s2 = s;
        s = "hallowedCliffsID";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, ConfigHardcore.findBiomeID(ConfigHardcore.getInt(s2) + 1)).getInt(ConfigHardcore.findBiomeID(ConfigHardcore.getInt(s2) + 1)));
        s2 = s;
        s = "scorchedWastelandsID";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, ConfigHardcore.findBiomeID(ConfigHardcore.getInt(s2) + 1)).getInt(ConfigHardcore.findBiomeID(ConfigHardcore.getInt(s2) + 1)));
        s2 = s;
        s = "scorchedValleyID";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, ConfigHardcore.findBiomeID(ConfigHardcore.getInt(s2) + 1)).getInt(ConfigHardcore.findBiomeID(ConfigHardcore.getInt(s2) + 1)));
        s2 = s;
        s = "scorchedScarlandsID";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, ConfigHardcore.findBiomeID(ConfigHardcore.getInt(s2) + 1)).getInt(ConfigHardcore.findBiomeID(ConfigHardcore.getInt(s2) + 1)));
        s2 = s;
        s = "corrodedSteppeID";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, ConfigHardcore.findBiomeID(ConfigHardcore.getInt(s2) + 1)).getInt(ConfigHardcore.findBiomeID(ConfigHardcore.getInt(s2) + 1)));
        s2 = s;
        s = "corrodedHeightsID";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, ConfigHardcore.findBiomeID(ConfigHardcore.getInt(s2) + 1)).getInt(ConfigHardcore.findBiomeID(ConfigHardcore.getInt(s2) + 1)));
        s2 = s;
        s = "corrodedVeldID";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, ConfigHardcore.findBiomeID(ConfigHardcore.getInt(s2) + 1)).getInt(ConfigHardcore.findBiomeID(ConfigHardcore.getInt(s2) + 1)));
        s2 = s;
        s = "corrodedRunoffID";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, ConfigHardcore.findBiomeID(ConfigHardcore.getInt(s2) + 1)).getInt(ConfigHardcore.findBiomeID(ConfigHardcore.getInt(s2) + 1)));
        s2 = s;
        s = "corrodedFalloutID";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, ConfigHardcore.findBiomeID(ConfigHardcore.getInt(s2) + 1)).getInt(ConfigHardcore.findBiomeID(ConfigHardcore.getInt(s2) + 1)));
        s2 = s;
        s = "frozenTundraID";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, ConfigHardcore.findBiomeID(ConfigHardcore.getInt(s2) + 1)).getInt(ConfigHardcore.findBiomeID(ConfigHardcore.getInt(s2) + 1)));
        s2 = s;
        s = "frozenHillsID";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, ConfigHardcore.findBiomeID(ConfigHardcore.getInt(s2) + 1)).getInt(ConfigHardcore.findBiomeID(ConfigHardcore.getInt(s2) + 1)));
        s2 = s;
        s = "frozenDepthsID";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, ConfigHardcore.findBiomeID(ConfigHardcore.getInt(s2) + 1)).getInt(ConfigHardcore.findBiomeID(ConfigHardcore.getInt(s2) + 1)));
        s2 = s;
        s = "crystalID";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, ConfigHardcore.findBiomeID(ConfigHardcore.getInt(s2) + 1)).getInt(ConfigHardcore.findBiomeID(ConfigHardcore.getInt(s2) + 1)));
        s2 = s;
        s = "darkForestID";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, ConfigHardcore.findBiomeID(ConfigHardcore.getInt(s2) + 1)).getInt(ConfigHardcore.findBiomeID(ConfigHardcore.getInt(s2) + 1)));
        s2 = s;
        s = "darkForestHillsID";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, ConfigHardcore.findBiomeID(ConfigHardcore.getInt(s2) + 1)).getInt(ConfigHardcore.findBiomeID(ConfigHardcore.getInt(s2) + 1)));
        s2 = s;
        s = "darkMarshID";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, ConfigHardcore.findBiomeID(ConfigHardcore.getInt(s2) + 1)).getInt(ConfigHardcore.findBiomeID(ConfigHardcore.getInt(s2) + 1)));
        s2 = s;
        s = "synapseDeadID";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, ConfigHardcore.findBiomeID(ConfigHardcore.getInt(s2) + 1)).getInt(ConfigHardcore.findBiomeID(ConfigHardcore.getInt(s2) + 1)));
        s2 = s;
        s = "synapseCorruptID";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, ConfigHardcore.findBiomeID(ConfigHardcore.getInt(s2) + 1)).getInt(ConfigHardcore.findBiomeID(ConfigHardcore.getInt(s2) + 1)));
        s2 = s;
        s = "nekoBarrensID";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, ConfigHardcore.findBiomeID(ConfigHardcore.getInt(s2) + 1)).getInt(ConfigHardcore.findBiomeID(ConfigHardcore.getInt(s2) + 1)));
        s2 = s;
        s = "nekoForestID";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, ConfigHardcore.findBiomeID(ConfigHardcore.getInt(s2) + 1)).getInt(ConfigHardcore.findBiomeID(ConfigHardcore.getInt(s2) + 1)));
        s2 = s;
        s = "nekoHeightsID";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, ConfigHardcore.findBiomeID(ConfigHardcore.getInt(s2) + 1)).getInt(ConfigHardcore.findBiomeID(ConfigHardcore.getInt(s2) + 1)));
        s = "decayingHillsWeight";
        ConfigHardcore.registerObject(s, ConfigHardcore.clamp(config.get(cat.getName(), s, 20).getInt(20), 0, 250));
        s = "decayingValleyWeight";
        ConfigHardcore.registerObject(s, ConfigHardcore.clamp(config.get(cat.getName(), s, 5).getInt(5), 0, 250));
        s = "decayingWastelandWeight";
        ConfigHardcore.registerObject(s, ConfigHardcore.clamp(config.get(cat.getName(), s, 20).getInt(20), 0, 250));
        s = "decayingMountainsWeight";
        ConfigHardcore.registerObject(s, ConfigHardcore.clamp(config.get(cat.getName(), s, 10).getInt(10), 0, 250));
        s = "paintedForestWeight";
        ConfigHardcore.registerObject(s, ConfigHardcore.clamp(config.get(cat.getName(), s, 30).getInt(30), 0, 250));
        s = "paintedPlainsWeight";
        ConfigHardcore.registerObject(s, ConfigHardcore.clamp(config.get(cat.getName(), s, 10).getInt(10), 0, 250));
        s = "paintedHillsWeight";
        ConfigHardcore.registerObject(s, ConfigHardcore.clamp(config.get(cat.getName(), s, 20).getInt(20), 0, 250));
        s = "paintedClearingWeight";
        ConfigHardcore.registerObject(s, ConfigHardcore.clamp(config.get(cat.getName(), s, 5).getInt(5), 0, 250));
        s = "ashenMountainsWeight";
        ConfigHardcore.registerObject(s, ConfigHardcore.clamp(config.get(cat.getName(), s, 10).getInt(10), 0, 250));
        s = "ashenHillsWeight";
        ConfigHardcore.registerObject(s, ConfigHardcore.clamp(config.get(cat.getName(), s, 20).getInt(20), 0, 250));
        s = "ashenBadlandsWeight";
        ConfigHardcore.registerObject(s, ConfigHardcore.clamp(config.get(cat.getName(), s, 25).getInt(25), 0, 250));
        s = "starlitPrarieWeight";
        ConfigHardcore.registerObject(s, ConfigHardcore.clamp(config.get(cat.getName(), s, 25).getInt(25), 0, 250));
        s = "starlitPlateausWeight";
        ConfigHardcore.registerObject(s, ConfigHardcore.clamp(config.get(cat.getName(), s, 15).getInt(15), 0, 250));
        s = "starlitCliffsWeight";
        ConfigHardcore.registerObject(s, ConfigHardcore.clamp(config.get(cat.getName(), s, 10).getInt(10), 0, 250));
        s = "starlitLowlandsWeight";
        ConfigHardcore.registerObject(s, ConfigHardcore.clamp(config.get(cat.getName(), s, 25).getInt(25), 0, 250));
        s = "taintedSpikesWeight";
        ConfigHardcore.registerObject(s, ConfigHardcore.clamp(config.get(cat.getName(), s, 25).getInt(25), 0, 250));
        s = "taintedLowlandsWeight";
        ConfigHardcore.registerObject(s, ConfigHardcore.clamp(config.get(cat.getName(), s, 10).getInt(10), 0, 250));
        s = "taintedRisesWeight";
        ConfigHardcore.registerObject(s, ConfigHardcore.clamp(config.get(cat.getName(), s, 15).getInt(15), 0, 250));
        s = "taintedScarlandsWeight";
        ConfigHardcore.registerObject(s, ConfigHardcore.clamp(config.get(cat.getName(), s, 15).getInt(15), 0, 250));
        s = "taintedIslesWeight";
        ConfigHardcore.registerObject(s, ConfigHardcore.clamp(config.get(cat.getName(), s, 5).getInt(5), 0, 250));
        s = "hallowedHillsWeight";
        ConfigHardcore.registerObject(s, ConfigHardcore.clamp(config.get(cat.getName(), s, 10).getInt(10), 0, 250));
        s = "hallowedForestWeight";
        ConfigHardcore.registerObject(s, ConfigHardcore.clamp(config.get(cat.getName(), s, 25).getInt(25), 0, 250));
        s = "hallowedPrarieWeight";
        ConfigHardcore.registerObject(s, ConfigHardcore.clamp(config.get(cat.getName(), s, 20).getInt(20), 0, 250));
        s = "hallowedCliffsWeight";
        ConfigHardcore.registerObject(s, ConfigHardcore.clamp(config.get(cat.getName(), s, 5).getInt(5), 0, 250));
        s = "scorchedWastelandsWeight";
        ConfigHardcore.registerObject(s, ConfigHardcore.clamp(config.get(cat.getName(), s, 15).getInt(15), 0, 250));
        s = "scorchedValleyWeight";
        ConfigHardcore.registerObject(s, ConfigHardcore.clamp(config.get(cat.getName(), s, 5).getInt(5), 0, 250));
        s = "scorchedScarlandsWeight";
        ConfigHardcore.registerObject(s, ConfigHardcore.clamp(config.get(cat.getName(), s, 10).getInt(10), 0, 250));
        s = "corrodedSteppeWeight";
        ConfigHardcore.registerObject(s, ConfigHardcore.clamp(config.get(cat.getName(), s, 25).getInt(25), 0, 250));
        s = "corrodedHeightsWeight";
        ConfigHardcore.registerObject(s, ConfigHardcore.clamp(config.get(cat.getName(), s, 15).getInt(15), 0, 250));
        s = "corrodedVeldWeight";
        ConfigHardcore.registerObject(s, ConfigHardcore.clamp(config.get(cat.getName(), s, 10).getInt(10), 0, 250));
        s = "corrodedRunoffWeight";
        ConfigHardcore.registerObject(s, ConfigHardcore.clamp(config.get(cat.getName(), s, 20).getInt(10), 0, 250));
        s = "corrodedFalloutWeight";
        ConfigHardcore.registerObject(s, ConfigHardcore.clamp(config.get(cat.getName(), s, 5).getInt(5), 0, 250));
        s = "frozenTundraWeight";
        ConfigHardcore.registerObject(s, ConfigHardcore.clamp(config.get(cat.getName(), s, 25).getInt(25), 0, 250));
        s = "frozenHillsWeight";
        ConfigHardcore.registerObject(s, ConfigHardcore.clamp(config.get(cat.getName(), s, 15).getInt(15), 0, 250));
        s = "frozenDepthsWeight";
        ConfigHardcore.registerObject(s, ConfigHardcore.clamp(config.get(cat.getName(), s, 5).getInt(5), 0, 250));
        s = "crystalWeight";
        ConfigHardcore.registerObject(s, ConfigHardcore.clamp(config.get(cat.getName(), s, 5).getInt(5), 0, 250));
        s = "darkForestWeight";
        ConfigHardcore.registerObject(s, ConfigHardcore.clamp(config.get(cat.getName(), s, 25).getInt(25), 0, 250));
        s = "darkForestHillsWeight";
        ConfigHardcore.registerObject(s, ConfigHardcore.clamp(config.get(cat.getName(), s, 15).getInt(15), 0, 250));
        s = "darkMarshWeight";
        ConfigHardcore.registerObject(s, ConfigHardcore.clamp(config.get(cat.getName(), s, 10).getInt(10), 0, 250));
        cat = config.getCategory("Doom");
        cat.setComment("Modify aspects of Doom.");
        cat.setRequiresMcRestart(true);
        prop = config.get(cat.getName(), "allowDoomsdays", true);
        prop.comment = "Are Doomsdays able to be used?";
        m = 0;
        ConfigHardcore.doomConfig[0] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "allowInfluenceDoomsdays", true);
        prop.comment = "Can Influence Doomsdays be used?";
        m = (byte)(m + 1);
        ConfigHardcore.doomConfig[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "allowOverflowDoomsdays", true);
        prop.comment = "Can Overflow Doomsdays be used?";
        m = (byte)(m + 1);
        ConfigHardcore.doomConfig[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "allowCrisisDoomsdays", true);
        prop.comment = "Can Crisis Doomsdays be used?";
        m = (byte)(m + 1);
        ConfigHardcore.doomConfig[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "allowWorldShaperDoomsdays", true);
        prop.comment = "Can World Shaper Doomsdays be used?";
        m = (byte)(m + 1);
        ConfigHardcore.doomConfig[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "allowCombinationDoomsdays", true);
        prop.comment = "Can Combination Doomsdays be used?";
        m = (byte)(m + 1);
        ConfigHardcore.doomConfig[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "allowNonDoomsdayAbilities", true);
        prop.comment = "Can non-Doomsday Weapon and Armor abilities be used?";
        m = (byte)(m + 1);
        ConfigHardcore.doomConfig[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "allowDoomIncrease", true);
        prop.comment = "Can the maximum Doom amount be increased by a Doom Consume?";
        m = (byte)(m + 1);
        ConfigHardcore.doomConfig[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "allowConsumeRefill", false);
        prop.comment = "Should Doom Consumes refill your Doom when used?";
        m = (byte)(m + 1);
        ConfigHardcore.doomConfig[m] = prop.getBoolean(false);
        prop = config.get(cat.getName(), "allowDoomPainCharge", false);
        prop.comment = "Should your Doom increase when you take or inflict damage?";
        m = (byte)(m + 1);
        ConfigHardcore.doomConfig[m] = prop.getBoolean(false);
        prop = config.get(cat.getName(), "allowDoomNaturalCharge", false);
        prop.comment = "Should your Doom recharge naturally?";
        m = (byte)(m + 1);
        ConfigHardcore.doomConfig[m] = prop.getBoolean(false);
        prop = config.get(cat.getName(), "allowCrucialMoments", false);
        prop.comment = "Can Doomsdays have a chance to have extra effectiveness?";
        m = (byte)(m + 1);
        ConfigHardcore.doomConfig[m] = prop.getBoolean(false);
        prop = config.get(cat.getName(), "allowBacklash", true);
        prop.comment = "Can Doomsdays have a chance to fail?";
        m = (byte)(m + 1);
        ConfigHardcore.doomConfig[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "allowCooldown", true);
        prop.comment = "Should Doomsdays inflict Global cooldown after use?";
        m = (byte)(m + 1);
        ConfigHardcore.doomConfig[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "allowDoomKillCharge", true);
        prop.comment = "Should killing enemies recharge your Doom?";
        m = (byte)(m + 1);
        ConfigHardcore.doomConfig[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "allowCooldownDefuse", false);
        prop.comment = "Can Cooldown Defuses be used to remove your Global cooldown?";
        m = (byte)(m + 1);
        ConfigHardcore.doomConfig[m] = prop.getBoolean(false);
        prop = config.get(cat.getName(), "allowPartnerDoomsdays", false);
        prop.comment = "Can two people activate a Doomsday combination while near each other? (This hasn't been tested and you should report your results from use)";
        m = (byte)(m + 1);
        ConfigHardcore.doomConfig[m] = prop.getBoolean(false);
        prop = config.get(cat.getName(), "canCombineDoomsdayScrollsWithItems", false);
        prop.comment = "Can you combine a Doomsday scroll with a non-TragicMC weapon or armor piece to imbue it with a Doomsday?";
        ConfigHardcore.doomConfig[(byte)(m + 1)] = prop.getBoolean(false);
        s = "maxDoomAmount";
        prop = config.get(cat.getName(), s, 500);
        prop.comment = "The highest Doom amount you can have.";
        ConfigHardcore.registerObject(s, ConfigHardcore.clampPositive(prop.getInt(10)));
        s = "doomRechargeRate";
        prop = config.get(cat.getName(), s, 1);
        prop.comment = "The speed at which you naturally recharge Doom. Maxes out at 20, which would be one recharge per tick essentially.";
        ConfigHardcore.registerObject(s, ConfigHardcore.clamp(prop.getInt(1), 1, 20));
        s = "doomConsumeRarity";
        prop = config.get(cat.getName(), s, 3);
        prop.comment = "The chance of getting a Doom Consume out of a chest, higher value is higher chance.";
        ConfigHardcore.registerObject(s, ConfigHardcore.clamp(prop.getInt(3), 1, 250));
        s = "cooldownDefuseRarity";
        prop = config.get(cat.getName(), s, 5);
        prop.comment = "The chance of getting a Cooldown Defuse out of a chest, higher value is higher chance.";
        ConfigHardcore.registerObject(s, ConfigHardcore.clamp(prop.getInt(5), 1, 250));
        s = "doomConsumeRefillAmount";
        prop = config.get(cat.getName(), s, 50);
        prop.comment = "The percentage of Doom that you'll refill upon use of a Doom Consume.";
        ConfigHardcore.registerObject(s, ConfigHardcore.clamp(prop.getInt(50), 1, 100));
        s = "cooldownDefuseRefillAmount";
        prop = config.get(cat.getName(), s, 30);
        prop.comment = "The amount of cooldown that you'll remove upon use of a Cooldown Defuse.";
        ConfigHardcore.registerObject(s, ConfigHardcore.clampPositive(prop.getInt(30)));
        s = "backlashChance";
        prop = config.get(cat.getName(), s, 5);
        prop.comment = "The chance that Backlash will occur, higher value is higher chance.";
        ConfigHardcore.registerObject(s, ConfigHardcore.clamp(prop.getInt(5), 1, 100));
        s = "crucialMomentChance";
        prop = config.get(cat.getName(), s, 5);
        prop.comment = "The chance that a Crucial Moment will occur, higher value is higher chance.";
        ConfigHardcore.registerObject(s, ConfigHardcore.clamp(prop.getInt(5), 1, 100));
        s = "doomConsumeIncreaseAmount";
        prop = config.get(cat.getName(), s, 50);
        prop.comment = "The amount of Max Doom you gain per Doom Consume use.";
        ConfigHardcore.registerObject(s, ConfigHardcore.clampPositive(prop.getInt(1)));
        s = "maxDoomStartAmount";
        prop = config.get(cat.getName(), s, 50);
        prop.comment = "The default amount of Max Doom that you start with.";
        ConfigHardcore.registerObject(s, ConfigHardcore.clampPositive(prop.getInt(5)));
        s = "doomRechargeAmount";
        prop = config.get(cat.getName(), s, 1);
        prop.comment = "The amount you recharge per recharge tick, also used by the Doom kill charge.";
        ConfigHardcore.registerObject(s, ConfigHardcore.clampPositive(prop.getInt(1)));
        s = "partnerDoomsdayDistance";
        prop = config.get(cat.getName(), s, 12);
        prop.comment = "How far away you can be from someone to activate a Partner Combination Doomsday.";
        ConfigHardcore.registerObject(s, ConfigHardcore.clampPositive(prop.getInt(1)));
        cat = config.getCategory("Doomsdays");
        cat.setComment("Set whether each Doomsday is allowed, as well as set their cooldown and their Doom cost.");
        cat.setRequiresWorldRestart(false);
        prop = config.get(cat.getName(), "decayAllow", true);
        m = 1;
        ConfigHardcore.doomsdayAllow[1] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "huntersInstinctAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "toxicityAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "berserkerAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "piercingLightAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "natureDrainAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "poisonBreakAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "snipeAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "rapidFireAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "pulseAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "lightShoveAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "fearAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "harmonizerAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "ravageAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "tormentAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "beastlyImpulsesAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "huntersInstinctAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "suicicalTendenciesAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "reaperLaughAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "realityAlterAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "skullCrusherAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "minerSkillsAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "freezeAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "moonlightSonataAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "flightOfTheValkyriesAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "titanfallAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "bloodlustAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "permafrostAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "purgeAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "lightningRushAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "marionetteAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "mindcrackAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "growthSpurtAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "blizzardAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "asphyxiateAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "fireRainAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "dragonsRoarAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "firestormAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "shotgunAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "guardiansCallAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "hardenAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "sharpenAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "flashAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "septicsAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "kurayamiAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "lifeShareAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "deathMarkAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "paradigmShiftAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "adrenalineAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "escapeAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "giftOfTheGodsAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "gamblerAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "soulstealerAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "parasiteAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "symbiosisAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "timeCollapseAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "magnetizerAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "ambienceAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "dimentiaAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "deleteAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "laserCutterAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "radiantLightAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "dangerZoneAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "supportAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "purifyAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "recallAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "shuffleAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "blinkAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "evacuateAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "medicAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "resurgenceAllow", true);
        ConfigHardcore.doomsdayAllow[(byte)(m + 1)] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "decayCost", 40);
        m = 1;
        ConfigHardcore.doomsdayCost[1] = ConfigHardcore.clampPositive(prop.getInt(40));
        prop = config.get(cat.getName(), "huntersInstinctCost", 60);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayCost[m] = ConfigHardcore.clampPositive(prop.getInt(60));
        prop = config.get(cat.getName(), "toxicityCost", 40);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayCost[m] = ConfigHardcore.clampPositive(prop.getInt(40));
        prop = config.get(cat.getName(), "berserkerCost", 50);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayCost[m] = ConfigHardcore.clampPositive(prop.getInt(50));
        prop = config.get(cat.getName(), "piercingLightCost", 60);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayCost[m] = ConfigHardcore.clampPositive(prop.getInt(60));
        prop = config.get(cat.getName(), "natureDrainCost", 12);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayCost[m] = ConfigHardcore.clampPositive(prop.getInt(12));
        prop = config.get(cat.getName(), "poisonBreakCost", 30);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayCost[m] = ConfigHardcore.clampPositive(prop.getInt(30));
        prop = config.get(cat.getName(), "snipeCost", 90);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayCost[m] = ConfigHardcore.clampPositive(prop.getInt(90));
        prop = config.get(cat.getName(), "rapidFireCost", 8);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayCost[m] = ConfigHardcore.clampPositive(prop.getInt(8));
        prop = config.get(cat.getName(), "pulseCost", 10);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayCost[m] = ConfigHardcore.clampPositive(prop.getInt(10));
        prop = config.get(cat.getName(), "lightShoveCost", 3);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayCost[m] = ConfigHardcore.clampPositive(prop.getInt(3));
        prop = config.get(cat.getName(), "fearCost", 30);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayCost[m] = ConfigHardcore.clampPositive(prop.getInt(30));
        prop = config.get(cat.getName(), "harmonizerCost", 40);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayCost[m] = ConfigHardcore.clampPositive(prop.getInt(40));
        prop = config.get(cat.getName(), "ravageCost", 55);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayCost[m] = ConfigHardcore.clampPositive(prop.getInt(55));
        prop = config.get(cat.getName(), "tormentCost", 45);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayCost[m] = ConfigHardcore.clampPositive(prop.getInt(45));
        prop = config.get(cat.getName(), "beastlyImpulsesCost", 60);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayCost[m] = ConfigHardcore.clampPositive(prop.getInt(60));
        prop = config.get(cat.getName(), "suicidalTendenciesCost", 12);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayCost[m] = ConfigHardcore.clampPositive(prop.getInt(12));
        prop = config.get(cat.getName(), "reaperLaughCost", 16);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayCost[m] = ConfigHardcore.clampPositive(prop.getInt(16));
        prop = config.get(cat.getName(), "realityAlterCost", 40);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayCost[m] = ConfigHardcore.clampPositive(prop.getInt(40));
        prop = config.get(cat.getName(), "skullCrusherCost", 50);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayCost[m] = ConfigHardcore.clampPositive(prop.getInt(50));
        prop = config.get(cat.getName(), "minerSkillsCost", 30);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayCost[m] = ConfigHardcore.clampPositive(prop.getInt(30));
        prop = config.get(cat.getName(), "freezeCost", 30);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayCost[m] = ConfigHardcore.clampPositive(prop.getInt(30));
        prop = config.get(cat.getName(), "moonlightSonataCost", 1);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayCost[m] = ConfigHardcore.clampPositive(prop.getInt(1));
        prop = config.get(cat.getName(), "flightOfTheValkyriesCost", 10);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayCost[m] = ConfigHardcore.clampPositive(prop.getInt(10));
        prop = config.get(cat.getName(), "titanfallCost", 5);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayCost[m] = ConfigHardcore.clampPositive(prop.getInt(5));
        prop = config.get(cat.getName(), "bloodlustCost", 80);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayCost[m] = ConfigHardcore.clampPositive(prop.getInt(80));
        prop = config.get(cat.getName(), "permafrostCost", 6);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayCost[m] = ConfigHardcore.clampPositive(prop.getInt(6));
        prop = config.get(cat.getName(), "purgeCost", 5);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayCost[m] = ConfigHardcore.clampPositive(prop.getInt(5));
        prop = config.get(cat.getName(), "lightningRushCost", 8);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayCost[m] = ConfigHardcore.clampPositive(prop.getInt(8));
        prop = config.get(cat.getName(), "marionetteCost", 3);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayCost[m] = ConfigHardcore.clampPositive(prop.getInt(3));
        prop = config.get(cat.getName(), "mindcrackCost", 45);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayCost[m] = ConfigHardcore.clampPositive(prop.getInt(45));
        prop = config.get(cat.getName(), "growthSpurtCost", 50);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayCost[m] = ConfigHardcore.clampPositive(prop.getInt(50));
        prop = config.get(cat.getName(), "blizzardCost", 10);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayCost[m] = ConfigHardcore.clampPositive(prop.getInt(10));
        prop = config.get(cat.getName(), "asphyxiateCost", 3);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayCost[m] = ConfigHardcore.clampPositive(prop.getInt(3));
        prop = config.get(cat.getName(), "fireRainCost", 8);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayCost[m] = ConfigHardcore.clampPositive(prop.getInt(8));
        prop = config.get(cat.getName(), "dragonsRoarCost", 25);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayCost[m] = ConfigHardcore.clampPositive(prop.getInt(25));
        prop = config.get(cat.getName(), "firestormCost", 10);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayCost[m] = ConfigHardcore.clampPositive(prop.getInt(10));
        prop = config.get(cat.getName(), "shotgunCost", 10);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayCost[m] = ConfigHardcore.clampPositive(prop.getInt(10));
        prop = config.get(cat.getName(), "guardiansCallCost", 75);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayCost[m] = ConfigHardcore.clampPositive(prop.getInt(75));
        prop = config.get(cat.getName(), "hardenCost", 60);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayCost[m] = ConfigHardcore.clampPositive(prop.getInt(60));
        prop = config.get(cat.getName(), "sharpenCost", 75);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayCost[m] = ConfigHardcore.clampPositive(prop.getInt(75));
        prop = config.get(cat.getName(), "flashCost", 10);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayCost[m] = ConfigHardcore.clampPositive(prop.getInt(10));
        prop = config.get(cat.getName(), "septicsCost", 8);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayCost[m] = ConfigHardcore.clampPositive(prop.getInt(8));
        prop = config.get(cat.getName(), "kurayamiCost", 115);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayCost[m] = ConfigHardcore.clampPositive(prop.getInt(115));
        prop = config.get(cat.getName(), "lifeShareCost", 65);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayCost[m] = ConfigHardcore.clampPositive(prop.getInt(65));
        prop = config.get(cat.getName(), "deathMarkCost", 12);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayCost[m] = ConfigHardcore.clampPositive(prop.getInt(12));
        prop = config.get(cat.getName(), "paradigmShiftCost", 50);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayCost[m] = ConfigHardcore.clampPositive(prop.getInt(50));
        prop = config.get(cat.getName(), "adrenalineCost", 33);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayCost[m] = ConfigHardcore.clampPositive(prop.getInt(33));
        prop = config.get(cat.getName(), "escapeCost", 12);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayCost[m] = ConfigHardcore.clampPositive(prop.getInt(12));
        prop = config.get(cat.getName(), "giftOfTheGodsCost", 115);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayCost[m] = ConfigHardcore.clampPositive(prop.getInt(115));
        prop = config.get(cat.getName(), "gamblerCost", 15);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayCost[m] = ConfigHardcore.clampPositive(prop.getInt(15));
        prop = config.get(cat.getName(), "soulstealerCost", 12);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayCost[m] = ConfigHardcore.clampPositive(prop.getInt(12));
        prop = config.get(cat.getName(), "parasiteCost", 16);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayCost[m] = ConfigHardcore.clampPositive(prop.getInt(16));
        prop = config.get(cat.getName(), "symbiosisCost", 18);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayCost[m] = ConfigHardcore.clampPositive(prop.getInt(18));
        prop = config.get(cat.getName(), "timeCollapseCost", 3);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayCost[m] = ConfigHardcore.clampPositive(prop.getInt(3));
        prop = config.get(cat.getName(), "magnetizerCost", 95);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayCost[m] = ConfigHardcore.clampPositive(prop.getInt(95));
        prop = config.get(cat.getName(), "ambienceCost", 1);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayCost[m] = ConfigHardcore.clampPositive(prop.getInt(1));
        prop = config.get(cat.getName(), "dimentiaCost", 99);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayCost[m] = ConfigHardcore.clampPositive(prop.getInt(99));
        prop = config.get(cat.getName(), "deleteCost", 135);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayCost[m] = ConfigHardcore.clampPositive(prop.getInt(135));
        prop = config.get(cat.getName(), "laserCutterCost", 16);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayCost[m] = ConfigHardcore.clampPositive(prop.getInt(16));
        prop = config.get(cat.getName(), "radiantLightCost", 62);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayCost[m] = ConfigHardcore.clampPositive(prop.getInt(62));
        prop = config.get(cat.getName(), "dangerZoneCost", 22);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayCost[m] = ConfigHardcore.clampPositive(prop.getInt(22));
        prop = config.get(cat.getName(), "supportCost", 60);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayCost[m] = ConfigHardcore.clampPositive(prop.getInt(60));
        prop = config.get(cat.getName(), "purifyCost", 42);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayCost[m] = ConfigHardcore.clampPositive(prop.getInt(42));
        prop = config.get(cat.getName(), "recallCost", 82);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayCost[m] = ConfigHardcore.clampPositive(prop.getInt(82));
        prop = config.get(cat.getName(), "shuffleCost", 18);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayCost[m] = ConfigHardcore.clampPositive(prop.getInt(18));
        prop = config.get(cat.getName(), "blinkCost", 15);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayCost[m] = ConfigHardcore.clampPositive(prop.getInt(15));
        prop = config.get(cat.getName(), "evacuateCost", 56);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayCost[m] = ConfigHardcore.clampPositive(prop.getInt(56));
        prop = config.get(cat.getName(), "medicCost", 9);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayCost[m] = ConfigHardcore.clampPositive(prop.getInt(9));
        prop = config.get(cat.getName(), "resurgenceCost", 135);
        ConfigHardcore.doomsdayCost[(byte)(m + 1)] = ConfigHardcore.clampPositive(prop.getInt(135));
        prop = config.get(cat.getName(), "decayCooldown", 20);
        m = 1;
        ConfigHardcore.doomsdayCooldown[1] = ConfigHardcore.clampPositive(prop.getInt(20));
        prop = config.get(cat.getName(), "huntersInstinctCooldown", 25);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayCooldown[m] = ConfigHardcore.clampPositive(prop.getInt(25));
        prop = config.get(cat.getName(), "toxicityCooldown", 15);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayCooldown[m] = ConfigHardcore.clampPositive(prop.getInt(15));
        prop = config.get(cat.getName(), "berserkerCooldown", 15);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayCooldown[m] = ConfigHardcore.clampPositive(prop.getInt(15));
        prop = config.get(cat.getName(), "piercingLightCooldown", 30);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayCooldown[m] = ConfigHardcore.clampPositive(prop.getInt(30));
        prop = config.get(cat.getName(), "natureDrainCooldown", 6);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayCooldown[m] = ConfigHardcore.clampPositive(prop.getInt(6));
        prop = config.get(cat.getName(), "poisonBreakCooldown", 10);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayCooldown[m] = ConfigHardcore.clampPositive(prop.getInt(10));
        prop = config.get(cat.getName(), "snipeCooldown", 55);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayCooldown[m] = ConfigHardcore.clampPositive(prop.getInt(55));
        prop = config.get(cat.getName(), "rapidFireCooldown", 3);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayCooldown[m] = ConfigHardcore.clampPositive(prop.getInt(3));
        prop = config.get(cat.getName(), "pulseCooldown", 6);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayCooldown[m] = ConfigHardcore.clampPositive(prop.getInt(6));
        prop = config.get(cat.getName(), "lightShoveCooldown", 1);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayCooldown[m] = ConfigHardcore.clampPositive(prop.getInt(1));
        prop = config.get(cat.getName(), "fearCooldown", 20);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayCooldown[m] = ConfigHardcore.clampPositive(prop.getInt(20));
        prop = config.get(cat.getName(), "harmonizerCooldown", 30);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayCooldown[m] = ConfigHardcore.clampPositive(prop.getInt(30));
        prop = config.get(cat.getName(), "ravageCooldown", 35);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayCooldown[m] = ConfigHardcore.clampPositive(prop.getInt(35));
        prop = config.get(cat.getName(), "tormentCooldown", 20);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayCooldown[m] = ConfigHardcore.clampPositive(prop.getInt(20));
        prop = config.get(cat.getName(), "beastlyImpulsesCooldown", 50);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayCooldown[m] = ConfigHardcore.clampPositive(prop.getInt(50));
        prop = config.get(cat.getName(), "suicidalTendenciesCooldown", 4);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayCooldown[m] = ConfigHardcore.clampPositive(prop.getInt(4));
        prop = config.get(cat.getName(), "reaperLaughCooldown", 3);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayCooldown[m] = ConfigHardcore.clampPositive(prop.getInt(3));
        prop = config.get(cat.getName(), "realityAlterCooldown", 12);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayCooldown[m] = ConfigHardcore.clampPositive(prop.getInt(12));
        prop = config.get(cat.getName(), "skullCrusherCooldown", 15);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayCooldown[m] = ConfigHardcore.clampPositive(prop.getInt(15));
        prop = config.get(cat.getName(), "minerSkillsCooldown", 20);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayCooldown[m] = ConfigHardcore.clampPositive(prop.getInt(20));
        prop = config.get(cat.getName(), "freezeCooldown", 30);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayCooldown[m] = ConfigHardcore.clampPositive(prop.getInt(30));
        prop = config.get(cat.getName(), "moonlightSonataCooldown", 60);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayCooldown[m] = ConfigHardcore.clampPositive(prop.getInt(60));
        prop = config.get(cat.getName(), "flightOfTheValkyriesCooldown", 10);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayCooldown[m] = ConfigHardcore.clampPositive(prop.getInt(10));
        prop = config.get(cat.getName(), "titanfallCooldown", 10);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayCooldown[m] = ConfigHardcore.clampPositive(prop.getInt(10));
        prop = config.get(cat.getName(), "bloodlustCooldown", 30);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayCooldown[m] = ConfigHardcore.clampPositive(prop.getInt(30));
        prop = config.get(cat.getName(), "permafrostCooldown", 5);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayCooldown[m] = ConfigHardcore.clampPositive(prop.getInt(5));
        prop = config.get(cat.getName(), "purgeCooldown", 4);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayCooldown[m] = ConfigHardcore.clampPositive(prop.getInt(4));
        prop = config.get(cat.getName(), "lightningRushCooldown", 6);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayCooldown[m] = ConfigHardcore.clampPositive(prop.getInt(6));
        prop = config.get(cat.getName(), "marionetteCooldown", 3);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayCooldown[m] = ConfigHardcore.clampPositive(prop.getInt(3));
        prop = config.get(cat.getName(), "mindcrackCooldown", 60);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayCooldown[m] = ConfigHardcore.clampPositive(prop.getInt(60));
        prop = config.get(cat.getName(), "growthSpurtCooldown", 10);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayCooldown[m] = ConfigHardcore.clampPositive(prop.getInt(10));
        prop = config.get(cat.getName(), "blizzardCooldown", 6);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayCooldown[m] = ConfigHardcore.clampPositive(prop.getInt(6));
        prop = config.get(cat.getName(), "asphyxiateCooldown", 3);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayCooldown[m] = ConfigHardcore.clampPositive(prop.getInt(3));
        prop = config.get(cat.getName(), "fireRainCooldown", 5);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayCooldown[m] = ConfigHardcore.clampPositive(prop.getInt(5));
        prop = config.get(cat.getName(), "dragonsRoarCooldown", 15);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayCooldown[m] = ConfigHardcore.clampPositive(prop.getInt(15));
        prop = config.get(cat.getName(), "firestormCooldown", 8);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayCooldown[m] = ConfigHardcore.clampPositive(prop.getInt(8));
        prop = config.get(cat.getName(), "shotgunCooldown", 5);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayCooldown[m] = ConfigHardcore.clampPositive(prop.getInt(5));
        prop = config.get(cat.getName(), "guardiansCallCooldown", 50);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayCooldown[m] = ConfigHardcore.clampPositive(prop.getInt(50));
        prop = config.get(cat.getName(), "hardenCooldown", 4);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayCooldown[m] = ConfigHardcore.clampPositive(prop.getInt(4));
        prop = config.get(cat.getName(), "sharpenCooldown", 6);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayCooldown[m] = ConfigHardcore.clampPositive(prop.getInt(6));
        prop = config.get(cat.getName(), "flashCooldown", 5);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayCooldown[m] = ConfigHardcore.clampPositive(prop.getInt(5));
        prop = config.get(cat.getName(), "septicsCooldown", 6);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayCooldown[m] = ConfigHardcore.clampPositive(prop.getInt(6));
        prop = config.get(cat.getName(), "kurayamiCooldown", 80);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayCooldown[m] = ConfigHardcore.clampPositive(prop.getInt(80));
        prop = config.get(cat.getName(), "lifeShareCooldown", 25);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayCooldown[m] = ConfigHardcore.clampPositive(prop.getInt(25));
        prop = config.get(cat.getName(), "deathMarkCooldown", 10);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayCooldown[m] = ConfigHardcore.clampPositive(prop.getInt(10));
        prop = config.get(cat.getName(), "paradigmShiftCooldown", 0);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayCooldown[m] = ConfigHardcore.clampPositive(prop.getInt(0));
        prop = config.get(cat.getName(), "adrenalineCooldown", 21);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayCooldown[m] = ConfigHardcore.clampPositive(prop.getInt(21));
        prop = config.get(cat.getName(), "escapeCooldown", 38);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayCooldown[m] = ConfigHardcore.clampPositive(prop.getInt(38));
        prop = config.get(cat.getName(), "giftOfTheGodsCooldown", 100);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayCooldown[m] = ConfigHardcore.clampPositive(prop.getInt(100));
        prop = config.get(cat.getName(), "gamblerCooldown", 20);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayCooldown[m] = ConfigHardcore.clampPositive(prop.getInt(20));
        prop = config.get(cat.getName(), "soulstealerCooldown", 8);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayCooldown[m] = ConfigHardcore.clampPositive(prop.getInt(8));
        prop = config.get(cat.getName(), "parasiteCooldown", 12);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayCooldown[m] = ConfigHardcore.clampPositive(prop.getInt(12));
        prop = config.get(cat.getName(), "symbiosisCooldown", 14);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayCooldown[m] = ConfigHardcore.clampPositive(prop.getInt(14));
        prop = config.get(cat.getName(), "timeCollapseCooldown", 2);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayCooldown[m] = ConfigHardcore.clampPositive(prop.getInt(2));
        prop = config.get(cat.getName(), "magnetizerCooldown", 65);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayCooldown[m] = ConfigHardcore.clampPositive(prop.getInt(65));
        prop = config.get(cat.getName(), "ambienceCooldown", 1);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayCooldown[m] = ConfigHardcore.clampPositive(prop.getInt(1));
        prop = config.get(cat.getName(), "dimentiaCooldown", 77);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayCooldown[m] = ConfigHardcore.clampPositive(prop.getInt(77));
        prop = config.get(cat.getName(), "deleteCooldown", 125);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayCooldown[m] = ConfigHardcore.clampPositive(prop.getInt(125));
        prop = config.get(cat.getName(), "laserCutterCooldown", 15);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayCooldown[m] = ConfigHardcore.clampPositive(prop.getInt(15));
        prop = config.get(cat.getName(), "radiantLightCooldown", 65);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayCooldown[m] = ConfigHardcore.clampPositive(prop.getInt(65));
        prop = config.get(cat.getName(), "dangerZoneCooldown", 24);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayCooldown[m] = ConfigHardcore.clampPositive(prop.getInt(24));
        prop = config.get(cat.getName(), "supportCooldown", 16);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayCooldown[m] = ConfigHardcore.clampPositive(prop.getInt(16));
        prop = config.get(cat.getName(), "purifyCooldown", 42);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayCooldown[m] = ConfigHardcore.clampPositive(prop.getInt(42));
        prop = config.get(cat.getName(), "recallCooldown", 22);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayCooldown[m] = ConfigHardcore.clampPositive(prop.getInt(22));
        prop = config.get(cat.getName(), "shuffleCooldown", 8);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayCooldown[m] = ConfigHardcore.clampPositive(prop.getInt(8));
        prop = config.get(cat.getName(), "blinkCooldown", 1);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayCooldown[m] = ConfigHardcore.clampPositive(prop.getInt(1));
        prop = config.get(cat.getName(), "evacuateCooldown", 77);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayCooldown[m] = ConfigHardcore.clampPositive(prop.getInt(77));
        prop = config.get(cat.getName(), "medicCooldown", 9);
        m = (byte)(m + 1);
        ConfigHardcore.doomsdayCooldown[m] = ConfigHardcore.clampPositive(prop.getInt(9));
        prop = config.get(cat.getName(), "resurgenceCooldown", 55);
        ConfigHardcore.doomsdayCooldown[(byte)(m + 1)] = ConfigHardcore.clampPositive(prop.getInt(55));
        cat = config.getCategory("Weapons");
        cat.setComment("Modify non-Doomsday abilities of weapons, setting whether they are allowed and their cost.");
        cat.setRequiresWorldRestart(false);
        prop = config.get(cat.getName(), "beastlyClawsComboAllow", true);
        m = 0;
        ConfigHardcore.doomAbility[0] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "blindingLightSolarBombAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.doomAbility[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "blindingLightBurnAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.doomAbility[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "blindingLightProjectileDeflectAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.doomAbility[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "butcherCritKnockbackAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.doomAbility[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "butcherKnockbackResistanceBuffAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.doomAbility[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "butcherWeaknessDebuffAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.doomAbility[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "celestialAegisDamageReductionAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.doomAbility[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "celestialLongbowTeleportAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.doomAbility[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "dragonFangBurnAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.doomAbility[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "dragonFangLargeFireballAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.doomAbility[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "dragonFangExtinguishAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.doomAbility[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "frozenLightningSlownessDebuffAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.doomAbility[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "frozenLightningLightningStrikeAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.doomAbility[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "frozenLightningIcicleAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.doomAbility[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "gravitySpikeLaunchAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.doomAbility[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "guiltyThornPoisonStunDebuffAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.doomAbility[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "harmonyBellHarmonyDebuffAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.doomAbility[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "harmonyBellHealingAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.doomAbility[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "mourningStarSelfDestructAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.doomAbility[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "mourningStarLookExplosionAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.doomAbility[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "paranoiaFearSubmissionDebuffAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.doomAbility[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "paranoiaDarkEnergySprayAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.doomAbility[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "paranoiaSingleDarkEnergyAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.doomAbility[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "pitchBlackThrowAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.doomAbility[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "reaperScytheSmallPumpkinbombAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.doomAbility[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "reaperScytheLargePumpkinbombAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.doomAbility[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "splinterRandomDirectonHitAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.doomAbility[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "splinterGroupRandomDirectionHitAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.doomAbility[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "thardusSlownessDebuffAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.doomAbility[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "thardusIcicleAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.doomAbility[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "titanLightningHitAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.doomAbility[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "titanLightningStrikesAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.doomAbility[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "titanLightningAbsorbAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.doomAbility[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "witheringAxeWitherDebuffAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.doomAbility[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "witherAxeWitherSkullAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.doomAbility[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "witheringAxeBlueWitherSkullAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.doomAbility[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "dragonFangFlamethrowerAllow", true);
        ConfigHardcore.doomAbility[(byte)(m + 1)] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "beastlyClawsComboCost", 0);
        m = 0;
        ConfigHardcore.doomAbilityCost[0] = ConfigHardcore.clampPositive(prop.getInt(0));
        prop = config.get(cat.getName(), "blindingLightSolarBombCost", 15);
        m = (byte)(m + 1);
        ConfigHardcore.doomAbilityCost[m] = ConfigHardcore.clampPositive(prop.getInt(15));
        prop = config.get(cat.getName(), "blindingLightBurnCost", 10);
        m = (byte)(m + 1);
        ConfigHardcore.doomAbilityCost[m] = ConfigHardcore.clampPositive(prop.getInt(10));
        prop = config.get(cat.getName(), "blindingLightProjectileDeflectCost", 5);
        m = (byte)(m + 1);
        ConfigHardcore.doomAbilityCost[m] = ConfigHardcore.clampPositive(prop.getInt(5));
        prop = config.get(cat.getName(), "butcherCritKnockbackCost", 1);
        m = (byte)(m + 1);
        ConfigHardcore.doomAbilityCost[m] = ConfigHardcore.clampPositive(prop.getInt(1));
        prop = config.get(cat.getName(), "butcherKnockbackResistanceCost", 0);
        m = (byte)(m + 1);
        ConfigHardcore.doomAbilityCost[m] = ConfigHardcore.clampPositive(prop.getInt(0));
        prop = config.get(cat.getName(), "butcherWeaknessDebuffCost", 0);
        m = (byte)(m + 1);
        ConfigHardcore.doomAbilityCost[m] = ConfigHardcore.clampPositive(prop.getInt(0));
        prop = config.get(cat.getName(), "celestialAegisDamageReductionCost", 0);
        m = (byte)(m + 1);
        ConfigHardcore.doomAbilityCost[m] = ConfigHardcore.clampPositive(prop.getInt(0));
        prop = config.get(cat.getName(), "celestialLongbowTeleportCost", 0);
        m = (byte)(m + 1);
        ConfigHardcore.doomAbilityCost[m] = ConfigHardcore.clampPositive(prop.getInt(0));
        prop = config.get(cat.getName(), "dragonFangBurnCost", 1);
        m = (byte)(m + 1);
        ConfigHardcore.doomAbilityCost[m] = ConfigHardcore.clampPositive(prop.getInt(1));
        prop = config.get(cat.getName(), "dragonFangLargeFireballCost", 10);
        m = (byte)(m + 1);
        ConfigHardcore.doomAbilityCost[m] = ConfigHardcore.clampPositive(prop.getInt(10));
        prop = config.get(cat.getName(), "dragonFangExtinguishCost", 1);
        m = (byte)(m + 1);
        ConfigHardcore.doomAbilityCost[m] = ConfigHardcore.clampPositive(prop.getInt(1));
        prop = config.get(cat.getName(), "frozenLightningSlownessDebuffCost", 3);
        m = (byte)(m + 1);
        ConfigHardcore.doomAbilityCost[m] = ConfigHardcore.clampPositive(prop.getInt(3));
        prop = config.get(cat.getName(), "frozenLightningLightningStrikeCost", 20);
        m = (byte)(m + 1);
        ConfigHardcore.doomAbilityCost[m] = ConfigHardcore.clampPositive(prop.getInt(20));
        prop = config.get(cat.getName(), "frozenLightningIcicleCost", 3);
        m = (byte)(m + 1);
        ConfigHardcore.doomAbilityCost[m] = ConfigHardcore.clampPositive(prop.getInt(3));
        prop = config.get(cat.getName(), "gravitySpikeLaunchCost", 7);
        m = (byte)(m + 1);
        ConfigHardcore.doomAbilityCost[m] = ConfigHardcore.clampPositive(prop.getInt(7));
        prop = config.get(cat.getName(), "guiltyThornPoisonStunDebuffCost", 5);
        m = (byte)(m + 1);
        ConfigHardcore.doomAbilityCost[m] = ConfigHardcore.clampPositive(prop.getInt(5));
        prop = config.get(cat.getName(), "harmonyBellHarmonyDebuffCost", 3);
        m = (byte)(m + 1);
        ConfigHardcore.doomAbilityCost[m] = ConfigHardcore.clampPositive(prop.getInt(3));
        prop = config.get(cat.getName(), "harmonyBellHealingCost", 1);
        m = (byte)(m + 1);
        ConfigHardcore.doomAbilityCost[m] = ConfigHardcore.clampPositive(prop.getInt(1));
        prop = config.get(cat.getName(), "mourningStarSelfDestructCost", 25);
        m = (byte)(m + 1);
        ConfigHardcore.doomAbilityCost[m] = ConfigHardcore.clampPositive(prop.getInt(25));
        prop = config.get(cat.getName(), "mourningStarLookExplosionCost", 30);
        m = (byte)(m + 1);
        ConfigHardcore.doomAbilityCost[m] = ConfigHardcore.clampPositive(prop.getInt(30));
        prop = config.get(cat.getName(), "paranoiaFearSubmissionDebuffCost", 10);
        m = (byte)(m + 1);
        ConfigHardcore.doomAbilityCost[m] = ConfigHardcore.clampPositive(prop.getInt(10));
        prop = config.get(cat.getName(), "paranoiaDarkEnergySprayCost", 15);
        m = (byte)(m + 1);
        ConfigHardcore.doomAbilityCost[m] = ConfigHardcore.clampPositive(prop.getInt(15));
        prop = config.get(cat.getName(), "paranoiaSingleDarkEnergyCost", 5);
        m = (byte)(m + 1);
        ConfigHardcore.doomAbilityCost[m] = ConfigHardcore.clampPositive(prop.getInt(5));
        prop = config.get(cat.getName(), "pitchBlackThrowCost", 5);
        m = (byte)(m + 1);
        ConfigHardcore.doomAbilityCost[m] = ConfigHardcore.clampPositive(prop.getInt(5));
        prop = config.get(cat.getName(), "reaperScytheSmallPumpkinbombCost", 5);
        m = (byte)(m + 1);
        ConfigHardcore.doomAbilityCost[m] = ConfigHardcore.clampPositive(prop.getInt(5));
        prop = config.get(cat.getName(), "reaperScytheLargePumpkinbombCost", 15);
        m = (byte)(m + 1);
        ConfigHardcore.doomAbilityCost[m] = ConfigHardcore.clampPositive(prop.getInt(15));
        prop = config.get(cat.getName(), "splinterRandomDirectionHitCost", 3);
        m = (byte)(m + 1);
        ConfigHardcore.doomAbilityCost[m] = ConfigHardcore.clampPositive(prop.getInt(3));
        prop = config.get(cat.getName(), "splinterGroupRandomDirectionHitCost", 10);
        m = (byte)(m + 1);
        ConfigHardcore.doomAbilityCost[m] = ConfigHardcore.clampPositive(prop.getInt(10));
        prop = config.get(cat.getName(), "thardusSlownessDebuffCost", 5);
        m = (byte)(m + 1);
        ConfigHardcore.doomAbilityCost[m] = ConfigHardcore.clampPositive(prop.getInt(5));
        prop = config.get(cat.getName(), "thardusIcicleCost", 5);
        m = (byte)(m + 1);
        ConfigHardcore.doomAbilityCost[m] = ConfigHardcore.clampPositive(prop.getInt(5));
        prop = config.get(cat.getName(), "titanLightningHitCost", 10);
        m = (byte)(m + 1);
        ConfigHardcore.doomAbilityCost[m] = ConfigHardcore.clampPositive(prop.getInt(10));
        prop = config.get(cat.getName(), "titanLightningStrikesCost", 20);
        m = (byte)(m + 1);
        ConfigHardcore.doomAbilityCost[m] = ConfigHardcore.clampPositive(prop.getInt(20));
        prop = config.get(cat.getName(), "titanLightningAbsorbCost", 5);
        m = (byte)(m + 1);
        ConfigHardcore.doomAbilityCost[m] = ConfigHardcore.clampPositive(prop.getInt(5));
        prop = config.get(cat.getName(), "witheringAxeWitherDebuffCost", 5);
        m = (byte)(m + 1);
        ConfigHardcore.doomAbilityCost[m] = ConfigHardcore.clampPositive(prop.getInt(5));
        prop = config.get(cat.getName(), "witheringAxeWitherSkullCost", 5);
        m = (byte)(m + 1);
        ConfigHardcore.doomAbilityCost[m] = ConfigHardcore.clampPositive(prop.getInt(5));
        prop = config.get(cat.getName(), "witheringAxeBlueWitherSkullCost", 15);
        m = (byte)(m + 1);
        ConfigHardcore.doomAbilityCost[m] = ConfigHardcore.clampPositive(prop.getInt(15));
        prop = config.get(cat.getName(), "dragonFangFlamethrowerCost", 3);
        ConfigHardcore.doomAbilityCost[(byte)(m + 1)] = ConfigHardcore.clampPositive(prop.getInt(3));
        cat = config.getCategory("Enchantments");
        cat.setComment("Disable certain enchantments and set their ids, also set their weights.");
        cat.setRequiresMcRestart(true);
        prop = config.get(cat.getName(), "decayAllow", true);
        m = 0;
        ConfigHardcore.enchantAllow[0] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "slayAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.enchantAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "absolveAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.enchantAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "vampirismAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.enchantAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "leechAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.enchantAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "consumeAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.enchantAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "distractAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.enchantAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "multiplyAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.enchantAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "combustionAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.enchantAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "runeBreakAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.enchantAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "reachAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.enchantAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "unbreakableAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.enchantAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "rustAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.enchantAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "veteranAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.enchantAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "deathTouchAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.enchantAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "ignitionAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.enchantAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "toxicityAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.enchantAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "paralysisAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.enchantAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "elasticityAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.enchantAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "agilityAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.enchantAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "runeWalkerAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.enchantAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "luminescenceAllow", true);
        ConfigHardcore.enchantAllow[(byte)(m + 1)] = prop.getBoolean(true);
        s = "decayID";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, ConfigHardcore.findEnchantID(128)).getInt(ConfigHardcore.findEnchantID(128)));
        s2 = s;
        s = "slayID";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, ConfigHardcore.findEnchantID(ConfigHardcore.getInt(s2) + 1)).getInt(ConfigHardcore.findEnchantID(ConfigHardcore.getInt(s2) + 1)));
        s2 = s;
        s = "absolveID";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, ConfigHardcore.findEnchantID(ConfigHardcore.getInt(s2) + 1)).getInt(ConfigHardcore.findEnchantID(ConfigHardcore.getInt(s2) + 1)));
        s2 = s;
        s = "vampirismID";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, ConfigHardcore.findEnchantID(ConfigHardcore.getInt(s2) + 1)).getInt(ConfigHardcore.findEnchantID(ConfigHardcore.getInt(s2) + 1)));
        s2 = s;
        s = "leechID";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, ConfigHardcore.findEnchantID(ConfigHardcore.getInt(s2) + 1)).getInt(ConfigHardcore.findEnchantID(ConfigHardcore.getInt(s2) + 1)));
        s2 = s;
        s = "consumeID";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, ConfigHardcore.findEnchantID(ConfigHardcore.getInt(s2) + 1)).getInt(ConfigHardcore.findEnchantID(ConfigHardcore.getInt(s2) + 1)));
        s2 = s;
        s = "distractID";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, ConfigHardcore.findEnchantID(ConfigHardcore.getInt(s2) + 1)).getInt(ConfigHardcore.findEnchantID(ConfigHardcore.getInt(s2) + 1)));
        s2 = s;
        s = "multiplyID";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, ConfigHardcore.findEnchantID(ConfigHardcore.getInt(s2) + 1)).getInt(ConfigHardcore.findEnchantID(ConfigHardcore.getInt(s2) + 1)));
        s2 = s;
        s = "combustionID";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, ConfigHardcore.findEnchantID(ConfigHardcore.getInt(s2) + 1)).getInt(ConfigHardcore.findEnchantID(ConfigHardcore.getInt(s2) + 1)));
        s2 = s;
        s = "runeBreakID";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, ConfigHardcore.findEnchantID(ConfigHardcore.getInt(s2) + 1)).getInt(ConfigHardcore.findEnchantID(ConfigHardcore.getInt(s2) + 1)));
        s2 = s;
        s = "reachID";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, ConfigHardcore.findEnchantID(ConfigHardcore.getInt(s2) + 1)).getInt(ConfigHardcore.findEnchantID(ConfigHardcore.getInt(s2) + 1)));
        s2 = s;
        s = "unbreakableID";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, ConfigHardcore.findEnchantID(ConfigHardcore.getInt(s2) + 1)).getInt(ConfigHardcore.findEnchantID(ConfigHardcore.getInt(s2) + 1)));
        s2 = s;
        s = "rustID";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, ConfigHardcore.findEnchantID(ConfigHardcore.getInt(s2) + 1)).getInt(ConfigHardcore.findEnchantID(ConfigHardcore.getInt(s2) + 1)));
        s2 = s;
        s = "veteranID";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, ConfigHardcore.findEnchantID(ConfigHardcore.getInt(s2) + 1)).getInt(ConfigHardcore.findEnchantID(ConfigHardcore.getInt(s2) + 1)));
        s2 = s;
        s = "deathTouchID";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, ConfigHardcore.findEnchantID(ConfigHardcore.getInt(s2) + 1)).getInt(ConfigHardcore.findEnchantID(ConfigHardcore.getInt(s2) + 1)));
        s2 = s;
        s = "ignitionID";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, ConfigHardcore.findEnchantID(ConfigHardcore.getInt(s2) + 1)).getInt(ConfigHardcore.findEnchantID(ConfigHardcore.getInt(s2) + 1)));
        s2 = s;
        s = "toxicityID";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, ConfigHardcore.findEnchantID(ConfigHardcore.getInt(s2) + 1)).getInt(ConfigHardcore.findEnchantID(ConfigHardcore.getInt(s2) + 1)));
        s2 = s;
        s = "paralysisID";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, ConfigHardcore.findEnchantID(ConfigHardcore.getInt(s2) + 1)).getInt(ConfigHardcore.findEnchantID(ConfigHardcore.getInt(s2) + 1)));
        s2 = s;
        s = "elasticityID";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, ConfigHardcore.findEnchantID(ConfigHardcore.getInt(s2) + 1)).getInt(ConfigHardcore.findEnchantID(ConfigHardcore.getInt(s2) + 1)));
        s2 = s;
        s = "agilityID";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, ConfigHardcore.findEnchantID(ConfigHardcore.getInt(s2) + 1)).getInt(ConfigHardcore.findEnchantID(ConfigHardcore.getInt(s2) + 1)));
        s2 = s;
        s = "runeWalkerID";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, ConfigHardcore.findEnchantID(ConfigHardcore.getInt(s2) + 1)).getInt(ConfigHardcore.findEnchantID(ConfigHardcore.getInt(s2) + 1)));
        s2 = s;
        s = "luminescenceID";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), "luminescenceID", ConfigHardcore.findEnchantID(ConfigHardcore.getInt(s2) + 1)).getInt(ConfigHardcore.findEnchantID(ConfigHardcore.getInt(s2) + 1)));
        s = "decayWeight";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, 5).getInt(5));
        s = "slayWeight";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, 5).getInt(5));
        s = "absolveWeight";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, 5).getInt(5));
        s = "vampirismWeight";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, 1).getInt(1));
        s = "leechWeight";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, 1).getInt(1));
        s = "consumeWeight";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, 1).getInt(1));
        s = "distractWeight";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, 1).getInt(1));
        s = "multiplyWeight";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, 1).getInt(1));
        s = "combustionWeight";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, 1).getInt(1));
        s = "runeBreakWeight";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, 5).getInt(5));
        s = "reachWeight";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, 5).getInt(5));
        s = "unbreakableWeight";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, 1).getInt(1));
        s = "rustWeight";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, 1).getInt(1));
        s = "veteranWeight";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, 1).getInt(1));
        s = "deathTouchWeight";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, 2).getInt(2));
        s = "ignitionWeight";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, 2).getInt(2));
        s = "toxicityWeight";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, 2).getInt(2));
        s = "paralysisWeight";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, 2).getInt(2));
        s = "elasticityWeight";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, 4).getInt(4));
        s = "agilityWeight";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, 1).getInt(2));
        s = "runeWalkerWeight";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, 2).getInt(2));
        s = "luminescenceWeight";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, 1).getInt(1));
        cat = config.getCategory("Mobs");
        cat.setComment("Set various aspects of Mobs.");
        prop = config.get(cat.getName(), "allowNormalMobs", true);
        prop.comment = "Are all of the normal mod-exclusive mobs allowed?";
        m = 0;
        ConfigHardcore.mobConfig[0] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "allowMiniBosses", true);
        prop.comment = "Are all of the Mini-Boss variants of some of the mobs allowed?";
        m = (byte)(m + 1);
        ConfigHardcore.mobConfig[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "allowBosses", true);
        prop.comment = "Are all of the Bosses allowed? (Disbling the Overlord disables all of it's forms and disables the Seeker mob)";
        m = (byte)(m + 1);
        ConfigHardcore.mobConfig[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "allowBossOverworldSpawns", true);
        prop.comment = "Are Bosses able to spawn in the Overworld?";
        m = (byte)(m + 1);
        ConfigHardcore.mobConfig[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "allowExtraBossLoot", true);
        prop.comment = "Can Bosses drop a lot of extra normal loot in addition to their specific drops?";
        m = (byte)(m + 1);
        ConfigHardcore.mobConfig[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "allowMobTransformation", true);
        prop.comment = "Can normal mobs transform into their Mini-Boss variants?";
        m = (byte)(m + 1);
        ConfigHardcore.mobConfig[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "allowNonDimensionMobSpawns", true);
        prop.comment = "Are the mod-exclusive mobs able to spawn naturally outside of the mod's Dimensions?";
        m = (byte)(m + 1);
        ConfigHardcore.mobConfig[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "allowMobGroupBuffs", true);
        prop.comment = "Are the mod-exclusive mobs able to randomly spawn with a potion effect when they spawn naturally in a group?";
        m = (byte)(m + 1);
        ConfigHardcore.mobConfig[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "allowEasyBosses", false);
        prop.comment = "Can Bosses be fought on Easy difficulty?";
        m = (byte)(m + 1);
        ConfigHardcore.mobConfig[m] = prop.getBoolean(false);
        prop = config.get(cat.getName(), "allowCustomMobSounds", true);
        prop.comment = "Can the mod-exclusive mobs make their custom sounds? (they will still play the Vanilla sounds if disabled)";
        m = (byte)(m + 1);
        ConfigHardcore.mobConfig[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "bossesDenyFlight", true);
        prop.comment = "When being near Bosses, do they cancel Flight for the player?";
        m = (byte)(m + 1);
        ConfigHardcore.mobConfig[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "allowMobInfighting", false);
        prop.comment = "Can mobs from the mod target other mobs from the mod?";
        m = (byte)(m + 1);
        ConfigHardcore.mobConfig[m] = prop.getBoolean(false);
        prop = config.get(cat.getName(), "allowMobIllumination", false);
        prop.comment = "Can mobs glow via a Luminescence block?";
        m = (byte)(m + 1);
        ConfigHardcore.mobConfig[m] = prop.getBoolean(false);
        prop = config.get(cat.getName(), "allowRandomSupportMob", true);
        prop.comment = "Can Support mobs sometimes spawn and continuously buff other nearby mobs?";
        m = (byte)(m + 1);
        ConfigHardcore.mobConfig[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "allowCustomBossDeathUpdate", false);
        prop.comment = "On death, should Bosses do a custom death effect?";
        m = (byte)(m + 1);
        ConfigHardcore.mobConfig[m] = prop.getBoolean(false);
        prop = config.get(cat.getName(), "allowRidableEntities", true);
        prop.comment = "Should Ridable entities be allowed?";
        m = (byte)(m + 1);
        ConfigHardcore.mobConfig[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "allowRidableEntityAbilities", true);
        prop.comment = "Should Ridable entities be able to use their unique abilities when ridden by a player?";
        m = (byte)(m + 1);
        ConfigHardcore.mobConfig[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "allowRidableEntityAbilitiesViaMob", true);
        prop.comment = "Should Ridable entities be able to use their unique abilities when ridden by other mobs?";
        ConfigHardcore.mobConfig[(byte)(m + 1)] = prop.getBoolean(true);
        s = "commonMobDropChance";
        prop = config.get(cat.getName(), s, 25);
        prop.comment = "Affects the chances of getting common mob drops from the looting amount you killed mobs with, only affects mod-exclusive entities.";
        ConfigHardcore.registerObject(s, ConfigHardcore.clamp(prop.getInt(25), 1, 200));
        s = "rareMobDropChance";
        prop = config.get(cat.getName(), s, 5);
        prop.comment = "Affects the chances of getting rare mob drops from the looting amount you killed mobs with, only affects mod-exclusive entities.";
        ConfigHardcore.registerObject(s, ConfigHardcore.clamp(prop.getInt(5), 1, 100));
        s = "mobTransformationChance";
        ConfigHardcore.registerObject(s, ConfigHardcore.clamp(config.get(cat.getName(), s, 3).getInt(3), 1, 100));
        s = "bossDamageCap";
        ConfigHardcore.registerObject(s, ConfigHardcore.clampPositive(config.get(cat.getName(), s, 25).getInt(25)));
        s = "groupBuffChance";
        ConfigHardcore.registerObject(s, ConfigHardcore.clamp(config.get(cat.getName(), s, 25).getInt(15), 1, 200));
        cat = config.getCategory("Mob Stats");
        cat.setComment("Change mob stats and allowances.");
        prop = config.get(cat.getName(), "jabbaAllow", true);
        m = 0;
        ConfigHardcore.mobAllow[0] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "jannaAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.mobAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "plagueAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.mobAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "gragulAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.mobAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "minotaurAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.mobAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "inklingAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.mobAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "ragrAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.mobAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "pumpkinheadAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.mobAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "tragicNekoAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.mobAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "toxAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.mobAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "poxAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.mobAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "cryseAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.mobAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "starCryseAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.mobAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "norVoxAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.mobAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "starVoxAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.mobAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "pirahAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.mobAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "stinAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.mobAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "stinBabyAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.mobAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "kindlingSpiritAllow", false);
        m = (byte)(m + 1);
        ConfigHardcore.mobAllow[m] = prop.getBoolean(false);
        prop = config.get(cat.getName(), "abominationAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.mobAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "erkelAllow", false);
        m = (byte)(m + 1);
        ConfigHardcore.mobAllow[m] = prop.getBoolean(false);
        prop = config.get(cat.getName(), "sirvAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.mobAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "psygoteAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.mobAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "lockbotAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.mobAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "nanoSwarmAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.mobAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "snowGolemAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.mobAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "hunterAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.mobAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "harvesterAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.mobAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "seekerAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.mobAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "archangelAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.mobAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "ireAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.mobAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "fuseaAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.mobAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "ranmasAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.mobAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "parasmiteAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.mobAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "avrisAllow", false);
        m = (byte)(m + 1);
        ConfigHardcore.mobAllow[m] = prop.getBoolean(false);
        prop = config.get(cat.getName(), "kurayamiAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.mobAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "jetNekoAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.mobAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "scienceNekoAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.mobAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "mechaNekoAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.mobAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "assaultNekoAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.mobAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "commonNekoAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.mobAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "traderNekoAllow", true);
        ConfigHardcore.mobAllow[(byte)(m + 1)] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "mechaExoAllow", true);
        m = 0;
        ConfigHardcore.ridableAllow[0] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "jarraAllow", true);
        m = 0;
        ConfigHardcore.miniBossAllow[0] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "kragulAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.miniBossAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "magmoxAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.miniBossAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "megaCryseAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.miniBossAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "voxStellarumAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.miniBossAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "greaterStinAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.miniBossAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "stinKingAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.miniBossAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "stinQueenAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.miniBossAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "aegarAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.miniBossAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "volatileFuseaAllow", true);
        ConfigHardcore.miniBossAllow[(byte)(m + 1)] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "apisAllow", true);
        m = 0;
        ConfigHardcore.bossAllow[0] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "skultarAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.bossAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "kitsunakumaAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.bossAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "empariahAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.bossAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "timeControllerAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.bossAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "polarisAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.bossAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "enyvilAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.bossAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "claymationAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.bossAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "professorNekoidAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.bossAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "overlordAllow", true);
        ConfigHardcore.bossAllow[(byte)(m + 1)] = prop.getBoolean(true);
        s = "jabbaStats";
        prop = config.get(cat.getName(), s, new double[]{40.0, 0.275, 5.5, 32.0, 0.0, 0.0});
        ConfigHardcore.registerObject(s, TragicConfig.MobStat.verifyMobStat(new TragicConfig.MobStat(prop.getDoubleList())));
        s = "jannaStats";
        prop = config.get(cat.getName(), s, new double[]{20.0, 0.325, 4.5, 32.0, 0.0, 0.0});
        ConfigHardcore.registerObject(s, TragicConfig.MobStat.verifyMobStat(new TragicConfig.MobStat(prop.getDoubleList())));
        s = "jarraStats";
        prop = config.get(cat.getName(), s, new double[]{70.0, 0.36, 6.5, 64.0, 0.0, 0.0});
        ConfigHardcore.registerObject(s, TragicConfig.MobStat.verifyMobStat(new TragicConfig.MobStat(prop.getDoubleList())));
        s = "plagueStats";
        prop = config.get(cat.getName(), s, new double[]{4.0, 0.235, 1.0, 16.0, 0.0, 0.0});
        ConfigHardcore.registerObject(s, TragicConfig.MobStat.verifyMobStat(new TragicConfig.MobStat(prop.getDoubleList())));
        s = "gragulStats";
        prop = config.get(cat.getName(), s, new double[]{5.0, 0.35, 5.0, 32.0, 0.0, 0.0});
        ConfigHardcore.registerObject(s, TragicConfig.MobStat.verifyMobStat(new TragicConfig.MobStat(prop.getDoubleList())));
        s = "kragulStats";
        prop = config.get(cat.getName(), s, new double[]{8.0, 0.38, 5.0, 5.0, 32.0, 0.0});
        ConfigHardcore.registerObject(s, TragicConfig.MobStat.verifyMobStat(new TragicConfig.MobStat(prop.getDoubleList())));
        s = "minotaurStats";
        prop = config.get(cat.getName(), s, new double[]{32.0, 0.35, 7.0, 32.0, 0.5, 6.0});
        ConfigHardcore.registerObject(s, TragicConfig.MobStat.verifyMobStat(new TragicConfig.MobStat(prop.getDoubleList())));
        s = "inklingStats";
        prop = config.get(cat.getName(), s, new double[]{16.0, 0.23, 1.0, 32.0, 0.0, 0.0});
        ConfigHardcore.registerObject(s, TragicConfig.MobStat.verifyMobStat(new TragicConfig.MobStat(prop.getDoubleList())));
        s = "ragrStats";
        prop = config.get(cat.getName(), s, new double[]{65.0, 0.38, 7.0, 32.0, 1.0, 10.0});
        ConfigHardcore.registerObject(s, TragicConfig.MobStat.verifyMobStat(new TragicConfig.MobStat(prop.getDoubleList())));
        s = "pumpkinheadStats";
        prop = config.get(cat.getName(), s, new double[]{60.0, 0.275, 6.0, 32.0, 0.0, 18.0});
        ConfigHardcore.registerObject(s, TragicConfig.MobStat.verifyMobStat(new TragicConfig.MobStat(prop.getDoubleList())));
        s = "tragicNekoStats";
        prop = config.get(cat.getName(), s, new double[]{60.0, 0.335, 4.0, 32.0, 0.0, 0.0});
        ConfigHardcore.registerObject(s, TragicConfig.MobStat.verifyMobStat(new TragicConfig.MobStat(prop.getDoubleList())));
        s = "toxStats";
        prop = config.get(cat.getName(), s, new double[]{40.0, 0.05, 8.0, 64.0, 1.0, 16.0});
        ConfigHardcore.registerObject(s, TragicConfig.MobStat.verifyMobStat(new TragicConfig.MobStat(prop.getDoubleList())));
        s = "poxStats";
        prop = config.get(cat.getName(), s, new double[]{30.0, 0.05, 4.0, 64.0, 0.7, 10.0});
        ConfigHardcore.registerObject(s, TragicConfig.MobStat.verifyMobStat(new TragicConfig.MobStat(prop.getDoubleList())));
        s = "magmoxStats";
        prop = config.get(cat.getName(), s, new double[]{75.0, 0.05, 15.0, 64.0, 1.0, 20.0});
        ConfigHardcore.registerObject(s, TragicConfig.MobStat.verifyMobStat(new TragicConfig.MobStat(prop.getDoubleList())));
        s = "cryseStats";
        prop = config.get(cat.getName(), s, new double[]{35.0, 0.285, 4.0, 48.0, 0.0, 4.0});
        ConfigHardcore.registerObject(s, TragicConfig.MobStat.verifyMobStat(new TragicConfig.MobStat(prop.getDoubleList())));
        s = "starCryseStats";
        prop = config.get(cat.getName(), s, new double[]{55.0, 0.315, 4.0, 48.0, 0.0, 4.0});
        ConfigHardcore.registerObject(s, TragicConfig.MobStat.verifyMobStat(new TragicConfig.MobStat(prop.getDoubleList())));
        s = "megaCryseStats";
        prop = config.get(cat.getName(), s, new double[]{50.0, 0.31, 6.0, 48.0, 1.0, 18.0});
        ConfigHardcore.registerObject(s, TragicConfig.MobStat.verifyMobStat(new TragicConfig.MobStat(prop.getDoubleList())));
        s = "norVoxStats";
        prop = config.get(cat.getName(), s, new double[]{30.0, 0.39, 4.0, 32.0, 0.25, 8.0});
        ConfigHardcore.registerObject(s, TragicConfig.MobStat.verifyMobStat(new TragicConfig.MobStat(prop.getDoubleList())));
        s = "starVoxStats";
        prop = config.get(cat.getName(), s, new double[]{40.0, 0.39, 4.0, 32.0, 0.25, 16.0});
        ConfigHardcore.registerObject(s, TragicConfig.MobStat.verifyMobStat(new TragicConfig.MobStat(prop.getDoubleList())));
        s = "voxStellarumStats";
        prop = config.get(cat.getName(), s, new double[]{150.0, 0.46, 4.0, 64.0, 0.2, 16.0});
        ConfigHardcore.registerObject(s, TragicConfig.MobStat.verifyMobStat(new TragicConfig.MobStat(prop.getDoubleList())));
        s = "pirahStats";
        prop = config.get(cat.getName(), s, new double[]{10.0, 0.45, 3.0, 16.0, 0.0, 0.0});
        ConfigHardcore.registerObject(s, TragicConfig.MobStat.verifyMobStat(new TragicConfig.MobStat(prop.getDoubleList())));
        s = "goldenPirahStats";
        prop = config.get(cat.getName(), s, new double[]{25.0, 0.45, 7.5, 16.0, 0.0, 0.0});
        ConfigHardcore.registerObject(s, TragicConfig.MobStat.verifyMobStat(new TragicConfig.MobStat(prop.getDoubleList())));
        s = "stinStats";
        prop = config.get(cat.getName(), s, new double[]{40.0, 0.246, 10.0, 32.0, 0.5, 6.0});
        ConfigHardcore.registerObject(s, TragicConfig.MobStat.verifyMobStat(new TragicConfig.MobStat(prop.getDoubleList())));
        s = "stinBabyStats";
        prop = config.get(cat.getName(), s, new double[]{16.0, 0.346, 6.0, 32.0, 0.0, 0.0});
        ConfigHardcore.registerObject(s, TragicConfig.MobStat.verifyMobStat(new TragicConfig.MobStat(prop.getDoubleList())));
        s = "greaterStinStats";
        prop = config.get(cat.getName(), s, new double[]{80.0, 0.276, 14.0, 24.0, 1.0, 12.0});
        ConfigHardcore.registerObject(s, TragicConfig.MobStat.verifyMobStat(new TragicConfig.MobStat(prop.getDoubleList())));
        s = "stinKingStats";
        prop = config.get(cat.getName(), s, new double[]{100.0, 0.226, 20.0, 32.0, 2.0, 20.0});
        ConfigHardcore.registerObject(s, TragicConfig.MobStat.verifyMobStat(new TragicConfig.MobStat(prop.getDoubleList())));
        s = "stinQueenStats";
        prop = config.get(cat.getName(), s, new double[]{160.0, 0.186, 12.0, 24.0, 2.0, 10.0});
        ConfigHardcore.registerObject(s, TragicConfig.MobStat.verifyMobStat(new TragicConfig.MobStat(prop.getDoubleList())));
        s = "kindlingSpiritStats";
        prop = config.get(cat.getName(), s, new double[]{8.0, 0.476, 1.0, 16.0, 0.0, 0.0});
        ConfigHardcore.registerObject(s, TragicConfig.MobStat.verifyMobStat(new TragicConfig.MobStat(prop.getDoubleList())));
        s = "abominationStats";
        prop = config.get(cat.getName(), s, new double[]{45.0, 0.276, 7.0, 32.0, 0.5, 4.0});
        ConfigHardcore.registerObject(s, TragicConfig.MobStat.verifyMobStat(new TragicConfig.MobStat(prop.getDoubleList())));
        s = "erkelStats";
        prop = config.get(cat.getName(), s, new double[]{16.0, 0.476, 1.0, 16.0, 0.0, 0.0});
        ConfigHardcore.registerObject(s, TragicConfig.MobStat.verifyMobStat(new TragicConfig.MobStat(prop.getDoubleList())));
        s = "sirvStats";
        prop = config.get(cat.getName(), s, new double[]{8.0, 0.375, 14.0, 64.0, 0.5, 0.0});
        ConfigHardcore.registerObject(s, TragicConfig.MobStat.verifyMobStat(new TragicConfig.MobStat(prop.getDoubleList())));
        s = "psygoteStats";
        prop = config.get(cat.getName(), s, new double[]{52.0, 0.29, 8.0, 32.0, 0.65, 10.0});
        ConfigHardcore.registerObject(s, TragicConfig.MobStat.verifyMobStat(new TragicConfig.MobStat(prop.getDoubleList())));
        s = "lockbotStats";
        prop = config.get(cat.getName(), s, new double[]{22.0, 0.0, 1.0, 8.0, 100.0, 8.0});
        ConfigHardcore.registerObject(s, TragicConfig.MobStat.verifyMobStat(new TragicConfig.MobStat(prop.getDoubleList())));
        s = "nanoSwarmStats";
        prop = config.get(cat.getName(), s, new double[]{6.0, 0.335, 2.0, 64.0, 0.0, 0.0});
        ConfigHardcore.registerObject(s, TragicConfig.MobStat.verifyMobStat(new TragicConfig.MobStat(prop.getDoubleList())));
        s = "hunterStats";
        prop = config.get(cat.getName(), s, new double[]{16.0, 0.236, 4.0, 32.0, 0.0, 0.0});
        ConfigHardcore.registerObject(s, TragicConfig.MobStat.verifyMobStat(new TragicConfig.MobStat(prop.getDoubleList())));
        s = "harvesterStats";
        prop = config.get(cat.getName(), s, new double[]{56.0, 0.145, 0.0, 16.0, 100.0, 20.0});
        ConfigHardcore.registerObject(s, TragicConfig.MobStat.verifyMobStat(new TragicConfig.MobStat(prop.getDoubleList())));
        s = "seekerStats";
        prop = config.get(cat.getName(), s, new double[]{30.0, 0.0, 1.0, 48.0, 100.0, 24.0});
        ConfigHardcore.registerObject(s, TragicConfig.MobStat.verifyMobStat(new TragicConfig.MobStat(prop.getDoubleList())));
        s = "archangelStats";
        prop = config.get(cat.getName(), s, new double[]{45.0, 0.0, 1.0, 32.0, 0.5, 12.0});
        ConfigHardcore.registerObject(s, TragicConfig.MobStat.verifyMobStat(new TragicConfig.MobStat(prop.getDoubleList())));
        s = "ireStats";
        prop = config.get(cat.getName(), s, new double[]{25.0, 0.0, 1.0, 16.0, 100.0, 0.0});
        ConfigHardcore.registerObject(s, TragicConfig.MobStat.verifyMobStat(new TragicConfig.MobStat(prop.getDoubleList())));
        s = "fuseaStats";
        prop = config.get(cat.getName(), s, new double[]{10.0, 0.0, 0.0, 16.0, 100.0, 0.0});
        ConfigHardcore.registerObject(s, TragicConfig.MobStat.verifyMobStat(new TragicConfig.MobStat(prop.getDoubleList())));
        s = "volatileFuseaStats";
        prop = config.get(cat.getName(), s, new double[]{18.0, 0.0, 0.0, 32.0, 100.0, 0.0});
        ConfigHardcore.registerObject(s, TragicConfig.MobStat.verifyMobStat(new TragicConfig.MobStat(prop.getDoubleList())));
        s = "ranmasStats";
        prop = config.get(cat.getName(), s, new double[]{50.0, 0.0, 1.0, 32.0, 100.0, 24.0});
        ConfigHardcore.registerObject(s, TragicConfig.MobStat.verifyMobStat(new TragicConfig.MobStat(prop.getDoubleList())));
        s = "parasmiteStats";
        prop = config.get(cat.getName(), s, new double[]{10.0, 0.0, 1.0, 16.0, 0.0, 0.0});
        ConfigHardcore.registerObject(s, TragicConfig.MobStat.verifyMobStat(new TragicConfig.MobStat(prop.getDoubleList())));
        s = "kurayamiStats";
        prop = config.get(cat.getName(), s, new double[]{120.0, 0.42, 12.0, 64.0, 0.4, 10.0});
        ConfigHardcore.registerObject(s, TragicConfig.MobStat.verifyMobStat(new TragicConfig.MobStat(prop.getDoubleList())));
        s = "avrisStats";
        prop = config.get(cat.getName(), s, new double[]{75.0, 0.312, 2.0, 64.0, 0.6, 16.0});
        ConfigHardcore.registerObject(s, TragicConfig.MobStat.verifyMobStat(new TragicConfig.MobStat(prop.getDoubleList())));
        s = "jetNekoStats";
        prop = config.get(cat.getName(), s, new double[]{45.0, 0.23, 1.0, 32.0, 1.0, 6.0});
        ConfigHardcore.registerObject(s, TragicConfig.MobStat.verifyMobStat(new TragicConfig.MobStat(prop.getDoubleList())));
        s = "scienceNekoStats";
        prop = config.get(cat.getName(), s, new double[]{30.0, 0.225, 2.0, 32.0, 0.0, 0.0});
        ConfigHardcore.registerObject(s, TragicConfig.MobStat.verifyMobStat(new TragicConfig.MobStat(prop.getDoubleList())));
        s = "mechaNekoStats";
        prop = config.get(cat.getName(), s, new double[]{15.0, 0.27, 4.0, 32.0, 0.0, 0.0});
        ConfigHardcore.registerObject(s, TragicConfig.MobStat.verifyMobStat(new TragicConfig.MobStat(prop.getDoubleList())));
        s = "assaultNekoStats";
        prop = config.get(cat.getName(), s, new double[]{42.0, 0.33, 4.0, 32.0, 0.5, 8.0});
        ConfigHardcore.registerObject(s, TragicConfig.MobStat.verifyMobStat(new TragicConfig.MobStat(prop.getDoubleList())));
        s = "commonNekoStats";
        prop = config.get(cat.getName(), s, new double[]{20.0, 0.245, 2.0, 32.0, 0.0, 4.0});
        ConfigHardcore.registerObject(s, TragicConfig.MobStat.verifyMobStat(new TragicConfig.MobStat(prop.getDoubleList())));
        s = "traderNekoStats";
        prop = config.get(cat.getName(), s, new double[]{30.0, 0.215, 1.0, 16.0, 0.0, 0.0});
        ConfigHardcore.registerObject(s, TragicConfig.MobStat.verifyMobStat(new TragicConfig.MobStat(prop.getDoubleList())));
        s = "mechaExoStats";
        prop = config.get(cat.getName(), s, new double[]{25.0, 0.19, 5.0, 32.0, 1.0, 24.0});
        ConfigHardcore.registerObject(s, TragicConfig.MobStat.verifyMobStat(new TragicConfig.MobStat(prop.getDoubleList())));
        s = "aegarStats";
        prop = config.get(cat.getName(), s, new double[]{150.0, 0.185, 26.0, 32.0, 2.5, 24.0});
        ConfigHardcore.registerObject(s, TragicConfig.MobStat.verifyMobStat(new TragicConfig.MobStat(prop.getDoubleList())));
        s = "apisStats";
        prop = config.get(cat.getName(), s, new double[]{160.0, 0.375, 12.0, 32.0, 1.0, 16.0});
        ConfigHardcore.registerObject(s, TragicConfig.MobStat.verifyMobStat(new TragicConfig.MobStat(prop.getDoubleList())));
        s = "skultarStats";
        prop = config.get(cat.getName(), s, new double[]{220.0, 0.35, 16.0, 32.0, 1.0, 20.0});
        ConfigHardcore.registerObject(s, TragicConfig.MobStat.verifyMobStat(new TragicConfig.MobStat(prop.getDoubleList())));
        s = "kitsunakumaStats";
        prop = config.get(cat.getName(), s, new double[]{80.0, 0.42, 6.0, 64.0, 0.0, 0.0});
        ConfigHardcore.registerObject(s, TragicConfig.MobStat.verifyMobStat(new TragicConfig.MobStat(prop.getDoubleList())));
        s = "polarisStats";
        prop = config.get(cat.getName(), s, new double[]{120.0, 0.44, 5.0, 64.0, 0.0, 14.0});
        ConfigHardcore.registerObject(s, TragicConfig.MobStat.verifyMobStat(new TragicConfig.MobStat(prop.getDoubleList())));
        s = "empariahStats";
        prop = config.get(cat.getName(), s, new double[]{140.0, 0.326, 16.0, 48.0, 2.0, 22.0});
        ConfigHardcore.registerObject(s, TragicConfig.MobStat.verifyMobStat(new TragicConfig.MobStat(prop.getDoubleList())));
        s = "timeControllerStats";
        prop = config.get(cat.getName(), s, new double[]{350.0, 0.366, 6.0, 64.0, 0.5, 18.0});
        ConfigHardcore.registerObject(s, TragicConfig.MobStat.verifyMobStat(new TragicConfig.MobStat(prop.getDoubleList())));
        s = "enyvilStats";
        prop = config.get(cat.getName(), s, new double[]{450.0, 0.276, 24.0, 48.0, 1.0, 4.0});
        ConfigHardcore.registerObject(s, TragicConfig.MobStat.verifyMobStat(new TragicConfig.MobStat(prop.getDoubleList())));
        s = "claymationStats";
        prop = config.get(cat.getName(), s, new double[]{150.0, 0.32, 12.0, 32.0, 1.0, 18.0});
        ConfigHardcore.registerObject(s, TragicConfig.MobStat.verifyMobStat(new TragicConfig.MobStat(prop.getDoubleList())));
        s = "professorNekoidStats";
        prop = config.get(cat.getName(), s, new double[]{200.0, 0.25, 6.0, 32.0, 0.0, 12.0});
        ConfigHardcore.registerObject(s, TragicConfig.MobStat.verifyMobStat(new TragicConfig.MobStat(prop.getDoubleList())));
        s = "overlordCocoonStats";
        prop = config.get(cat.getName(), s, new double[]{500.0, 0.226, 24.0, 64.0, 4.5, 0.0});
        ConfigHardcore.registerObject(s, TragicConfig.MobStat.verifyMobStat(new TragicConfig.MobStat(prop.getDoubleList())));
        s = "overlordCombatStats";
        prop = config.get(cat.getName(), s, new double[]{500.0, 0.326, 24.0, 64.0, 4.5, 0.0});
        ConfigHardcore.registerObject(s, TragicConfig.MobStat.verifyMobStat(new TragicConfig.MobStat(prop.getDoubleList())));
        s = "overlordCoreStats";
        prop = config.get(cat.getName(), s, new double[]{1000.0, 0.326, 24.0, 64.0, 4.5, 0.0});
        ConfigHardcore.registerObject(s, TragicConfig.MobStat.verifyMobStat(new TragicConfig.MobStat(prop.getDoubleList())));
        cat = config.getCategory("Mob Spawns");
        cat.setComment("Set spawn chances and group sizes for each mob, can also override the Vanilla biome spawns.");
        s = "jabbaSpawnChance";
        ConfigHardcore.registerObject(s, ConfigHardcore.clamp(config.get(cat.getName(), s, 75).getInt(75), 1, 1000));
        s = "jannaSpawnChance";
        ConfigHardcore.registerObject(s, ConfigHardcore.clamp(config.get(cat.getName(), s, 50).getInt(50), 1, 1000));
        s = "jarraSpawnChance";
        ConfigHardcore.registerObject(s, ConfigHardcore.clamp(config.get(cat.getName(), s, 5).getInt(5), 1, 1000));
        s = "plagueSpawnChance";
        ConfigHardcore.registerObject(s, ConfigHardcore.clamp(config.get(cat.getName(), s, 50).getInt(50), 1, 1000));
        s = "gragulSpawnChance";
        ConfigHardcore.registerObject(s, ConfigHardcore.clamp(config.get(cat.getName(), "gragulSpawnChance", 25).getInt(25), 1, 1000));
        s = "kragulSpawnChance";
        ConfigHardcore.registerObject(s, ConfigHardcore.clamp(config.get(cat.getName(), s, 5).getInt(5), 1, 1000));
        s = "minotaurSpawnChance";
        ConfigHardcore.registerObject(s, ConfigHardcore.clamp(config.get(cat.getName(), s, 75).getInt(75), 1, 1000));
        s = "inklingSpawnChance";
        ConfigHardcore.registerObject(s, ConfigHardcore.clamp(config.get(cat.getName(), s, 75).getInt(75), 1, 1000));
        s = "ragrSpawnChance";
        ConfigHardcore.registerObject(s, ConfigHardcore.clamp(config.get(cat.getName(), s, 25).getInt(25), 1, 1000));
        s = "pumpkinheadSpawnChance";
        ConfigHardcore.registerObject(s, ConfigHardcore.clamp(config.get(cat.getName(), s, 25).getInt(25), 1, 1000));
        s = "tragicNekoSpawnChance";
        ConfigHardcore.registerObject(s, ConfigHardcore.clamp(config.get(cat.getName(), s, 50).getInt(50), 1, 1000));
        s = "toxSpawnChance";
        ConfigHardcore.registerObject(s, ConfigHardcore.clamp(config.get(cat.getName(), s, 50).getInt(50), 1, 1000));
        s = "poxSpawnChance";
        ConfigHardcore.registerObject(s, ConfigHardcore.clamp(config.get(cat.getName(), s, 50).getInt(50), 1, 1000));
        s = "magmoxSpawnChance";
        ConfigHardcore.registerObject(s, ConfigHardcore.clamp(config.get(cat.getName(), s, 5).getInt(5), 1, 1000));
        s = "cryseSpawnChance";
        ConfigHardcore.registerObject(s, ConfigHardcore.clamp(config.get(cat.getName(), s, 75).getInt(75), 1, 1000));
        s = "starCryseSpawnChance";
        ConfigHardcore.registerObject(s, ConfigHardcore.clamp(config.get(cat.getName(), s, 75).getInt(75), 1, 1000));
        s = "megaCryseSpawnChance";
        ConfigHardcore.registerObject(s, ConfigHardcore.clamp(config.get(cat.getName(), s, 5).getInt(5), 1, 1000));
        s = "norVoxSpawnChance";
        ConfigHardcore.registerObject(s, ConfigHardcore.clamp(config.get(cat.getName(), s, 25).getInt(25), 1, 1000));
        s = "starVoxSpawnChance";
        ConfigHardcore.registerObject(s, ConfigHardcore.clamp(config.get(cat.getName(), s, 25).getInt(25), 1, 1000));
        s = "voxStellarumSpawnChance";
        ConfigHardcore.registerObject(s, ConfigHardcore.clamp(config.get(cat.getName(), s, 5).getInt(5), 1, 1000));
        s = "pirahSpawnChance";
        ConfigHardcore.registerObject(s, ConfigHardcore.clamp(config.get(cat.getName(), s, 25).getInt(25), 1, 1000));
        s = "stinSpawnChance";
        ConfigHardcore.registerObject(s, ConfigHardcore.clamp(config.get(cat.getName(), s, 50).getInt(50), 1, 1000));
        s = "greaterStinSpawnChance";
        ConfigHardcore.registerObject(s, ConfigHardcore.clamp(config.get(cat.getName(), s, 5).getInt(5), 1, 1000));
        s = "stinKingSpawnChance";
        ConfigHardcore.registerObject(s, ConfigHardcore.clamp(config.get(cat.getName(), s, 5).getInt(5), 1, 1000));
        s = "stinQueenSpawnChance";
        ConfigHardcore.registerObject(s, ConfigHardcore.clamp(config.get(cat.getName(), s, 5).getInt(5), 1, 1000));
        s = "kindlingSpiritSpawnChance";
        ConfigHardcore.registerObject(s, ConfigHardcore.clamp(config.get(cat.getName(), s, 15).getInt(15), 1, 1000));
        s = "abominationSpawnChance";
        ConfigHardcore.registerObject(s, ConfigHardcore.clamp(config.get(cat.getName(), s, 25).getInt(25), 1, 1000));
        s = "erkelSpawnChance";
        ConfigHardcore.registerObject(s, ConfigHardcore.clamp(config.get(cat.getName(), s, 25).getInt(25), 1, 1000));
        s = "sirvSpawnChance";
        ConfigHardcore.registerObject(s, ConfigHardcore.clamp(config.get(cat.getName(), s, 50).getInt(50), 1, 1000));
        s = "psygoteSpawnChance";
        ConfigHardcore.registerObject(s, ConfigHardcore.clamp(config.get(cat.getName(), s, 5).getInt(5), 1, 1000));
        s = "lockbotSpawnChance";
        ConfigHardcore.registerObject(s, ConfigHardcore.clamp(config.get(cat.getName(), s, 5).getInt(5), 1, 1000));
        s = "nanoSwarmSpawnChance";
        ConfigHardcore.registerObject(s, ConfigHardcore.clamp(config.get(cat.getName(), s, 25).getInt(25), 1, 1000));
        s = "snowGolemSpawnChance";
        ConfigHardcore.registerObject(s, ConfigHardcore.clamp(config.get(cat.getName(), s, 20).getInt(20), 1, 1000));
        s = "hunterSpawnChance";
        ConfigHardcore.registerObject(s, ConfigHardcore.clamp(config.get(cat.getName(), s, 15).getInt(15), 1, 1000));
        s = "harvesterSpawnChance";
        ConfigHardcore.registerObject(s, ConfigHardcore.clamp(config.get(cat.getName(), s, 10).getInt(10), 1, 1000));
        s = "seekerSpawnChance";
        ConfigHardcore.registerObject(s, ConfigHardcore.clamp(config.get(cat.getName(), s, 5).getInt(5), 1, 1000));
        s = "archangelSpawnChance";
        ConfigHardcore.registerObject(s, ConfigHardcore.clamp(config.get(cat.getName(), s, 5).getInt(5), 1, 1000));
        s = "ireSpawnChance";
        ConfigHardcore.registerObject(s, ConfigHardcore.clamp(config.get(cat.getName(), s, 45).getInt(45), 1, 1000));
        s = "fuseaSpawnChance";
        ConfigHardcore.registerObject(s, ConfigHardcore.clamp(config.get(cat.getName(), s, 25).getInt(25), 1, 1000));
        s = "volatileFuseaSpawnChance";
        ConfigHardcore.registerObject(s, ConfigHardcore.clamp(config.get(cat.getName(), s, 5).getInt(5), 1, 1000));
        s = "ranmasSpawnChance";
        ConfigHardcore.registerObject(s, ConfigHardcore.clamp(config.get(cat.getName(), s, 25).getInt(25), 1, 1000));
        s = "parasmiteSpawnChance";
        ConfigHardcore.registerObject(s, ConfigHardcore.clamp(config.get(cat.getName(), s, 25).getInt(25), 1, 1000));
        s = "avrisSpawnChance";
        ConfigHardcore.registerObject(s, ConfigHardcore.clamp(config.get(cat.getName(), s, 5).getInt(5), 1, 1000));
        s = "jetNekoSpawnChance";
        ConfigHardcore.registerObject(s, ConfigHardcore.clamp(config.get(cat.getName(), s, 5).getInt(5), 1, 1000));
        s = "scienceNekoSpawnChance";
        ConfigHardcore.registerObject(s, ConfigHardcore.clamp(config.get(cat.getName(), s, 25).getInt(25), 1, 1000));
        s = "mechaNekoSpawnChance";
        ConfigHardcore.registerObject(s, ConfigHardcore.clamp(config.get(cat.getName(), s, 1).getInt(1), 1, 1000));
        s = "assaultNekoSpawnChance";
        ConfigHardcore.registerObject(s, ConfigHardcore.clamp(config.get(cat.getName(), s, 25).getInt(25), 1, 1000));
        s = "commonNekoSpawnChance";
        ConfigHardcore.registerObject(s, ConfigHardcore.clamp(config.get(cat.getName(), s, 45).getInt(45), 1, 1000));
        s = "traderNekoSpawnChance";
        ConfigHardcore.registerObject(s, ConfigHardcore.clamp(config.get(cat.getName(), s, 1).getInt(1), 1, 1000));
        s = "aegarSpawnChance";
        ConfigHardcore.registerObject(s, ConfigHardcore.clamp(config.get(cat.getName(), s, 5).getInt(5), 1, 1000));
        s = "apisSpawnChance";
        ConfigHardcore.registerObject(s, ConfigHardcore.clamp(config.get(cat.getName(), s, 5).getInt(5), 1, 1000));
        s = "skultarSpawnChance";
        ConfigHardcore.registerObject(s, ConfigHardcore.clamp(config.get(cat.getName(), s, 5).getInt(5), 1, 1000));
        s = "kitsunakumaSpawnChance";
        ConfigHardcore.registerObject(s, ConfigHardcore.clamp(config.get(cat.getName(), s, 5).getInt(5), 1, 1000));
        s = "empariahSpawnChance";
        ConfigHardcore.registerObject(s, ConfigHardcore.clamp(config.get(cat.getName(), s, 5).getInt(5), 1, 1000));
        s = "timeControllerSpawnChance";
        ConfigHardcore.registerObject(s, ConfigHardcore.clamp(config.get(cat.getName(), s, 5).getInt(5), 1, 1000));
        s = "polarisSpawnChance";
        ConfigHardcore.registerObject(s, ConfigHardcore.clamp(config.get(cat.getName(), s, 5).getInt(5), 1, 1000));
        s = "enyvilSpawnChance";
        ConfigHardcore.registerObject(s, ConfigHardcore.clamp(config.get(cat.getName(), s, 5).getInt(5), 1, 1000));
        s = "claymationSpawnChance";
        ConfigHardcore.registerObject(s, ConfigHardcore.clamp(config.get(cat.getName(), s, 5).getInt(5), 1, 1000));
        s = "professorNekoidSpawnChance";
        ConfigHardcore.registerObject(s, ConfigHardcore.clamp(config.get(cat.getName(), s, 1).getInt(1), 1, 1000));
        s = "jabbaGroupSize";
        ConfigHardcore.registerObject(s, ConfigHardcore.verifyGS(config.get(cat.getName(), s, new int[]{0, 2}).getIntList()));
        s = "jannaGroupSize";
        ConfigHardcore.registerObject(s, ConfigHardcore.verifyGS(config.get(cat.getName(), s, new int[]{0, 2}).getIntList()));
        s = "plagueGroupSize";
        ConfigHardcore.registerObject(s, ConfigHardcore.verifyGS(config.get(cat.getName(), s, new int[]{2, 3}).getIntList()));
        s = "gragulGroupSize";
        ConfigHardcore.registerObject(s, ConfigHardcore.verifyGS(config.get(cat.getName(), s, new int[]{0, 1}).getIntList()));
        s = "minotaurGroupSize";
        ConfigHardcore.registerObject(s, ConfigHardcore.verifyGS(config.get(cat.getName(), s, new int[]{0, 1}).getIntList()));
        s = "inklingGroupSize";
        ConfigHardcore.registerObject(s, ConfigHardcore.verifyGS(config.get(cat.getName(), s, new int[]{2, 5}).getIntList()));
        s = "ragrGroupSize";
        ConfigHardcore.registerObject(s, ConfigHardcore.verifyGS(config.get(cat.getName(), s, new int[]{0, 1}).getIntList()));
        s = "pumpkinheadGroupSize";
        ConfigHardcore.registerObject(s, ConfigHardcore.verifyGS(config.get(cat.getName(), s, new int[]{2, 4}).getIntList()));
        s = "tragicNekoGroupSize";
        ConfigHardcore.registerObject(s, ConfigHardcore.verifyGS(config.get(cat.getName(), s, new int[]{0, 1}).getIntList()));
        s = "toxGroupSize";
        ConfigHardcore.registerObject(s, ConfigHardcore.verifyGS(config.get(cat.getName(), s, new int[]{0, 1}).getIntList()));
        s = "poxGroupSize";
        ConfigHardcore.registerObject(s, ConfigHardcore.verifyGS(config.get(cat.getName(), s, new int[]{0, 1}).getIntList()));
        s = "cryseGroupSize";
        ConfigHardcore.registerObject(s, ConfigHardcore.verifyGS(config.get(cat.getName(), s, new int[]{0, 2}).getIntList()));
        s = "starCryseGroupSize";
        ConfigHardcore.registerObject(s, ConfigHardcore.verifyGS(config.get(cat.getName(), s, new int[]{1, 3}).getIntList()));
        s = "norVoxGroupSize";
        ConfigHardcore.registerObject(s, ConfigHardcore.verifyGS(config.get(cat.getName(), s, new int[]{0, 1}).getIntList()));
        s = "starVoxGroupSize";
        ConfigHardcore.registerObject(s, ConfigHardcore.verifyGS(config.get(cat.getName(), s, new int[]{2, 5}).getIntList()));
        s = "pirahGroupSize";
        ConfigHardcore.registerObject(s, ConfigHardcore.verifyGS(config.get(cat.getName(), s, new int[]{4, 6}).getIntList()));
        s = "stinGroupSize";
        ConfigHardcore.registerObject(s, ConfigHardcore.verifyGS(config.get(cat.getName(), s, new int[]{1, 2}).getIntList()));
        s = "kindlingSpiritGroupSize";
        ConfigHardcore.registerObject(s, ConfigHardcore.verifyGS(config.get(cat.getName(), s, new int[]{0, 1}).getIntList()));
        s = "abominationGroupSize";
        ConfigHardcore.registerObject(s, ConfigHardcore.verifyGS(config.get(cat.getName(), s, new int[]{2, 5}).getIntList()));
        s = "erkelGroupSize";
        ConfigHardcore.registerObject(s, ConfigHardcore.verifyGS(config.get(cat.getName(), s, new int[]{1, 2}).getIntList()));
        s = "sirvGroupSize";
        ConfigHardcore.registerObject(s, ConfigHardcore.verifyGS(config.get(cat.getName(), s, new int[]{4, 6}).getIntList()));
        s = "psygoteGroupSize";
        ConfigHardcore.registerObject(s, ConfigHardcore.verifyGS(config.get(cat.getName(), s, new int[]{0, 1}).getIntList()));
        s = "lockbotGroupSize";
        ConfigHardcore.registerObject(s, ConfigHardcore.verifyGS(config.get(cat.getName(), s, new int[]{0, 1}).getIntList()));
        s = "nanoSwarmGroupSize";
        ConfigHardcore.registerObject(s, ConfigHardcore.verifyGS(config.get(cat.getName(), s, new int[]{2, 4}).getIntList()));
        s = "snowGolemGroupSize";
        ConfigHardcore.registerObject(s, ConfigHardcore.verifyGS(config.get(cat.getName(), s, new int[]{0, 1}).getIntList()));
        s = "hunterGroupSize";
        ConfigHardcore.registerObject(s, ConfigHardcore.verifyGS(config.get(cat.getName(), s, new int[]{4, 6}).getIntList()));
        s = "harvesterGroupSize";
        ConfigHardcore.registerObject(s, ConfigHardcore.verifyGS(config.get(cat.getName(), s, new int[]{0, 2}).getIntList()));
        s = "seekerGroupSize";
        ConfigHardcore.registerObject(s, ConfigHardcore.verifyGS(config.get(cat.getName(), s, new int[]{0, 1}).getIntList()));
        s = "archangelGroupSize";
        ConfigHardcore.registerObject(s, ConfigHardcore.verifyGS(config.get(cat.getName(), s, new int[]{0, 1}).getIntList()));
        s = "ireGroupSize";
        ConfigHardcore.registerObject(s, ConfigHardcore.verifyGS(config.get(cat.getName(), s, new int[]{2, 4}).getIntList()));
        s = "fuseaGroupSize";
        ConfigHardcore.registerObject(s, ConfigHardcore.verifyGS(config.get(cat.getName(), s, new int[]{0, 2}).getIntList()));
        s = "ranmasGroupSize";
        ConfigHardcore.registerObject(s, ConfigHardcore.verifyGS(config.get(cat.getName(), s, new int[]{0, 1}).getIntList()));
        s = "parasmiteGroupSize";
        ConfigHardcore.registerObject(s, ConfigHardcore.verifyGS(config.get(cat.getName(), s, new int[]{0, 1}).getIntList()));
        s = "avrisGroupSize";
        ConfigHardcore.registerObject(s, ConfigHardcore.verifyGS(config.get(cat.getName(), s, new int[]{0, 1}).getIntList()));
        s = "jarraGroupSize";
        ConfigHardcore.registerObject(s, ConfigHardcore.verifyGS(config.get(cat.getName(), s, new int[]{0, 1}).getIntList()));
        s = "kragulGroupSize";
        ConfigHardcore.registerObject(s, ConfigHardcore.verifyGS(config.get(cat.getName(), s, new int[]{0, 1}).getIntList()));
        s = "magmoxGroupSize";
        ConfigHardcore.registerObject(s, ConfigHardcore.verifyGS(config.get(cat.getName(), s, new int[]{0, 1}).getIntList()));
        s = "megaCryseGroupSize";
        ConfigHardcore.registerObject(s, ConfigHardcore.verifyGS(config.get(cat.getName(), s, new int[]{0, 1}).getIntList()));
        s = "voxStellarumGroupSize";
        ConfigHardcore.registerObject(s, ConfigHardcore.verifyGS(config.get(cat.getName(), s, new int[]{0, 1}).getIntList()));
        s = "greaterStinGroupSize";
        ConfigHardcore.registerObject(s, ConfigHardcore.verifyGS(config.get(cat.getName(), s, new int[]{0, 1}).getIntList()));
        s = "stinKingGroupSize";
        ConfigHardcore.registerObject(s, ConfigHardcore.verifyGS(config.get(cat.getName(), s, new int[]{0, 1}).getIntList()));
        s = "stinQueenGroupSize";
        ConfigHardcore.registerObject(s, ConfigHardcore.verifyGS(config.get(cat.getName(), s, new int[]{0, 1}).getIntList()));
        s = "volatileFuseaGroupSize";
        ConfigHardcore.registerObject(s, ConfigHardcore.verifyGS(config.get(cat.getName(), s, new int[]{0, 1}).getIntList()));
        s = "aegarGroupSize";
        ConfigHardcore.registerObject(s, ConfigHardcore.verifyGS(config.get(cat.getName(), s, new int[]{0, 1}).getIntList()));
        s = "jabbaSpawnOverride";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, false).getBoolean(false));
        s = "jabbaSpawnBiomes";
        ConfigHardcore.registerObject(s, ConfigHardcore.getIntsAsBiome(config.get(cat.getName(), s, new int[]{BiomeGenBase.field_76769_d.field_76756_M, BiomeGenBase.field_76786_s.field_76756_M, BiomeGenBase.field_150589_Z.field_76756_M, BiomeGenBase.field_76778_j.field_76756_M, BiomeGenBase.field_150608_ab.field_76756_M, BiomeGenBase.field_150607_aa.field_76756_M}).getIntList()));
        s = "plagueSpawnOverride";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, false).getBoolean(false));
        s = "plagueSpawnBiomes";
        ConfigHardcore.registerObject(s, ConfigHardcore.getIntsAsBiome(config.get(cat.getName(), s, new int[]{BiomeGenBase.field_76787_r.field_76756_M, BiomeGenBase.field_150583_P.field_76756_M, BiomeGenBase.field_150582_Q.field_76756_M, BiomeGenBase.field_150577_O.field_76756_M, BiomeGenBase.field_150584_S.field_76756_M, BiomeGenBase.field_150579_T.field_76756_M, BiomeGenBase.field_150575_M.field_76756_M, BiomeGenBase.field_76769_d.field_76756_M, BiomeGenBase.field_76786_s.field_76756_M, BiomeGenBase.field_76770_e.field_76756_M, BiomeGenBase.field_76783_v.field_76756_M, BiomeGenBase.field_150580_W.field_76756_M, BiomeGenBase.field_76767_f.field_76756_M, BiomeGenBase.field_76785_t.field_76756_M, BiomeGenBase.field_76776_l.field_76756_M, BiomeGenBase.field_76777_m.field_76756_M, BiomeGenBase.field_76778_j.field_76756_M, BiomeGenBase.field_76775_o.field_76756_M, BiomeGenBase.field_76774_n.field_76756_M, BiomeGenBase.field_76782_w.field_76756_M, BiomeGenBase.field_150574_L.field_76756_M, BiomeGenBase.field_76792_x.field_76756_M, BiomeGenBase.field_150578_U.field_76756_M, BiomeGenBase.field_150581_V.field_76756_M, BiomeGenBase.field_150589_Z.field_76756_M, BiomeGenBase.field_150608_ab.field_76756_M, BiomeGenBase.field_150607_aa.field_76756_M, BiomeGenBase.field_76789_p.field_76756_M, BiomeGenBase.field_76788_q.field_76756_M, BiomeGenBase.field_76771_b.field_76756_M, BiomeGenBase.field_76772_c.field_76756_M, BiomeGenBase.field_76781_i.field_76756_M, BiomeGenBase.field_150585_R.field_76756_M, BiomeGenBase.field_150588_X.field_76756_M, BiomeGenBase.field_150587_Y.field_76756_M, BiomeGenBase.field_76779_k.field_76756_M, BiomeGenBase.field_150576_N.field_76756_M, BiomeGenBase.field_76780_h.field_76756_M, BiomeGenBase.field_76768_g.field_76756_M, BiomeGenBase.field_76784_u.field_76756_M}).getIntList()));
        s = "gragulSpawnOverride";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, false).getBoolean(false));
        s = "gragulSpawnBiomes";
        ConfigHardcore.registerObject(s, ConfigHardcore.getIntsAsBiome(config.get(cat.getName(), s, new int[]{BiomeGenBase.field_76786_s.field_76756_M, BiomeGenBase.field_150608_ab.field_76756_M, BiomeGenBase.field_150607_aa.field_76756_M, BiomeGenBase.field_76770_e.field_76756_M, BiomeGenBase.field_150580_W.field_76756_M, BiomeGenBase.field_150578_U.field_76756_M, BiomeGenBase.field_150581_V.field_76756_M, BiomeGenBase.field_150585_R.field_76756_M, BiomeGenBase.field_76780_h.field_76756_M, BiomeGenBase.field_76789_p.field_76756_M, BiomeGenBase.field_76788_q.field_76756_M}).getIntList()));
        s = "minotaurSpawnOverride";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, false).getBoolean(false));
        s = "minotaurSpawnBiomes";
        ConfigHardcore.registerObject(s, ConfigHardcore.getIntsAsBiome(config.get(cat.getName(), s, new int[]{BiomeGenBase.field_76772_c.field_76756_M, BiomeGenBase.field_150588_X.field_76756_M, BiomeGenBase.field_150587_Y.field_76756_M, BiomeGenBase.field_76767_f.field_76756_M, BiomeGenBase.field_76785_t.field_76756_M, BiomeGenBase.field_150583_P.field_76756_M, BiomeGenBase.field_150582_Q.field_76756_M, BiomeGenBase.field_150589_Z.field_76756_M, BiomeGenBase.field_150608_ab.field_76756_M, BiomeGenBase.field_150607_aa.field_76756_M, BiomeGenBase.field_76770_e.field_76756_M, BiomeGenBase.field_76783_v.field_76756_M, BiomeGenBase.field_150580_W.field_76756_M}).getIntList()));
        s = "inklingSpawnOverride";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, false).getBoolean(false));
        s = "inklingSpawnBiomes";
        ConfigHardcore.registerObject(s, ConfigHardcore.getIntsAsBiome(config.get(cat.getName(), s, new int[]{BiomeGenBase.field_76787_r.field_76756_M, BiomeGenBase.field_150583_P.field_76756_M, BiomeGenBase.field_150582_Q.field_76756_M, BiomeGenBase.field_150577_O.field_76756_M, BiomeGenBase.field_150584_S.field_76756_M, BiomeGenBase.field_150579_T.field_76756_M, BiomeGenBase.field_150575_M.field_76756_M, BiomeGenBase.field_76769_d.field_76756_M, BiomeGenBase.field_76786_s.field_76756_M, BiomeGenBase.field_76770_e.field_76756_M, BiomeGenBase.field_76783_v.field_76756_M, BiomeGenBase.field_150580_W.field_76756_M, BiomeGenBase.field_76767_f.field_76756_M, BiomeGenBase.field_76785_t.field_76756_M, BiomeGenBase.field_76776_l.field_76756_M, BiomeGenBase.field_76777_m.field_76756_M, BiomeGenBase.field_76775_o.field_76756_M, BiomeGenBase.field_76774_n.field_76756_M, BiomeGenBase.field_76782_w.field_76756_M, BiomeGenBase.field_150574_L.field_76756_M, BiomeGenBase.field_76792_x.field_76756_M, BiomeGenBase.field_150578_U.field_76756_M, BiomeGenBase.field_150581_V.field_76756_M, BiomeGenBase.field_150589_Z.field_76756_M, BiomeGenBase.field_150608_ab.field_76756_M, BiomeGenBase.field_150607_aa.field_76756_M, BiomeGenBase.field_76789_p.field_76756_M, BiomeGenBase.field_76788_q.field_76756_M, BiomeGenBase.field_76771_b.field_76756_M, BiomeGenBase.field_76772_c.field_76756_M, BiomeGenBase.field_76781_i.field_76756_M, BiomeGenBase.field_150585_R.field_76756_M, BiomeGenBase.field_150588_X.field_76756_M, BiomeGenBase.field_150587_Y.field_76756_M, BiomeGenBase.field_150576_N.field_76756_M, BiomeGenBase.field_76780_h.field_76756_M, BiomeGenBase.field_76768_g.field_76756_M, BiomeGenBase.field_76784_u.field_76756_M}).getIntList()));
        s = "ragrSpawnOverride";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, false).getBoolean(false));
        s = "ragrSpawnBiomes";
        ConfigHardcore.registerObject(s, ConfigHardcore.getIntsAsBiome(config.get(cat.getName(), s, new int[]{BiomeGenBase.field_76768_g.field_76756_M, BiomeGenBase.field_76784_u.field_76756_M, BiomeGenBase.field_150584_S.field_76756_M, BiomeGenBase.field_150579_T.field_76756_M, BiomeGenBase.field_76774_n.field_76756_M, BiomeGenBase.field_76775_o.field_76756_M}).getIntList()));
        s = "pumpkinheadSpawnOverride";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, false).getBoolean(false));
        s = "pumpkinheadSpawnBiomes";
        ConfigHardcore.registerObject(s, ConfigHardcore.getIntsAsBiome(config.get(cat.getName(), s, new int[]{BiomeGenBase.field_150583_P.field_76756_M, BiomeGenBase.field_150582_Q.field_76756_M, BiomeGenBase.field_76767_f.field_76756_M, BiomeGenBase.field_76785_t.field_76756_M, BiomeGenBase.field_150578_U.field_76756_M, BiomeGenBase.field_150581_V.field_76756_M, BiomeGenBase.field_76789_p.field_76756_M, BiomeGenBase.field_76788_q.field_76756_M, BiomeGenBase.field_76772_c.field_76756_M, BiomeGenBase.field_150585_R.field_76756_M, BiomeGenBase.field_150588_X.field_76756_M, BiomeGenBase.field_150587_Y.field_76756_M, BiomeGenBase.field_76768_g.field_76756_M, BiomeGenBase.field_76784_u.field_76756_M}).getIntList()));
        s = "tragicNekoSpawnOverride";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, false).getBoolean(false));
        s = "tragicNekoSpawnBiomes";
        ConfigHardcore.registerObject(s, ConfigHardcore.getIntsAsBiome(config.get(cat.getName(), s, new int[]{0}).getIntList()));
        s = "toxSpawnOverride";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, false).getBoolean(false));
        s = "toxSpawnBiomes";
        ConfigHardcore.registerObject(s, ConfigHardcore.getIntsAsBiome(config.get(cat.getName(), s, new int[]{BiomeGenBase.field_150585_R.field_76756_M, BiomeGenBase.field_76767_f.field_76756_M, BiomeGenBase.field_76785_t.field_76756_M, BiomeGenBase.field_150583_P.field_76756_M, BiomeGenBase.field_150582_Q.field_76756_M, BiomeGenBase.field_76782_w.field_76756_M, BiomeGenBase.field_76792_x.field_76756_M}).getIntList()));
        s = "cryseSpawnOverride";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, false).getBoolean(false));
        s = "cryseSpawnBiomes";
        ConfigHardcore.registerObject(s, ConfigHardcore.getIntsAsBiome(config.get(cat.getName(), s, new int[]{BiomeGenBase.field_76774_n.field_76756_M, BiomeGenBase.field_76775_o.field_76756_M, BiomeGenBase.field_150584_S.field_76756_M, BiomeGenBase.field_150579_T.field_76756_M}).getIntList()));
        s = "norVoxSpawnOverride";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, false).getBoolean(false));
        s = "norVoxSpawnBiomes";
        ConfigHardcore.registerObject(s, ConfigHardcore.getIntsAsBiome(config.get(cat.getName(), s, new int[]{BiomeGenBase.field_150583_P.field_76756_M, BiomeGenBase.field_150582_Q.field_76756_M, BiomeGenBase.field_150575_M.field_76756_M, BiomeGenBase.field_76770_e.field_76756_M, BiomeGenBase.field_76783_v.field_76756_M, BiomeGenBase.field_150580_W.field_76756_M, BiomeGenBase.field_76767_f.field_76756_M, BiomeGenBase.field_76785_t.field_76756_M, BiomeGenBase.field_76782_w.field_76756_M, BiomeGenBase.field_150574_L.field_76756_M, BiomeGenBase.field_76792_x.field_76756_M, BiomeGenBase.field_150578_U.field_76756_M, BiomeGenBase.field_150581_V.field_76756_M, BiomeGenBase.field_150589_Z.field_76756_M, BiomeGenBase.field_150608_ab.field_76756_M, BiomeGenBase.field_150607_aa.field_76756_M, BiomeGenBase.field_76789_p.field_76756_M, BiomeGenBase.field_76788_q.field_76756_M, BiomeGenBase.field_76771_b.field_76756_M, BiomeGenBase.field_76772_c.field_76756_M, BiomeGenBase.field_76781_i.field_76756_M, BiomeGenBase.field_150585_R.field_76756_M, BiomeGenBase.field_150588_X.field_76756_M, BiomeGenBase.field_150587_Y.field_76756_M, BiomeGenBase.field_150576_N.field_76756_M, BiomeGenBase.field_76780_h.field_76756_M, BiomeGenBase.field_76768_g.field_76756_M, BiomeGenBase.field_76784_u.field_76756_M}).getIntList()));
        s = "pirahSpawnOverride";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, false).getBoolean(false));
        s = "pirahSpawnBiomes";
        ConfigHardcore.registerObject(s, ConfigHardcore.getIntsAsBiome(config.get(cat.getName(), s, new int[]{BiomeGenBase.field_150575_M.field_76756_M, BiomeGenBase.field_76771_b.field_76756_M, BiomeGenBase.field_76781_i.field_76756_M}).getIntList()));
        s = "stinSpawnOverride";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, false).getBoolean(false));
        s = "stinSpawnBiomes";
        ConfigHardcore.registerObject(s, ConfigHardcore.getIntsAsBiome(config.get(cat.getName(), s, new int[]{0}).getIntList()));
        s = "kindlingSpiritSpawnOverride";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, false).getBoolean(false));
        s = "kindlingSpiritSpawnBiomes";
        ConfigHardcore.registerObject(s, ConfigHardcore.getIntsAsBiome(config.get(cat.getName(), s, new int[]{BiomeGenBase.field_150585_R.field_76756_M, BiomeGenBase.field_76767_f.field_76756_M, BiomeGenBase.field_76785_t.field_76756_M, BiomeGenBase.field_150583_P.field_76756_M, BiomeGenBase.field_150582_Q.field_76756_M, BiomeGenBase.field_76782_w.field_76756_M, BiomeGenBase.field_76792_x.field_76756_M, BiomeGenBase.field_76769_d.field_76756_M, BiomeGenBase.field_76786_s.field_76756_M, BiomeGenBase.field_150589_Z.field_76756_M}).getIntList()));
        s = "abominationSpawnOverride";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, false).getBoolean(false));
        s = "abominationSpawnBiomes";
        ConfigHardcore.registerObject(s, ConfigHardcore.getIntsAsBiome(config.get(cat.getName(), s, new int[]{BiomeGenBase.field_76774_n.field_76756_M, BiomeGenBase.field_76775_o.field_76756_M, BiomeGenBase.field_76776_l.field_76756_M, BiomeGenBase.field_76777_m.field_76756_M, BiomeGenBase.field_150577_O.field_76756_M, BiomeGenBase.field_150584_S.field_76756_M, BiomeGenBase.field_150579_T.field_76756_M}).getIntList()));
        s = "erkelSpawnOverride";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, false).getBoolean(false));
        s = "erkelSpawnBiomes";
        ConfigHardcore.registerObject(s, ConfigHardcore.getIntsAsBiome(config.get(cat.getName(), s, new int[]{0}).getIntList()));
        s = "sirvSpawnOverride";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, false).getBoolean(false));
        s = "sirvSpawnBiomes";
        ConfigHardcore.registerObject(s, ConfigHardcore.getIntsAsBiome(config.get(cat.getName(), s, new int[]{0}).getIntList()));
        s = "psygoteSpawnOverride";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, false).getBoolean(false));
        s = "psygoteSpawnBiomes";
        ConfigHardcore.registerObject(s, ConfigHardcore.getIntsAsBiome(config.get(cat.getName(), s, new int[]{0}).getIntList()));
        s = "lockbotSpawnOverride";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, false).getBoolean(false));
        s = "lockbotSpawnBiomes";
        ConfigHardcore.registerObject(s, ConfigHardcore.getIntsAsBiome(config.get(cat.getName(), s, new int[]{0}).getIntList()));
        s = "nanoSwarmSpawnOverride";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, false).getBoolean(false));
        s = "nanoSwarmSpawnBiomes";
        ConfigHardcore.registerObject(s, ConfigHardcore.getIntsAsBiome(config.get(cat.getName(), s, new int[]{0}).getIntList()));
        s = "hunterSpawnOverride";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, false).getBoolean(false));
        s = "hunterSpawnBiomes";
        ConfigHardcore.registerObject(s, ConfigHardcore.getIntsAsBiome(config.get(cat.getName(), s, new int[]{0}).getIntList()));
        s = "harvesterSpawnOverride";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, false).getBoolean(false));
        s = "harvesterSpawnBiomes";
        ConfigHardcore.registerObject(s, ConfigHardcore.getIntsAsBiome(config.get(cat.getName(), s, new int[]{0}).getIntList()));
        s = "seekerSpawnOverride";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, false).getBoolean(false));
        s = "seekerSpawnBiomes";
        ConfigHardcore.registerObject(s, ConfigHardcore.getIntsAsBiome(config.get(cat.getName(), s, new int[]{0}).getIntList()));
        s = "archangelSpawnOverride";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, false).getBoolean(false));
        s = "archangelSpawnBiomes";
        ConfigHardcore.registerObject(s, ConfigHardcore.getIntsAsBiome(config.get(cat.getName(), s, new int[]{0}).getIntList()));
        s = "ireSpawnOverride";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, false).getBoolean(false));
        s = "ireSpawnBiomes";
        ConfigHardcore.registerObject(s, ConfigHardcore.getIntsAsBiome(config.get(cat.getName(), s, new int[]{0}).getIntList()));
        s = "fuseaSpawnOverride";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, false).getBoolean(false));
        s = "fuseaSpawnBiomes";
        ConfigHardcore.registerObject(s, ConfigHardcore.getIntsAsBiome(config.get(cat.getName(), s, new int[]{0}).getIntList()));
        s = "ranmasSpawnOverride";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, false).getBoolean(false));
        s = "ranmasSpawnBiomes";
        ConfigHardcore.registerObject(s, ConfigHardcore.getIntsAsBiome(config.get(cat.getName(), s, new int[]{0}).getIntList()));
        s = "parasmiteSpawnOverride";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, false).getBoolean(false));
        s = "parasmiteSpawnBiomes";
        ConfigHardcore.registerObject(s, ConfigHardcore.getIntsAsBiome(config.get(cat.getName(), s, new int[]{0}).getIntList()));
        s = "avrisSpawnOverride";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, false).getBoolean(false));
        s = "avrisSpawnBiomes";
        ConfigHardcore.registerObject(s, ConfigHardcore.getIntsAsBiome(config.get(cat.getName(), s, new int[]{0}).getIntList()));
        s = "jetNekoSpawnOverride";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, false).getBoolean(false));
        s = "jetNekoSpawnBiomes";
        ConfigHardcore.registerObject(s, ConfigHardcore.getIntsAsBiome(config.get(cat.getName(), s, new int[]{0}).getIntList()));
        s = "scienceNekoSpawnOverride";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, false).getBoolean(false));
        s = "scienceNekoSpawnBiomes";
        ConfigHardcore.registerObject(s, ConfigHardcore.getIntsAsBiome(config.get(cat.getName(), s, new int[]{0}).getIntList()));
        s = "mechaNekoSpawnOverride";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, false).getBoolean(false));
        s = "mechaNekoSpawnBiomes";
        ConfigHardcore.registerObject(s, ConfigHardcore.getIntsAsBiome(config.get(cat.getName(), s, new int[]{0}).getIntList()));
        s = "assaultNekoSpawnOverride";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, false).getBoolean(false));
        s = "assaultNekoSpawnBiomes";
        ConfigHardcore.registerObject(s, ConfigHardcore.getIntsAsBiome(config.get(cat.getName(), s, new int[]{0}).getIntList()));
        s = "commonNekoSpawnOverride";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, false).getBoolean(false));
        s = "commonNekoSpawnBiomes";
        ConfigHardcore.registerObject(s, ConfigHardcore.getIntsAsBiome(config.get(cat.getName(), s, new int[]{0}).getIntList()));
        s = "traderNekoSpawnOverride";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, false).getBoolean(false));
        s = "traderNekoSpawnBiomes";
        ConfigHardcore.registerObject(s, ConfigHardcore.getIntsAsBiome(config.get(cat.getName(), s, new int[]{0}).getIntList()));
        s = "snowGolemSpawnOverride";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, false).getBoolean(false));
        s = "snowGolemSpawnBiomes";
        ConfigHardcore.registerObject(s, ConfigHardcore.getIntsAsBiome(config.get(cat.getName(), s, new int[]{BiomeGenBase.field_76774_n.field_76756_M, BiomeGenBase.field_76775_o.field_76756_M, BiomeGenBase.field_76776_l.field_76756_M, BiomeGenBase.field_76777_m.field_76756_M, BiomeGenBase.field_150577_O.field_76756_M, BiomeGenBase.field_150584_S.field_76756_M, BiomeGenBase.field_150579_T.field_76756_M}).getIntList()));
        s = "jarraSpawnOverride";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, false).getBoolean(false));
        s = "jarraSpawnBiomes";
        ConfigHardcore.registerObject(s, ConfigHardcore.getIntsAsBiome(config.get(cat.getName(), s, new int[]{BiomeGenBase.field_76778_j.field_76756_M, BiomeGenBase.field_76769_d.field_76756_M, BiomeGenBase.field_76786_s.field_76756_M, BiomeGenBase.field_150589_Z.field_76756_M, BiomeGenBase.field_150608_ab.field_76756_M, BiomeGenBase.field_150607_aa.field_76756_M}).getIntList()));
        s = "kragulSpawnOverride";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, false).getBoolean(false));
        s = "kragulSpawnBiomes";
        ConfigHardcore.registerObject(s, ConfigHardcore.getIntsAsBiome(config.get(cat.getName(), s, new int[]{BiomeGenBase.field_76786_s.field_76756_M, BiomeGenBase.field_150608_ab.field_76756_M, BiomeGenBase.field_150607_aa.field_76756_M, BiomeGenBase.field_76770_e.field_76756_M, BiomeGenBase.field_150580_W.field_76756_M, BiomeGenBase.field_150578_U.field_76756_M, BiomeGenBase.field_150581_V.field_76756_M, BiomeGenBase.field_150585_R.field_76756_M, BiomeGenBase.field_76780_h.field_76756_M, BiomeGenBase.field_76789_p.field_76756_M, BiomeGenBase.field_76788_q.field_76756_M}).getIntList()));
        s = "magmoxSpawnOverride";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, false).getBoolean(false));
        s = "magmoxSpawnBiomes";
        ConfigHardcore.registerObject(s, ConfigHardcore.getIntsAsBiome(config.get(cat.getName(), s, new int[]{BiomeGenBase.field_76778_j.field_76756_M}).getIntList()));
        s = "megaCryseSpawnOverride";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, false).getBoolean(false));
        s = "megaCryseSpawnBiomes";
        ConfigHardcore.registerObject(s, ConfigHardcore.getIntsAsBiome(config.get(cat.getName(), s, new int[]{BiomeGenBase.field_76774_n.field_76756_M, BiomeGenBase.field_76775_o.field_76756_M, BiomeGenBase.field_150584_S.field_76756_M, BiomeGenBase.field_150579_T.field_76756_M}).getIntList()));
        s = "greaterStinSpawnOverride";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, false).getBoolean(false));
        s = "greaterStinSpawnBiomes";
        ConfigHardcore.registerObject(s, ConfigHardcore.getIntsAsBiome(config.get(cat.getName(), s, new int[]{0}).getIntList()));
        s = "stinKingSpawnOverride";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, false).getBoolean(false));
        s = "stinKingSpawnBiomes";
        ConfigHardcore.registerObject(s, ConfigHardcore.getIntsAsBiome(config.get(cat.getName(), s, new int[]{0}).getIntList()));
        s = "stinQueenSpawnOverride";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, false).getBoolean(false));
        s = "stinQueenSpawnBiomes";
        ConfigHardcore.registerObject(s, ConfigHardcore.getIntsAsBiome(config.get(cat.getName(), s, new int[]{0}).getIntList()));
        s = "voxStellarumSpawnOverride";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, false).getBoolean(false));
        s = "voxStellarumSpawnBiomes";
        ConfigHardcore.registerObject(s, ConfigHardcore.getIntsAsBiome(config.get(cat.getName(), s, new int[]{0}).getIntList()));
        s = "volatileFuseaSpawnOverride";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, false).getBoolean(false));
        s = "volatileFuseaSpawnBiomes";
        ConfigHardcore.registerObject(s, ConfigHardcore.getIntsAsBiome(config.get(cat.getName(), s, new int[]{0}).getIntList()));
        s = "aegarSpawnOverride";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, false).getBoolean(false));
        s = "aegarSpawnBiomes";
        ConfigHardcore.registerObject(s, ConfigHardcore.getIntsAsBiome(config.get(cat.getName(), s, new int[]{0}).getIntList()));
        s = "apisSpawnOverride";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, false).getBoolean(false));
        s = "apisSpawnBiomes";
        ConfigHardcore.registerObject(s, ConfigHardcore.getIntsAsBiome(config.get(cat.getName(), s, new int[]{BiomeGenBase.field_76772_c.field_76756_M, BiomeGenBase.field_150588_X.field_76756_M, BiomeGenBase.field_150587_Y.field_76756_M, BiomeGenBase.field_76767_f.field_76756_M, BiomeGenBase.field_76785_t.field_76756_M, BiomeGenBase.field_150583_P.field_76756_M, BiomeGenBase.field_150582_Q.field_76756_M, BiomeGenBase.field_150589_Z.field_76756_M, BiomeGenBase.field_150608_ab.field_76756_M, BiomeGenBase.field_150607_aa.field_76756_M, BiomeGenBase.field_76770_e.field_76756_M, BiomeGenBase.field_76783_v.field_76756_M, BiomeGenBase.field_150580_W.field_76756_M}).getIntList()));
        s = "skultarSpawnOverride";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, false).getBoolean(false));
        s = "skultarSpawnBiomes";
        ConfigHardcore.registerObject(s, ConfigHardcore.getIntsAsBiome(config.get(cat.getName(), s, new int[]{BiomeGenBase.field_76767_f.field_76756_M, BiomeGenBase.field_76785_t.field_76756_M, BiomeGenBase.field_150583_P.field_76756_M, BiomeGenBase.field_150582_Q.field_76756_M}).getIntList()));
        s = "kitsunakumaSpawnOverride";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, false).getBoolean(false));
        s = "kitsunakumaSpawnBiomes";
        ConfigHardcore.registerObject(s, ConfigHardcore.getIntsAsBiome(config.get(cat.getName(), s, new int[]{BiomeGenBase.field_76778_j.field_76756_M}).getIntList()));
        s = "empariahSpawnOverride";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, false).getBoolean(false));
        s = "empariahSpawnBiomes";
        ConfigHardcore.registerObject(s, ConfigHardcore.getIntsAsBiome(config.get(cat.getName(), s, new int[]{BiomeGenBase.field_76774_n.field_76756_M, BiomeGenBase.field_76775_o.field_76756_M, BiomeGenBase.field_76776_l.field_76756_M, BiomeGenBase.field_76777_m.field_76756_M, BiomeGenBase.field_150577_O.field_76756_M, BiomeGenBase.field_150584_S.field_76756_M, BiomeGenBase.field_150579_T.field_76756_M}).getIntList()));
        s = "timeControllerSpawnOverride";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, false).getBoolean(false));
        s = "timeControllerSpawnBiomes";
        ConfigHardcore.registerObject(s, ConfigHardcore.getIntsAsBiome(config.get(cat.getName(), s, new int[]{BiomeGenBase.field_150583_P.field_76756_M, BiomeGenBase.field_150582_Q.field_76756_M, BiomeGenBase.field_150575_M.field_76756_M, BiomeGenBase.field_76770_e.field_76756_M, BiomeGenBase.field_76783_v.field_76756_M, BiomeGenBase.field_150580_W.field_76756_M, BiomeGenBase.field_76767_f.field_76756_M, BiomeGenBase.field_76785_t.field_76756_M, BiomeGenBase.field_76782_w.field_76756_M, BiomeGenBase.field_150574_L.field_76756_M, BiomeGenBase.field_76792_x.field_76756_M, BiomeGenBase.field_150578_U.field_76756_M, BiomeGenBase.field_150581_V.field_76756_M, BiomeGenBase.field_150589_Z.field_76756_M, BiomeGenBase.field_150608_ab.field_76756_M, BiomeGenBase.field_150607_aa.field_76756_M, BiomeGenBase.field_76789_p.field_76756_M, BiomeGenBase.field_76788_q.field_76756_M, BiomeGenBase.field_76771_b.field_76756_M, BiomeGenBase.field_76772_c.field_76756_M, BiomeGenBase.field_76781_i.field_76756_M, BiomeGenBase.field_150585_R.field_76756_M, BiomeGenBase.field_150588_X.field_76756_M, BiomeGenBase.field_150587_Y.field_76756_M, BiomeGenBase.field_150576_N.field_76756_M, BiomeGenBase.field_76780_h.field_76756_M, BiomeGenBase.field_76768_g.field_76756_M, BiomeGenBase.field_76784_u.field_76756_M}).getIntList()));
        s = "polarisSpawnOverride";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, false).getBoolean(false));
        s = "polarisSpawnBiomes";
        ConfigHardcore.registerObject(s, ConfigHardcore.getIntsAsBiome(config.get(cat.getName(), s, new int[]{BiomeGenBase.field_150583_P.field_76756_M, BiomeGenBase.field_150582_Q.field_76756_M, BiomeGenBase.field_150575_M.field_76756_M, BiomeGenBase.field_76770_e.field_76756_M, BiomeGenBase.field_76783_v.field_76756_M, BiomeGenBase.field_150580_W.field_76756_M, BiomeGenBase.field_76767_f.field_76756_M, BiomeGenBase.field_76785_t.field_76756_M, BiomeGenBase.field_76782_w.field_76756_M, BiomeGenBase.field_150574_L.field_76756_M, BiomeGenBase.field_76792_x.field_76756_M, BiomeGenBase.field_150578_U.field_76756_M, BiomeGenBase.field_150581_V.field_76756_M, BiomeGenBase.field_150589_Z.field_76756_M, BiomeGenBase.field_150608_ab.field_76756_M, BiomeGenBase.field_150607_aa.field_76756_M, BiomeGenBase.field_76789_p.field_76756_M, BiomeGenBase.field_76788_q.field_76756_M, BiomeGenBase.field_76771_b.field_76756_M, BiomeGenBase.field_76772_c.field_76756_M, BiomeGenBase.field_76781_i.field_76756_M, BiomeGenBase.field_150585_R.field_76756_M, BiomeGenBase.field_150588_X.field_76756_M, BiomeGenBase.field_150587_Y.field_76756_M, BiomeGenBase.field_150576_N.field_76756_M, BiomeGenBase.field_76780_h.field_76756_M, BiomeGenBase.field_76768_g.field_76756_M, BiomeGenBase.field_76784_u.field_76756_M}).getIntList()));
        s = "enyvilSpawnOverride";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, false).getBoolean(false));
        s = "enyvilSpawnBiomes";
        ConfigHardcore.registerObject(s, ConfigHardcore.getIntsAsBiome(config.get(cat.getName(), s, new int[]{BiomeGenBase.field_150583_P.field_76756_M, BiomeGenBase.field_150582_Q.field_76756_M, BiomeGenBase.field_150575_M.field_76756_M, BiomeGenBase.field_76770_e.field_76756_M, BiomeGenBase.field_76783_v.field_76756_M, BiomeGenBase.field_150580_W.field_76756_M, BiomeGenBase.field_76767_f.field_76756_M, BiomeGenBase.field_76785_t.field_76756_M, BiomeGenBase.field_76782_w.field_76756_M, BiomeGenBase.field_150574_L.field_76756_M, BiomeGenBase.field_76792_x.field_76756_M, BiomeGenBase.field_150578_U.field_76756_M, BiomeGenBase.field_150581_V.field_76756_M, BiomeGenBase.field_150589_Z.field_76756_M, BiomeGenBase.field_150608_ab.field_76756_M, BiomeGenBase.field_150607_aa.field_76756_M, BiomeGenBase.field_76789_p.field_76756_M, BiomeGenBase.field_76788_q.field_76756_M, BiomeGenBase.field_76771_b.field_76756_M, BiomeGenBase.field_76772_c.field_76756_M, BiomeGenBase.field_76781_i.field_76756_M, BiomeGenBase.field_150585_R.field_76756_M, BiomeGenBase.field_150588_X.field_76756_M, BiomeGenBase.field_150587_Y.field_76756_M, BiomeGenBase.field_150576_N.field_76756_M, BiomeGenBase.field_76780_h.field_76756_M, BiomeGenBase.field_76768_g.field_76756_M, BiomeGenBase.field_76784_u.field_76756_M}).getIntList()));
        s = "claymationSpawnOverride";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, false).getBoolean(false));
        s = "claymationSpawnBiomes";
        ConfigHardcore.registerObject(s, ConfigHardcore.getIntsAsBiome(config.get(cat.getName(), s, new int[]{BiomeGenBase.field_76769_d.field_76756_M, BiomeGenBase.field_76786_s.field_76756_M, BiomeGenBase.field_150589_Z.field_76756_M, BiomeGenBase.field_150608_ab.field_76756_M, BiomeGenBase.field_150607_aa.field_76756_M}).getIntList()));
        s = "professorNekoidSpawnOverride";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, false).getBoolean(false));
        s = "professorNekoidSpawnBiomes";
        ConfigHardcore.registerObject(s, ConfigHardcore.getIntsAsBiome(config.get(cat.getName(), s, new int[]{0}).getIntList()));
        cat = config.getCategory("Potions");
        cat.setComment("Modify various aspects of Potions.");
        prop = config.get(cat.getName(), "flightAllow", true);
        m = 0;
        ConfigHardcore.potionAllow[0] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "aquaSuperiorityAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.potionAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "immunityAllow", false);
        m = (byte)(m + 1);
        ConfigHardcore.potionAllow[m] = prop.getBoolean(false);
        prop = config.get(cat.getName(), "resurrectionAllow", false);
        m = (byte)(m + 1);
        ConfigHardcore.potionAllow[m] = prop.getBoolean(false);
        prop = config.get(cat.getName(), "harmonyAllow", false);
        m = (byte)(m + 1);
        ConfigHardcore.potionAllow[m] = prop.getBoolean(false);
        prop = config.get(cat.getName(), "invulnerabilityAllow", false);
        m = (byte)(m + 1);
        ConfigHardcore.potionAllow[m] = prop.getBoolean(false);
        prop = config.get(cat.getName(), "clarityAllow", false);
        m = (byte)(m + 1);
        ConfigHardcore.potionAllow[m] = prop.getBoolean(false);
        prop = config.get(cat.getName(), "convergenceAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.potionAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "divinityAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.potionAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "corruptionAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.potionAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "disorientationAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.potionAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "stunAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.potionAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "fearAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.potionAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "malnourishAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.potionAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "crippleAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.potionAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "submissionAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.potionAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "inhibitAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.potionAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "leadFootAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.potionAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "hackedAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.potionAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "burnedAllow", true);
        ConfigHardcore.potionAllow[(byte)(m + 1)] = prop.getBoolean(true);
        s = "flightID";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, ConfigHardcore.findPotionID(32)).getInt(ConfigHardcore.findPotionID(32)));
        s2 = s;
        s = "aquaSuperiorityID";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, ConfigHardcore.findPotionID(ConfigHardcore.getInt(s2) + 1)).getInt(ConfigHardcore.findPotionID(ConfigHardcore.getInt(s2) + 1)));
        s2 = s;
        s = "immunityID";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, ConfigHardcore.findPotionID(ConfigHardcore.getInt(s2) + 1)).getInt(ConfigHardcore.findPotionID(ConfigHardcore.getInt(s2) + 1)));
        s2 = s;
        s = "resurrectionID";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, ConfigHardcore.findPotionID(ConfigHardcore.getInt(s2) + 1)).getInt(ConfigHardcore.findPotionID(ConfigHardcore.getInt(s2) + 1)));
        s2 = s;
        s = "harmonyID";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, ConfigHardcore.findPotionID(ConfigHardcore.getInt(s2) + 1)).getInt(ConfigHardcore.findPotionID(ConfigHardcore.getInt(s2) + 1)));
        s2 = s;
        s = "invulnerabilityID";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, ConfigHardcore.findPotionID(ConfigHardcore.getInt(s2) + 1)).getInt(ConfigHardcore.findPotionID(ConfigHardcore.getInt(s2) + 1)));
        s2 = s;
        s = "clarityID";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, ConfigHardcore.findPotionID(ConfigHardcore.getInt(s2) + 1)).getInt(ConfigHardcore.findPotionID(ConfigHardcore.getInt(s2) + 1)));
        s2 = s;
        s = "convergenceID";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, ConfigHardcore.findPotionID(ConfigHardcore.getInt(s2) + 1)).getInt(ConfigHardcore.findPotionID(ConfigHardcore.getInt(s2) + 1)));
        s2 = s;
        s = "divinityID";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, ConfigHardcore.findPotionID(ConfigHardcore.getInt(s2) + 1)).getInt(ConfigHardcore.findPotionID(ConfigHardcore.getInt(s2) + 1)));
        s2 = s;
        s = "corruptionID";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, ConfigHardcore.findPotionID(ConfigHardcore.getInt(s2) + 1)).getInt(ConfigHardcore.findPotionID(ConfigHardcore.getInt(s2) + 1)));
        s2 = s;
        s = "disorientationID";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, ConfigHardcore.findPotionID(ConfigHardcore.getInt(s2) + 1)).getInt(ConfigHardcore.findPotionID(ConfigHardcore.getInt(s2) + 1)));
        s2 = s;
        s = "stunID";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, ConfigHardcore.findPotionID(ConfigHardcore.getInt(s2) + 1)).getInt(ConfigHardcore.findPotionID(ConfigHardcore.getInt(s2) + 1)));
        s2 = s;
        s = "fearID";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, ConfigHardcore.findPotionID(ConfigHardcore.getInt(s2) + 1)).getInt(ConfigHardcore.findPotionID(ConfigHardcore.getInt(s2) + 1)));
        s2 = s;
        s = "malnourishID";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, ConfigHardcore.findPotionID(ConfigHardcore.getInt(s2) + 1)).getInt(ConfigHardcore.findPotionID(ConfigHardcore.getInt(s2) + 1)));
        s2 = s;
        s = "crippleID";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, ConfigHardcore.findPotionID(ConfigHardcore.getInt(s2) + 1)).getInt(ConfigHardcore.findPotionID(ConfigHardcore.getInt(s2) + 1)));
        s2 = s;
        s = "submissionID";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, ConfigHardcore.findPotionID(ConfigHardcore.getInt(s2) + 1)).getInt(ConfigHardcore.findPotionID(ConfigHardcore.getInt(s2) + 1)));
        s2 = s;
        s = "inhibitID";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, ConfigHardcore.findPotionID(ConfigHardcore.getInt(s2) + 1)).getInt(ConfigHardcore.findPotionID(ConfigHardcore.getInt(s2) + 1)));
        s2 = s;
        s = "leadFootID";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, ConfigHardcore.findPotionID(ConfigHardcore.getInt(s2) + 1)).getInt(ConfigHardcore.findPotionID(ConfigHardcore.getInt(s2) + 1)));
        s2 = s;
        s = "hackedID";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, ConfigHardcore.findPotionID(ConfigHardcore.getInt(s2) + 1)).getInt(ConfigHardcore.findPotionID(ConfigHardcore.getInt(s2) + 1)));
        s2 = s;
        s = "burnedID";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, ConfigHardcore.findPotionID(ConfigHardcore.getInt(s2) + 1)).getInt(ConfigHardcore.findPotionID(ConfigHardcore.getInt(s2) + 1)));
        cat = config.getCategory("Vanilla Changes");
        cat.setComment("These toggle the various changes the mod does that explicitly affects Vanilla Minecraft. Ore rate and vein size only affects those ores generated in Vanilla Dimensions.");
        prop = config.get(cat.getName(), "allowMobBuffs", true);
        prop.comment = "Will various Vanilla Mobs gain a Health, Attack Damage, Knockback Resistance or Speed buff?";
        m = 0;
        ConfigHardcore.vanillaConfig[0] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "allowExtraMobEffects", true);
        prop.comment = "Will some mobs gain Potion Effect debuffs and other abilities along with their normal attacks?";
        m = (byte)(m + 1);
        ConfigHardcore.vanillaConfig[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "allowAnimalRetribution", true);
        prop.comment = "Can slaying animals sometimes trigger a Lightning strike?";
        m = (byte)(m + 1);
        ConfigHardcore.vanillaConfig[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "allowMobModdedArmor", true);
        prop.comment = "Can Vanilla mobs sometimes spawn in with Armor from the mod?";
        m = (byte)(m + 1);
        ConfigHardcore.vanillaConfig[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "allowRespawnPunishment", true);
        prop.comment = "Will you get inflicted with negative effects upon respawning after a death?";
        m = (byte)(m + 1);
        ConfigHardcore.vanillaConfig[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "allowExtraExplosiveEffects", true);
        prop.comment = "Do explosions inflict extra negative effects on you when hit?";
        m = (byte)(m + 1);
        ConfigHardcore.vanillaConfig[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "allowMobBlindnessDebuff", true);
        prop.comment = "Does Blindness reduce the follow range of mobs?";
        m = (byte)(m + 1);
        ConfigHardcore.vanillaConfig[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "allowExtraOverworldFlowers", true);
        prop.comment = "Can some of the mod-exclusive flowers generate in Vanilla biomes?";
        m = (byte)(m + 1);
        ConfigHardcore.vanillaConfig[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "allowOverworldSilverfishGen", true);
        prop.comment = "Will Silverfish stone generate in lower y-levels in the Overworld?";
        m = (byte)(m + 1);
        ConfigHardcore.vanillaConfig[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "allowNetherOreGen", true);
        prop.comment = "Can mod-exclusive ores generate in the Nether?";
        m = (byte)(m + 1);
        ConfigHardcore.vanillaConfig[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "allowOverworldOreGen", true);
        prop.comment = "Can mod-exclusive ores generate in the Overworld?";
        m = (byte)(m + 1);
        ConfigHardcore.vanillaConfig[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "allowDrudgeGen", true);
        prop.comment = "Can Drudge generate in the Nether?";
        m = (byte)(m + 1);
        ConfigHardcore.vanillaConfig[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "allowAnimalAndGolemCorruption", true);
        prop.comment = "Can Animals and Golems become Corrupted?";
        m = (byte)(m + 1);
        ConfigHardcore.vanillaConfig[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "allowCowMinotaurCreation", true);
        prop.comment = "Will striking a Cow with Lightning turn it into a Minotaur?";
        m = (byte)(m + 1);
        ConfigHardcore.vanillaConfig[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "allowIronGolemCooldown", true);
        prop.comment = "Should Iron Golems have an enforced hit cooldown?";
        m = (byte)(m + 1);
        ConfigHardcore.vanillaConfig[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "allowNauseaRandomMiss", false);
        prop.comment = "Should Nausea (Confusion) have a random chance to make you miss a non-projectile, non-magic hit?";
        m = (byte)(m + 1);
        ConfigHardcore.vanillaConfig[m] = prop.getBoolean(false);
        prop = config.get(cat.getName(), "allowBlindnessReachDebuff", false);
        prop.comment = "Should Blindness debuff your Reach?";
        m = (byte)(m + 1);
        ConfigHardcore.vanillaConfig[m] = prop.getBoolean(false);
        prop = config.get(cat.getName(), "allowCripplingFall", false);
        prop.comment = "Should a fall that damages you inflict Cripple?";
        ConfigHardcore.vanillaConfig[(byte)(m + 1)] = prop.getBoolean(false);
        s = "rubyOreGenRate";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, 10).getInt(10));
        s = "rubyOreVeinSize";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, 3).getInt(3));
        s = "sapphireOreGenRate";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, 10).getInt(10));
        s = "sapphireOreVeinSize";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, 3).getInt(3));
        s = "mercuryOreGenRate";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, 20).getInt(20));
        s = "mercuryOreVeinSize";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, 4).getInt(4));
        s = "tungstenOreGenRate";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, 10).getInt(10));
        s = "tungstenOreVeinSize";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, 3).getInt(3));
        s = "drudgeGenRate";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, 10).getInt(10));
        s = "drudgeVeinSize";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, 10).getInt(10));
        s = "silverfishStoneGenRate";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, 12).getInt(12));
        s = "silverfishStoneVeinSize";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, 3).getInt(3));
        s = "aerisRarity";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, 5).getInt(5));
        s = "nauseaMissChance";
        ConfigHardcore.registerObject(s, ConfigHardcore.clamp(config.get(cat.getName(), s, 8).getInt(8), 1, 100));
        s = "blindnessReachDebuffAmount";
        ConfigHardcore.registerObject(s, config.get(cat.getName(), s, 0.25).getDouble(0.25));
        cat = config.getCategory("WorldGen");
        cat.setComment("Change things related to the mod-exclusive Dimensional World Generation.");
        prop = config.get(cat.getName(), "allowVoidPits", true);
        prop.comment = "Should void pits be allowed to generate?";
        m = 0;
        ConfigHardcore.worldGenConfig[0] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "allowSpikes", true);
        prop.comment = "Should large spikes, ice spikes, star crystals and crystal spikes be allowed to generate?";
        m = (byte)(m + 1);
        ConfigHardcore.worldGenConfig[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "allowScatteredSurfaceWorldGen", true);
        prop.comment = "Should scattered surface features like mixed dirt, light orbs and cracked permafrost be allowed to generate?";
        m = (byte)(m + 1);
        ConfigHardcore.worldGenConfig[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "allowStringLights", true);
        prop.comment = "Should String Lights be allowed to generate?";
        m = (byte)(m + 1);
        ConfigHardcore.worldGenConfig[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "allowDarkStoneVariantGen", true);
        prop.comment = "Should Dark Stone have layers generate as a colored variant?";
        m = (byte)(m + 1);
        ConfigHardcore.worldGenConfig[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "allowStructureGen", true);
        prop.comment = "Should mod-exclusive Structures be allowed to generate?";
        m = (byte)(m + 1);
        ConfigHardcore.worldGenConfig[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "allowRoughTerrainGen", true);
        prop.comment = "Should rough terrain like in the Tainted or Scorched Scarlands be generated?";
        m = (byte)(m + 1);
        ConfigHardcore.worldGenConfig[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "allowDigitalSeaGen", true);
        prop.comment = "Should Digital Sea generate in the Synapse?";
        m = (byte)(m + 1);
        ConfigHardcore.worldGenConfig[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "allowFruitGen", true);
        prop.comment = "Should Honeydrop, Deathglow and Sky Fruit generate naturally?";
        m = (byte)(m + 1);
        ConfigHardcore.worldGenConfig[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "allowIsleGen", true);
        prop.comment = "Should Isles be generated in the Tainted Isles biome?";
        m = (byte)(m + 1);
        ConfigHardcore.worldGenConfig[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "allowFlowerGen", true);
        prop.comment = "Should flowers generate in the mod's Dimensions?";
        ConfigHardcore.worldGenConfig[(byte)(m + 1)] = prop.getBoolean(true);
        cat = config.getCategory("Structures");
        cat.setComment("Toggle specific structures and change their rarities. Higher number is higher chance to generate.");
        s = "structureOverallRarity";
        ConfigHardcore.registerObject(s, ConfigHardcore.clamp(config.get(cat.getName(), s, 15).getInt(15), 1, 500));
        s = "tickBuilderSchematicLimit";
        prop = config.get(cat.getName(), s, 250);
        prop.comment = "The maximum blocks the tick builder will set per structure schematic per tick";
        ConfigHardcore.registerObject(s, ConfigHardcore.clampPositive(prop.getInt(100)));
        s = "tickBuilderOverallLimit";
        prop = config.get(cat.getName(), s, 500);
        prop.comment = "The maximum total blocks the tick builder will place per tick.";
        ConfigHardcore.registerObject(s, ConfigHardcore.clampPositive(prop.getInt(200)));
        s = "tickBuilderTickRate";
        prop = config.get(cat.getName(), s, 4);
        prop.comment = "The tick rate that the Builders will work at, higher value is slower building";
        ConfigHardcore.registerObject(s, ConfigHardcore.clampPositive(prop.getInt(4)));
        s = "allowTickBuilder";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should structures generate using a tick builder, which spreads out the placement of blocks over several ticks instead of generating the structure all at once in one tick?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "tickBuilderIgnoresAir";
        prop = config.get(cat.getName(), s, false);
        prop.comment = "Will air factor into the total blocks placed by the TickBuilder?";
        ConfigHardcore.registerObject(s, prop.getBoolean(false));
        prop = config.get(cat.getName(), "apisTempleAllow", true);
        m = 0;
        ConfigHardcore.structureAllow[0] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "randomTowerAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.structureAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "deathCircleAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.structureAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "obsidianCavernAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.structureAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "kitsunakumaDenAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.structureAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "celestialTempleAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.structureAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "timeAltarAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.structureAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "soulTombAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.structureAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "corruptedSpireAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.structureAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "empariahCaveAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.structureAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "claymationRuinAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.structureAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "darkHutAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.structureAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "spiderNestAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.structureAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "memoryCacheAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.structureAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "lightSpireAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.structureAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "hackerNetAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.structureAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "cubeMazeAllow", true);
        m = (byte)(m + 1);
        ConfigHardcore.structureAllow[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "outlookAllow", true);
        ConfigHardcore.structureAllow[(byte)(m + 1)] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "apisTempleRarity", 5);
        m = 0;
        ConfigHardcore.structureRarity[0] = ConfigHardcore.clamp(prop.getInt(5), 1, 200);
        prop = config.get(cat.getName(), "randomTowerRarity", 15);
        m = (byte)(m + 1);
        ConfigHardcore.structureRarity[m] = ConfigHardcore.clamp(prop.getInt(15), 1, 200);
        prop = config.get(cat.getName(), "deathCircleRarity", 5);
        m = (byte)(m + 1);
        ConfigHardcore.structureRarity[m] = ConfigHardcore.clamp(prop.getInt(5), 1, 200);
        prop = config.get(cat.getName(), "obsidianCavernRarity", 10);
        m = (byte)(m + 1);
        ConfigHardcore.structureRarity[m] = ConfigHardcore.clamp(prop.getInt(10), 1, 200);
        prop = config.get(cat.getName(), "kitsunakumaDenRarity", 5);
        m = (byte)(m + 1);
        ConfigHardcore.structureRarity[m] = ConfigHardcore.clamp(prop.getInt(5), 1, 200);
        prop = config.get(cat.getName(), "celestialTempleRarity", 10);
        m = (byte)(m + 1);
        ConfigHardcore.structureRarity[m] = ConfigHardcore.clamp(prop.getInt(10), 1, 200);
        prop = config.get(cat.getName(), "timeAltarRarity", 3);
        m = (byte)(m + 1);
        ConfigHardcore.structureRarity[m] = ConfigHardcore.clamp(prop.getInt(3), 1, 200);
        prop = config.get(cat.getName(), "soulTombRarity", 15);
        m = (byte)(m + 1);
        ConfigHardcore.structureRarity[m] = ConfigHardcore.clamp(prop.getInt(15), 1, 200);
        prop = config.get(cat.getName(), "corruptedSpireRarity", 0);
        m = (byte)(m + 1);
        ConfigHardcore.structureRarity[m] = ConfigHardcore.clamp(prop.getInt(0), 1, 200);
        prop = config.get(cat.getName(), "empariahCaveRarity", 5);
        m = (byte)(m + 1);
        ConfigHardcore.structureRarity[m] = ConfigHardcore.clamp(prop.getInt(5), 1, 200);
        prop = config.get(cat.getName(), "claymationRuinRarity", 5);
        m = (byte)(m + 1);
        ConfigHardcore.structureRarity[m] = ConfigHardcore.clamp(prop.getInt(5), 1, 200);
        prop = config.get(cat.getName(), "darkHutRarity", 15);
        m = (byte)(m + 1);
        ConfigHardcore.structureRarity[m] = ConfigHardcore.clamp(prop.getInt(15), 1, 200);
        prop = config.get(cat.getName(), "spiderNestRarity", 15);
        m = (byte)(m + 1);
        ConfigHardcore.structureRarity[m] = ConfigHardcore.clamp(prop.getInt(15), 1, 200);
        prop = config.get(cat.getName(), "memoryCacheRarity", 3);
        m = (byte)(m + 1);
        ConfigHardcore.structureRarity[m] = ConfigHardcore.clamp(prop.getInt(3), 1, 200);
        prop = config.get(cat.getName(), "lightSpireRarity", 10);
        m = (byte)(m + 1);
        ConfigHardcore.structureRarity[m] = ConfigHardcore.clamp(prop.getInt(10), 1, 200);
        prop = config.get(cat.getName(), "hackerNetRarity", 3);
        m = (byte)(m + 1);
        ConfigHardcore.structureRarity[m] = ConfigHardcore.clamp(prop.getInt(3), 1, 200);
        prop = config.get(cat.getName(), "cubeMazeRarity", 25);
        m = (byte)(m + 1);
        ConfigHardcore.structureRarity[m] = ConfigHardcore.clamp(prop.getInt(25), 1, 200);
        prop = config.get(cat.getName(), "outlookRarity", 3);
        m = (byte)(m + 1);
        ConfigHardcore.structureRarity[m] = ConfigHardcore.clamp(prop.getInt(3), 1, 200);
        prop = config.get(cat.getName(), "nekoBarracksRarity", 10);
        m = (byte)(m + 1);
        ConfigHardcore.structureRarity[m] = ConfigHardcore.clamp(prop.getInt(10), 1, 200);
        prop = config.get(cat.getName(), "nekoWarehouseRarity", 5);
        m = (byte)(m + 1);
        ConfigHardcore.structureRarity[m] = ConfigHardcore.clamp(prop.getInt(5), 1, 200);
        prop = config.get(cat.getName(), "nekoGuardTowerRarity", 25);
        m = (byte)(m + 1);
        ConfigHardcore.structureRarity[m] = ConfigHardcore.clamp(prop.getInt(25), 1, 200);
        prop = config.get(cat.getName(), "nekoShelterRarity", 50);
        m = (byte)(m + 1);
        ConfigHardcore.structureRarity[m] = ConfigHardcore.clamp(prop.getInt(50), 1, 200);
        prop = config.get(cat.getName(), "nekoWalledCityRarity", 3);
        m = (byte)(m + 1);
        ConfigHardcore.structureRarity[m] = ConfigHardcore.clamp(prop.getInt(3), 1, 200);
        prop = config.get(cat.getName(), "nekoidsFOBRarity", 1);
        m = (byte)(m + 1);
        ConfigHardcore.structureRarity[m] = ConfigHardcore.clamp(prop.getInt(1), 1, 200);
        prop = config.get(cat.getName(), "nekoidsMansionRarity", 0);
        ConfigHardcore.structureRarity[(byte)(m + 1)] = ConfigHardcore.clamp(prop.getInt(0), 1, 200);
        cat = config.getCategory("Miscellaneous");
        cat.setComment("Random other options that don't quite fit into other categories.");
        s = "allowRandomWeaponLore";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should mod-exclusive weapons and armor come with randomized Lore?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "allowChallengeScrolls";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Are Challenge Scrolls enabled?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "allowMobStatueDrops";
        prop = config.get(cat.getName(), "allowMobStatueDrops", true);
        prop.comment = "Can certain mobs drop statues?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "allowGeneratorItems";
        prop = config.get(cat.getName(), "allowGeneratorItems", true);
        prop.comment = "Will Creative mode-only generator items be enabled?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "allowItemTimeAltering";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Certain items and blocks may alter in-game time, should this be allowed?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "allowPvP";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should Doomsdays and Weapons be able to be used against other players?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "allowDefaultLores";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should the Lores bundled with the mod be used? Perhaps disable them if you wish to only use your own custom Lore.";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "allowCorruptionTransfer";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should Corruption transfer between entities?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "challengeScrollDropChance";
        prop = config.get(cat.getName(), s, 5);
        prop.comment = "Chance for Challenge Scrolls to drop off of any mob that you kill.";
        ConfigHardcore.registerObject(s, ConfigHardcore.clamp(prop.getInt(5), 1, 100));
        s = "mobStatueDropChance";
        prop = config.get(cat.getName(), s, 100);
        prop.comment = "Chance for a mob to drop it's corresponding statue. Only certain mobs have these.";
        ConfigHardcore.registerObject(s, ConfigHardcore.clamp(prop.getInt(100), 1, 100));
        cat = config.getCategory("Client-side Only Options");
        cat.setComment("These are client-side only options, they affect nothing on the server-side.");
        s = "allowAnimatedGui";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Whether or not the Doom GUI is animated.";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "allowArmorModels";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Whether or not custom armor models are rendered for armor that has it";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "allowWeaponModels";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Whether or not custom weapon models are used for weapons that have it";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "allowDivinityColorChange";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Whether the Divinity potion effect has a rainbow-like render overlay";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "showDoomGui";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Whether the Doom GUI is rendered";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "showAmuletStatusGui";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Whether the Amulet Status GUI is rendered";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "allowDimensionalMusic";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Whether Dimension-specific music is played";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "allowPotionEffectOverlays";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Whether certain potion effects have an overlay rendered while they are active";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "allowExtraDoomsdayInfoInGui";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "If you can activate a Doomsday, displays that Doomsday's information in the Gui";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "allowCorruptionMobRender";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should mobs render darker the longer they are corrupted? Only affects this mod's mobs.";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "guiTransparency";
        ConfigHardcore.registerObject(s, ConfigHardcore.clamp(config.get(cat.getName(), s, 100).getInt(100), 1, 100));
        s = "guiTextureSkinID";
        ConfigHardcore.registerObject(s, ConfigHardcore.clamp(config.get(cat.getName(), s, 0).getInt(0), 0, 100));
        s = "guiX";
        ConfigHardcore.registerObject(s, ConfigHardcore.clampPositive(config.get(cat.getName(), s, 1).getInt(1)));
        s = "guiY";
        ConfigHardcore.registerObject(s, ConfigHardcore.clampPositive(config.get(cat.getName(), s, 1).getInt(1)));
        cat = config.getCategory("Griefing Options");
        cat.setComment("Toggle whether specific Weapon abilities or Doomsdays damage the terrain.");
        prop = config.get(cat.getName(), "allowNatureDrainDestruction", true);
        m = 0;
        ConfigHardcore.griefConfig[0] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "allowRavageDestruction", true);
        m = (byte)(m + 1);
        ConfigHardcore.griefConfig[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "allowFrozenLightningDestruction", true);
        m = (byte)(m + 1);
        ConfigHardcore.griefConfig[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "allowMourningStarDestruction", true);
        m = (byte)(m + 1);
        ConfigHardcore.griefConfig[m] = prop.getBoolean(true);
        prop = config.get(cat.getName(), "allowTitanDestruction", true);
        ConfigHardcore.griefConfig[(byte)(m + 1)] = prop.getBoolean(true);
        cat = config.getCategory("Mob AI");
        cat.setComment("Toggle aspects of each mob's AI and also set specific griefing instances.");
        s = "jabbaAnger";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should the Jabba species become angry after being in combat for a while and gain new abilities?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "jabbaProjectiles";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should the Jabba species shoot projectiles at targets when angered?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "plagueCorruption";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should Plagues corrupt entities around it?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "gragulDamageReduction";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should the Gragul species take partial health damage instead of normal damage?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "gragulPercentageDamage";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should the Gragul species inflict partial health damage instead of normal damage? (They will still do armor piercing damage)";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "minotaurCharge";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should Minotaurs charge at their target?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "inklingInvisibility";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should Inklings become invisible when threatened?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "inklingTorchBreaking";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should Inklings randomly destroy torches when near them?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "inklingTeleport";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should Inklings teleport?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "ragrExplosions";
        prop = config.get(cat.getName(), s, false);
        prop.comment = "Should Ragrs create explosions when landing?";
        ConfigHardcore.registerObject(s, prop.getBoolean(false));
        s = "ragrBlockCrushing";
        prop = config.get(cat.getName(), s, false);
        prop.comment = "Should Ragrs crush blocks when landing?";
        ConfigHardcore.registerObject(s, prop.getBoolean(false));
        s = "pumpkinheadPumpkinSpawn";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should Pumpkinheads create a Home Pumpkin upon spawning?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "pumpkinheadHaste";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should Pumpkinheads gain increased stats while they have a Home Pumpkin and are being threatened?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "pumpkinheadPumpkinbombs";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should Pumpkinheads fire Pumpkinbombs when they are low on health and have a Home Pumpkin?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "tragicNekoRockets";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should Tragic Nekos fire rockets at people's faces?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "tragicNekoStickyBombs";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should Tragic Nekos throw Sticky Bombs into people's faces?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "tragicNekoClusterBomb";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should Tragic Nekos throw Cluster Bombs at people's faces?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "tragicNekoDeathBomb";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should Tragic Nekos have a chance to drop various bombs on death?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "tragicNekoCelebration";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should Tragic Nekos celebrate their birthday?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "toxProjectiles";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should the Tox species fire projectiles? (They still attack on contact)";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "cryseReflection";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should the Cryse species reflect damage?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "norVoxProjectiles";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should the Nor-Vox species fire projectiles?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "norVoxRegeneration";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should the Nor-Vox species regenerate health naturally?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "pirahGolden";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should Pirah be randomly spawned as a Golden stronger version?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "stinTeleport";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should the Stin species randomly teleport you away when you attack them?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "abominationHelpCall";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should Abominations call for help when they are attacked?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "erkelMushroomSpawning";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should Erkels randomly place Mushrooms?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "sirvHelpCall";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should Sirvs call for help when they are attacked?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "psygoteSwapTeleport";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should Psygotes attempt to swap places with their attacker to confuse them?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "psygoteProjectiles";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should Psygotes fire Dark Mortors at their attacker?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "psygoteRegeneration";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should Psygotes regenerate health naturally?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "lockbotLockdown";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should Lockbots lock down their target?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "harvesterBuffDebuffEntities";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should Harvesters buff Synapse mobs and debuff everything else?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "harvesterNanoSwarms";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should Harvesters spawn Nano Swarms in to defend them?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "seekerKillbeam";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should Seekers kill you with their gaze?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "archangelHolybeam";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should Archangels kill you with their Holy Beam of death?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "ireEnergyBurst";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should Ires shoot an Ire Energy burst at their target?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "fuseaExplosiveDamage";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should the Fusea species explode when they take damage?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "fuseaExplosiveAttack";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should the Fusea species explode when they attack something?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "fuseaExplosiveLayers";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should the Fusea species only take damage when they explode?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "ranmasCharge";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should Ranmas hurl themselves at you?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "ranmasImpactExplosions";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should Ranmas create explosions if they impact something at high enough velocity";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "parasmiteLeech";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should Parasmites attempt to latch onto entities to simultaneously buff and hurt them?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "avrisAnnouncements";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should Avris' announce when they spawn, die or elude attackers?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "avrisDespawnTime";
        prop = config.get(cat.getName(), "avrisDespawnTime", true);
        prop.comment = "Should Avris' despawn after a preset amount of time?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "jetNekoRockets";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should Jet Nekos fire rockets at their target?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "jetNekoHovering";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should Jet Nekos stop and hover occasionally?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "scienceNekoLaser";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should Science Nekos fire their ray guns at their target?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "scienceNekoPotions";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should Science Nekos toss potions at their target?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "scienceNekoTargetsUndead";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should Science Nekos seek out Undead creatures to kill?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "mechaNekoCommandExo";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should Mecha Nekos command the Exo they are riding to use abilities?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "mechaNekoRidingExo";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should Mecha Nekos spawn in riding a Mecha Exo?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "mechaNekoRidingArmor";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should Mecha Nekos gain increased armor when riding another entity?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "assaultNekoChargeAttack";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should Assault Nekos charge towards their target when far away?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "assaultNekoShield";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should Assault Nekos sometimes get a temporary shield that absorbs damage?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "assaultNekoLaserSword";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should Assault Nekos do armor piercing damage?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "traderNekoTrading";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should Trader Nekos be allowed to trade?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "traderNekoReleaseTrading";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should Trader Nekos only be allowed to trade when they are released?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "kragulSpiritCasts";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should Kraguls fire Spirit Casts at their target?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "magmoxLargeFireballs";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should Magmox fire Large Fireballs in addition to the smaller projectiles at their target?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "megaCryseShields";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should Mega Cryse have shields that block all damage (except Magic)?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "greaterStinCharge";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should Greater Stins charge towards their targets?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "stinKingMortors";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should Stin Kings fire Dark Mortors at their target?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "stinQueenWebBombs";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should Stin Queens fire Web Bombs at their target?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "stinQueenBabies";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should Stin Queens spawn in babies to attack their target?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "stinQueenWebs";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should Stin Queens trap attackers in webs?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "voxStellarumSpinAttack";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should Vox Stellarums do a spinning attack?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "voxStellarumHealing";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should Vox Stellarums go into a healing phase to regenerate their health quickly?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "aegarHypermode";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should Aegars enter Hypermode after their crystal is damaged and gain increased stats?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "aegarShockwave";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should Aegars do a ground shockwave attack?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "aegarLasers";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should Aegars fire a laser at their target?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "aegarMortors";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should Aegars fire Crystal Mortors at their target?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "volatileFuseaElementalChange";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should Volatile Fuseas change elements based on their surroundings? (they gain projectile attacks from this)";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "apisSolarbombs";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should Apis fire Solar Bombs at it's target?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "apisChargeAttack";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should Apis charge towards it's target?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "apisExplosiveCharge";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should Apis create an explosion when it charges?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "apisSuperStomp";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should Apis do a super stomp attack on nearby targets?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "apisReflection";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should Apis be able to reflect attacks temporarily?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "skultarDemeanor";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should Skultar use demeanor to change it's attack state?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "skultarProjectiles";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should Skultar fire projectiles at it's target?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "skultarClone";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should Skultar create clones when it's health is low to confuse attackers?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "skultarWitheringGas";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should Skultar create Withering Gas when it's health is low?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "skultarRegeneration";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should Skultar regenerate health naturally?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "kitsunakumaFireballExempt";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should Kitsunakuma be immune to all damage but Fireball damage?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "kitsunakumaFireballs";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should Kitsunakuma shoot fireballs?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "kitsunakumaTeleport";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should Kitsunakuma teleport?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "kitsunakumaTaunt";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should Kitsunakuma taunt?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "polarisTeleport";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should Polaris teleport?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "polarisInvisibility";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should Polaris go invisible?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "polarisAfterImage";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should Polaris sometimes leave an after-image (clone) when teleporting?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "polarisNighttimeSet";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should Polaris automatically set the world to night?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "polarisFearGolems";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should Polaris run away from Golems?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "polarisRegeneration";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should Polaris regenerate health naturally?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "empariahDemeanor";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should Empariah use demeanor to determine it's attack patterns?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "empariahCharge";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should Empariah charge towards it's target?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "empariahFrostBreath";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should Empariah use a Frost breath attack?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "empariahRoar";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should Empariah use a Roar attack?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "empariahRockThrowing";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should Empariah throw rocks at it's target?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "empariahSummonAbomination";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should Empariah summon Abominations to help it?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "empariahCallHelp";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should Empariah call for help of nearby Abominations?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "empariahRegeneration";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should Empariah regenerate health naturally?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "timeControllerRegeneration";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should Time Controller generate health naturally?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "timeControllerQuantumLeap";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should Time Controller use a Quantum Leap attack that reverts entities to their position from a few seconds ago?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "timeControllerFlux";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should Time Controller use a Flux attack that pulls entities towards it and absorbs damage?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "timeControllerPurge";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should Time Controller use a Purge attack that deflects projectiles and hits entities near it?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "timeControllerSpaz";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should Time Controller spaz out when it's health is low and teleport around?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "timeControllerTimeBombs";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should Time Controller spawn in Time Bombs that affect entities near them?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "timeControllerTimeAltering";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should Time Controller be able to change the world time?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "enyvilDarkCrystals";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should Enyvil need Dark Crystals to use it's abilities?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "enyvilDarkLightning";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should Enyvil shoot Dark Lightning projectiles?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "enyvilCrystalLaser";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should Enyvil be able to use it's Dark Crystals to fire a laser at it's target?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "enyvilDarkEnergySpray";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should Enyvil be able to fire Dark Energy at it's target?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "enyvilTractorBeam";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should Enyvil be able to Tractor beam far away targets to it?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "enyvilThunderstorm";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should Enyvil be able to summon Lightning down around it?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "enyvilLightningExplosions";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should Enyvil create explosions when it strikes something with Lightning?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "enyvilSlam";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should Enyvil have a Slam attack?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "enyvilDestroyBlocks";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should Enyvil destroy blocks if it gets stuck?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "enyvilRegeneration";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should Enyvil regenerate health naturally while it has a Dark Crystal?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "claymationTransformation";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should Claymation transform into other mobs and inherit their abilities?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "claymationPotionReflection";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should Claymation reflect bad potion effects at it's target?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "professorNekoidBlaster";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should Professor Nekoid use an Aero-Blaster to knock enemies away?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "professorNekoidMechaSpawn";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should Professor Nekoid spawn in riding a Mecha Exo?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "professorNekoidMechaArmor";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should Professor Nekoid gain increased armor from riding a Mecha Exo?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "professorNekoidUseMecha";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should Professor Nekoid use it's ridden Mecha Exo's abilities?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "professorNekoidReinforcements";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should Professor Nekoid summon reinforcements when it's out of it's mech or it's health is low?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "professorNekoidTitanfall";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should Professor Nekoid call in a replacement Mecha Exo if it's previous one was destroyed?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "professorNekoidDeathRelease";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should Professor Nekoid send out a release signal upon death that releases Nekos in a huge radius around it?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "overlordDivineWeakness";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should the Overlord species be immune to all damage unless Divinity is active on the attacker?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "overlordBarriers";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should the Overlord species place their specialized barrier blocks in specific situations?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "overlordGas";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should the Overlord species place Corrupting gas in specific situations?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "overlordClearSpace";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should the Overlord species clear space around them to avoid suffocation?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "overlordTransformation";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should the Overlord species transform into it's next form upon death?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "overlordTransformationAesthetics";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should the Overlord species do the transformation idle stuff upon spawning?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "overlordNanoSwarms";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should the Overlord species spawn in Nano Swarms for protection?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "overlordPhases";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should the Overlord Cocoon instance be in phases, alternating Seekers and damage cycles? If this is disabled you won't need Divinity to damage it.";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "overlordSeekers";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should the Overlord Cocoon use Seekers in it's instance? If this is set to false and phases are true, it'll always be in damage cycle.";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "overlordUnstableAnomalies";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should the Overlord Combat become unstable and spawn anomalies? If this is disabled, you won't need Divinity to damage it.";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "overlordMegaLeap";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should the Overlord Combat leap into the air and do a massive slam onto the ground?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "overlordSlashAttack";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should the Overlord Combat have an Area of Effect on it's normal attack?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "overlordChargeAttack";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should the Overlord Combat turtle up and charge towards it's target?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "overlordGrappleAttack";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should the Overlord Combat pull targets towards it with an attracting laser beam?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "overlordReflection";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should the Overlord Combat cocoon up and reflect all incoming damage?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "overlordHunters";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should the Overlord Combat spawn Hunters to attack it's target?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "overlordDeleteBlocks";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should the Overlord Core delete blocks it passes through?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "overlordMortors";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should the Overlord Core hover and fire mortors to create anomalies? If this is disabled, you won't need Divinity to damage it.";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "overlordVulnerable";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should the Overlord Core become vulnerable and flee when it takes damage?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "overlordGrabAttack";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should the Overlord Core grab nearby targets and focus attacks on them while carrying them high up into the sky?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "overlordRegeneration";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should the Overlord Core regenerate health naturally?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "overlordPlatform";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should the Overlord Core generate a platform to catch it's drops upon death?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        s = "overlordSentinelDrop";
        prop = config.get(cat.getName(), s, true);
        prop.comment = "Should the Overlord Core drop a Sentinel upon death every time?";
        ConfigHardcore.registerObject(s, prop.getBoolean(true));
        cat = config.getCategory("Attribute Modifiers");
        cat.setComment("Set each mob's modifier's actual amount, these can also be used to disable them by setting them to 0 in most cases.");
        prop = config.get(cat.getName(), "claymationSpeedDebuff", -1.0);
        prop.comment = "For any of the Claymation's forms that require it to have it's speed debuffed.";
        m = 0;
        ConfigHardcore.modifier[0] = prop.getDouble(-1.0);
        prop = config.get(cat.getName(), "kitsunakumaSpeedDebuff", -0.5);
        prop.comment = "For when the Kitsunakuma is preparing to fire a fireball or taunt.";
        m = (byte)(m + 1);
        ConfigHardcore.modifier[m] = prop.getDouble(-0.5);
        prop = config.get(cat.getName(), "timeControllerSpeedBuff", 0.5);
        prop.comment = "For when the Time Controller is in Purge mode.";
        m = (byte)(m + 1);
        ConfigHardcore.modifier[m] = prop.getDouble(0.55);
        prop = config.get(cat.getName(), "empariahSpeedDebuff", -0.5);
        prop.comment = "For when the Empariah is about to throw a rock or use it's Frost Breath.";
        m = (byte)(m + 1);
        ConfigHardcore.modifier[m] = prop.getDouble(-0.5);
        prop = config.get(cat.getName(), "aegarSpeedBuff", 0.156);
        prop.comment = "For when the Aegar has it's Core destroyed and it is in Hypermode.";
        m = (byte)(m + 1);
        ConfigHardcore.modifier[m] = prop.getDouble(0.156);
        prop = config.get(cat.getName(), "megaCryseAttackBuff", 2.0);
        prop.comment = "For when the Mega Cryse has all of it's shields destroyed.";
        m = (byte)(m + 1);
        ConfigHardcore.modifier[m] = prop.getDouble(2.0);
        prop = config.get(cat.getName(), "jabbaAttackBuff", 2.5);
        prop.comment = "For when Jabba, Janna or Jarra is below half health.";
        m = (byte)(m + 1);
        ConfigHardcore.modifier[m] = prop.getDouble(2.5);
        prop = config.get(cat.getName(), "norVoxSpeedDebuff", -0.5);
        prop.comment = "For when the Nor-Vox, Star-Vox or Vox Stellarum is about to fire a projectile.";
        m = (byte)(m + 1);
        ConfigHardcore.modifier[m] = prop.getDouble(-0.5);
        prop = config.get(cat.getName(), "psygoteSpeedDebuff", -0.5);
        prop.comment = "For when the Psygote is about to teleport or fire a projectile.";
        m = (byte)(m + 1);
        ConfigHardcore.modifier[m] = prop.getDouble(-0.5);
        prop = config.get(cat.getName(), "tragicNekoSpeedDebuff", -0.5);
        prop.comment = "For when the Tragic Neko is about to fire or throw a projectile.";
        m = (byte)(m + 1);
        ConfigHardcore.modifier[m] = prop.getDouble(-0.5);
        prop = config.get(cat.getName(), "dynamicMobHealthBuff", 20.0);
        prop.comment = "Health buff for mod-exclusive mobs on Hard difficulty. Only affects mobs that have over double of this value for their base Max Health value.";
        m = (byte)(m + 1);
        ConfigHardcore.modifier[m] = prop.getDouble(20.0);
        prop = config.get(cat.getName(), "dynamicMobHealthDebuff", -20.0);
        prop.comment = "Health debuff for mod-exclusive mobs on Easy difficulty. Only affects mobs that have over double of this value for their base Max Health.";
        m = (byte)(m + 1);
        ConfigHardcore.modifier[m] = prop.getDouble(-20.0);
        prop = config.get(cat.getName(), "dynamicBossHealthBuff", 50.0);
        prop.comment = "Health buff for mod-exclusive Bosses on Hard difficulty. Only affects mobs that have over 25% of this value for their base Max Health.";
        m = (byte)(m + 1);
        ConfigHardcore.modifier[m] = prop.getDouble(50.0);
        prop = config.get(cat.getName(), "apisSpeedDebuff", -0.5);
        prop.comment = "For when Apis is using it's Stomp attack.";
        m = (byte)(m + 1);
        ConfigHardcore.modifier[m] = prop.getDouble(-0.5);
        prop = config.get(cat.getName(), "ghastHealthBuff", 30.0);
        prop.comment = "Vanilla mob buff for Ghasts.";
        m = (byte)(m + 1);
        ConfigHardcore.modifier[m] = prop.getDouble(30.0);
        prop = config.get(cat.getName(), "zombieSkeletonCreeperHealthBuff", 10.0);
        prop.comment = "Vanilla mob buff for Skeletons, Creepers and Zombies.";
        m = (byte)(m + 1);
        ConfigHardcore.modifier[m] = prop.getDouble(10.0);
        prop = config.get(cat.getName(), "endermanHealthBuff", 20.0);
        prop.comment = "Vanilla mob buff for Endermen.";
        m = (byte)(m + 1);
        ConfigHardcore.modifier[m] = prop.getDouble(20.0);
        prop = config.get(cat.getName(), "spiderHealthBuff", 8.0);
        prop.comment = "Vanilla mob buff for Spiders.";
        m = (byte)(m + 1);
        ConfigHardcore.modifier[m] = prop.getDouble(8.0);
        prop = config.get(cat.getName(), "mobFollowRangeDebuff", -16.0);
        prop.comment = "Overall mob debuff for when a mob has Blindness.";
        m = (byte)(m + 1);
        ConfigHardcore.modifier[m] = prop.getDouble(-16.0);
        prop = config.get(cat.getName(), "hydrationKnockbackResistanceBuff", 1.0);
        prop.comment = "The Knockback Resistance buff that the Hydration Talisman gives you when you're in water or it's raining.";
        m = (byte)(m + 1);
        ConfigHardcore.modifier[m] = prop.getDouble(1.0);
        prop = config.get(cat.getName(), "lightningRodAttackBuff", 5.0);
        prop.comment = "The Attack Damage buff that the Lightning Rod Talisman gives you when it's thundering.";
        m = (byte)(m + 1);
        ConfigHardcore.modifier[m] = prop.getDouble(5.0);
        prop = config.get(cat.getName(), "moonlightHealthBuff", 10.0);
        prop.comment = "The Health buff that the Moonlight Talisman gives you when it's nighttime and it's not raining or thundering.";
        m = (byte)(m + 1);
        ConfigHardcore.modifier[m] = prop.getDouble(10.0);
        prop = config.get(cat.getName(), "synthesisHealthBuff", 10.0);
        prop.comment = "The Health buff that the Synthesis Talisman gives you when it's daytime and not raining or thundering.";
        m = (byte)(m + 1);
        ConfigHardcore.modifier[m] = prop.getDouble(10.0);
        prop = config.get(cat.getName(), "butcherKnockbackResistanceBuff", 1.0);
        prop.comment = "The Knockback Resistance buff you gain from holding the Butcher.";
        m = (byte)(m + 1);
        ConfigHardcore.modifier[m] = prop.getDouble(1.0);
        prop = config.get(cat.getName(), "overlordArmorHealthBuff", 5.0);
        prop.comment = "The Health buff you gain from wearing any of the Overlord Armor set.";
        m = (byte)(m + 1);
        ConfigHardcore.modifier[m] = prop.getDouble(5.0);
        if (config.hasChanged()) {
            config.save();
        }
    }
}

