/*
 * Decompiled with CFR 0.152.
 */
package tragicneko.tragicmc.blocks.tileentity;

import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.server.gui.IUpdatePlayerListBox;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import tragicneko.tragicmc.TragicBlocks;
import tragicneko.tragicmc.TragicConfig;
import tragicneko.tragicmc.TragicMC;
import tragicneko.tragicmc.blocks.BlockStructureSeed;
import tragicneko.tragicmc.blocks.BlockStructureSeed2;
import tragicneko.tragicmc.worldgen.schematic.Schematic;
import tragicneko.tragicmc.worldgen.structure.Structure;
import tragicneko.tragicmc.worldgen.structure.TickBuilder;

public class TileEntityStructureSeed
extends TileEntity
implements IUpdatePlayerListBox {
    public boolean warned = false;

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && this.field_145850_b.func_82737_E() % 5L == 0L && !this.warned) {
            this.growStructure();
        }
    }

    public void growStructure() {
        IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
        Integer prop = (Integer)(state.func_177230_c() == TragicBlocks.StructureSeed ? state.func_177229_b((IProperty)BlockStructureSeed.STRUCTURE) : state.func_177229_b((IProperty)BlockStructureSeed2.STRUCTURE));
        int id = prop;
        if (id >= Structure.getRegistrySize()) {
            return;
        }
        EntityPlayer player = this.field_145850_b.func_72977_a((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), 16.0);
        Structure structure = Structure.getStructureById(id);
        if (structure == null) {
            if (player != null) {
                player.func_145747_a((IChatComponent)new ChatComponentText("The structure you are attempting to generate is null for some reason. Try a different seed."));
            }
            this.warned = true;
            return;
        }
        if (structure.getHeight() + this.func_174877_v().func_177956_o() > this.field_145850_b.func_72940_L()) {
            if (player != null) {
                player.func_145747_a((IChatComponent)new ChatComponentText(structure.getLocalizedName() + " wasn't able to generate due to not enough height!"));
            }
            this.warned = true;
            return;
        }
        if (!structure.canGenerate() && !TragicConfig.structureAllow[id]) {
            if (player != null) {
                player.func_145747_a((IChatComponent)new ChatComponentText(structure.getLocalizedName() + " wasn't able to generate due to being disabled in the config!"));
            }
            this.warned = true;
            return;
        }
        Schematic sch = structure.generate(this.field_145850_b, this.field_145850_b.field_73012_v, this.func_174877_v());
        if (sch != null) {
            boolean flag = false;
            if (TragicConfig.getBoolean("allowTickBuilder") && TickBuilder.getBuilderFor(this.field_145850_b) != null) {
                flag = TickBuilder.getBuilderFor(this.field_145850_b).addSchematic(this.field_174879_c, sch);
                TragicMC.logInfo("builder wasn't null");
            }
            if (player != null) {
                ChatComponentText text = new ChatComponentText(structure.getLocalizedName() + (TragicConfig.getBoolean("allowTickBuilder") ? (flag ? " had it's schematic generated successfully, building..." : " had it's schematic generated, however, there is a schematic being generated at that coordinate already.") : " was generated successfully!"));
                player.func_145747_a((IChatComponent)text);
            }
            this.field_145850_b.func_175656_a(this.field_174879_c, Blocks.field_150350_a.func_176223_P());
        } else {
            TragicMC.logError("Something went wrong while generating a " + structure.getLocalizedName() + " with a structure seed");
            if (player != null) {
                player.func_145747_a((IChatComponent)new ChatComponentText("Something went wrong while generating that structure..."));
            }
            this.warned = true;
        }
    }
}

