/*
 * Decompiled with CFR 0.152.
 */
package tragicneko.tragicmc.worldgen.structure;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import tragicneko.tragicmc.TragicConfig;
import tragicneko.tragicmc.util.Tuple;
import tragicneko.tragicmc.worldgen.schematic.Schematic;
import tragicneko.tragicmc.worldgen.structure.Structure;

public class TickBuilder {
    public static final Logger logger = LogManager.getLogger((String)"TragicMC/Tick Builder");
    public ConcurrentHashMap<BlockPos, Schematic> schemas = new ConcurrentHashMap();
    public static HashMap<World, TickBuilder> builders = new HashMap();
    public final World theWorld;
    private boolean shouldBuild = true;
    public static int BUILD_LIMIT = TragicConfig.getInt("tickBuilderSchematicLimit");
    public static int OVERALL_BUILD_LIMIT = TragicConfig.getInt("tickBuilderOverallLimit");
    public static int TICK_RATE = TragicConfig.getInt("tickBuilderTickRate");
    public static long tick = 0L;
    public static final String BUILD_TAG = "TragicMC.IncompleteBuilds";
    public static final String STRUCTURE_ID_TAG = "structureID";
    public static final String STRUCTURE_ORIGIN_X_TAG = "posOriginX";
    public static final String STRUCTURE_ORIGIN_Y_TAG = "posOriginY";
    public static final String STRUCTURE_ORIGIN_Z_TAG = "posOriginZ";
    public static final String STRUCTURE_LAST_POS_TAG = "structureLastPosition";
    public static final String STRUCTURE_NBT_DATA = "structureNbtData";

    public TickBuilder() {
        this.theWorld = null;
    }

    public TickBuilder(World world) {
        this.theWorld = world;
        builders.put(world, this);
    }

    public static TickBuilder getBuilderFor(World world) {
        return builders.get(world);
    }

    public void continueBuilding() {
        this.shouldBuild = true;
    }

    public void stopBuilding() {
        this.shouldBuild = false;
    }

    @SubscribeEvent
    public void onTick(TickEvent.ServerTickEvent event) {
        if (builders.isEmpty()) {
            return;
        }
        if (tick++ % (long)TICK_RATE != 0L) {
            return;
        }
        Iterator<TickBuilder> bldrs = builders.values().iterator();
        boolean flag = TragicConfig.getBoolean("tickBuilderIgnoresAir");
        while (bldrs.hasNext()) {
            TickBuilder tb = bldrs.next();
            if (tb.hasFinished() || !tb.shouldBuild || tb.theWorld == null) continue;
            Set schemas = tb.schemas.keySet();
            Iterator ite = schemas.iterator();
            int totalPlaces = 0;
            while (ite.hasNext() && totalPlaces < OVERALL_BUILD_LIMIT) {
                BlockPos origin = (BlockPos)ite.next();
                Schematic sch = tb.schemas.get(origin);
                int placements = 0;
                if (sch.hasFinished()) {
                    tb.removeSchematic(origin);
                    List<Tuple<BlockPos, Entity>> list = sch.entityList;
                    if (list == null) continue;
                    for (Tuple<BlockPos, Entity> tp : list) {
                        Entity e = tp.getRight();
                        BlockPos pos = tp.getLeft();
                        e.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
                        if (e instanceof EntityCreature) {
                            ((EntityCreature)e).func_180482_a(tb.theWorld.func_175649_E(pos), null);
                        }
                        tb.theWorld.func_72838_d(e);
                    }
                    continue;
                }
                int progress = sch.placedBlocks;
                boolean hasContinued = false;
                int i = 0;
                for (int j = 0; j < sch.list.size() && placements < BUILD_LIMIT && totalPlaces < OVERALL_BUILD_LIMIT; ++j) {
                    if (i++ < progress && !hasContinued) continue;
                    hasContinued = true;
                    Schematic.PosPreset pre = sch.list.get(j);
                    if (pre == null) continue;
                    if (pre.state == tb.theWorld.func_180495_p(pre.pos) && !pre.tileEntity) {
                        ++sch.placedBlocks;
                        continue;
                    }
                    sch.setMappedBlock(tb.theWorld, pre);
                    ++sch.placedBlocks;
                    if (flag && (!flag || pre.state.func_177230_c() == Blocks.field_150350_a)) continue;
                    ++placements;
                    ++totalPlaces;
                }
                if (!sch.hasFinished()) continue;
                tb.removeSchematic(origin);
                List<Tuple<BlockPos, Entity>> list = sch.entityList;
                if (list == null) continue;
                for (Tuple<BlockPos, Entity> tp : list) {
                    Entity e = tp.getRight();
                    BlockPos pos = tp.getLeft();
                    e.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
                    if (e instanceof EntityCreature) {
                        ((EntityCreature)e).func_180482_a(tb.theWorld.func_175649_E(pos), null);
                    }
                    tb.theWorld.func_72838_d(e);
                }
            }
        }
    }

    public boolean hasFinished() {
        return this.schemas.isEmpty();
    }

    public synchronized boolean addSchematic(BlockPos origin, Schematic sch) {
        if (this.schemas.containsKey(origin)) {
            logger.warn("Builder already has a mapping for this schematic's origin (" + origin + "), ignoring...");
            return false;
        }
        this.schemas.put(origin, sch);
        return true;
    }

    public synchronized void removeSchematic(BlockPos origin) {
        Schematic sch = this.schemas.get(origin);
        if (sch == null || !this.schemas.containsKey(origin)) {
            logger.warn("Attempted to remove schematic at that origin (" + origin + "), but the map didn't contain one, this is an error...");
            return;
        }
        logger.info("Removed schematic at the origin (" + origin + ")");
        this.schemas.remove(origin);
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        if (event.world.field_72995_K) {
            return;
        }
        if (TickBuilder.getBuilderFor(event.world) != null) {
            TickBuilder.getBuilderFor(event.world).continueBuilding();
        } else {
            new TickBuilder(event.world).continueBuilding();
        }
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        if (event.world.field_72995_K) {
            return;
        }
        if (TickBuilder.getBuilderFor(event.world) != null) {
            TickBuilder.getBuilderFor(event.world).stopBuilding();
            builders.remove(event.world);
        }
    }

    @SubscribeEvent
    public void onChunkLoad(ChunkDataEvent.Load event) {
        if (event.world.field_72995_K) {
            return;
        }
        if (TickBuilder.getBuilderFor(event.world) != null) {
            NBTTagCompound tag;
            TickBuilder tb = TickBuilder.getBuilderFor(event.world);
            if (event.getData() != null && (tag = event.getData()).func_74764_b(BUILD_TAG)) {
                NBTTagList tagList = tag.func_150295_c(BUILD_TAG, 10);
                if (tagList.func_82582_d()) {
                    tag.func_82580_o(BUILD_TAG);
                    return;
                }
                for (int i = 0; i < tagList.func_74745_c(); ++i) {
                    NBTTagCompound tg = tagList.func_150305_b(i);
                    if (tg == null) continue;
                    try {
                        int id = tg.func_74762_e(STRUCTURE_ID_TAG);
                        int x = tg.func_74762_e(STRUCTURE_ORIGIN_X_TAG);
                        int y = tg.func_74762_e(STRUCTURE_ORIGIN_Y_TAG);
                        int z = tg.func_74762_e(STRUCTURE_ORIGIN_Z_TAG);
                        BlockPos pos = TickBuilder.toPos(new int[]{x, y, z});
                        int progress = tg.func_74762_e(STRUCTURE_LAST_POS_TAG);
                        NBTTagCompound tag2 = tg.func_74775_l(STRUCTURE_NBT_DATA);
                        Structure str = Structure.getStructureById(id);
                        Schematic sch = str.getSchematicFor(event.world, event.world.field_73012_v, pos).readFromNBT(tag2);
                        sch.generateStructure(event.world, event.world.field_73012_v, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()).sortIntoList();
                        sch.placedBlocks = progress;
                        sch.retrogradeBuildProgress();
                        tb.addSchematic(pos, sch);
                        continue;
                    }
                    catch (Exception e) {
                        logger.error("There was an error trying to read a Schematic from chunk data, skipping...", (Throwable)e);
                    }
                }
                tag.func_82580_o(BUILD_TAG);
            }
        }
    }

    public static BlockPos toPos(int[] array) {
        return new BlockPos(array[0], array[1], array[2]);
    }

    @SubscribeEvent
    public void onChunkSave(ChunkDataEvent.Save event) {
        if (event.world.field_72995_K) {
            return;
        }
        TickBuilder tb = TickBuilder.getBuilderFor(event.world);
        if (tb == null) {
            tb = new TickBuilder(event.world);
        }
        if (!tb.hasFinished()) {
            Iterator ite = ((ConcurrentHashMap.KeySetView)tb.schemas.keySet()).iterator();
            NBTTagList tagList = new NBTTagList();
            boolean save = false;
            while (ite.hasNext()) {
                BlockPos pos = (BlockPos)ite.next();
                Schematic sch = tb.schemas.get(pos);
                if (event.getChunk() != event.world.func_175726_f(pos)) continue;
                save = true;
                NBTTagCompound tag = new NBTTagCompound();
                int[] array = TickBuilder.toArray(pos);
                tag.func_74768_a(STRUCTURE_ORIGIN_X_TAG, array[0]);
                tag.func_74768_a(STRUCTURE_ORIGIN_Y_TAG, array[1]);
                tag.func_74768_a(STRUCTURE_ORIGIN_Z_TAG, array[2]);
                tag.func_74768_a(STRUCTURE_ID_TAG, sch.structure.getStructureId());
                tag.func_74768_a(STRUCTURE_LAST_POS_TAG, sch.placedBlocks);
                tag.func_74782_a(STRUCTURE_NBT_DATA, (NBTBase)sch.writeToNBT(new NBTTagCompound()));
                tagList.func_74742_a((NBTBase)tag);
                if (event.getChunk().func_177410_o()) continue;
                tb.removeSchematic(pos);
            }
            if (save) {
                event.getData().func_74782_a(BUILD_TAG, (NBTBase)tagList);
            }
        }
    }

    public static int[] toArray(BlockPos pos) {
        return new int[]{pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()};
    }
}

