/*
 * Decompiled with CFR 0.152.
 */
package tragicneko.tragicmc.worldgen.structure;

import java.util.Random;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.biome.BiomeGenHell;
import tragicneko.tragicmc.TragicConfig;
import tragicneko.tragicmc.worldgen.biome.BiomeGenDecayingWasteland;
import tragicneko.tragicmc.worldgen.biome.BiomeGenScorchedWasteland;
import tragicneko.tragicmc.worldgen.schematic.Schematic;
import tragicneko.tragicmc.worldgen.schematic.SchematicDeathCircle;
import tragicneko.tragicmc.worldgen.structure.Structure;

public class StructureDeathCircle
extends Structure {
    public StructureDeathCircle(int id, String name) {
        super(id, name, 6);
    }

    @Override
    public boolean isSurfaceStructure() {
        return true;
    }

    @Override
    public boolean isValidDimension(int dim) {
        return dim == -1 || dim == TragicConfig.getInt("collisionID");
    }

    @Override
    public boolean areCoordsValidForGeneration(World world, BlockPos pos, Random rand) {
        BiomeGenBase biome = world.func_180494_b(pos);
        if (biome instanceof BiomeGenHell || biome instanceof BiomeGenDecayingWasteland || biome instanceof BiomeGenScorchedWasteland) {
            return super.areCoordsValidForGeneration(world, pos, rand) && this.getRarity(200);
        }
        return false;
    }

    @Override
    public int getStructureColor() {
        return 0x770300;
    }

    @Override
    public Schematic getSchematicFor(World world, Random rand, BlockPos pos) {
        return new SchematicDeathCircle(pos, this, world);
    }
}

