/*
 * Decompiled with CFR 0.152.
 */
package tragicneko.tragicmc.worldgen.structure;

import java.util.Random;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import tragicneko.tragicmc.TragicConfig;
import tragicneko.tragicmc.worldgen.biome.BiomeGenDarkForest;
import tragicneko.tragicmc.worldgen.schematic.Schematic;
import tragicneko.tragicmc.worldgen.schematic.SchematicDarkHut;
import tragicneko.tragicmc.worldgen.structure.Structure;

public class StructureDarkHut
extends Structure {
    public StructureDarkHut(int id, String s) {
        super(id, s, 13);
    }

    @Override
    public boolean isSurfaceStructure() {
        return true;
    }

    @Override
    public boolean isValidDimension(int dim) {
        return dim == TragicConfig.getInt("collisionID");
    }

    @Override
    public boolean areCoordsValidForGeneration(World world, BlockPos pos, Random rand) {
        BiomeGenBase biome = world.func_180494_b(pos);
        if (biome instanceof BiomeGenDarkForest) {
            return super.areCoordsValidForGeneration(world, pos, rand) && this.getRarity(200);
        }
        return false;
    }

    @Override
    public int getStructureColor() {
        return 8860331;
    }

    @Override
    public Schematic getSchematicFor(World world, Random rand, BlockPos pos) {
        return new SchematicDarkHut(pos, this, world);
    }
}

