/*
 * Decompiled with CFR 0.152.
 */
package tragicneko.tragicmc.worldgen.structure;

import java.util.Random;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.biome.BiomeGenDesert;
import tragicneko.tragicmc.TragicConfig;
import tragicneko.tragicmc.worldgen.biome.BiomeGenDecayingWasteland;
import tragicneko.tragicmc.worldgen.schematic.Schematic;
import tragicneko.tragicmc.worldgen.schematic.SchematicClaymationRuin;
import tragicneko.tragicmc.worldgen.structure.Structure;

public class StructureClaymationRuin
extends Structure {
    public StructureClaymationRuin(int id, String name) {
        super(id, name, 5);
    }

    @Override
    public boolean isSurfaceStructure() {
        return true;
    }

    @Override
    public boolean isValidDimension(int dim) {
        return dim == 0 || dim == TragicConfig.getInt("collisionID");
    }

    @Override
    public boolean areCoordsValidForGeneration(World world, BlockPos pos, Random rand) {
        if (pos.func_177956_o() > 80) {
            return false;
        }
        BiomeGenBase biome = world.func_180494_b(pos);
        if (biome instanceof BiomeGenDesert || biome instanceof BiomeGenDecayingWasteland) {
            return super.areCoordsValidForGeneration(world, pos, rand) && this.getRarity(200);
        }
        return false;
    }

    @Override
    public int getStructureColor() {
        return 16744704;
    }

    @Override
    public Schematic getSchematicFor(World world, Random rand, BlockPos pos) {
        return new SchematicClaymationRuin(pos, this, world);
    }
}

