/*
 * Decompiled with CFR 0.152.
 */
package tragicneko.tragicmc.worldgen.structure;

import java.util.Random;
import net.minecraft.util.BlockPos;
import net.minecraft.util.RegistryNamespacedDefaultedByKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import tragicneko.tragicmc.TragicConfig;
import tragicneko.tragicmc.TragicMC;
import tragicneko.tragicmc.worldgen.schematic.Schematic;
import tragicneko.tragicmc.worldgen.structure.StructureApisTemple;
import tragicneko.tragicmc.worldgen.structure.StructureCelestialTemple;
import tragicneko.tragicmc.worldgen.structure.StructureClaymationRuin;
import tragicneko.tragicmc.worldgen.structure.StructureCorruptedSpire;
import tragicneko.tragicmc.worldgen.structure.StructureCubeMaze;
import tragicneko.tragicmc.worldgen.structure.StructureDarkHut;
import tragicneko.tragicmc.worldgen.structure.StructureDeathCircle;
import tragicneko.tragicmc.worldgen.structure.StructureEmpariahCave;
import tragicneko.tragicmc.worldgen.structure.StructureHackerNet;
import tragicneko.tragicmc.worldgen.structure.StructureKitsuneDen;
import tragicneko.tragicmc.worldgen.structure.StructureLightSpire;
import tragicneko.tragicmc.worldgen.structure.StructureMemoryCache;
import tragicneko.tragicmc.worldgen.structure.StructureNekoBarracks;
import tragicneko.tragicmc.worldgen.structure.StructureNekoHouse;
import tragicneko.tragicmc.worldgen.structure.StructureNekoTower;
import tragicneko.tragicmc.worldgen.structure.StructureNekoVillage;
import tragicneko.tragicmc.worldgen.structure.StructureNekoWarehouse;
import tragicneko.tragicmc.worldgen.structure.StructureNekoidsForwardBase;
import tragicneko.tragicmc.worldgen.structure.StructureNekoidsMansion;
import tragicneko.tragicmc.worldgen.structure.StructureObsidianCavern;
import tragicneko.tragicmc.worldgen.structure.StructureOutlook;
import tragicneko.tragicmc.worldgen.structure.StructureSoulTomb;
import tragicneko.tragicmc.worldgen.structure.StructureSpiderNest;
import tragicneko.tragicmc.worldgen.structure.StructureTimeAltar;
import tragicneko.tragicmc.worldgen.structure.StructureTower;

public abstract class Structure {
    protected final int height;
    public static final RegistryNamespacedDefaultedByKey<ResourceLocation, Structure> structureRegistry = new RegistryNamespacedDefaultedByKey((Object)new ResourceLocation("null"));
    public static Structure apisTemple = new StructureApisTemple(0, "apisTemple");
    public static Structure towerStructure = new StructureTower(1, "tower");
    public static Structure deathCircle = new StructureDeathCircle(2, "deathCircle");
    public static Structure obsidianCavern = new StructureObsidianCavern(3, "obsidianCavern");
    public static Structure kitsuneDen = new StructureKitsuneDen(4, "kitsuneDen");
    public static Structure celestialTemple = new StructureCelestialTemple(5, "celestialTemple");
    public static Structure timeAltar = new StructureTimeAltar(6, "timeAltar");
    public static Structure soulTomb = new StructureSoulTomb(7, "soulTomb");
    public static Structure corruptedSpire = new StructureCorruptedSpire(8, "corruptedSpire");
    public static Structure empariahCave = new StructureEmpariahCave(9, "empariahCave");
    public static Structure claymationRuin = new StructureClaymationRuin(10, "claymationRuin");
    public static Structure darkHut = new StructureDarkHut(11, "darkHut");
    public static Structure spiderNest = new StructureSpiderNest(12, "spiderNest");
    public static Structure memoryCache = new StructureMemoryCache(13, "memoryCache");
    public static Structure lightSpire = new StructureLightSpire(14, "lightSpire");
    public static Structure hackerNet = new StructureHackerNet(15, "hackerNet");
    public static Structure cubeMaze = new StructureCubeMaze(16, "cubeMaze");
    public static Structure outlook = new StructureOutlook(17, "outlook");
    public static Structure nekoBarracks = new StructureNekoBarracks(18, "nekoBarracks");
    public static Structure nekoWarehouse = new StructureNekoWarehouse(19, "nekoWarehouse");
    public static Structure nekoGuardTower = new StructureNekoTower(20, "nekoGuardTower");
    public static Structure nekoCottage = new StructureNekoHouse(21, "nekoCottage");
    public static Structure nekoVillage = new StructureNekoVillage(22, "nekoVillage");
    public static Structure nekoidsForwardBase = new StructureNekoidsForwardBase(23, "nekoidsForwardBase");
    public static Structure nekoidsMansion = new StructureNekoidsMansion(24, "nekoidsMansion");

    public Structure(int id, String s, int height) {
        ResourceLocation rl = new ResourceLocation("tragicmc:" + s);
        if (structureRegistry.func_148741_d((Object)rl)) {
            throw new IllegalArgumentException("There is a Structure using that name (" + rl + ") already!");
        }
        structureRegistry.func_177775_a(id, (Object)rl, (Object)this);
        this.height = height;
    }

    public boolean isSurfaceStructure() {
        return false;
    }

    public boolean isValidDimension(int dim) {
        return true;
    }

    public boolean areCoordsValidForGeneration(World world, BlockPos pos, Random rand) {
        return World.func_175683_a((IBlockAccess)world, (BlockPos)pos.func_177977_b()) && pos.func_177956_o() + this.height < world.field_73011_w.getActualHeight();
    }

    public boolean canGenerate() {
        return TragicConfig.structureAllow[this.getStructureId()];
    }

    public int getStructureId() {
        return structureRegistry.func_148757_b((Object)this);
    }

    public boolean getRarity(int compare) {
        return TragicMC.rand.nextInt(compare) <= TragicConfig.structureRarity[this.getStructureId()];
    }

    public int getHeight() {
        return this.height;
    }

    public Schematic generate(World world, Random rand, BlockPos pos) {
        if (!world.field_72995_K && this.canGenerate()) {
            try {
                Schematic sch = this.getSchematicFor(world, rand, pos);
                if (sch != null) {
                    sch = this.applySchematicTransformations(sch, world, rand, pos);
                    return (sch = sch.generateStructure(world, rand, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p())) != null ? sch.sortIntoList() : null;
                }
            }
            catch (Exception e) {
                TragicMC.logError("Schematic errored during generation. (" + this.getLocalizedName() + ")", e);
                return null;
            }
        }
        return null;
    }

    public Schematic applySchematicTransformations(Schematic sch, World world, Random rand, BlockPos pos) {
        return sch;
    }

    public String getLocalizedName() {
        return StatCollector.func_74838_a((String)("tile.tragicmc.structureSeed." + this.getUnlocalizedName() + ".name"));
    }

    public String getUnlocalizedName() {
        return ((ResourceLocation)structureRegistry.func_177774_c((Object)this)).func_110623_a();
    }

    public int getStructureColor() {
        return 0;
    }

    public static Structure getStructureById(int i) {
        return (Structure)structureRegistry.func_148754_a(i);
    }

    public static int getRegistrySize() {
        return structureRegistry.func_148742_b().size();
    }

    public abstract Schematic getSchematicFor(World var1, Random var2, BlockPos var3);
}

