/*
 * Decompiled with CFR 0.152.
 */
package tragicneko.tragicmc.worldgen.schematic;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;
import tragicneko.tragicmc.TragicBlocks;
import tragicneko.tragicmc.util.ChestHooks;
import tragicneko.tragicmc.util.WorldHelper;
import tragicneko.tragicmc.worldgen.schematic.Schematic;
import tragicneko.tragicmc.worldgen.structure.Structure;

public class SchematicNekoidsMansion
extends Schematic {
    private static final byte[] BIT_MASK_X = new byte[]{1, 0, 0, 1, 0, 0, 1, 0, 0, 1, 0, 0};
    private static final byte[] BIT_MASK_Z = new byte[]{0, 0, 1, 0, 0, 1, 0, 0, 1, 0, 0, 1, 0, 0, 1, 0, 1, 0, 0, 1, 0, 0, 1, 0, 0, 1, 0, 0, 1, 0, 0};

    public SchematicNekoidsMansion(BlockPos origin, Structure structure, World world) {
        super(origin, structure, world, 16, 24, 32);
    }

    /*
     * Opcode count of 14945 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    @Override
    public Schematic generateStructure(World world, Random rand, int x, int y, int z) {
        int x1;
        int z1;
        int y1;
        int z12;
        int x12;
        int z13;
        for (int b = 0; b < 16; b = (int)((byte)(b + 1))) {
            for (int b2 = -19; b2 < 12; b2 = (int)((byte)(b2 + 1))) {
                for (int b3 = -11; b3 < 12; b3 = (int)((byte)(b3 + 1))) {
                    this.setBlockToAir(world, x + b3, y + b, z + b2);
                }
            }
        }
        for (z13 = -19; z13 < 12; z13 = (int)((byte)(z13 + 1))) {
            for (x12 = -11; x12 < 12; x12 = (int)((byte)(x12 + 1))) {
                this.setBlock(world, new BlockPos(x + x12, y - 1, z + z13), TragicBlocks.NekoGrass.func_176203_a(0));
            }
        }
        for (z13 = -8; z13 < 9; z13 = (int)((byte)(z13 + 1))) {
            for (x12 = -8; x12 < 9; x12 = (int)((byte)(x12 + 1))) {
                this.setBlock(world, new BlockPos(x + x12, y - 1, z + z13), TragicBlocks.NekitePlate.func_176203_a(2));
            }
        }
        for (int x13 = -1; x13 < 2; x13 = (int)((byte)(x13 + 1))) {
            IBlockState state = TragicBlocks.NekitePlate.func_176203_a(x13 == 0 ? 2 : 1);
            for (z12 = -19; z12 < -8; z12 = (int)((byte)(z12 + 1))) {
                this.setBlock(world, new BlockPos(x + x13, y - 1, z + z12), state);
            }
        }
        for (int y12 = 0; y12 < 6; y12 = (int)((byte)(y12 + 1))) {
            int x14;
            IBlockState state2;
            IBlockState state = y12 < 4 ? TragicBlocks.NekitePlate.func_176203_a(2) : (y12 != 5 ? TragicBlocks.NekitePlate.func_176203_a(1) : TragicBlocks.NekiteWire.func_176203_a(0));
            for (z12 = -19; z12 < 12; z12 = (int)((byte)(z12 + 1))) {
                state2 = y12 == 0 && BIT_MASK_Z[z12 + 19] == 1 ? TragicBlocks.NekitePlate.func_176203_a(0) : state;
                this.setBlock(world, new BlockPos(x + 11, y + y12, z + z12), state2);
                this.setBlock(world, new BlockPos(x - 11, y + y12, z + z12), state2);
            }
            for (x14 = -11; x14 < 12; x14 = (int)((byte)(x14 + 1))) {
                state2 = y12 == 0 && BIT_MASK_X[Math.abs(x14)] == 1 ? TragicBlocks.NekitePlate.func_176203_a(0) : state;
                this.setBlock(world, new BlockPos(x + x14, y + y12, z + 11), state2);
                this.setBlock(world, new BlockPos(x + x14, y + y12, z - 19), state2);
            }
            for (x14 = -2; y12 < 3 && x14 < 3; x14 = (int)((byte)(x14 + 1))) {
                if (Math.abs(x14) == 2) {
                    this.setBlock(world, new BlockPos(x + x14, y + y12, z - 19), TragicBlocks.NekitePlate.func_176203_a(1));
                    continue;
                }
                this.setBlockToAir(world, x + x14, y + y12, z - 19);
            }
            for (x14 = -2; y12 == 3 && x14 < 3; x14 = (int)((byte)(x14 + 1))) {
                this.setBlock(world, new BlockPos(x + x14, y + y12, z - 19), TragicBlocks.NekitePlate.func_176203_a(1));
            }
        }
        int xTree = rand.nextInt(6) + 3;
        int n = rand.nextBoolean() ? 1 : -1;
        int zTree = rand.nextInt(6) - 16;
        int yTree = rand.nextInt(3) + 4;
        int xTree2 = rand.nextInt(6) + 3;
        xTree2 *= (xTree *= n) < 0 ? 1 : -1;
        int zTree2 = rand.nextInt(6) - 16;
        int yTree2 = rand.nextInt(3) + 4;
        ArrayList<BlockPos> list = WorldHelper.getBlocksInSphericalRange(world, 0.25 + (double)yTree / 3.0, new BlockPos((double)(x + xTree) + 0.5, (double)(y + yTree - 1), (double)(z + zTree) + 0.5));
        for (BlockPos pos : list) {
            this.setBlock(world, pos, TragicBlocks.NekowoodLeaves.func_176223_P().func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)BlockLeaves.field_176237_a, (Comparable)Boolean.valueOf(true)));
        }
        list = WorldHelper.getBlocksInSphericalRange(world, 0.25 + (double)yTree2 / 3.0, new BlockPos((double)(x + xTree2) + 0.5, (double)(y + yTree2 - 1), (double)(z + zTree2) + 0.5));
        for (BlockPos pos : list) {
            this.setBlock(world, pos, TragicBlocks.NekowoodLeaves.func_176223_P().func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)BlockLeaves.field_176237_a, (Comparable)Boolean.valueOf(true)));
        }
        for (y1 = 0; y1 < yTree; y1 = (int)((byte)(y1 + 1))) {
            this.setBlock(world, new BlockPos(x + xTree, y + y1, z + zTree), TragicBlocks.Nekowood.func_176203_a(0));
        }
        for (y1 = 0; y1 < yTree2; y1 = (int)((byte)(y1 + 1))) {
            this.setBlock(world, new BlockPos(x + xTree2, y + y1, z + zTree2), TragicBlocks.Nekowood.func_176203_a(0));
        }
        for (int meow = 0; meow < 12; meow = (int)((byte)(meow + 1))) {
            int randX = (rand.nextInt(7) + 3) * (rand.nextBoolean() ? 1 : -1);
            int randZ = rand.nextInt(7) - 16;
            if (randX == xTree || randZ == zTree || randX == xTree2 || randZ == zTree2) continue;
            this.setBlock(world, new BlockPos(x + randX, y, z + randZ), TragicBlocks.NekoBush.func_176223_P());
        }
        for (z1 = -8; z1 < 9; z1 = (int)((byte)(z1 + 1))) {
            this.setBlock(world, new BlockPos(x - 8, y, z + z1), TragicBlocks.NekitePlate.func_176203_a(1));
            this.setBlock(world, new BlockPos(x + 8, y, z + z1), TragicBlocks.NekitePlate.func_176203_a(1));
            this.setBlock(world, new BlockPos(x + z1, y, z + 8), TragicBlocks.NekitePlate.func_176203_a(1));
            this.setBlock(world, new BlockPos(x + z1, y, z - 8), TragicBlocks.NekitePlate.func_176203_a(1));
        }
        for (z1 = -6; z1 < 7; z1 = (int)((byte)(z1 + 1))) {
            this.setBlock(world, new BlockPos(x - 6, y, z + z1), TragicBlocks.NekitePlate.func_176203_a(1));
            this.setBlock(world, new BlockPos(x + 6, y, z + z1), TragicBlocks.NekitePlate.func_176203_a(1));
            this.setBlock(world, new BlockPos(x + z1, y, z + 6), TragicBlocks.NekitePlate.func_176203_a(1));
            this.setBlock(world, new BlockPos(x + z1, y, z - 6), TragicBlocks.NekitePlate.func_176203_a(1));
        }
        for (z1 = -9; z1 < -4; z1 = (int)((byte)(z1 + 1))) {
            this.setBlock(world, new BlockPos(x - 9, y, z + z1), TragicBlocks.NekitePlate.func_176203_a(1));
            this.setBlock(world, new BlockPos(x + 9, y, z + z1), TragicBlocks.NekitePlate.func_176203_a(1));
            this.setBlock(world, new BlockPos(x + z1, y, z + 9), TragicBlocks.NekitePlate.func_176203_a(1));
            this.setBlock(world, new BlockPos(x + z1, y, z - 9), TragicBlocks.NekitePlate.func_176203_a(1));
        }
        for (z1 = 5; z1 < 10; z1 = (int)((byte)(z1 + 1))) {
            this.setBlock(world, new BlockPos(x - 9, y, z + z1), TragicBlocks.NekitePlate.func_176203_a(1));
            this.setBlock(world, new BlockPos(x + 9, y, z + z1), TragicBlocks.NekitePlate.func_176203_a(1));
            this.setBlock(world, new BlockPos(x + z1, y, z + 9), TragicBlocks.NekitePlate.func_176203_a(1));
            this.setBlock(world, new BlockPos(x + z1, y, z - 9), TragicBlocks.NekitePlate.func_176203_a(1));
        }
        this.setBlockToAir(world, x, y, z - 8);
        this.setBlockToAir(world, x, y, z - 6);
        for (z1 = -5; z1 < -3; z1 = (int)((byte)(z1 + 1))) {
            this.setBlock(world, new BlockPos(x - 5, y, z + z1), TragicBlocks.NekitePlate.func_176203_a(1));
            this.setBlock(world, new BlockPos(x + 5, y, z + z1), TragicBlocks.NekitePlate.func_176203_a(1));
            this.setBlock(world, new BlockPos(x + z1, y, z + 5), TragicBlocks.NekitePlate.func_176203_a(1));
            this.setBlock(world, new BlockPos(x + z1, y, z - 5), TragicBlocks.NekitePlate.func_176203_a(1));
        }
        for (z1 = 4; z1 < 6; z1 = (int)((byte)(z1 + 1))) {
            this.setBlock(world, new BlockPos(x - 5, y, z + z1), TragicBlocks.NekitePlate.func_176203_a(1));
            this.setBlock(world, new BlockPos(x + 5, y, z + z1), TragicBlocks.NekitePlate.func_176203_a(1));
            this.setBlock(world, new BlockPos(x + z1, y, z + 5), TragicBlocks.NekitePlate.func_176203_a(1));
            this.setBlock(world, new BlockPos(x + z1, y, z - 5), TragicBlocks.NekitePlate.func_176203_a(1));
        }
        for (z1 = -1; z1 < 2; z1 = (int)((byte)(z1 + 1))) {
            for (int x15 = -1; x15 < 2; x15 = (int)((byte)(x15 + 1))) {
                this.setBlock(world, new BlockPos(x + x15, y - 1, z + z1), TragicBlocks.NekitePlate.func_176203_a(5));
            }
        }
        this.setBlock(world, new BlockPos(x + 2, y - 1, z), TragicBlocks.NekitePlate.func_176203_a(5));
        this.setBlock(world, new BlockPos(x - 2, y - 1, z), TragicBlocks.NekitePlate.func_176203_a(5));
        this.setBlock(world, new BlockPos(x, y - 1, z + 2), TragicBlocks.NekitePlate.func_176203_a(5));
        this.setBlock(world, new BlockPos(x, y - 1, z - 2), TragicBlocks.NekitePlate.func_176203_a(5));
        this.setBlock(world, new BlockPos(x + 2, y - 1, z + 1), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x - 2, y - 1, z + 1), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x + 2, y - 1, z - 1), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x - 2, y - 1, z - 1), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x + 1, y - 1, z + 2), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x - 1, y - 1, z + 2), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x + 1, y - 1, z - 2), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x - 1, y - 1, z - 2), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x + 3, y - 1, z), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x - 3, y - 1, z), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x, y - 1, z + 3), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x, y - 1, z - 3), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x, y - 1, z), TragicBlocks.NekitePlate.func_176203_a(0));
        this.setBlock(world, new BlockPos(x + 3, y, z - 7), TragicBlocks.NekitePlate.func_176203_a(2));
        this.setBlock(world, new BlockPos(x - 3, y, z - 7), TragicBlocks.NekitePlate.func_176203_a(2));
        this.setBlock(world, new BlockPos(x + 4, y, z + 4), Blocks.field_150474_ac.func_176203_a(0), "TragicMC.TragicNeko");
        this.setBlock(world, new BlockPos(x - 4, y, z + 4), Blocks.field_150474_ac.func_176203_a(0), "TragicMC.TragicNeko");
        this.setBlock(world, new BlockPos(x + 4, y, z - 4), Blocks.field_150474_ac.func_176203_a(0), "TragicMC.TragicNeko");
        this.setBlock(world, new BlockPos(x - 4, y, z - 4), Blocks.field_150474_ac.func_176203_a(0), "TragicMC.TragicNeko");
        this.setBlock(world, new BlockPos(x, y, z), TragicBlocks.SoulChest.func_176203_a(0), ChestHooks.rareHook);
        for (z1 = -8; z1 < 9; z1 = (int)((byte)(z1 + 1))) {
            this.setBlock(world, new BlockPos(x - 8, y + 1, z + z1), TragicBlocks.NekitePlate.func_176203_a(5));
            this.setBlock(world, new BlockPos(x + 8, y + 1, z + z1), TragicBlocks.NekitePlate.func_176203_a(5));
            this.setBlock(world, new BlockPos(x + z1, y + 1, z + 8), TragicBlocks.NekitePlate.func_176203_a(5));
            this.setBlock(world, new BlockPos(x + z1, y + 1, z - 8), TragicBlocks.NekitePlate.func_176203_a(5));
        }
        for (z1 = -6; z1 < 7; z1 = (int)((byte)(z1 + 1))) {
            this.setBlock(world, new BlockPos(x - 6, y + 1, z + z1), TragicBlocks.NekitePlate.func_176203_a(5));
            this.setBlock(world, new BlockPos(x + 6, y + 1, z + z1), TragicBlocks.NekitePlate.func_176203_a(5));
            this.setBlock(world, new BlockPos(x + z1, y + 1, z + 6), TragicBlocks.NekitePlate.func_176203_a(5));
            this.setBlock(world, new BlockPos(x + z1, y + 1, z - 6), TragicBlocks.NekitePlate.func_176203_a(5));
        }
        for (z1 = -8; z1 < -5; z1 = (int)((byte)(z1 + 1))) {
            this.setBlock(world, new BlockPos(x - 8, y + 1, z + z1), TragicBlocks.NekitePlate.func_176203_a(2));
            this.setBlock(world, new BlockPos(x + 8, y + 1, z + z1), TragicBlocks.NekitePlate.func_176203_a(2));
            this.setBlock(world, new BlockPos(x + z1, y + 1, z + 8), TragicBlocks.NekitePlate.func_176203_a(2));
            this.setBlock(world, new BlockPos(x + z1, y + 1, z - 8), TragicBlocks.NekitePlate.func_176203_a(2));
        }
        for (z1 = 6; z1 < 9; z1 = (int)((byte)(z1 + 1))) {
            this.setBlock(world, new BlockPos(x - 8, y + 1, z + z1), TragicBlocks.NekitePlate.func_176203_a(2));
            this.setBlock(world, new BlockPos(x + 8, y + 1, z + z1), TragicBlocks.NekitePlate.func_176203_a(2));
            this.setBlock(world, new BlockPos(x + z1, y + 1, z + 8), TragicBlocks.NekitePlate.func_176203_a(2));
            this.setBlock(world, new BlockPos(x + z1, y + 1, z - 8), TragicBlocks.NekitePlate.func_176203_a(2));
        }
        this.setBlockToAir(world, x, y + 1, z - 8);
        this.setBlockToAir(world, x, y + 1, z - 6);
        this.setBlock(world, new BlockPos(x + 1, y + 1, z - 8), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x - 1, y + 1, z - 8), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x + 1, y + 1, z - 6), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x - 1, y + 1, z - 6), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x + 5, y + 1, z + 8), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x - 5, y + 1, z + 8), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x + 5, y + 1, z - 8), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x - 5, y + 1, z - 8), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x + 8, y + 1, z + 5), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x - 8, y + 1, z + 5), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x + 8, y + 1, z - 5), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x - 8, y + 1, z - 5), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x + 5, y + 1, z + 5), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x - 5, y + 1, z + 5), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x + 5, y + 1, z - 5), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x - 5, y + 1, z - 5), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x + 9, y + 1, z + 9), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x - 9, y + 1, z + 9), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x + 9, y + 1, z - 9), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x - 9, y + 1, z - 9), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x + 5, y + 1, z + 9), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x - 5, y + 1, z + 9), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x + 5, y + 1, z - 9), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x - 5, y + 1, z - 9), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x + 9, y + 1, z + 5), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x - 9, y + 1, z + 5), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x + 9, y + 1, z - 5), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x - 9, y + 1, z - 5), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x + 4, y + 1, z - 7), TragicBlocks.NekitePlate.func_176203_a(2));
        this.setBlock(world, new BlockPos(x - 4, y + 1, z - 7), TragicBlocks.NekitePlate.func_176203_a(2));
        for (z1 = -8; z1 < 9; z1 = (int)((byte)(z1 + 1))) {
            this.setBlock(world, new BlockPos(x - 8, y + 2, z + z1), TragicBlocks.NekitePlate.func_176203_a(5));
            this.setBlock(world, new BlockPos(x + 8, y + 2, z + z1), TragicBlocks.NekitePlate.func_176203_a(5));
            this.setBlock(world, new BlockPos(x + z1, y + 2, z + 8), TragicBlocks.NekitePlate.func_176203_a(5));
            this.setBlock(world, new BlockPos(x + z1, y + 2, z - 8), TragicBlocks.NekitePlate.func_176203_a(5));
        }
        for (z1 = -6; z1 < 7; z1 = (int)((byte)(z1 + 1))) {
            this.setBlock(world, new BlockPos(x - 6, y + 2, z + z1), TragicBlocks.NekitePlate.func_176203_a(5));
            this.setBlock(world, new BlockPos(x + 6, y + 2, z + z1), TragicBlocks.NekitePlate.func_176203_a(5));
            this.setBlock(world, new BlockPos(x + z1, y + 2, z + 6), TragicBlocks.NekitePlate.func_176203_a(5));
            this.setBlock(world, new BlockPos(x + z1, y + 2, z - 6), TragicBlocks.NekitePlate.func_176203_a(5));
        }
        for (z1 = -8; z1 < -5; z1 = (int)((byte)(z1 + 1))) {
            int i = Math.abs(z1) == 7 ? 0 : 2;
            this.setBlock(world, new BlockPos(x - 8, y + 2, z + z1), TragicBlocks.NekitePlate.func_176203_a(i));
            this.setBlock(world, new BlockPos(x + 8, y + 2, z + z1), TragicBlocks.NekitePlate.func_176203_a(i));
            this.setBlock(world, new BlockPos(x + z1, y + 2, z + 8), TragicBlocks.NekitePlate.func_176203_a(i));
            this.setBlock(world, new BlockPos(x + z1, y + 2, z - 8), TragicBlocks.NekitePlate.func_176203_a(i));
        }
        for (z1 = 6; z1 < 9; z1 = (int)((byte)(z1 + 1))) {
            int i = Math.abs(z1) == 7 ? 0 : 2;
            this.setBlock(world, new BlockPos(x - 8, y + 2, z + z1), TragicBlocks.NekitePlate.func_176203_a(i));
            this.setBlock(world, new BlockPos(x + 8, y + 2, z + z1), TragicBlocks.NekitePlate.func_176203_a(i));
            this.setBlock(world, new BlockPos(x + z1, y + 2, z + 8), TragicBlocks.NekitePlate.func_176203_a(i));
            this.setBlock(world, new BlockPos(x + z1, y + 2, z - 8), TragicBlocks.NekitePlate.func_176203_a(i));
        }
        this.setBlock(world, new BlockPos(x + 1, y + 2, z - 8), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x - 1, y + 2, z - 8), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x + 1, y + 2, z - 6), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x - 1, y + 2, z - 6), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x, y + 2, z - 8), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x, y + 2, z - 6), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x + 5, y + 2, z + 8), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x - 5, y + 2, z + 8), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x + 5, y + 2, z - 8), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x - 5, y + 2, z - 8), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x + 8, y + 2, z + 5), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x - 8, y + 2, z + 5), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x + 8, y + 2, z - 5), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x - 8, y + 2, z - 5), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x + 5, y + 2, z + 5), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x - 5, y + 2, z + 5), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x + 5, y + 2, z - 5), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x - 5, y + 2, z - 5), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x + 9, y + 2, z + 9), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x - 9, y + 2, z + 9), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x + 9, y + 2, z - 9), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x - 9, y + 2, z - 9), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x + 5, y + 2, z + 9), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x - 5, y + 2, z + 9), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x + 5, y + 2, z - 9), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x - 5, y + 2, z - 9), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x + 9, y + 2, z + 5), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x - 9, y + 2, z + 5), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x + 9, y + 2, z - 5), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x - 9, y + 2, z - 5), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x + 5, y + 2, z - 7), TragicBlocks.NekitePlate.func_176203_a(2));
        this.setBlock(world, new BlockPos(x - 5, y + 2, z - 7), TragicBlocks.NekitePlate.func_176203_a(2));
        this.setBlock(world, new BlockPos(x + 1, y + 2, z - 7), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x, y + 2, z - 7), TragicBlocks.NekitePlate.func_176203_a(0));
        this.setBlock(world, new BlockPos(x - 1, y + 2, z - 7), TragicBlocks.NekitePlate.func_176203_a(1));
        for (z1 = -8; z1 < 9; z1 = (int)((byte)(z1 + 1))) {
            this.setBlock(world, new BlockPos(x - 8, y + 3, z + z1), TragicBlocks.NekitePlate.func_176203_a(5));
            this.setBlock(world, new BlockPos(x + 8, y + 3, z + z1), TragicBlocks.NekitePlate.func_176203_a(5));
            this.setBlock(world, new BlockPos(x + z1, y + 3, z + 8), TragicBlocks.NekitePlate.func_176203_a(5));
            this.setBlock(world, new BlockPos(x + z1, y + 3, z - 8), TragicBlocks.NekitePlate.func_176203_a(5));
        }
        for (z1 = -6; z1 < 7; z1 = (int)((byte)(z1 + 1))) {
            this.setBlock(world, new BlockPos(x - 6, y + 3, z + z1), TragicBlocks.NekitePlate.func_176203_a(5));
            this.setBlock(world, new BlockPos(x + 6, y + 3, z + z1), TragicBlocks.NekitePlate.func_176203_a(5));
            this.setBlock(world, new BlockPos(x + z1, y + 3, z + 6), TragicBlocks.NekitePlate.func_176203_a(5));
            this.setBlock(world, new BlockPos(x + z1, y + 3, z - 6), TragicBlocks.NekitePlate.func_176203_a(5));
        }
        for (z1 = -8; z1 < -5; z1 = (int)((byte)(z1 + 1))) {
            this.setBlock(world, new BlockPos(x - 8, y + 3, z + z1), TragicBlocks.NekitePlate.func_176203_a(2));
            this.setBlock(world, new BlockPos(x + 8, y + 3, z + z1), TragicBlocks.NekitePlate.func_176203_a(2));
            this.setBlock(world, new BlockPos(x + z1, y + 3, z + 8), TragicBlocks.NekitePlate.func_176203_a(2));
            this.setBlock(world, new BlockPos(x + z1, y + 3, z - 8), TragicBlocks.NekitePlate.func_176203_a(2));
        }
        for (z1 = 6; z1 < 9; z1 = (int)((byte)(z1 + 1))) {
            this.setBlock(world, new BlockPos(x - 8, y + 3, z + z1), TragicBlocks.NekitePlate.func_176203_a(2));
            this.setBlock(world, new BlockPos(x + 8, y + 3, z + z1), TragicBlocks.NekitePlate.func_176203_a(2));
            this.setBlock(world, new BlockPos(x + z1, y + 3, z + 8), TragicBlocks.NekitePlate.func_176203_a(2));
            this.setBlock(world, new BlockPos(x + z1, y + 3, z - 8), TragicBlocks.NekitePlate.func_176203_a(2));
        }
        this.setBlock(world, new BlockPos(x + 5, y + 3, z + 8), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x - 5, y + 3, z + 8), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x + 5, y + 3, z - 8), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x - 5, y + 3, z - 8), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x + 8, y + 3, z + 5), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x - 8, y + 3, z + 5), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x + 8, y + 3, z - 5), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x - 8, y + 3, z - 5), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x + 5, y + 3, z + 5), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x - 5, y + 3, z + 5), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x + 5, y + 3, z - 5), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x - 5, y + 3, z - 5), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x + 9, y + 3, z + 9), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x - 9, y + 3, z + 9), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x + 9, y + 3, z - 9), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x - 9, y + 3, z - 9), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x + 5, y + 3, z + 9), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x - 5, y + 3, z + 9), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x + 5, y + 3, z - 9), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x - 5, y + 3, z - 9), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x + 9, y + 3, z + 5), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x - 9, y + 3, z + 5), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x + 9, y + 3, z - 5), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x - 9, y + 3, z - 5), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x + 6, y + 3, z - 7), TragicBlocks.NekitePlate.func_176203_a(2));
        this.setBlock(world, new BlockPos(x - 6, y + 3, z - 7), TragicBlocks.NekitePlate.func_176203_a(2));
        this.setBlock(world, new BlockPos(x + 6, y + 3, z + 7), TragicBlocks.NekitePlate.func_176203_a(2));
        this.setBlock(world, new BlockPos(x - 6, y + 3, z + 7), TragicBlocks.NekitePlate.func_176203_a(2));
        this.setBlock(world, new BlockPos(x + 7, y + 3, z - 6), TragicBlocks.NekitePlate.func_176203_a(2));
        this.setBlock(world, new BlockPos(x - 7, y + 3, z - 6), TragicBlocks.NekitePlate.func_176203_a(2));
        this.setBlock(world, new BlockPos(x + 7, y + 3, z + 6), TragicBlocks.NekitePlate.func_176203_a(2));
        this.setBlock(world, new BlockPos(x - 7, y + 3, z + 6), TragicBlocks.NekitePlate.func_176203_a(2));
        this.setBlock(world, new BlockPos(x + 7, y + 3, z - 7), TragicBlocks.NekitePlate.func_176203_a(2));
        this.setBlock(world, new BlockPos(x - 7, y + 3, z - 7), TragicBlocks.NekitePlate.func_176203_a(2));
        this.setBlock(world, new BlockPos(x + 7, y + 3, z + 7), TragicBlocks.NekitePlate.func_176203_a(2));
        this.setBlock(world, new BlockPos(x - 7, y + 3, z + 7), TragicBlocks.NekitePlate.func_176203_a(2));
        for (x1 = -2; x1 < 3; x1 = (int)((byte)(x1 + 1))) {
            this.setBlock(world, new BlockPos(x + x1, y + 3, z - 7), TragicBlocks.NekitePlate.func_176203_a(1));
            this.setBlock(world, new BlockPos(x + x1, y + 3, z - 8), TragicBlocks.NekitePlate.func_176203_a(1));
            this.setBlock(world, new BlockPos(x + x1, y + 3, z + 7), TragicBlocks.NekitePlate.func_176203_a(1));
            this.setBlock(world, new BlockPos(x + x1, y + 3, z + 8), TragicBlocks.NekitePlate.func_176203_a(1));
            this.setBlock(world, new BlockPos(x + 7, y + 3, z + x1), TragicBlocks.NekitePlate.func_176203_a(1));
            this.setBlock(world, new BlockPos(x + 8, y + 3, z + x1), TragicBlocks.NekitePlate.func_176203_a(1));
            this.setBlock(world, new BlockPos(x - 7, y + 3, z + x1), TragicBlocks.NekitePlate.func_176203_a(1));
            this.setBlock(world, new BlockPos(x - 8, y + 3, z + x1), TragicBlocks.NekitePlate.func_176203_a(1));
        }
        this.setBlock(world, new BlockPos(x, y + 3, z - 8), TragicBlocks.NekitePlate.func_176203_a(4));
        for (z1 = -5; z1 < 6; z1 = (int)((byte)(z1 + 1))) {
            this.setBlock(world, new BlockPos(x - 7, y + 3, z + z1), TragicBlocks.NekitePlate.func_176203_a(5));
            this.setBlock(world, new BlockPos(x + 7, y + 3, z + z1), TragicBlocks.NekitePlate.func_176203_a(5));
            this.setBlock(world, new BlockPos(x + z1, y + 3, z + 7), TragicBlocks.NekitePlate.func_176203_a(5));
        }
        this.setBlock(world, new BlockPos(x + 6, y + 3, z + 5), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x - 6, y + 3, z + 5), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x + 6, y + 3, z - 5), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x - 6, y + 3, z - 5), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x + 5, y + 3, z + 6), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x - 5, y + 3, z + 6), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x + 5, y + 3, z - 6), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x - 5, y + 3, z - 6), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x + 6, y + 3, z + 6), TragicBlocks.NekitePlate.func_176203_a(2));
        this.setBlock(world, new BlockPos(x - 6, y + 3, z + 6), TragicBlocks.NekitePlate.func_176203_a(2));
        this.setBlock(world, new BlockPos(x + 6, y + 3, z - 6), TragicBlocks.NekitePlate.func_176203_a(2));
        this.setBlock(world, new BlockPos(x - 6, y + 3, z - 6), TragicBlocks.NekitePlate.func_176203_a(2));
        for (z1 = -5; z1 < 6; z1 = (int)((byte)(z1 + 1))) {
            this.setBlock(world, new BlockPos(x - 5, y + 3, z + z1), TragicBlocks.NekitePlate.func_176203_a(5));
            this.setBlock(world, new BlockPos(x + 5, y + 3, z + z1), TragicBlocks.NekitePlate.func_176203_a(5));
            this.setBlock(world, new BlockPos(x + z1, y + 3, z + 5), TragicBlocks.NekitePlate.func_176203_a(5));
            this.setBlock(world, new BlockPos(x + z1, y + 3, z - 5), TragicBlocks.NekitePlate.func_176203_a(5));
        }
        for (z1 = -5; z1 < -3; z1 = (int)((byte)(z1 + 1))) {
            this.setBlock(world, new BlockPos(x - 5, y + 3, z + z1), TragicBlocks.NekitePlate.func_176203_a(1));
            this.setBlock(world, new BlockPos(x + 5, y + 3, z + z1), TragicBlocks.NekitePlate.func_176203_a(1));
            this.setBlock(world, new BlockPos(x + z1, y + 3, z + 5), TragicBlocks.NekitePlate.func_176203_a(1));
            this.setBlock(world, new BlockPos(x + z1, y + 3, z - 5), TragicBlocks.NekitePlate.func_176203_a(1));
        }
        for (z1 = 4; z1 < 6; z1 = (int)((byte)(z1 + 1))) {
            this.setBlock(world, new BlockPos(x - 5, y + 3, z + z1), TragicBlocks.NekitePlate.func_176203_a(1));
            this.setBlock(world, new BlockPos(x + 5, y + 3, z + z1), TragicBlocks.NekitePlate.func_176203_a(1));
            this.setBlock(world, new BlockPos(x + z1, y + 3, z + 5), TragicBlocks.NekitePlate.func_176203_a(1));
            this.setBlock(world, new BlockPos(x + z1, y + 3, z - 5), TragicBlocks.NekitePlate.func_176203_a(1));
        }
        for (z1 = -9; z1 < -4; z1 = (int)((byte)(z1 + 1))) {
            this.setBlock(world, new BlockPos(x - 9, y + 4, z + z1), TragicBlocks.NekitePlate.func_176203_a(1));
            this.setBlock(world, new BlockPos(x + 9, y + 4, z + z1), TragicBlocks.NekitePlate.func_176203_a(1));
            this.setBlock(world, new BlockPos(x + z1, y + 4, z + 9), TragicBlocks.NekitePlate.func_176203_a(1));
            this.setBlock(world, new BlockPos(x + z1, y + 4, z - 9), TragicBlocks.NekitePlate.func_176203_a(1));
        }
        for (z1 = 5; z1 < 10; z1 = (int)((byte)(z1 + 1))) {
            this.setBlock(world, new BlockPos(x - 9, y + 4, z + z1), TragicBlocks.NekitePlate.func_176203_a(1));
            this.setBlock(world, new BlockPos(x + 9, y + 4, z + z1), TragicBlocks.NekitePlate.func_176203_a(1));
            this.setBlock(world, new BlockPos(x + z1, y + 4, z + 9), TragicBlocks.NekitePlate.func_176203_a(1));
            this.setBlock(world, new BlockPos(x + z1, y + 4, z - 9), TragicBlocks.NekitePlate.func_176203_a(1));
        }
        for (z1 = -5; z1 < -1; z1 = (int)((byte)(z1 + 1))) {
            this.setBlock(world, new BlockPos(x - 8, y + 4, z + z1), TragicBlocks.NekitePlate.func_176203_a(1));
            this.setBlock(world, new BlockPos(x + 8, y + 4, z + z1), TragicBlocks.NekitePlate.func_176203_a(1));
            this.setBlock(world, new BlockPos(x + z1, y + 4, z + 8), TragicBlocks.NekitePlate.func_176203_a(1));
            this.setBlock(world, new BlockPos(x + z1, y + 4, z - 8), TragicBlocks.NekitePlate.func_176203_a(1));
        }
        for (z1 = 2; z1 < 6; z1 = (int)((byte)(z1 + 1))) {
            this.setBlock(world, new BlockPos(x - 8, y + 4, z + z1), TragicBlocks.NekitePlate.func_176203_a(1));
            this.setBlock(world, new BlockPos(x + 8, y + 4, z + z1), TragicBlocks.NekitePlate.func_176203_a(1));
            this.setBlock(world, new BlockPos(x + z1, y + 4, z + 8), TragicBlocks.NekitePlate.func_176203_a(1));
            this.setBlock(world, new BlockPos(x + z1, y + 4, z - 8), TragicBlocks.NekitePlate.func_176203_a(1));
        }
        for (z1 = -4; z1 < 5; z1 = (int)((byte)(z1 + 1))) {
            this.setBlock(world, new BlockPos(x - 4, y + 4, z + z1), TragicBlocks.NekitePlate.func_176203_a(1));
            this.setBlock(world, new BlockPos(x + 4, y + 4, z + z1), TragicBlocks.NekitePlate.func_176203_a(1));
            this.setBlock(world, new BlockPos(x + z1, y + 4, z + 4), TragicBlocks.NekitePlate.func_176203_a(1));
            this.setBlock(world, new BlockPos(x + z1, y + 4, z - 4), TragicBlocks.NekitePlate.func_176203_a(1));
        }
        this.setBlock(world, new BlockPos(x + 5, y + 4, z + 5), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x - 5, y + 4, z + 5), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x + 5, y + 4, z - 5), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x - 5, y + 4, z - 5), TragicBlocks.NekitePlate.func_176203_a(1));
        for (x1 = -2; x1 < 3; x1 = (int)((byte)(x1 + 1))) {
            int i = Math.abs(x1) < 2 ? 2 : 1;
            this.setBlock(world, new BlockPos(x + x1, y + 4, z - 7), TragicBlocks.NekitePlate.func_176203_a(i));
            this.setBlock(world, new BlockPos(x + x1, y + 4, z + 7), TragicBlocks.NekitePlate.func_176203_a(i));
            this.setBlock(world, new BlockPos(x + 7, y + 4, z + x1), TragicBlocks.NekitePlate.func_176203_a(i));
            this.setBlock(world, new BlockPos(x - 7, y + 4, z + x1), TragicBlocks.NekitePlate.func_176203_a(i));
        }
        for (z1 = -8; z1 < -5; z1 = (int)((byte)(z1 + 1))) {
            this.setBlock(world, new BlockPos(x - 8, y + 4, z + z1), TragicBlocks.NekitePlate.func_176203_a(2));
            this.setBlock(world, new BlockPos(x + 8, y + 4, z + z1), TragicBlocks.NekitePlate.func_176203_a(2));
            this.setBlock(world, new BlockPos(x + z1, y + 4, z + 8), TragicBlocks.NekitePlate.func_176203_a(2));
            this.setBlock(world, new BlockPos(x + z1, y + 4, z - 8), TragicBlocks.NekitePlate.func_176203_a(2));
        }
        for (z1 = 6; z1 < 9; z1 = (int)((byte)(z1 + 1))) {
            this.setBlock(world, new BlockPos(x - 8, y + 4, z + z1), TragicBlocks.NekitePlate.func_176203_a(2));
            this.setBlock(world, new BlockPos(x + 8, y + 4, z + z1), TragicBlocks.NekitePlate.func_176203_a(2));
            this.setBlock(world, new BlockPos(x + z1, y + 4, z + 8), TragicBlocks.NekitePlate.func_176203_a(2));
            this.setBlock(world, new BlockPos(x + z1, y + 4, z - 8), TragicBlocks.NekitePlate.func_176203_a(2));
        }
        this.setBlock(world, new BlockPos(x + 7, y + 4, z + 7), TragicBlocks.NekitePlate.func_176203_a(2));
        this.setBlock(world, new BlockPos(x - 7, y + 4, z + 7), TragicBlocks.NekitePlate.func_176203_a(2));
        for (z1 = -5; z1 < -1; z1 = (int)((byte)(z1 + 1))) {
            int i = z1 == -5 || z1 == -2 ? 1 : 5;
            this.setBlock(world, new BlockPos(x - 8, y + 5, z + z1), TragicBlocks.NekitePlate.func_176203_a(i));
            this.setBlock(world, new BlockPos(x + 8, y + 5, z + z1), TragicBlocks.NekitePlate.func_176203_a(i));
            this.setBlock(world, new BlockPos(x + z1, y + 5, z + 8), TragicBlocks.NekitePlate.func_176203_a(i));
            this.setBlock(world, new BlockPos(x + z1, y + 5, z - 8), TragicBlocks.NekitePlate.func_176203_a(i));
        }
        for (z1 = 2; z1 < 6; z1 = (int)((byte)(z1 + 1))) {
            int i = z1 == 2 || z1 == 5 ? 1 : 5;
            this.setBlock(world, new BlockPos(x - 8, y + 5, z + z1), TragicBlocks.NekitePlate.func_176203_a(i));
            this.setBlock(world, new BlockPos(x + 8, y + 5, z + z1), TragicBlocks.NekitePlate.func_176203_a(i));
            this.setBlock(world, new BlockPos(x + z1, y + 5, z + 8), TragicBlocks.NekitePlate.func_176203_a(i));
            this.setBlock(world, new BlockPos(x + z1, y + 5, z - 8), TragicBlocks.NekitePlate.func_176203_a(i));
        }
        this.setBlock(world, new BlockPos(x + 5, y + 5, z + 5), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x - 5, y + 5, z + 5), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x + 5, y + 5, z - 5), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x - 5, y + 5, z - 5), TragicBlocks.NekitePlate.func_176203_a(1));
        for (x1 = -2; x1 < 3; x1 = (int)((byte)(x1 + 1))) {
            int i = Math.abs(x1) < 2 ? (x1 == 0 ? 0 : 2) : 1;
            this.setBlock(world, new BlockPos(x + x1, y + 5, z - 7), TragicBlocks.NekitePlate.func_176203_a(i));
            this.setBlock(world, new BlockPos(x + x1, y + 5, z + 7), TragicBlocks.NekitePlate.func_176203_a(i));
            this.setBlock(world, new BlockPos(x + 7, y + 5, z + x1), TragicBlocks.NekitePlate.func_176203_a(i));
            this.setBlock(world, new BlockPos(x - 7, y + 5, z + x1), TragicBlocks.NekitePlate.func_176203_a(i));
        }
        for (z1 = -8; z1 < -5; z1 = (int)((byte)(z1 + 1))) {
            this.setBlock(world, new BlockPos(x - 8, y + 5, z + z1), TragicBlocks.NekitePlate.func_176203_a(2));
            this.setBlock(world, new BlockPos(x + 8, y + 5, z + z1), TragicBlocks.NekitePlate.func_176203_a(2));
            this.setBlock(world, new BlockPos(x + z1, y + 5, z + 8), TragicBlocks.NekitePlate.func_176203_a(2));
            this.setBlock(world, new BlockPos(x + z1, y + 5, z - 8), TragicBlocks.NekitePlate.func_176203_a(2));
        }
        for (z1 = 6; z1 < 9; z1 = (int)((byte)(z1 + 1))) {
            this.setBlock(world, new BlockPos(x - 8, y + 5, z + z1), TragicBlocks.NekitePlate.func_176203_a(2));
            this.setBlock(world, new BlockPos(x + 8, y + 5, z + z1), TragicBlocks.NekitePlate.func_176203_a(2));
            this.setBlock(world, new BlockPos(x + z1, y + 5, z + 8), TragicBlocks.NekitePlate.func_176203_a(2));
            this.setBlock(world, new BlockPos(x + z1, y + 5, z - 8), TragicBlocks.NekitePlate.func_176203_a(2));
        }
        this.setBlock(world, new BlockPos(x + 9, y + 5, z + 9), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x - 9, y + 5, z + 9), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x + 9, y + 5, z - 9), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x - 9, y + 5, z - 9), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x + 5, y + 5, z + 9), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x - 5, y + 5, z + 9), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x + 5, y + 5, z - 9), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x - 5, y + 5, z - 9), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x + 9, y + 5, z + 5), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x - 9, y + 5, z + 5), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x + 9, y + 5, z - 5), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x - 9, y + 5, z - 5), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x + 6, y + 5, z + 7), TragicBlocks.NekitePlate.func_176203_a(2));
        this.setBlock(world, new BlockPos(x - 6, y + 5, z + 7), TragicBlocks.NekitePlate.func_176203_a(2));
        for (z1 = -5; z1 < -1; z1 = (int)((byte)(z1 + 1))) {
            int i = z1 == -5 || z1 == -2 ? 1 : 5;
            this.setBlock(world, new BlockPos(x - 8, y + 6, z + z1), TragicBlocks.NekitePlate.func_176203_a(i));
            this.setBlock(world, new BlockPos(x + 8, y + 6, z + z1), TragicBlocks.NekitePlate.func_176203_a(i));
            this.setBlock(world, new BlockPos(x + z1, y + 6, z + 8), TragicBlocks.NekitePlate.func_176203_a(i));
            this.setBlock(world, new BlockPos(x + z1, y + 6, z - 8), TragicBlocks.NekitePlate.func_176203_a(i));
        }
        for (z1 = 2; z1 < 6; z1 = (int)((byte)(z1 + 1))) {
            int i = z1 == 2 || z1 == 5 ? 1 : 5;
            this.setBlock(world, new BlockPos(x - 8, y + 6, z + z1), TragicBlocks.NekitePlate.func_176203_a(i));
            this.setBlock(world, new BlockPos(x + 8, y + 6, z + z1), TragicBlocks.NekitePlate.func_176203_a(i));
            this.setBlock(world, new BlockPos(x + z1, y + 6, z + 8), TragicBlocks.NekitePlate.func_176203_a(i));
            this.setBlock(world, new BlockPos(x + z1, y + 6, z - 8), TragicBlocks.NekitePlate.func_176203_a(i));
        }
        this.setBlock(world, new BlockPos(x + 5, y + 6, z + 5), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x - 5, y + 6, z + 5), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x + 5, y + 6, z - 5), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x - 5, y + 6, z - 5), TragicBlocks.NekitePlate.func_176203_a(1));
        for (x1 = -2; x1 < 3; x1 = (int)((byte)(x1 + 1))) {
            int i = Math.abs(x1) < 2 ? (x1 == 0 ? 0 : 2) : 1;
            this.setBlock(world, new BlockPos(x + x1, y + 6, z - 7), TragicBlocks.NekitePlate.func_176203_a(i));
            this.setBlock(world, new BlockPos(x + x1, y + 6, z + 7), TragicBlocks.NekitePlate.func_176203_a(i));
            this.setBlock(world, new BlockPos(x + 7, y + 6, z + x1), TragicBlocks.NekitePlate.func_176203_a(i));
            this.setBlock(world, new BlockPos(x - 7, y + 6, z + x1), TragicBlocks.NekitePlate.func_176203_a(i));
        }
        for (z1 = -8; z1 < -5; z1 = (int)((byte)(z1 + 1))) {
            int i = z1 == -7 ? 0 : 2;
            this.setBlock(world, new BlockPos(x - 8, y + 6, z + z1), TragicBlocks.NekitePlate.func_176203_a(i));
            this.setBlock(world, new BlockPos(x + 8, y + 6, z + z1), TragicBlocks.NekitePlate.func_176203_a(i));
            this.setBlock(world, new BlockPos(x + z1, y + 6, z + 8), TragicBlocks.NekitePlate.func_176203_a(i));
            this.setBlock(world, new BlockPos(x + z1, y + 6, z - 8), TragicBlocks.NekitePlate.func_176203_a(i));
        }
        for (z1 = 6; z1 < 9; z1 = (int)((byte)(z1 + 1))) {
            int i = z1 == 7 ? 0 : 2;
            this.setBlock(world, new BlockPos(x - 8, y + 6, z + z1), TragicBlocks.NekitePlate.func_176203_a(i));
            this.setBlock(world, new BlockPos(x + 8, y + 6, z + z1), TragicBlocks.NekitePlate.func_176203_a(i));
            this.setBlock(world, new BlockPos(x + z1, y + 6, z + 8), TragicBlocks.NekitePlate.func_176203_a(i));
            this.setBlock(world, new BlockPos(x + z1, y + 6, z - 8), TragicBlocks.NekitePlate.func_176203_a(i));
        }
        this.setBlock(world, new BlockPos(x + 9, y + 6, z + 9), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x - 9, y + 6, z + 9), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x + 9, y + 6, z - 9), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x - 9, y + 6, z - 9), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x + 5, y + 6, z + 9), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x - 5, y + 6, z + 9), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x + 5, y + 6, z - 9), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x - 5, y + 6, z - 9), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x + 9, y + 6, z + 5), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x - 9, y + 6, z + 5), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x + 9, y + 6, z - 5), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x - 9, y + 6, z - 5), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x + 6, y + 6, z + 6), TragicBlocks.NekitePlate.func_176203_a(2));
        this.setBlock(world, new BlockPos(x - 6, y + 6, z + 6), TragicBlocks.NekitePlate.func_176203_a(2));
        for (z1 = -5; z1 < -1; z1 = (int)((byte)(z1 + 1))) {
            this.setBlock(world, new BlockPos(x - 8, y + 7, z + z1), TragicBlocks.NekitePlate.func_176203_a(1));
            this.setBlock(world, new BlockPos(x + 8, y + 7, z + z1), TragicBlocks.NekitePlate.func_176203_a(1));
            this.setBlock(world, new BlockPos(x + z1, y + 7, z + 8), TragicBlocks.NekitePlate.func_176203_a(1));
            this.setBlock(world, new BlockPos(x + z1, y + 7, z - 8), TragicBlocks.NekitePlate.func_176203_a(1));
        }
        for (z1 = 2; z1 < 6; z1 = (int)((byte)(z1 + 1))) {
            this.setBlock(world, new BlockPos(x - 8, y + 7, z + z1), TragicBlocks.NekitePlate.func_176203_a(1));
            this.setBlock(world, new BlockPos(x + 8, y + 7, z + z1), TragicBlocks.NekitePlate.func_176203_a(1));
            this.setBlock(world, new BlockPos(x + z1, y + 7, z + 8), TragicBlocks.NekitePlate.func_176203_a(1));
            this.setBlock(world, new BlockPos(x + z1, y + 7, z - 8), TragicBlocks.NekitePlate.func_176203_a(1));
        }
        for (x1 = -2; x1 < 3; x1 = (int)((byte)(x1 + 1))) {
            int i = Math.abs(x1) < 2 ? 2 : 1;
            this.setBlock(world, new BlockPos(x + x1, y + 7, z - 7), TragicBlocks.NekitePlate.func_176203_a(i));
            this.setBlock(world, new BlockPos(x + x1, y + 7, z + 7), TragicBlocks.NekitePlate.func_176203_a(i));
            this.setBlock(world, new BlockPos(x + 7, y + 7, z + x1), TragicBlocks.NekitePlate.func_176203_a(i));
            this.setBlock(world, new BlockPos(x - 7, y + 7, z + x1), TragicBlocks.NekitePlate.func_176203_a(i));
        }
        for (z1 = -8; z1 < -5; z1 = (int)((byte)(z1 + 1))) {
            this.setBlock(world, new BlockPos(x - 8, y + 7, z + z1), TragicBlocks.NekitePlate.func_176203_a(2));
            this.setBlock(world, new BlockPos(x + 8, y + 7, z + z1), TragicBlocks.NekitePlate.func_176203_a(2));
            this.setBlock(world, new BlockPos(x + z1, y + 7, z + 8), TragicBlocks.NekitePlate.func_176203_a(2));
            this.setBlock(world, new BlockPos(x + z1, y + 7, z - 8), TragicBlocks.NekitePlate.func_176203_a(2));
        }
        for (z1 = 6; z1 < 9; z1 = (int)((byte)(z1 + 1))) {
            this.setBlock(world, new BlockPos(x - 8, y + 7, z + z1), TragicBlocks.NekitePlate.func_176203_a(2));
            this.setBlock(world, new BlockPos(x + 8, y + 7, z + z1), TragicBlocks.NekitePlate.func_176203_a(2));
            this.setBlock(world, new BlockPos(x + z1, y + 7, z + 8), TragicBlocks.NekitePlate.func_176203_a(2));
            this.setBlock(world, new BlockPos(x + z1, y + 7, z - 8), TragicBlocks.NekitePlate.func_176203_a(2));
        }
        this.setBlock(world, new BlockPos(x + 9, y + 7, z + 9), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x - 9, y + 7, z + 9), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x + 9, y + 7, z - 9), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x - 9, y + 7, z - 9), TragicBlocks.NekitePlate.func_176203_a(1));
        for (z1 = -7; z1 < -2; z1 = (int)((byte)(z1 + 1))) {
            this.setBlock(world, new BlockPos(x + 6, y + 7, z + z1), TragicBlocks.NekitePlate.func_176203_a(2));
            this.setBlock(world, new BlockPos(x + 7, y + 7, z + z1), TragicBlocks.NekitePlate.func_176203_a(2));
            this.setBlock(world, new BlockPos(x - 6, y + 7, z + z1), TragicBlocks.NekitePlate.func_176203_a(2));
            this.setBlock(world, new BlockPos(x - 7, y + 7, z + z1), TragicBlocks.NekitePlate.func_176203_a(2));
            this.setBlock(world, new BlockPos(x + z1, y + 7, z + 6), TragicBlocks.NekitePlate.func_176203_a(2));
            this.setBlock(world, new BlockPos(x + z1, y + 7, z + 7), TragicBlocks.NekitePlate.func_176203_a(2));
            this.setBlock(world, new BlockPos(x + z1, y + 7, z - 6), TragicBlocks.NekitePlate.func_176203_a(2));
            this.setBlock(world, new BlockPos(x + z1, y + 7, z - 7), TragicBlocks.NekitePlate.func_176203_a(2));
        }
        for (z1 = 3; z1 < 8; z1 = (int)((byte)(z1 + 1))) {
            this.setBlock(world, new BlockPos(x + 6, y + 7, z + z1), TragicBlocks.NekitePlate.func_176203_a(2));
            this.setBlock(world, new BlockPos(x + 7, y + 7, z + z1), TragicBlocks.NekitePlate.func_176203_a(2));
            this.setBlock(world, new BlockPos(x - 6, y + 7, z + z1), TragicBlocks.NekitePlate.func_176203_a(2));
            this.setBlock(world, new BlockPos(x - 7, y + 7, z + z1), TragicBlocks.NekitePlate.func_176203_a(2));
            this.setBlock(world, new BlockPos(x + z1, y + 7, z + 6), TragicBlocks.NekitePlate.func_176203_a(2));
            this.setBlock(world, new BlockPos(x + z1, y + 7, z + 7), TragicBlocks.NekitePlate.func_176203_a(2));
            this.setBlock(world, new BlockPos(x + z1, y + 7, z - 6), TragicBlocks.NekitePlate.func_176203_a(2));
            this.setBlock(world, new BlockPos(x + z1, y + 7, z - 7), TragicBlocks.NekitePlate.func_176203_a(2));
        }
        for (z1 = -9; z1 < -1; z1 = (int)((byte)(z1 + 1))) {
            this.setBlock(world, new BlockPos(x + 5, y + 7, z + z1), TragicBlocks.NekitePlate.func_176203_a(1));
            this.setBlock(world, new BlockPos(x - 5, y + 7, z + z1), TragicBlocks.NekitePlate.func_176203_a(1));
            this.setBlock(world, new BlockPos(x + z1, y + 7, z + 5), TragicBlocks.NekitePlate.func_176203_a(1));
            this.setBlock(world, new BlockPos(x + z1, y + 7, z - 5), TragicBlocks.NekitePlate.func_176203_a(1));
        }
        for (z1 = 2; z1 < 10; z1 = (int)((byte)(z1 + 1))) {
            this.setBlock(world, new BlockPos(x + 5, y + 7, z + z1), TragicBlocks.NekitePlate.func_176203_a(1));
            this.setBlock(world, new BlockPos(x - 5, y + 7, z + z1), TragicBlocks.NekitePlate.func_176203_a(1));
            this.setBlock(world, new BlockPos(x + z1, y + 7, z + 5), TragicBlocks.NekitePlate.func_176203_a(1));
            this.setBlock(world, new BlockPos(x + z1, y + 7, z - 5), TragicBlocks.NekitePlate.func_176203_a(1));
        }
        this.setBlock(world, new BlockPos(x + 6, y + 7, z - 2), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x - 6, y + 7, z - 2), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x + 6, y + 7, z + 2), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x - 6, y + 7, z + 2), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x + 2, y + 7, z - 6), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x - 2, y + 7, z - 6), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x + 2, y + 7, z + 6), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x - 2, y + 7, z + 6), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlockToAir(world, x + 7, y + 7, z + 7);
        this.setBlockToAir(world, x - 7, y + 7, z + 7);
        this.setBlockToAir(world, x + 6, y + 7, z + 7);
        this.setBlockToAir(world, x - 6, y + 7, z + 7);
        this.setBlockToAir(world, x + 6, y + 7, z + 6);
        this.setBlockToAir(world, x - 6, y + 7, z + 6);
        for (z1 = -9; z1 < -4; z1 = (int)((byte)(z1 + 1))) {
            this.setBlock(world, new BlockPos(x - 9, y + 8, z + z1), TragicBlocks.NekitePlate.func_176203_a(1));
            this.setBlock(world, new BlockPos(x + 9, y + 8, z + z1), TragicBlocks.NekitePlate.func_176203_a(1));
            this.setBlock(world, new BlockPos(x + z1, y + 8, z + 9), TragicBlocks.NekitePlate.func_176203_a(1));
            this.setBlock(world, new BlockPos(x + z1, y + 8, z - 9), TragicBlocks.NekitePlate.func_176203_a(1));
        }
        for (z1 = 5; z1 < 10; z1 = (int)((byte)(z1 + 1))) {
            this.setBlock(world, new BlockPos(x - 9, y + 8, z + z1), TragicBlocks.NekitePlate.func_176203_a(1));
            this.setBlock(world, new BlockPos(x + 9, y + 8, z + z1), TragicBlocks.NekitePlate.func_176203_a(1));
            this.setBlock(world, new BlockPos(x + z1, y + 8, z + 9), TragicBlocks.NekitePlate.func_176203_a(1));
            this.setBlock(world, new BlockPos(x + z1, y + 8, z - 9), TragicBlocks.NekitePlate.func_176203_a(1));
        }
        for (z1 = -8; z1 < -5; z1 = (int)((byte)(z1 + 1))) {
            this.setBlock(world, new BlockPos(x - 8, y + 8, z + z1), TragicBlocks.NekitePlate.func_176203_a(2));
            this.setBlock(world, new BlockPos(x + 8, y + 8, z + z1), TragicBlocks.NekitePlate.func_176203_a(2));
            this.setBlock(world, new BlockPos(x + z1, y + 8, z + 8), TragicBlocks.NekitePlate.func_176203_a(2));
            this.setBlock(world, new BlockPos(x + z1, y + 8, z - 8), TragicBlocks.NekitePlate.func_176203_a(2));
        }
        for (z1 = 6; z1 < 9; z1 = (int)((byte)(z1 + 1))) {
            this.setBlock(world, new BlockPos(x - 8, y + 8, z + z1), TragicBlocks.NekitePlate.func_176203_a(2));
            this.setBlock(world, new BlockPos(x + 8, y + 8, z + z1), TragicBlocks.NekitePlate.func_176203_a(2));
            this.setBlock(world, new BlockPos(x + z1, y + 8, z + 8), TragicBlocks.NekitePlate.func_176203_a(2));
            this.setBlock(world, new BlockPos(x + z1, y + 8, z - 8), TragicBlocks.NekitePlate.func_176203_a(2));
        }
        for (x1 = -2; x1 < 3; x1 = (int)((byte)(x1 + 1))) {
            this.setBlock(world, new BlockPos(x + x1, y + 8, z - 5), TragicBlocks.NekitePlate.func_176203_a(1));
            this.setBlock(world, new BlockPos(x + x1, y + 8, z - 8), TragicBlocks.NekitePlate.func_176203_a(1));
            this.setBlock(world, new BlockPos(x + x1, y + 8, z + 5), TragicBlocks.NekitePlate.func_176203_a(1));
            this.setBlock(world, new BlockPos(x + x1, y + 8, z + 8), TragicBlocks.NekitePlate.func_176203_a(1));
            this.setBlock(world, new BlockPos(x + 5, y + 8, z + x1), TragicBlocks.NekitePlate.func_176203_a(1));
            this.setBlock(world, new BlockPos(x + 8, y + 8, z + x1), TragicBlocks.NekitePlate.func_176203_a(1));
            this.setBlock(world, new BlockPos(x - 5, y + 8, z + x1), TragicBlocks.NekitePlate.func_176203_a(1));
            this.setBlock(world, new BlockPos(x - 8, y + 8, z + x1), TragicBlocks.NekitePlate.func_176203_a(1));
        }
        this.setBlock(world, new BlockPos(x + 5, y + 8, z + 5), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x - 5, y + 8, z + 5), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x + 5, y + 8, z - 5), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x - 5, y + 8, z - 5), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x + 8, y + 8, z + 5), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x - 8, y + 8, z + 5), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x + 8, y + 8, z - 5), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x - 8, y + 8, z - 5), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x + 5, y + 8, z + 8), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x - 5, y + 8, z + 8), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x + 5, y + 8, z - 8), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x - 5, y + 8, z - 8), TragicBlocks.NekitePlate.func_176203_a(1));
        for (x1 = -5; x1 < 6; x1 = (int)((byte)(x1 + 1))) {
            this.setBlock(world, new BlockPos(x + x1, y + 8, z - 6), TragicBlocks.NekitePlate.func_176203_a(2));
            this.setBlock(world, new BlockPos(x + x1, y + 8, z - 7), TragicBlocks.NekitePlate.func_176203_a(2));
            this.setBlock(world, new BlockPos(x - 6, y + 8, z + x1), TragicBlocks.NekitePlate.func_176203_a(2));
            this.setBlock(world, new BlockPos(x - 7, y + 8, z + x1), TragicBlocks.NekitePlate.func_176203_a(2));
            this.setBlock(world, new BlockPos(x + x1, y + 8, z + 6), TragicBlocks.NekitePlate.func_176203_a(2));
            this.setBlock(world, new BlockPos(x + x1, y + 8, z + 7), TragicBlocks.NekitePlate.func_176203_a(2));
            this.setBlock(world, new BlockPos(x + 6, y + 8, z + x1), TragicBlocks.NekitePlate.func_176203_a(2));
            this.setBlock(world, new BlockPos(x + 7, y + 8, z + x1), TragicBlocks.NekitePlate.func_176203_a(2));
        }
        for (z1 = -9; z1 < -4; z1 = (int)((byte)(z1 + 1))) {
            this.setBlock(world, new BlockPos(x - 9, y + 9, z + z1), TragicBlocks.NekitePlate.func_176203_a(5));
            this.setBlock(world, new BlockPos(x + 9, y + 9, z + z1), TragicBlocks.NekitePlate.func_176203_a(5));
            this.setBlock(world, new BlockPos(x + z1, y + 9, z + 9), TragicBlocks.NekitePlate.func_176203_a(5));
            this.setBlock(world, new BlockPos(x + z1, y + 9, z - 9), TragicBlocks.NekitePlate.func_176203_a(5));
        }
        for (z1 = 5; z1 < 10; z1 = (int)((byte)(z1 + 1))) {
            this.setBlock(world, new BlockPos(x - 9, y + 9, z + z1), TragicBlocks.NekitePlate.func_176203_a(5));
            this.setBlock(world, new BlockPos(x + 9, y + 9, z + z1), TragicBlocks.NekitePlate.func_176203_a(5));
            this.setBlock(world, new BlockPos(x + z1, y + 9, z + 9), TragicBlocks.NekitePlate.func_176203_a(5));
            this.setBlock(world, new BlockPos(x + z1, y + 9, z - 9), TragicBlocks.NekitePlate.func_176203_a(5));
        }
        this.setBlock(world, new BlockPos(x + 9, y + 9, z + 9), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x - 9, y + 9, z + 9), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x + 9, y + 9, z - 9), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x - 9, y + 9, z - 9), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x + 5, y + 9, z + 9), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x - 5, y + 9, z + 9), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x + 5, y + 9, z - 9), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x - 5, y + 9, z - 9), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x + 9, y + 9, z + 5), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x - 9, y + 9, z + 5), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x + 9, y + 9, z - 5), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x - 9, y + 9, z - 5), TragicBlocks.NekitePlate.func_176203_a(1));
        for (z1 = -8; z1 < -5; z1 = (int)((byte)(z1 + 1))) {
            this.setBlock(world, new BlockPos(x - 8, y + 9, z + z1), TragicBlocks.NekitePlate.func_176203_a(2));
            this.setBlock(world, new BlockPos(x + 8, y + 9, z + z1), TragicBlocks.NekitePlate.func_176203_a(2));
            this.setBlock(world, new BlockPos(x + z1, y + 9, z + 8), TragicBlocks.NekitePlate.func_176203_a(2));
            this.setBlock(world, new BlockPos(x + z1, y + 9, z - 8), TragicBlocks.NekitePlate.func_176203_a(2));
        }
        for (z1 = 6; z1 < 9; z1 = (int)((byte)(z1 + 1))) {
            this.setBlock(world, new BlockPos(x - 8, y + 9, z + z1), TragicBlocks.NekitePlate.func_176203_a(2));
            this.setBlock(world, new BlockPos(x + 8, y + 9, z + z1), TragicBlocks.NekitePlate.func_176203_a(2));
            this.setBlock(world, new BlockPos(x + z1, y + 9, z + 8), TragicBlocks.NekitePlate.func_176203_a(2));
            this.setBlock(world, new BlockPos(x + z1, y + 9, z - 8), TragicBlocks.NekitePlate.func_176203_a(2));
        }
        for (x1 = -2; x1 < 3; x1 = (int)((byte)(x1 + 1))) {
            this.setBlock(world, new BlockPos(x + x1, y + 9, z - 5), TragicBlocks.NekitePlate.func_176203_a(1));
            this.setBlock(world, new BlockPos(x + x1, y + 9, z + 5), TragicBlocks.NekitePlate.func_176203_a(1));
            this.setBlock(world, new BlockPos(x + 5, y + 9, z + x1), TragicBlocks.NekitePlate.func_176203_a(1));
            this.setBlock(world, new BlockPos(x - 5, y + 9, z + x1), TragicBlocks.NekitePlate.func_176203_a(1));
        }
        this.setBlock(world, new BlockPos(x + 5, y + 9, z + 5), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x - 5, y + 9, z + 5), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x + 5, y + 9, z - 5), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x - 5, y + 9, z - 5), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x + 8, y + 9, z + 5), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x - 8, y + 9, z + 5), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x + 8, y + 9, z - 5), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x - 8, y + 9, z - 5), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x + 5, y + 9, z + 8), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x - 5, y + 9, z + 8), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x + 5, y + 9, z - 8), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x - 5, y + 9, z - 8), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x + 8, y + 9, z + 4), TragicBlocks.NekitePlate.func_176203_a(0));
        this.setBlock(world, new BlockPos(x - 8, y + 9, z + 4), TragicBlocks.NekitePlate.func_176203_a(0));
        this.setBlock(world, new BlockPos(x + 8, y + 9, z - 4), TragicBlocks.NekitePlate.func_176203_a(0));
        this.setBlock(world, new BlockPos(x - 8, y + 9, z - 4), TragicBlocks.NekitePlate.func_176203_a(0));
        this.setBlock(world, new BlockPos(x + 4, y + 9, z + 8), TragicBlocks.NekitePlate.func_176203_a(0));
        this.setBlock(world, new BlockPos(x - 4, y + 9, z + 8), TragicBlocks.NekitePlate.func_176203_a(0));
        this.setBlock(world, new BlockPos(x + 4, y + 9, z - 8), TragicBlocks.NekitePlate.func_176203_a(0));
        this.setBlock(world, new BlockPos(x - 4, y + 9, z - 8), TragicBlocks.NekitePlate.func_176203_a(0));
        for (x1 = -7; x1 < 8; x1 = (int)((byte)(x1 + 1))) {
            this.setBlock(world, new BlockPos(x + x1, y + 9, z - 6), TragicBlocks.NekitePlate.func_176203_a(2));
            this.setBlock(world, new BlockPos(x + x1, y + 9, z - 7), TragicBlocks.NekitePlate.func_176203_a(2));
            this.setBlock(world, new BlockPos(x - 6, y + 9, z + x1), TragicBlocks.NekitePlate.func_176203_a(2));
            this.setBlock(world, new BlockPos(x - 7, y + 9, z + x1), TragicBlocks.NekitePlate.func_176203_a(2));
            this.setBlock(world, new BlockPos(x + x1, y + 9, z + 6), TragicBlocks.NekitePlate.func_176203_a(2));
            this.setBlock(world, new BlockPos(x + x1, y + 9, z + 7), TragicBlocks.NekitePlate.func_176203_a(2));
            this.setBlock(world, new BlockPos(x + 6, y + 9, z + x1), TragicBlocks.NekitePlate.func_176203_a(2));
            this.setBlock(world, new BlockPos(x + 7, y + 9, z + x1), TragicBlocks.NekitePlate.func_176203_a(2));
        }
        this.setBlock(world, new BlockPos(x + 7, y + 9, z + 7), TragicBlocks.NekitePlate.func_176203_a(0));
        this.setBlock(world, new BlockPos(x - 7, y + 9, z + 7), TragicBlocks.NekitePlate.func_176203_a(0));
        this.setBlock(world, new BlockPos(x + 7, y + 9, z - 7), TragicBlocks.NekitePlate.func_176203_a(0));
        this.setBlock(world, new BlockPos(x - 7, y + 9, z - 7), TragicBlocks.NekitePlate.func_176203_a(0));
        for (x1 = -2; x1 < 3; x1 = (int)((byte)(x1 + 1))) {
            for (int z14 = -4; z14 < 5; z14 = (int)((byte)(z14 + 1))) {
                this.setBlock(world, new BlockPos(x + x1, y + 9, z + z14), TragicBlocks.NekitePlate.func_176203_a(2));
                this.setBlock(world, new BlockPos(x + z14, y + 9, z + x1), TragicBlocks.NekitePlate.func_176203_a(2));
            }
        }
        this.setBlock(world, new BlockPos(x + 3, y + 9, z + 3), TragicBlocks.NekitePlate.func_176203_a(0));
        this.setBlock(world, new BlockPos(x - 3, y + 9, z + 3), TragicBlocks.NekitePlate.func_176203_a(0));
        this.setBlock(world, new BlockPos(x + 3, y + 9, z - 3), TragicBlocks.NekitePlate.func_176203_a(0));
        this.setBlock(world, new BlockPos(x - 3, y + 9, z - 3), TragicBlocks.NekitePlate.func_176203_a(0));
        this.setBlockToAir(world, x + 6, y + 9, z + 6);
        this.setBlockToAir(world, x + 7, y + 9, z + 6);
        this.setBlockToAir(world, x + 8, y + 9, z + 6);
        this.setBlockToAir(world, x - 6, y + 9, z + 6);
        this.setBlockToAir(world, x - 7, y + 9, z + 6);
        this.setBlockToAir(world, x - 8, y + 9, z + 6);
        this.setBlock(world, new BlockPos(x, y + 9, z), TragicBlocks.NekitePlate.func_176203_a(5));
        this.setBlock(world, new BlockPos(x + 1, y + 9, z), TragicBlocks.NekitePlate.func_176203_a(0));
        this.setBlock(world, new BlockPos(x - 1, y + 9, z), TragicBlocks.NekitePlate.func_176203_a(0));
        this.setBlock(world, new BlockPos(x + 2, y + 9, z), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x - 2, y + 9, z), TragicBlocks.NekitePlate.func_176203_a(1));
        for (x1 = -1; x1 < 2; x1 = (int)((byte)(x1 + 1))) {
            this.setBlock(world, new BlockPos(x + x1, y + 9, z + 1), TragicBlocks.NekitePlate.func_176203_a(1));
            this.setBlock(world, new BlockPos(x + x1, y + 9, z - 1), TragicBlocks.NekitePlate.func_176203_a(1));
        }
        for (z1 = -9; z1 < -4; z1 = (int)((byte)(z1 + 1))) {
            this.setBlock(world, new BlockPos(x - 9, y + 10, z + z1), TragicBlocks.NekitePlate.func_176203_a(5));
            this.setBlock(world, new BlockPos(x + 9, y + 10, z + z1), TragicBlocks.NekitePlate.func_176203_a(5));
            this.setBlock(world, new BlockPos(x + z1, y + 10, z + 9), TragicBlocks.NekitePlate.func_176203_a(5));
            this.setBlock(world, new BlockPos(x + z1, y + 10, z - 9), TragicBlocks.NekitePlate.func_176203_a(5));
        }
        for (z1 = 5; z1 < 10; z1 = (int)((byte)(z1 + 1))) {
            this.setBlock(world, new BlockPos(x - 9, y + 10, z + z1), TragicBlocks.NekitePlate.func_176203_a(5));
            this.setBlock(world, new BlockPos(x + 9, y + 10, z + z1), TragicBlocks.NekitePlate.func_176203_a(5));
            this.setBlock(world, new BlockPos(x + z1, y + 10, z + 9), TragicBlocks.NekitePlate.func_176203_a(5));
            this.setBlock(world, new BlockPos(x + z1, y + 10, z - 9), TragicBlocks.NekitePlate.func_176203_a(5));
        }
        this.setBlock(world, new BlockPos(x + 9, y + 10, z + 7), TragicBlocks.NekitePlate.func_176203_a(4));
        this.setBlock(world, new BlockPos(x - 9, y + 10, z + 7), TragicBlocks.NekitePlate.func_176203_a(4));
        this.setBlock(world, new BlockPos(x + 9, y + 10, z - 7), TragicBlocks.NekitePlate.func_176203_a(4));
        this.setBlock(world, new BlockPos(x - 9, y + 10, z - 7), TragicBlocks.NekitePlate.func_176203_a(4));
        this.setBlock(world, new BlockPos(x + 7, y + 10, z + 9), TragicBlocks.NekitePlate.func_176203_a(4));
        this.setBlock(world, new BlockPos(x - 7, y + 10, z + 9), TragicBlocks.NekitePlate.func_176203_a(4));
        this.setBlock(world, new BlockPos(x + 7, y + 10, z - 9), TragicBlocks.NekitePlate.func_176203_a(4));
        this.setBlock(world, new BlockPos(x - 7, y + 10, z - 9), TragicBlocks.NekitePlate.func_176203_a(4));
        this.setBlock(world, new BlockPos(x + 9, y + 10, z + 9), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x - 9, y + 10, z + 9), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x + 9, y + 10, z - 9), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x - 9, y + 10, z - 9), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x + 5, y + 10, z + 9), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x - 5, y + 10, z + 9), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x + 5, y + 10, z - 9), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x - 5, y + 10, z - 9), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x + 9, y + 10, z + 5), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x - 9, y + 10, z + 5), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x + 9, y + 10, z - 5), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x - 9, y + 10, z - 5), TragicBlocks.NekitePlate.func_176203_a(1));
        for (x1 = -2; x1 < 3; x1 = (int)((byte)(x1 + 1))) {
            this.setBlock(world, new BlockPos(x + x1, y + 10, z - 5), TragicBlocks.NekitePlate.func_176203_a(1));
            this.setBlock(world, new BlockPos(x + x1, y + 10, z + 5), TragicBlocks.NekitePlate.func_176203_a(1));
            this.setBlock(world, new BlockPos(x + x1, y + 10, z - 8), TragicBlocks.NekitePlate.func_176203_a(1));
            this.setBlock(world, new BlockPos(x + x1, y + 10, z + 8), TragicBlocks.NekitePlate.func_176203_a(1));
            this.setBlock(world, new BlockPos(x + 5, y + 10, z + x1), TragicBlocks.NekitePlate.func_176203_a(1));
            this.setBlock(world, new BlockPos(x - 5, y + 10, z + x1), TragicBlocks.NekitePlate.func_176203_a(1));
            this.setBlock(world, new BlockPos(x + 8, y + 10, z + x1), TragicBlocks.NekitePlate.func_176203_a(1));
            this.setBlock(world, new BlockPos(x - 8, y + 10, z + x1), TragicBlocks.NekitePlate.func_176203_a(1));
        }
        for (x1 = -5; x1 < -2; x1 = (int)((byte)(x1 + 1))) {
            for (int z15 = -5; z15 < -2; z15 = (int)((byte)(z15 + 1))) {
                this.setBlock(world, new BlockPos(x + x1, y + 10, z + z15), TragicBlocks.NekitePlate.func_176203_a(5));
                this.setBlock(world, new BlockPos(x - x1, y + 10, z + z15), TragicBlocks.NekitePlate.func_176203_a(5));
                this.setBlock(world, new BlockPos(x + x1, y + 10, z - z15), TragicBlocks.NekitePlate.func_176203_a(5));
                this.setBlock(world, new BlockPos(x - x1, y + 10, z - z15), TragicBlocks.NekitePlate.func_176203_a(5));
            }
        }
        this.setBlock(world, new BlockPos(x + 5, y + 10, z + 5), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x - 5, y + 10, z + 5), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x + 5, y + 10, z - 5), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x - 5, y + 10, z - 5), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x + 8, y + 10, z + 5), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x - 8, y + 10, z + 5), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x + 8, y + 10, z - 5), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x - 8, y + 10, z - 5), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x + 5, y + 10, z + 8), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x - 5, y + 10, z + 8), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x + 5, y + 10, z - 8), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x - 5, y + 10, z - 8), TragicBlocks.NekitePlate.func_176203_a(1));
        for (x1 = -4; x1 < 5; x1 = (int)((byte)(x1 + 1))) {
            this.setBlock(world, new BlockPos(x + x1, y + 10, z - 6), TragicBlocks.NekitePlate.func_176203_a(2));
            this.setBlock(world, new BlockPos(x + x1, y + 10, z - 7), TragicBlocks.NekitePlate.func_176203_a(2));
            this.setBlock(world, new BlockPos(x - 6, y + 10, z + x1), TragicBlocks.NekitePlate.func_176203_a(2));
            this.setBlock(world, new BlockPos(x - 7, y + 10, z + x1), TragicBlocks.NekitePlate.func_176203_a(2));
            this.setBlock(world, new BlockPos(x + x1, y + 10, z + 6), TragicBlocks.NekitePlate.func_176203_a(2));
            this.setBlock(world, new BlockPos(x + x1, y + 10, z + 7), TragicBlocks.NekitePlate.func_176203_a(2));
            this.setBlock(world, new BlockPos(x + 6, y + 10, z + x1), TragicBlocks.NekitePlate.func_176203_a(2));
            this.setBlock(world, new BlockPos(x + 7, y + 10, z + x1), TragicBlocks.NekitePlate.func_176203_a(2));
        }
        for (x1 = -1; x1 < 2; x1 = (int)((byte)(x1 + 1))) {
            this.setBlock(world, new BlockPos(x + x1, y + 10, z - 6), TragicBlocks.NekitePlate.func_176203_a(0));
            this.setBlock(world, new BlockPos(x + x1, y + 10, z - 7), TragicBlocks.NekitePlate.func_176203_a(0));
            this.setBlock(world, new BlockPos(x - 6, y + 10, z + x1), TragicBlocks.NekitePlate.func_176203_a(0));
            this.setBlock(world, new BlockPos(x - 7, y + 10, z + x1), TragicBlocks.NekitePlate.func_176203_a(0));
            this.setBlock(world, new BlockPos(x + x1, y + 10, z + 6), TragicBlocks.NekitePlate.func_176203_a(0));
            this.setBlock(world, new BlockPos(x + x1, y + 10, z + 7), TragicBlocks.NekitePlate.func_176203_a(0));
            this.setBlock(world, new BlockPos(x + 6, y + 10, z + x1), TragicBlocks.NekitePlate.func_176203_a(0));
            this.setBlock(world, new BlockPos(x + 7, y + 10, z + x1), TragicBlocks.NekitePlate.func_176203_a(0));
        }
        this.setBlock(world, new BlockPos(x, y + 10, z), TragicBlocks.SummonBlock.func_176203_a(11));
        for (z1 = -9; z1 < -4; z1 = (int)((byte)(z1 + 1))) {
            this.setBlock(world, new BlockPos(x - 9, y + 11, z + z1), TragicBlocks.NekitePlate.func_176203_a(5));
            this.setBlock(world, new BlockPos(x + 9, y + 11, z + z1), TragicBlocks.NekitePlate.func_176203_a(5));
            this.setBlock(world, new BlockPos(x + z1, y + 11, z + 9), TragicBlocks.NekitePlate.func_176203_a(5));
            this.setBlock(world, new BlockPos(x + z1, y + 11, z - 9), TragicBlocks.NekitePlate.func_176203_a(5));
        }
        for (z1 = 5; z1 < 10; z1 = (int)((byte)(z1 + 1))) {
            this.setBlock(world, new BlockPos(x - 9, y + 11, z + z1), TragicBlocks.NekitePlate.func_176203_a(5));
            this.setBlock(world, new BlockPos(x + 9, y + 11, z + z1), TragicBlocks.NekitePlate.func_176203_a(5));
            this.setBlock(world, new BlockPos(x + z1, y + 11, z + 9), TragicBlocks.NekitePlate.func_176203_a(5));
            this.setBlock(world, new BlockPos(x + z1, y + 11, z - 9), TragicBlocks.NekitePlate.func_176203_a(5));
        }
        this.setBlock(world, new BlockPos(x + 9, y + 11, z + 7), TragicBlocks.NekitePlate.func_176203_a(4));
        this.setBlock(world, new BlockPos(x - 9, y + 11, z + 7), TragicBlocks.NekitePlate.func_176203_a(4));
        this.setBlock(world, new BlockPos(x + 9, y + 11, z - 7), TragicBlocks.NekitePlate.func_176203_a(4));
        this.setBlock(world, new BlockPos(x - 9, y + 11, z - 7), TragicBlocks.NekitePlate.func_176203_a(4));
        this.setBlock(world, new BlockPos(x + 7, y + 11, z + 9), TragicBlocks.NekitePlate.func_176203_a(4));
        this.setBlock(world, new BlockPos(x - 7, y + 11, z + 9), TragicBlocks.NekitePlate.func_176203_a(4));
        this.setBlock(world, new BlockPos(x + 7, y + 11, z - 9), TragicBlocks.NekitePlate.func_176203_a(4));
        this.setBlock(world, new BlockPos(x - 7, y + 11, z - 9), TragicBlocks.NekitePlate.func_176203_a(4));
        this.setBlock(world, new BlockPos(x + 9, y + 11, z + 9), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x - 9, y + 11, z + 9), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x + 9, y + 11, z - 9), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x - 9, y + 11, z - 9), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x + 5, y + 11, z + 9), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x - 5, y + 11, z + 9), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x + 5, y + 11, z - 9), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x - 5, y + 11, z - 9), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x + 9, y + 11, z + 5), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x - 9, y + 11, z + 5), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x + 9, y + 11, z - 5), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x - 9, y + 11, z - 5), TragicBlocks.NekitePlate.func_176203_a(1));
        for (x1 = -5; x1 < -1; x1 = (int)((byte)(x1 + 1))) {
            this.setBlock(world, new BlockPos(x + x1, y + 11, z - 5), TragicBlocks.NekitePlate.func_176203_a(1));
            this.setBlock(world, new BlockPos(x + x1, y + 11, z + 5), TragicBlocks.NekitePlate.func_176203_a(1));
            this.setBlock(world, new BlockPos(x + x1, y + 11, z - 8), TragicBlocks.NekitePlate.func_176203_a(1));
            this.setBlock(world, new BlockPos(x + x1, y + 11, z + 8), TragicBlocks.NekitePlate.func_176203_a(1));
            this.setBlock(world, new BlockPos(x + 5, y + 11, z + x1), TragicBlocks.NekitePlate.func_176203_a(1));
            this.setBlock(world, new BlockPos(x - 5, y + 11, z + x1), TragicBlocks.NekitePlate.func_176203_a(1));
            this.setBlock(world, new BlockPos(x + 8, y + 11, z + x1), TragicBlocks.NekitePlate.func_176203_a(1));
            this.setBlock(world, new BlockPos(x - 8, y + 11, z + x1), TragicBlocks.NekitePlate.func_176203_a(1));
        }
        for (x1 = 2; x1 < 6; x1 = (int)((byte)(x1 + 1))) {
            this.setBlock(world, new BlockPos(x + x1, y + 11, z - 5), TragicBlocks.NekitePlate.func_176203_a(1));
            this.setBlock(world, new BlockPos(x + x1, y + 11, z + 5), TragicBlocks.NekitePlate.func_176203_a(1));
            this.setBlock(world, new BlockPos(x + x1, y + 11, z - 8), TragicBlocks.NekitePlate.func_176203_a(1));
            this.setBlock(world, new BlockPos(x + x1, y + 11, z + 8), TragicBlocks.NekitePlate.func_176203_a(1));
            this.setBlock(world, new BlockPos(x + 5, y + 11, z + x1), TragicBlocks.NekitePlate.func_176203_a(1));
            this.setBlock(world, new BlockPos(x - 5, y + 11, z + x1), TragicBlocks.NekitePlate.func_176203_a(1));
            this.setBlock(world, new BlockPos(x + 8, y + 11, z + x1), TragicBlocks.NekitePlate.func_176203_a(1));
            this.setBlock(world, new BlockPos(x - 8, y + 11, z + x1), TragicBlocks.NekitePlate.func_176203_a(1));
        }
        for (z1 = -9; z1 < -4; z1 = (int)((byte)(z1 + 1))) {
            this.setBlock(world, new BlockPos(x - 9, y + 12, z + z1), TragicBlocks.NekitePlate.func_176203_a(5));
            this.setBlock(world, new BlockPos(x + 9, y + 12, z + z1), TragicBlocks.NekitePlate.func_176203_a(5));
            this.setBlock(world, new BlockPos(x + z1, y + 12, z + 9), TragicBlocks.NekitePlate.func_176203_a(5));
            this.setBlock(world, new BlockPos(x + z1, y + 12, z - 9), TragicBlocks.NekitePlate.func_176203_a(5));
        }
        for (z1 = 5; z1 < 10; z1 = (int)((byte)(z1 + 1))) {
            this.setBlock(world, new BlockPos(x - 9, y + 12, z + z1), TragicBlocks.NekitePlate.func_176203_a(5));
            this.setBlock(world, new BlockPos(x + 9, y + 12, z + z1), TragicBlocks.NekitePlate.func_176203_a(5));
            this.setBlock(world, new BlockPos(x + z1, y + 12, z + 9), TragicBlocks.NekitePlate.func_176203_a(5));
            this.setBlock(world, new BlockPos(x + z1, y + 12, z - 9), TragicBlocks.NekitePlate.func_176203_a(5));
        }
        this.setBlock(world, new BlockPos(x + 9, y + 12, z + 9), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x - 9, y + 12, z + 9), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x + 9, y + 12, z - 9), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x - 9, y + 12, z - 9), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x + 5, y + 12, z + 9), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x - 5, y + 12, z + 9), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x + 5, y + 12, z - 9), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x - 5, y + 12, z - 9), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x + 9, y + 12, z + 5), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x - 9, y + 12, z + 5), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x + 9, y + 12, z - 5), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x - 9, y + 12, z - 5), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x + 5, y + 12, z + 5), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x - 5, y + 12, z + 5), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x + 5, y + 12, z - 5), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x - 5, y + 12, z - 5), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x + 8, y + 12, z + 5), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x - 8, y + 12, z + 5), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x + 8, y + 12, z - 5), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x - 8, y + 12, z - 5), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x + 5, y + 12, z + 8), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x - 5, y + 12, z + 8), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x + 5, y + 12, z - 8), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x - 5, y + 12, z - 8), TragicBlocks.NekitePlate.func_176203_a(1));
        for (z1 = -9; z1 < -4; z1 = (int)((byte)(z1 + 1))) {
            this.setBlock(world, new BlockPos(x - 9, y + 13, z + z1), TragicBlocks.NekitePlate.func_176203_a(1));
            this.setBlock(world, new BlockPos(x + 9, y + 13, z + z1), TragicBlocks.NekitePlate.func_176203_a(1));
            this.setBlock(world, new BlockPos(x + z1, y + 13, z + 9), TragicBlocks.NekitePlate.func_176203_a(1));
            this.setBlock(world, new BlockPos(x + z1, y + 13, z - 9), TragicBlocks.NekitePlate.func_176203_a(1));
            this.setBlock(world, new BlockPos(x - 5, y + 13, z + z1), TragicBlocks.NekitePlate.func_176203_a(1));
            this.setBlock(world, new BlockPos(x + 5, y + 13, z + z1), TragicBlocks.NekitePlate.func_176203_a(1));
            this.setBlock(world, new BlockPos(x + z1, y + 13, z + 5), TragicBlocks.NekitePlate.func_176203_a(1));
            this.setBlock(world, new BlockPos(x + z1, y + 13, z - 5), TragicBlocks.NekitePlate.func_176203_a(1));
        }
        for (z1 = 5; z1 < 10; z1 = (int)((byte)(z1 + 1))) {
            this.setBlock(world, new BlockPos(x - 9, y + 13, z + z1), TragicBlocks.NekitePlate.func_176203_a(1));
            this.setBlock(world, new BlockPos(x + 9, y + 13, z + z1), TragicBlocks.NekitePlate.func_176203_a(1));
            this.setBlock(world, new BlockPos(x + z1, y + 13, z + 9), TragicBlocks.NekitePlate.func_176203_a(1));
            this.setBlock(world, new BlockPos(x + z1, y + 13, z - 9), TragicBlocks.NekitePlate.func_176203_a(1));
            this.setBlock(world, new BlockPos(x - 5, y + 13, z + z1), TragicBlocks.NekitePlate.func_176203_a(1));
            this.setBlock(world, new BlockPos(x + 5, y + 13, z + z1), TragicBlocks.NekitePlate.func_176203_a(1));
            this.setBlock(world, new BlockPos(x + z1, y + 13, z + 5), TragicBlocks.NekitePlate.func_176203_a(1));
            this.setBlock(world, new BlockPos(x + z1, y + 13, z - 5), TragicBlocks.NekitePlate.func_176203_a(1));
        }
        for (x1 = -8; x1 < -5; x1 = (int)((byte)(x1 + 1))) {
            for (int z16 = -8; z16 < -5; z16 = (int)((byte)(z16 + 1))) {
                this.setBlock(world, new BlockPos(x + x1, y + 13, z + z16), TragicBlocks.NekitePlate.func_176203_a(2));
                this.setBlock(world, new BlockPos(x - x1, y + 13, z + z16), TragicBlocks.NekitePlate.func_176203_a(2));
                this.setBlock(world, new BlockPos(x + x1, y + 13, z - z16), TragicBlocks.NekitePlate.func_176203_a(2));
                this.setBlock(world, new BlockPos(x - x1, y + 13, z - z16), TragicBlocks.NekitePlate.func_176203_a(2));
            }
        }
        for (z1 = -9; z1 < -4; z1 = (int)((byte)(z1 + 1))) {
            if (z1 == -7) continue;
            this.setBlock(world, new BlockPos(x - 9, y + 14, z + z1), TragicBlocks.NekitePlate.func_176203_a(1));
            this.setBlock(world, new BlockPos(x + 9, y + 14, z + z1), TragicBlocks.NekitePlate.func_176203_a(1));
            this.setBlock(world, new BlockPos(x + z1, y + 14, z + 9), TragicBlocks.NekitePlate.func_176203_a(1));
            this.setBlock(world, new BlockPos(x + z1, y + 14, z - 9), TragicBlocks.NekitePlate.func_176203_a(1));
            this.setBlock(world, new BlockPos(x - 5, y + 14, z + z1), TragicBlocks.NekitePlate.func_176203_a(1));
            this.setBlock(world, new BlockPos(x + 5, y + 14, z + z1), TragicBlocks.NekitePlate.func_176203_a(1));
            this.setBlock(world, new BlockPos(x + z1, y + 14, z + 5), TragicBlocks.NekitePlate.func_176203_a(1));
            this.setBlock(world, new BlockPos(x + z1, y + 14, z - 5), TragicBlocks.NekitePlate.func_176203_a(1));
        }
        for (z1 = 5; z1 < 10; z1 = (int)((byte)(z1 + 1))) {
            if (z1 == 7) continue;
            this.setBlock(world, new BlockPos(x - 9, y + 14, z + z1), TragicBlocks.NekitePlate.func_176203_a(1));
            this.setBlock(world, new BlockPos(x + 9, y + 14, z + z1), TragicBlocks.NekitePlate.func_176203_a(1));
            this.setBlock(world, new BlockPos(x + z1, y + 14, z + 9), TragicBlocks.NekitePlate.func_176203_a(1));
            this.setBlock(world, new BlockPos(x + z1, y + 14, z - 9), TragicBlocks.NekitePlate.func_176203_a(1));
            this.setBlock(world, new BlockPos(x - 5, y + 14, z + z1), TragicBlocks.NekitePlate.func_176203_a(1));
            this.setBlock(world, new BlockPos(x + 5, y + 14, z + z1), TragicBlocks.NekitePlate.func_176203_a(1));
            this.setBlock(world, new BlockPos(x + z1, y + 14, z + 5), TragicBlocks.NekitePlate.func_176203_a(1));
            this.setBlock(world, new BlockPos(x + z1, y + 14, z - 5), TragicBlocks.NekitePlate.func_176203_a(1));
        }
        if (rand.nextBoolean()) {
            this.setBlock(world, new BlockPos(x + 8, y + 14, z + 8), Blocks.field_150486_ae.func_176203_a(0), ChestHooks.epicHook);
        }
        if (rand.nextBoolean()) {
            this.setBlock(world, new BlockPos(x - 8, y + 14, z + 8), Blocks.field_150486_ae.func_176203_a(0), ChestHooks.epicHook);
        }
        if (rand.nextBoolean()) {
            this.setBlock(world, new BlockPos(x + 8, y + 14, z - 8), Blocks.field_150486_ae.func_176203_a(0), ChestHooks.epicHook);
        }
        if (rand.nextBoolean()) {
            this.setBlock(world, new BlockPos(x - 8, y + 14, z - 8), Blocks.field_150486_ae.func_176203_a(0), ChestHooks.epicHook);
        }
        this.setBlock(world, new BlockPos(x + 9, y + 15, z + 9), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x - 9, y + 15, z + 9), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x + 9, y + 15, z - 9), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x - 9, y + 15, z - 9), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x + 5, y + 15, z + 9), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x - 5, y + 15, z + 9), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x + 5, y + 15, z - 9), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x - 5, y + 15, z - 9), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x + 9, y + 15, z + 5), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x - 9, y + 15, z + 5), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x + 9, y + 15, z - 5), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x - 9, y + 15, z - 5), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x + 5, y + 15, z + 5), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x - 5, y + 15, z + 5), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x + 5, y + 15, z - 5), TragicBlocks.NekitePlate.func_176203_a(1));
        this.setBlock(world, new BlockPos(x - 5, y + 15, z - 5), TragicBlocks.NekitePlate.func_176203_a(1));
        return this;
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        return tag;
    }

    @Override
    public Schematic readFromNBT(NBTTagCompound tag) {
        return this;
    }
}

