/*
 * Decompiled with CFR 0.152.
 */
package tragicneko.tragicmc.worldgen.schematic;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;
import tragicneko.tragicmc.TragicBlocks;
import tragicneko.tragicmc.TragicConfig;
import tragicneko.tragicmc.util.ChestHooks;
import tragicneko.tragicmc.util.WorldHelper;
import tragicneko.tragicmc.worldgen.schematic.Schematic;
import tragicneko.tragicmc.worldgen.structure.Structure;

public class SchematicMemoryCache
extends Schematic {
    public SchematicMemoryCache(BlockPos pos, Structure str, World world) {
        super(pos, str, world, 12, 12, 12);
    }

    @Override
    public Schematic generateStructure(World world, Random rand, int x, int y, int z) {
        double size = rand.nextDouble() * 4.45 + 5.55;
        ArrayList<BlockPos> list = WorldHelper.getBlocksInSphericalRange(world, size, x, y, z);
        for (BlockPos coords : list) {
            this.setBlock(world, coords.func_177958_n(), coords.func_177956_o(), coords.func_177952_p(), TragicBlocks.Conduit, 0, 2);
        }
        list = WorldHelper.getBlocksInSphericalRange(world, size - 1.0, x, y, z);
        for (BlockPos coords : list) {
            this.setBlockToAir(world, coords.func_177958_n(), coords.func_177956_o(), coords.func_177952_p());
        }
        for (int x1 = -1; x1 < 2 && TragicConfig.getBoolean("allowNanoSwarm"); ++x1) {
            for (int z1 = -1; z1 < 2; ++z1) {
                for (int y1 = -1; y1 < 2; ++y1) {
                    this.setBlock(world, x + x1, y + y1, z + z1, Blocks.field_150474_ac, 0, 2, "TragicMC.NanoSwarm");
                }
            }
        }
        this.setBlock(world, x, y, z, (Block)Blocks.field_150486_ae, 0, 2, ChestHooks.uncommonHook);
        return this;
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        return tag;
    }

    @Override
    public Schematic readFromNBT(NBTTagCompound tag) {
        return this;
    }
}

