/*
 * Decompiled with CFR 0.152.
 */
package tragicneko.tragicmc.worldgen.schematic;

import java.util.Arrays;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;
import tragicneko.tragicmc.TragicConfig;
import tragicneko.tragicmc.util.ChestHooks;
import tragicneko.tragicmc.worldgen.schematic.Schematic;
import tragicneko.tragicmc.worldgen.structure.Structure;

public class SchematicCubeMaze
extends Schematic {
    private static final byte[][] values = new byte[][]{{-10, -10}, {-10, -4}, {-10, 3}, {-10, 9}, {-4, -10}, {-4, -4}, {-4, 3}, {-4, 9}, {3, -10}, {3, -4}, {3, 3}, {3, 9}, {9, -10}, {9, -4}, {9, 3}, {9, 9}};

    public SchematicCubeMaze(BlockPos pos, Structure str, World world) {
        super(pos, str, world, 32, 24, 24);
    }

    @Override
    public Schematic generateStructure(World world, Random rand, int x, int y, int z) {
        for (int y1 = 0; y1 < 37; y1 = (int)((byte)(y1 + 1))) {
            int x1;
            for (x1 = -13; x1 < 13; x1 = (int)((byte)(x1 + 1))) {
                for (int z1 = -13; z1 < 13; z1 = (int)((byte)(z1 + 1))) {
                    if (y1 % 6 == 0) {
                        this.setBlock(world, x + x1, y + y1, z + z1, Blocks.field_150343_Z);
                        continue;
                    }
                    this.setBlockToAir(world, x + x1, y + y1, z + z1);
                }
            }
            for (x1 = -13; x1 < 13; x1 = (int)((byte)(x1 + 1))) {
                this.setBlock(world, x + x1, y + y1, z + 12, Blocks.field_150343_Z);
                this.setBlock(world, x + x1, y + y1, z - 13, Blocks.field_150343_Z);
                this.setBlock(world, x - 13, y + y1, z + x1, Blocks.field_150343_Z);
                this.setBlock(world, x + 12, y + y1, z + x1, Blocks.field_150343_Z);
                this.setBlock(world, x + x1, y + y1, z + 6, Blocks.field_150343_Z);
                this.setBlock(world, x + x1, y + y1, z - 7, Blocks.field_150343_Z);
                this.setBlock(world, x - 7, y + y1, z + x1, Blocks.field_150343_Z);
                this.setBlock(world, x + 6, y + y1, z + x1, Blocks.field_150343_Z);
                this.setBlock(world, x + x1, y + y1, z, Blocks.field_150343_Z);
                this.setBlock(world, x + x1, y + y1, z - 1, Blocks.field_150343_Z);
                this.setBlock(world, x - 1, y + y1, z + x1, Blocks.field_150343_Z);
                this.setBlock(world, x, y + y1, z + x1, Blocks.field_150343_Z);
            }
        }
        int exits = 0;
        boolean invFlag = false;
        byte roomType = 0;
        int t = 0;
        int trap = 0;
        for (byte y1 = 0; y1 < 33; y1 = (byte)((byte)(y1 + 6))) {
            for (int i = 0; i < values.length; i = (int)((byte)(i + 1))) {
                boolean treasure;
                byte x0 = values[i][0];
                byte z0 = values[i][1];
                if ((Math.abs(x0) > 6 || Math.abs(z0) > 6) && exits < 5 && rand.nextInt(16) == 0) {
                    exits = (byte)(exits + 1);
                    invFlag = true;
                } else {
                    invFlag = false;
                }
                if (Math.abs(x0) > 6 || Math.abs(z0) > 6) {
                    boolean flag;
                    if (Math.abs(x0) > 6) {
                        if (Math.abs(z0) > 6) {
                            boolean flag2;
                            flag = x0 > 0;
                            boolean bl = flag2 = z0 > 0;
                            if (Math.abs(x0) > 6) {
                                roomType = flag ? (byte)(flag2 ? 5 : 6) : (byte)(flag2 ? 8 : 7);
                            } else if (Math.abs(z0) > 6) {
                                roomType = flag2 ? (byte)(flag ? 5 : 8) : (byte)(flag ? 6 : 7);
                            }
                        } else {
                            flag = x0 > 0;
                            roomType = (byte)(flag ? 1 : 2);
                        }
                    } else if (Math.abs(z0) > 6) {
                        flag = z0 > 0;
                        roomType = (byte)(flag ? 3 : 4);
                    }
                } else {
                    roomType = 0;
                }
                this.generateOpenings(world, rand, x + x0, y + y1, z + z0, roomType, y1, invFlag);
                boolean bl = treasure = roomType == 0 && rand.nextInt(8) == 0 && t == 0 && y1 > 5 && y1 < 28;
                this.setBlock(world, x + x0, y + y1 + 3, z + z0, (Block)(treasure ? Blocks.field_150486_ae : (rand.nextInt(16) == 0 ? Blocks.field_150350_a : Blocks.field_150426_aN)), 0, 2, ChestHooks.uncommonHook);
                if (treasure) {
                    t = (byte)(t + 1);
                    continue;
                }
                if (trap >= 3 || rand.nextInt(16) != 0) continue;
                if (rand.nextBoolean()) {
                    this.setBlock(world, x + x0, y + y1 + 4, z + z0, Blocks.field_150335_W, 1, 2);
                } else {
                    this.setBlock(world, x + x0, y + y1 + 4, z + z0, Blocks.field_150474_ac, 0, 2, TragicConfig.getBoolean("allowInkling") ? "TragicMC.Inkling" : "Enderman");
                }
                trap = (byte)(trap + 1);
            }
        }
        return this;
    }

    public void generateOpenings(World world, Random rand, int x, int y, int z, int roomType, byte y0, boolean inverse) {
        boolean[] discrim = new boolean[6];
        Arrays.fill(discrim, true);
        if (roomType == 3 || roomType == 5 || roomType == 8) {
            discrim[0] = false;
        }
        if (roomType == 4 || roomType == 6 || roomType == 7) {
            discrim[1] = false;
        }
        if (roomType == 1 || roomType == 5 || roomType == 6) {
            discrim[2] = false;
        }
        if (roomType == 2 || roomType == 7 || roomType == 8) {
            discrim[3] = false;
        }
        if (y0 < 10) {
            discrim[4] = false;
        }
        if (y0 > 26) {
            discrim[5] = false;
        }
        if (inverse) {
            for (int i = 0; i < discrim.length; ++i) {
                if (discrim[i]) continue;
                discrim[i] = true;
            }
        }
        byte attempts = (byte)(inverse ? 3 : 2);
        for (byte i = 0; i < attempts; i = (byte)(i + 1)) {
            int x1;
            byte j = (byte)rand.nextInt(discrim.length);
            boolean flag = false;
            while (!discrim[j]) {
                j = (byte)rand.nextInt(discrim.length);
            }
            if (!discrim[j]) continue;
            if (j == 0) {
                for (x1 = 2; x1 < 5; ++x1) {
                    this.setBlockToAir(world, x, y + 1, z + x1);
                    this.setBlockToAir(world, x, y + 2, z + x1);
                }
                continue;
            }
            if (j == 1) {
                for (x1 = -2; x1 > -5; --x1) {
                    this.setBlockToAir(world, x, y + 1, z + x1);
                    this.setBlockToAir(world, x, y + 2, z + x1);
                }
                continue;
            }
            if (j == 2) {
                for (x1 = 2; x1 < 5; ++x1) {
                    this.setBlockToAir(world, x + x1, y + 1, z);
                    this.setBlockToAir(world, x + x1, y + 2, z);
                }
                continue;
            }
            if (j == 3) {
                for (x1 = -2; x1 > -5; --x1) {
                    this.setBlockToAir(world, x + x1, y + 1, z);
                    this.setBlockToAir(world, x + x1, y + 2, z);
                }
                continue;
            }
            if (j == 4) {
                for (x1 = 1; x1 > -1; --x1) {
                    this.setBlockToAir(world, x, y + x1, z);
                    this.setBlockToAir(world, x, y + x1, z);
                    this.setBlockToAir(world, x + 1, y + x1, z);
                    this.setBlockToAir(world, x - 1, y + x1, z);
                    this.setBlockToAir(world, x, y + x1, z + 1);
                    this.setBlockToAir(world, x, y + x1, z - 1);
                }
                continue;
            }
            if (j != 5) continue;
            for (x1 = 5; x1 < 7; ++x1) {
                this.setBlockToAir(world, x, y + x1, z);
                this.setBlockToAir(world, x, y + x1, z);
                this.setBlockToAir(world, x + 1, y + x1, z);
                this.setBlockToAir(world, x - 1, y + x1, z);
                this.setBlockToAir(world, x, y + x1, z + 1);
                this.setBlockToAir(world, x, y + x1, z - 1);
            }
        }
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        return tag;
    }

    @Override
    public Schematic readFromNBT(NBTTagCompound tag) {
        return this;
    }
}

