/*
 * Decompiled with CFR 0.152.
 */
package tragicneko.tragicmc.worldgen.schematic;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;
import tragicneko.tragicmc.TragicBlocks;
import tragicneko.tragicmc.util.ChestHooks;
import tragicneko.tragicmc.worldgen.schematic.Schematic;
import tragicneko.tragicmc.worldgen.structure.Structure;

public class SchematicClaymationRuin
extends Schematic {
    private static final byte[] metas = new byte[]{0, 1, 3, 2, 5, 4};
    private static final byte ROOM_PADDING = 13;
    private static final byte ROOM_HEIGHT = 8;
    private byte[][] map = new byte[5][5];
    private byte[][] map2 = new byte[5][5];

    public SchematicClaymationRuin(BlockPos pos, Structure str, World world) {
        super(pos, str, world, 5, 5, 5);
        this.createMaps(world.field_73012_v);
    }

    @Override
    public boolean shouldLimitSpawnerRate() {
        return true;
    }

    @Override
    public Schematic generateStructure(World world, Random rand, int x, int y, int z) {
        this.generateEntrance(world, rand, x, y, z);
        return this;
    }

    public byte[][] createMap(Random rand) {
        byte[][] map = new byte[5][5];
        boolean flag = false;
        boolean flag2 = false;
        int noroom = 0;
        int trap = 0;
        int strt = 0;
        for (int i = 0; i < map.length; i = (int)((byte)(i + 1))) {
            for (int j = 0; j < map[i].length; j = (int)((byte)(j + 1))) {
                int b0;
                byte by = (byte)(!flag ? (int)rand.nextInt(metas.length) : (byte)(b0 = !flag2 ? (byte)rand.nextInt(metas.length - 1) : (byte)(rand.nextInt(metas.length - 3) + 1)));
                if (i == 0) {
                    if (!flag && j == map[i].length - 1) {
                        b0 = 5;
                    }
                    if (b0 == 4) {
                        b0 = (byte)(rand.nextInt(3) + 1);
                    }
                    if (b0 == 5) {
                        flag = true;
                        strt = j;
                    }
                } else {
                    if (j == strt && b0 == 0) {
                        b0 = (byte)(rand.nextInt(metas.length - 2) + 1);
                    }
                    if ((i == 0 || flag2) && b0 == 4) {
                        b0 = (byte)(rand.nextInt(metas.length - 3) + 1);
                    }
                    if (b0 > 0 && rand.nextBoolean()) {
                        strt = j;
                    }
                    if (i == map.length - 1 && !flag2 && j == map[i].length - 1) {
                        b0 = 4;
                    }
                    if (i > 0 && !flag2 && b0 == 4) {
                        flag2 = true;
                    }
                }
                if (b0 == 0) {
                    noroom = (byte)(noroom + 1);
                }
                if (noroom > 7 && b0 == 0) {
                    b0 = (byte)(rand.nextInt(metas.length - 3) + 1);
                }
                if (b0 == 3) {
                    trap = (byte)(trap + 1);
                }
                if (trap > 3 && b0 == 3) {
                    b0 = (byte)(rand.nextBoolean() ? 1 : 2);
                }
                map[i][j] = b0;
            }
        }
        return map;
    }

    public void createMaps(Random rand) {
        this.map = this.createMap(rand);
        this.map2 = this.createMap(rand);
        for (int i = 0; i < this.map.length; i = (int)((byte)(i + 1))) {
            for (int j = 0; j < this.map[i].length; j = (int)((byte)(j + 1))) {
                if (this.map2[i][j] == 5) {
                    this.map2[i][j] = (byte)(rand.nextInt(metas.length - 2) + 1);
                }
                if (this.map[i][j] == 4 && this.map2[i][j] == 4) {
                    this.map2[i][j] = 1;
                    byte val = (byte)rand.nextInt(this.map2.length);
                    byte val2 = (byte)rand.nextInt(this.map2[val].length);
                    if (val != i && val2 != j) {
                        this.map2[val][val2] = 4;
                    } else {
                        this.map2[0][rand.nextInt((int)this.map2[0].length)] = 4;
                    }
                }
                if (this.map[i][j] != 4 || this.map2[i][j] == 1) continue;
                this.map2[i][j] = 1;
            }
        }
    }

    public void generateTablet(World world, Random rand, int x, int y, int z) {
        for (int y1 = -2; y1 < 0; y1 = (int)((byte)(y1 + 1))) {
            for (int x1 = -2; x1 < 3; x1 = (int)((byte)(x1 + 1))) {
                this.setBlock(world, x + x1, y + y1, z, TragicBlocks.DarkSandstone, 0, 2);
            }
        }
        this.setTabletBlocks(world, rand, x, y, z);
    }

    public void setTabletBlocks(World world, Random rand, int x, int y, int z) {
        for (int i = 0; i < this.map.length; i = (int)((byte)(i + 1))) {
            for (int j = 0; j < this.map[i].length; j = (int)((byte)(j + 1))) {
                this.setBlock(world, x + j - 2, y + i, z, TragicBlocks.DarkSandstone, metas[this.map[i][j]], 2);
            }
        }
    }

    public void generateEntrance(World world, Random rand, int x, int y, int z) {
        int j;
        int y1;
        for (y1 = -2; y1 < 3; y1 = (int)((byte)(y1 + 1))) {
            for (int x1 = -2; x1 < 3; x1 = (int)((byte)(x1 + 1))) {
                for (int z1 = -2; z1 < 3; z1 = (int)((byte)(z1 + 1))) {
                    int m = 1;
                    if (z1 == -2 || z1 == 2 || x1 == -2 || x1 == 2) {
                        m = 0;
                    }
                    if (y1 < 0) {
                        this.setBlock(world, x + x1, y + y1, z + z1, TragicBlocks.DarkSandstone, m, 2);
                        continue;
                    }
                    this.setBlockToAir(world, x + x1, y + y1, z + z1);
                }
            }
        }
        this.setBlock(world, x + 2, y, z + 2, TragicBlocks.DarkSandstone, 0, 2);
        this.setBlock(world, x - 2, y, z + 2, TragicBlocks.DarkSandstone, 0, 2);
        this.setBlock(world, x + 2, y, z - 2, TragicBlocks.DarkSandstone, 0, 2);
        this.setBlock(world, x - 2, y, z - 2, TragicBlocks.DarkSandstone, 0, 2);
        this.setBlock(world, x + 2, y + 1, z - 2, TragicBlocks.Candle, 8, 2);
        this.setBlock(world, x - 2, y + 1, z - 2, TragicBlocks.Candle, 8, 2);
        y1 = -1;
        int z1 = 2;
        while (y1 > -60 && y1 + y > 32) {
            int i;
            for (i = 0; i < 5; i = (int)((byte)(i + 1))) {
                this.setBlockToAir(world, x - 2, y + y1 + i, z + z1);
                this.setBlockToAir(world, x - 1, y + y1 + i, z + z1);
                this.setBlockToAir(world, x, y + y1 + i, z + z1);
                this.setBlockToAir(world, x + 1, y + y1 + i, z + z1);
                this.setBlockToAir(world, x + 2, y + y1 + i, z + z1);
            }
            this.setBlock(world, x - 2, y + y1 + 1, z + z1, TragicBlocks.DarkSandstone, 0, 2);
            this.setBlock(world, x - 1, y + y1, z + z1, TragicBlocks.DarkSandstone, 1, 2);
            this.setBlock(world, x, y + y1, z + z1, TragicBlocks.DarkSandstone, 1, 2);
            this.setBlock(world, x + 1, y + y1, z + z1, TragicBlocks.DarkSandstone, 1, 2);
            this.setBlock(world, x + 2, y + y1 + 1, z + z1, TragicBlocks.DarkSandstone, 0, 2);
            this.setBlock(world, x - 2, y + y1, z + z1, TragicBlocks.DarkSandstone, 0, 2);
            this.setBlock(world, x + 2, y + y1, z + z1, TragicBlocks.DarkSandstone, 0, 2);
            this.setBlock(world, x - 1, y + y1, z + z1 - 1, TragicBlocks.DarkSandstone, 1, 2);
            this.setBlock(world, x, y + y1, z + z1 - 1, TragicBlocks.DarkSandstone, 1, 2);
            this.setBlock(world, x + 1, y + y1, z + z1 - 1, TragicBlocks.DarkSandstone, 1, 2);
            if ((y1 - 2) % 3 == 0) {
                this.setBlock(world, x + 2, y + y1 + 2, z + z1, TragicBlocks.Candle, 8, 2);
                this.setBlock(world, x - 2, y + y1 + 2, z + z1, TragicBlocks.Candle, 8, 2);
            } else if ((y1 - 1) % 3 == 0) {
                for (i = 1; i < 5; i = (int)((byte)(i + 1))) {
                    this.setBlock(world, x + 2, y + y1 + i, z + z1, TragicBlocks.DarkSandstone, 2, 2);
                    this.setBlock(world, x - 2, y + y1 + i, z + z1, TragicBlocks.DarkSandstone, 2, 2);
                }
            }
            y1 = (byte)(y1 - 1);
            z1 = (byte)(z1 + 1);
        }
        for (j = 0; j < 5; j = (int)((byte)(j + 1))) {
            for (int x1 = -2; x1 < 3; x1 = (int)((byte)(x1 + 1))) {
                for (int k = 0; k < 4; k = (int)((byte)(k + 1))) {
                    this.setBlockToAir(world, x + x1, y + y1 + j, z + z1 + k);
                }
            }
        }
        for (j = 0; j < 2; j = (int)((byte)(j + 1))) {
            this.setBlock(world, x + 2, y + y1, z + z1 + j, TragicBlocks.DarkSandstone, 0, 2);
            this.setBlock(world, x + 1, y + y1, z + z1 + j, TragicBlocks.DarkSandstone, 1, 2);
            this.setBlock(world, x, y + y1, z + z1 + j, TragicBlocks.DarkSandstone, 1, 2);
            this.setBlock(world, x - 1, y + y1, z + z1 + j, TragicBlocks.DarkSandstone, 1, 2);
            this.setBlock(world, x - 2, y + y1, z + z1 + j, TragicBlocks.DarkSandstone, 0, 2);
        }
        this.setBlock(world, x + 2, y + y1 + 1, z + z1 + 1, TragicBlocks.Candle, 8, 2);
        this.setBlock(world, x - 2, y + y1 + 1, z + z1 + 1, TragicBlocks.Candle, 8, 2);
        this.generateTablet(world, rand, x, y + 1, z - 3);
        this.generateFirstTunnel(world, rand, x, y + y1, z + z1 + 2);
        this.generateRoomsBasedOnMap(world, rand, x, y + y1, z + z1 + 15);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void generateRoomsBasedOnMap(World world, Random rand, int x, int y, int z) {
        int offsetY;
        int offsetZ;
        int offsetX;
        byte b0;
        int j;
        byte[] start = this.findRoomInMap(this.map, 5);
        byte[] dropdown = this.findRoomInMap(this.map, 4);
        byte w = start[1];
        int i = 0;
        while (true) {
            if (i >= this.map.length) break;
            block17: for (j = 0; j < this.map[i].length; j = (int)((byte)(j + 1))) {
                b0 = this.map[i][j];
                offsetX = (j - w) * 13;
                offsetZ = i * 13;
                offsetY = 0;
                switch (b0) {
                    case 0: {
                        continue block17;
                    }
                    case 1: {
                        this.generateEmptyRoom(world, rand, x + offsetX, y - offsetY, z + offsetZ);
                        continue block17;
                    }
                    case 2: {
                        this.generateColumnRoom(world, rand, x + offsetX, y - offsetY, z + offsetZ);
                        continue block17;
                    }
                    case 3: {
                        this.generateTrapRoom(world, rand, x + offsetX, y - offsetY, z + offsetZ);
                        continue block17;
                    }
                    case 4: {
                        continue block17;
                    }
                    case 5: {
                        this.generateColumnRoom(world, rand, x + offsetX, y - offsetY, z + offsetZ);
                        continue block17;
                    }
                }
            }
            i = (byte)(i + 1);
        }
        i = 0;
        while (i < this.map2.length) {
            block19: for (j = 0; j < this.map2[i].length; j = (int)((byte)(j + 1))) {
                b0 = this.map2[i][j];
                offsetX = (j - w) * 13;
                offsetZ = i * 13;
                offsetY = 8;
                switch (b0) {
                    case 0: {
                        continue block19;
                    }
                    case 1: {
                        this.generateEmptyRoom(world, rand, x + offsetX, y - offsetY, z + offsetZ);
                        break;
                    }
                    case 2: {
                        this.generateColumnRoom(world, rand, x + offsetX, y - offsetY, z + offsetZ);
                        break;
                    }
                    case 3: {
                        this.generateTrapRoom(world, rand, x + offsetX, y - offsetY, z + offsetZ);
                        break;
                    }
                    case 4: {
                        this.generateBossRoom(world, rand, x + offsetX, y - offsetY, z + offsetZ);
                        break;
                    }
                    case 5: {
                        this.generateColumnRoom(world, rand, x + offsetX, y - offsetY, z + offsetZ);
                    }
                }
                if (i != dropdown[0] || j != dropdown[1]) continue;
                this.generateDropdown(world, rand, x + offsetX, y, z + offsetZ);
            }
            i = (byte)(i + 1);
        }
        return;
    }

    public byte[] findRoomInMap(byte[][] map, int room) {
        for (byte i = 0; i < map.length; i = (byte)((byte)(i + 1))) {
            for (byte j = 0; j < map[i].length; j = (byte)((byte)(j + 1))) {
                if (map[i][j] != room) continue;
                return new byte[]{i, j};
            }
        }
        return new byte[]{0, 0};
    }

    public void generateFirstTunnel(World world, Random rand, int x, int y, int z) {
        for (int z1 = 0; z1 < 5; z1 = (int)((byte)(z1 + 1))) {
            int x1;
            int y1;
            int m;
            int x12;
            for (x12 = -3; x12 < 4; x12 = (int)((byte)(x12 + 1))) {
                for (int y12 = 0; y12 < 6; y12 = (int)((byte)(y12 + 1))) {
                    this.setBlockToAir(world, x + x12, y + y12, z + z1);
                }
            }
            for (x12 = -2; x12 < 3; x12 = (int)((byte)(x12 + 1))) {
                m = 1;
                if (x12 == -2 || x12 == 2) {
                    m = 0;
                }
                this.setBlock(world, x + x12, y, z + z1, TragicBlocks.DarkSandstone, m, 2);
            }
            if (z1 >= 2 && z1 <= 3 || z1 >= 6 && z1 <= 7) {
                this.setBlock(world, x + 3, y, z + z1, TragicBlocks.DarkSandstone, 0, 2);
                this.setBlock(world, x - 3, y, z + z1, TragicBlocks.DarkSandstone, 0, 2);
                for (y1 = 1; y1 < 6; y1 = (int)((byte)(y1 + 1))) {
                    this.setBlock(world, x + 4, y + y1, z + z1, TragicBlocks.DarkSandstone, 4, 2);
                    this.setBlock(world, x - 4, y + y1, z + z1, TragicBlocks.DarkSandstone, 4, 2);
                }
            } else {
                for (y1 = 1; y1 < 6; y1 = (int)((byte)(y1 + 1))) {
                    this.setBlock(world, x + 3, y + y1, z + z1, TragicBlocks.DarkSandstone, 2, 2);
                    this.setBlock(world, x - 3, y + y1, z + z1, TragicBlocks.DarkSandstone, 2, 2);
                }
            }
            if (z1 == 0) {
                for (y1 = 0; y1 < 5; y1 = (int)((byte)(y1 + 1))) {
                    this.setBlock(world, x + 2, y + y1, z + z1, TragicBlocks.DarkSandstone, 4, 2);
                    this.setBlock(world, x - 2, y + y1, z + z1, TragicBlocks.DarkSandstone, 4, 2);
                }
                for (x12 = -2; x12 < 3; x12 = (int)((byte)(x12 + 1))) {
                    m = x12 == -2 || x12 == 2 ? 3 : 4;
                    this.setBlock(world, x + x12, y + 5, z + z1, TragicBlocks.DarkSandstone, m, 2);
                }
                continue;
            }
            if (z1 == 1) {
                this.setBlock(world, x + 2, y + 1, z + z1, TragicBlocks.Candle, 8, 2);
                this.setBlock(world, x - 2, y + 1, z + z1, TragicBlocks.Candle, 8, 2);
                for (x12 = -2; x12 < 3; x12 = (int)((byte)(x12 + 1))) {
                    this.setBlock(world, x + x12, y + 6, z + z1, TragicBlocks.DarkSandstone, 4, 2);
                }
                continue;
            }
            byte m2 = (byte)(z1 == 4 ? 3 : 2);
            this.setBlock(world, x + 3, y + 5, z + z1, TragicBlocks.DarkSandstone, m2, 2);
            this.setBlock(world, x - 3, y + 5, z + z1, TragicBlocks.DarkSandstone, m2, 2);
            for (x1 = -2; x1 < 3; x1 = (int)((byte)(x1 + 1))) {
                this.setBlockToAir(world, x + x1, y + 6, z + z1);
            }
            this.setBlock(world, x + 2, y + 6, z + z1, TragicBlocks.DarkSandstone, 4, 2);
            this.setBlock(world, x - 2, y + 6, z + z1, TragicBlocks.DarkSandstone, 4, 2);
            for (x1 = -1; x1 < 2; x1 = (int)((byte)(x1 + 1))) {
                this.setBlock(world, x + x1, y + 7, z + z1, TragicBlocks.DarkSandstone, 3, 2);
            }
        }
    }

    public void generateColumnRoom(World world, Random rand, int x, int y, int z) {
        int x1;
        int z1;
        int x12;
        int y1;
        for (y1 = 0; y1 < 8; y1 = (int)((byte)(y1 + 1))) {
            for (x12 = -4; x12 < 5; x12 = (int)((byte)(x12 + 1))) {
                for (z1 = -4; z1 < 5; z1 = (int)((byte)(z1 + 1))) {
                    if (y1 == 0 || y1 >= 6) {
                        this.setBlock(world, x + x12, y + y1, z + z1, TragicBlocks.DarkSandstone, 0, 2);
                        continue;
                    }
                    this.setBlockToAir(world, x + x12, y + y1, z + z1);
                }
            }
        }
        for (x1 = -3; x1 < 4; x1 = (int)((byte)(x1 + 1))) {
            for (int z12 = -3; z12 < 4; z12 = (int)((byte)(z12 + 1))) {
                this.setBlock(world, x + x1, y, z + z12, TragicBlocks.DarkSandstone, 1, 2);
            }
        }
        for (x1 = -2; x1 < 3; x1 = (int)((byte)(x1 + 1))) {
            this.setBlock(world, x + x1, y, z - 4, TragicBlocks.DarkSandstone, 1, 2);
            this.setBlock(world, x + x1, y, z + 4, TragicBlocks.DarkSandstone, 1, 2);
        }
        for (int z13 = -2; z13 < 3; z13 = (int)((byte)(z13 + 1))) {
            this.setBlock(world, x + 4, y, z + z13, TragicBlocks.DarkSandstone, 1, 2);
            this.setBlock(world, x - 4, y, z + z13, TragicBlocks.DarkSandstone, 1, 2);
        }
        for (y1 = 0; y1 < 8; y1 = (int)((byte)(y1 + 1))) {
            for (x12 = -1; x12 < 2; x12 = (int)((byte)(x12 + 1))) {
                for (z1 = -1; z1 < 2; z1 = (int)((byte)(z1 + 1))) {
                    this.setBlock(world, x + x12, y + y1, z + z1, TragicBlocks.DarkSandstone, 0, 2);
                    if (y1 != 0) continue;
                    this.setBlock(world, x + 1, y + y1, z + 2, TragicBlocks.DarkSandstone, 0, 2);
                    this.setBlock(world, x - 1, y + y1, z + 2, TragicBlocks.DarkSandstone, 0, 2);
                    this.setBlock(world, x, y + y1, z + 2, TragicBlocks.DarkSandstone, 0, 2);
                    this.setBlock(world, x + 1, y + y1, z - 2, TragicBlocks.DarkSandstone, 0, 2);
                    this.setBlock(world, x - 1, y + y1, z - 2, TragicBlocks.DarkSandstone, 0, 2);
                    this.setBlock(world, x, y + y1, z - 2, TragicBlocks.DarkSandstone, 0, 2);
                    this.setBlock(world, x + 2, y + y1, z - 1, TragicBlocks.DarkSandstone, 0, 2);
                    this.setBlock(world, x + 2, y + y1, z, TragicBlocks.DarkSandstone, 0, 2);
                    this.setBlock(world, x + 2, y + y1, z + 1, TragicBlocks.DarkSandstone, 0, 2);
                    this.setBlock(world, x - 2, y + y1, z - 1, TragicBlocks.DarkSandstone, 0, 2);
                    this.setBlock(world, x - 2, y + y1, z, TragicBlocks.DarkSandstone, 0, 2);
                    this.setBlock(world, x - 2, y + y1, z + 1, TragicBlocks.DarkSandstone, 0, 2);
                }
            }
            if (y1 <= 0 || y1 >= 6) continue;
            if (y1 == 1 || y1 == 5) {
                this.setBlock(world, x + 4, y + y1, z + 4, TragicBlocks.DarkSandstone, 4, 2);
                this.setBlock(world, x - 4, y + y1, z + 4, TragicBlocks.DarkSandstone, 4, 2);
                this.setBlock(world, x + 4, y + y1, z - 4, TragicBlocks.DarkSandstone, 4, 2);
                this.setBlock(world, x - 4, y + y1, z - 4, TragicBlocks.DarkSandstone, 4, 2);
                continue;
            }
            this.setBlock(world, x + 5, y + y1, z + 4, TragicBlocks.DarkSandstone, 4, 2);
            this.setBlock(world, x - 5, y + y1, z + 4, TragicBlocks.DarkSandstone, 4, 2);
            this.setBlock(world, x + 5, y + y1, z - 4, TragicBlocks.DarkSandstone, 4, 2);
            this.setBlock(world, x - 5, y + y1, z - 4, TragicBlocks.DarkSandstone, 4, 2);
            this.setBlock(world, x + 4, y + y1, z + 5, TragicBlocks.DarkSandstone, 4, 2);
            this.setBlock(world, x - 4, y + y1, z + 5, TragicBlocks.DarkSandstone, 4, 2);
            this.setBlock(world, x + 4, y + y1, z - 5, TragicBlocks.DarkSandstone, 4, 2);
            this.setBlock(world, x - 4, y + y1, z - 5, TragicBlocks.DarkSandstone, 4, 2);
        }
        if (rand.nextInt(5) == 0) {
            this.setBlock(world, x, y + 1, z, (Block)Blocks.field_150486_ae, 0, 2, ChestHooks.uncommonHook);
            this.setBlockToAir(world, x, y + 2, z);
            this.setBlockToAir(world, x, y + 3, z);
        }
        this.generateTunnels(world, rand, x, y, z);
    }

    public void generateEmptyRoom(World world, Random rand, int x, int y, int z) {
        int z1;
        int x1;
        int z12;
        int x12;
        int y1;
        for (y1 = 0; y1 < 8; y1 = (int)((byte)(y1 + 1))) {
            for (x12 = -4; x12 < 5; x12 = (int)((byte)(x12 + 1))) {
                for (z12 = -4; z12 < 5; z12 = (int)((byte)(z12 + 1))) {
                    if (y1 == 0 || y1 >= 6) {
                        this.setBlock(world, x + x12, y + y1, z + z12, TragicBlocks.DarkSandstone, 0, 2);
                        continue;
                    }
                    this.setBlockToAir(world, x + x12, y + y1, z + z12);
                }
            }
        }
        for (x1 = -3; x1 < 4; x1 = (int)((byte)(x1 + 1))) {
            for (z1 = -3; z1 < 4; z1 = (int)((byte)(z1 + 1))) {
                this.setBlock(world, x + x1, y, z + z1, TragicBlocks.DarkSandstone, 1, 2);
            }
        }
        for (x1 = -2; x1 < 3; x1 = (int)((byte)(x1 + 1))) {
            this.setBlock(world, x + x1, y, z - 4, TragicBlocks.DarkSandstone, 1, 2);
            this.setBlock(world, x + x1, y, z + 4, TragicBlocks.DarkSandstone, 1, 2);
        }
        for (int z13 = -2; z13 < 3; z13 = (int)((byte)(z13 + 1))) {
            this.setBlock(world, x + 4, y, z + z13, TragicBlocks.DarkSandstone, 1, 2);
            this.setBlock(world, x - 4, y, z + z13, TragicBlocks.DarkSandstone, 1, 2);
        }
        for (x1 = -1; x1 < 2; x1 = (int)((byte)(x1 + 1))) {
            for (z1 = -1; z1 < 2; z1 = (int)((byte)(z1 + 1))) {
                this.setBlock(world, x + x1, y, z + z1, TragicBlocks.DarkSandstone, 0, 2);
            }
        }
        for (y1 = 0; y1 < 8; y1 = (int)((byte)(y1 + 1))) {
            if (y1 == 0) {
                for (x12 = -1; x12 < 2; x12 = (int)((byte)(x12 + 1))) {
                    for (z12 = -1; z12 < 2; z12 = (int)((byte)(z12 + 1))) {
                        this.setBlock(world, x + 1, y, z + 2, TragicBlocks.DarkSandstone, 0, 2);
                        this.setBlock(world, x - 1, y, z + 2, TragicBlocks.DarkSandstone, 0, 2);
                        this.setBlock(world, x, y, z + 2, TragicBlocks.DarkSandstone, 0, 2);
                        this.setBlock(world, x + 1, y, z - 2, TragicBlocks.DarkSandstone, 0, 2);
                        this.setBlock(world, x - 1, y, z - 2, TragicBlocks.DarkSandstone, 0, 2);
                        this.setBlock(world, x, y, z - 2, TragicBlocks.DarkSandstone, 0, 2);
                        this.setBlock(world, x + 2, y, z - 1, TragicBlocks.DarkSandstone, 0, 2);
                        this.setBlock(world, x + 2, y, z, TragicBlocks.DarkSandstone, 0, 2);
                        this.setBlock(world, x + 2, y, z + 1, TragicBlocks.DarkSandstone, 0, 2);
                        this.setBlock(world, x - 2, y, z - 1, TragicBlocks.DarkSandstone, 0, 2);
                        this.setBlock(world, x - 2, y, z, TragicBlocks.DarkSandstone, 0, 2);
                        this.setBlock(world, x - 2, y, z + 1, TragicBlocks.DarkSandstone, 0, 2);
                    }
                }
            }
            if (y1 <= 0 || y1 >= 6) continue;
            if (y1 == 1 || y1 == 5) {
                this.setBlock(world, x + 4, y + y1, z + 4, TragicBlocks.DarkSandstone, 4, 2);
                this.setBlock(world, x - 4, y + y1, z + 4, TragicBlocks.DarkSandstone, 4, 2);
                this.setBlock(world, x + 4, y + y1, z - 4, TragicBlocks.DarkSandstone, 4, 2);
                this.setBlock(world, x - 4, y + y1, z - 4, TragicBlocks.DarkSandstone, 4, 2);
                continue;
            }
            this.setBlock(world, x + 5, y + y1, z + 4, TragicBlocks.DarkSandstone, 4, 2);
            this.setBlock(world, x - 5, y + y1, z + 4, TragicBlocks.DarkSandstone, 4, 2);
            this.setBlock(world, x + 5, y + y1, z - 4, TragicBlocks.DarkSandstone, 4, 2);
            this.setBlock(world, x - 5, y + y1, z - 4, TragicBlocks.DarkSandstone, 4, 2);
            this.setBlock(world, x + 4, y + y1, z + 5, TragicBlocks.DarkSandstone, 4, 2);
            this.setBlock(world, x - 4, y + y1, z + 5, TragicBlocks.DarkSandstone, 4, 2);
            this.setBlock(world, x + 4, y + y1, z - 5, TragicBlocks.DarkSandstone, 4, 2);
            this.setBlock(world, x - 4, y + y1, z - 5, TragicBlocks.DarkSandstone, 4, 2);
        }
        if (rand.nextInt(20) == 0) {
            this.setBlock(world, x, y + 1, z, Blocks.field_150447_bR, 0, 2, ChestHooks.commonHook);
        }
        this.generateTunnels(world, rand, x, y, z);
    }

    public void generateDropdown(World world, Random rand, int x, int y, int z) {
        int x1;
        int z1;
        int x12;
        int y1;
        for (y1 = 0; y1 < 8; y1 = (int)((byte)(y1 + 1))) {
            for (x12 = -4; x12 < 5; x12 = (int)((byte)(x12 + 1))) {
                for (z1 = -4; z1 < 5; z1 = (int)((byte)(z1 + 1))) {
                    if (y1 == 0 || y1 >= 6) {
                        this.setBlock(world, x + x12, y + y1, z + z1, TragicBlocks.DarkSandstone, 0, 2);
                        continue;
                    }
                    this.setBlockToAir(world, x + x12, y + y1, z + z1);
                }
            }
        }
        for (x1 = -3; x1 < 4; x1 = (int)((byte)(x1 + 1))) {
            for (int z12 = -3; z12 < 4; z12 = (int)((byte)(z12 + 1))) {
                this.setBlock(world, x + x1, y, z + z12, TragicBlocks.DarkSandstone, 1, 2);
            }
        }
        for (x1 = -2; x1 < 3; x1 = (int)((byte)(x1 + 1))) {
            this.setBlock(world, x + x1, y, z - 4, TragicBlocks.DarkSandstone, 1, 2);
            this.setBlock(world, x + x1, y, z + 4, TragicBlocks.DarkSandstone, 1, 2);
        }
        for (int z13 = -2; z13 < 3; z13 = (int)((byte)(z13 + 1))) {
            this.setBlock(world, x + 4, y, z + z13, TragicBlocks.DarkSandstone, 1, 2);
            this.setBlock(world, x - 4, y, z + z13, TragicBlocks.DarkSandstone, 1, 2);
        }
        for (y1 = -2; y1 < 0; y1 = (int)((byte)(y1 + 1))) {
            for (x12 = -2; x12 < 3; x12 = (int)((byte)(x12 + 1))) {
                for (z1 = -2; z1 < 3; z1 = (int)((byte)(z1 + 1))) {
                    this.setBlock(world, x + x12, y + y1, z + z1, TragicBlocks.DarkSandstone, 0, 2);
                }
            }
        }
        for (y1 = -6; y1 < 2; y1 = (int)((byte)(y1 + 1))) {
            for (x12 = -1; x12 < 2; x12 = (int)((byte)(x12 + 1))) {
                for (z1 = -1; z1 < 2; z1 = (int)((byte)(z1 + 1))) {
                    this.setBlockToAir(world, x + x12, y + y1, z + z1);
                }
            }
        }
        for (y1 = 0; y1 < 8; y1 = (int)((byte)(y1 + 1))) {
            if (y1 == 0) {
                for (x12 = -1; x12 < 2; x12 = (int)((byte)(x12 + 1))) {
                    for (z1 = -1; z1 < 2; z1 = (int)((byte)(z1 + 1))) {
                        this.setBlock(world, x + 1, y, z + 2, TragicBlocks.DarkSandstone, 0, 2);
                        this.setBlock(world, x - 1, y, z + 2, TragicBlocks.DarkSandstone, 0, 2);
                        this.setBlock(world, x, y, z + 2, TragicBlocks.DarkSandstone, 0, 2);
                        this.setBlock(world, x + 1, y, z - 2, TragicBlocks.DarkSandstone, 0, 2);
                        this.setBlock(world, x - 1, y, z - 2, TragicBlocks.DarkSandstone, 0, 2);
                        this.setBlock(world, x, y, z - 2, TragicBlocks.DarkSandstone, 0, 2);
                        this.setBlock(world, x + 2, y, z - 1, TragicBlocks.DarkSandstone, 0, 2);
                        this.setBlock(world, x + 2, y, z, TragicBlocks.DarkSandstone, 0, 2);
                        this.setBlock(world, x + 2, y, z + 1, TragicBlocks.DarkSandstone, 0, 2);
                        this.setBlock(world, x - 2, y, z - 1, TragicBlocks.DarkSandstone, 0, 2);
                        this.setBlock(world, x - 2, y, z, TragicBlocks.DarkSandstone, 0, 2);
                        this.setBlock(world, x - 2, y, z + 1, TragicBlocks.DarkSandstone, 0, 2);
                    }
                }
            }
            if (y1 <= 0 || y1 >= 6) continue;
            if (y1 == 1 || y1 == 5) {
                this.setBlock(world, x + 4, y + y1, z + 4, TragicBlocks.DarkSandstone, 4, 2);
                this.setBlock(world, x - 4, y + y1, z + 4, TragicBlocks.DarkSandstone, 4, 2);
                this.setBlock(world, x + 4, y + y1, z - 4, TragicBlocks.DarkSandstone, 4, 2);
                this.setBlock(world, x - 4, y + y1, z - 4, TragicBlocks.DarkSandstone, 4, 2);
                continue;
            }
            this.setBlock(world, x + 5, y + y1, z + 4, TragicBlocks.DarkSandstone, 4, 2);
            this.setBlock(world, x - 5, y + y1, z + 4, TragicBlocks.DarkSandstone, 4, 2);
            this.setBlock(world, x + 5, y + y1, z - 4, TragicBlocks.DarkSandstone, 4, 2);
            this.setBlock(world, x - 5, y + y1, z - 4, TragicBlocks.DarkSandstone, 4, 2);
            this.setBlock(world, x + 4, y + y1, z + 5, TragicBlocks.DarkSandstone, 4, 2);
            this.setBlock(world, x - 4, y + y1, z + 5, TragicBlocks.DarkSandstone, 4, 2);
            this.setBlock(world, x + 4, y + y1, z - 5, TragicBlocks.DarkSandstone, 4, 2);
            this.setBlock(world, x - 4, y + y1, z - 5, TragicBlocks.DarkSandstone, 4, 2);
        }
        this.generateTunnels(world, rand, x, y, z);
    }

    public void generateBossRoom(World world, Random rand, int x, int y, int z) {
        int z1;
        int x1;
        int z12;
        int x12;
        int y1;
        this.generateDropdown(world, rand, x, y, z);
        for (y1 = 0; y1 < 8; y1 = (int)((byte)(y1 + 1))) {
            for (x12 = -4; x12 < 5; x12 = (int)((byte)(x12 + 1))) {
                for (z12 = -4; z12 < 5; z12 = (int)((byte)(z12 + 1))) {
                    if (y1 == 0 || y1 >= 6) {
                        this.setBlock(world, x + x12, y + y1 - 16, z + z12, TragicBlocks.DarkSandstone, 0, 2);
                        continue;
                    }
                    this.setBlockToAir(world, x + x12, y + y1 - 16, z + z12);
                }
            }
        }
        for (x1 = -3; x1 < 4; x1 = (int)((byte)(x1 + 1))) {
            for (z1 = -3; z1 < 4; z1 = (int)((byte)(z1 + 1))) {
                this.setBlock(world, x + x1, y - 16, z + z1, TragicBlocks.DarkSandstone, 1, 2);
            }
        }
        for (x1 = -2; x1 < 3; x1 = (int)((byte)(x1 + 1))) {
            this.setBlock(world, x + x1, y - 16, z - 4, TragicBlocks.DarkSandstone, 1, 2);
            this.setBlock(world, x + x1, y - 16, z + 4, TragicBlocks.DarkSandstone, 1, 2);
        }
        for (int z13 = -2; z13 < 3; z13 = (int)((byte)(z13 + 1))) {
            this.setBlock(world, x + 4, y - 16, z + z13, TragicBlocks.DarkSandstone, 1, 2);
            this.setBlock(world, x - 4, y - 16, z + z13, TragicBlocks.DarkSandstone, 1, 2);
        }
        for (x1 = -1; x1 < 2; x1 = (int)((byte)(x1 + 1))) {
            for (z1 = -1; z1 < 2; z1 = (int)((byte)(z1 + 1))) {
                this.setBlock(world, x + x1, y - 16, z + z1, TragicBlocks.DarkSandstone, 0, 2);
            }
        }
        for (y1 = 0; y1 < 8; y1 = (int)((byte)(y1 + 1))) {
            if (y1 == 0) {
                for (x12 = -1; x12 < 2; x12 = (int)((byte)(x12 + 1))) {
                    this.setBlock(world, x + x12, y - 16, z - 2, TragicBlocks.DarkSandstone, 0, 2);
                    this.setBlock(world, x + 2, y - 16, z + x12, TragicBlocks.DarkSandstone, 0, 2);
                    this.setBlock(world, x - 2, y - 16, z + x12, TragicBlocks.DarkSandstone, 0, 2);
                }
            } else {
                for (x12 = -3; x12 < 4; x12 = (int)((byte)(x12 + 1))) {
                    this.setBlock(world, x + x12, y + y1 - 16, z + 5, TragicBlocks.DarkSandstone, 3, 2);
                    this.setBlock(world, x + x12, y + y1 - 16, z - 5, TragicBlocks.DarkSandstone, 3, 2);
                    this.setBlock(world, x + 5, y + y1 - 16, z + x12, TragicBlocks.DarkSandstone, 3, 2);
                    this.setBlock(world, x - 5, y + y1 - 16, z + x12, TragicBlocks.DarkSandstone, 3, 2);
                }
            }
            if (y1 <= 0 || y1 >= 6) continue;
            if (y1 == 1 || y1 == 5) {
                this.setBlock(world, x + 4, y + y1 - 16, z + 4, TragicBlocks.DarkSandstone, 4, 2);
                this.setBlock(world, x - 4, y + y1 - 16, z + 4, TragicBlocks.DarkSandstone, 4, 2);
                this.setBlock(world, x + 4, y + y1 - 16, z - 4, TragicBlocks.DarkSandstone, 4, 2);
                this.setBlock(world, x - 4, y + y1 - 16, z - 4, TragicBlocks.DarkSandstone, 4, 2);
                continue;
            }
            this.setBlock(world, x + 5, y + y1 - 16, z + 4, TragicBlocks.DarkSandstone, 4, 2);
            this.setBlock(world, x - 5, y + y1 - 16, z + 4, TragicBlocks.DarkSandstone, 4, 2);
            this.setBlock(world, x + 5, y + y1 - 16, z - 4, TragicBlocks.DarkSandstone, 4, 2);
            this.setBlock(world, x - 5, y + y1 - 16, z - 4, TragicBlocks.DarkSandstone, 4, 2);
            this.setBlock(world, x + 4, y + y1 - 16, z + 5, TragicBlocks.DarkSandstone, 4, 2);
            this.setBlock(world, x - 4, y + y1 - 16, z + 5, TragicBlocks.DarkSandstone, 4, 2);
            this.setBlock(world, x + 4, y + y1 - 16, z - 5, TragicBlocks.DarkSandstone, 4, 2);
            this.setBlock(world, x - 4, y + y1 - 16, z - 5, TragicBlocks.DarkSandstone, 4, 2);
        }
        for (y1 = -3; y1 > -11; y1 = (int)((byte)(y1 - 1))) {
            for (x12 = -2; x12 < 3; x12 = (int)((byte)(x12 + 1))) {
                for (z12 = -2; z12 < 3; z12 = (int)((byte)(z12 + 1))) {
                    this.setBlock(world, x + x12, y + y1, z + z12, TragicBlocks.DarkSandstone, 0, 2);
                }
            }
            for (x12 = -1; x12 < 2; x12 = (int)((byte)(x12 + 1))) {
                for (z12 = -1; z12 < 2; z12 = (int)((byte)(z12 + 1))) {
                    this.setBlockToAir(world, x + x12, y + y1, z + z12);
                }
            }
        }
        for (y1 = 0; y1 < 7; y1 = (int)((byte)(y1 + 1))) {
            for (z1 = 5; z1 < 13; z1 = (int)((byte)(z1 + 1))) {
                int x13;
                for (x13 = -3; x13 < 4; x13 = (int)((byte)(x13 + 1))) {
                    this.setBlockToAir(world, x + x13, y + y1 - 16, z + z1);
                }
                if (y1 == 0) {
                    for (x13 = -1; x13 < 2; x13 = (int)((byte)(x13 + 1))) {
                        this.setBlock(world, x + x13, y - 16, z + z1, TragicBlocks.DarkSandstone, 1, 2);
                    }
                    this.setBlock(world, x - 2, y - 16, z + z1, TragicBlocks.DarkSandstone, 0, 2);
                    this.setBlock(world, x + 2, y - 16, z + z1, TragicBlocks.DarkSandstone, 0, 2);
                    if (z1 != 6 && z1 != 7 && z1 != 10 && z1 != 11) continue;
                    this.setBlock(world, x - 3, y - 16, z + z1, TragicBlocks.DarkSandstone, 0, 2);
                    this.setBlock(world, x + 3, y - 16, z + z1, TragicBlocks.DarkSandstone, 0, 2);
                    continue;
                }
                if (y1 < 6) {
                    if (z1 == 6 || z1 == 7 || z1 == 10 || z1 == 11) {
                        this.setBlock(world, x + 4, y + y1 - 16, z + z1, TragicBlocks.DarkSandstone, 4, 2);
                        this.setBlock(world, x - 4, y + y1 - 16, z + z1, TragicBlocks.DarkSandstone, 4, 2);
                        if (y1 == 5) {
                            this.setBlock(world, x + 3, y + y1 - 16, z + z1, TragicBlocks.DarkSandstone, 2, 2);
                            this.setBlock(world, x - 3, y + y1 - 16, z + z1, TragicBlocks.DarkSandstone, 2, 2);
                        }
                    }
                    if (z1 == 5 || z1 == 8 || z1 == 9 || z1 == 12) {
                        byte m = (byte)(y1 == 5 ? 3 : 2);
                        this.setBlock(world, x + 3, y + y1 - 16, z + z1, TragicBlocks.DarkSandstone, m, 2);
                        this.setBlock(world, x - 3, y + y1 - 16, z + z1, TragicBlocks.DarkSandstone, m, 2);
                    }
                    if (z1 != 5 && z1 != 11 || y1 != 1) continue;
                    this.setBlock(world, x + 2, y + y1 - 16, z + z1, TragicBlocks.Candle, 8, 2);
                    this.setBlock(world, x - 2, y + y1 - 16, z + z1, TragicBlocks.Candle, 8, 2);
                    continue;
                }
                this.setBlock(world, x + 2, y + y1 - 16, z + z1, TragicBlocks.DarkSandstone, 4, 2);
                this.setBlock(world, x - 2, y + y1 - 16, z + z1, TragicBlocks.DarkSandstone, 4, 2);
                if (z1 == 5 || z1 == 12) {
                    for (x13 = -1; x13 < 2; x13 = (int)((byte)(x13 + 1))) {
                        this.setBlock(world, x + x13, y + y1 - 16, z + z1, TragicBlocks.DarkSandstone, 4, 2);
                    }
                    continue;
                }
                for (x13 = -1; x13 < 2; x13 = (int)((byte)(x13 + 1))) {
                    this.setBlock(world, x + x13, y + y1 - 15, z + z1, TragicBlocks.DarkSandstone, 3, 2);
                }
            }
        }
        this.generateAltarRoom(world, rand, x, y - 16, z + 24);
    }

    public void generateAltarRoom(World world, Random rand, int x, int y, int z) {
        for (int y1 = 0; y1 < 11; y1 = (int)((byte)(y1 + 1))) {
            int z1;
            int z12;
            int x1;
            for (x1 = -10; x1 < 11 && y1 > 0; x1 = (int)((byte)(x1 + 1))) {
                for (z12 = -11; z12 < 12; z12 = (int)((byte)(z12 + 1))) {
                    this.setBlockToAir(world, x + x1, y + y1, z + z12);
                }
            }
            for (x1 = -11; x1 < 12; x1 = (int)((byte)(x1 + 1))) {
                this.setBlock(world, x + x1, y + y1, z - 12, TragicBlocks.DarkSandstone, 4, 2);
                this.setBlock(world, x + x1, y + y1, z + 12, TragicBlocks.DarkSandstone, 4, 2);
                this.setBlock(world, x + 11, y + y1, z + x1, TragicBlocks.DarkSandstone, 4, 2);
                this.setBlock(world, x - 11, y + y1, z + x1, TragicBlocks.DarkSandstone, 4, 2);
            }
            for (x1 = -2; x1 < 3 && y1 > 0 && y1 < 7; x1 = (int)((byte)(x1 + 1))) {
                for (z12 = -12; z12 < -8; z12 = (int)((byte)(z12 + 1))) {
                    this.setBlockToAir(world, x + x1, y + y1, z + z12);
                }
            }
            if (y1 == 0 || y1 == 10) {
                for (x1 = -10; x1 < 11; x1 = (int)((byte)(x1 + 1))) {
                    for (z12 = -11; z12 < 12; z12 = (int)((byte)(z12 + 1))) {
                        this.setBlock(world, x + x1, y + y1, z + z12, TragicBlocks.DarkSandstone, 1, 2);
                    }
                }
                if (y1 == 0) {
                    for (z1 = -11; z1 < 12; z1 = (int)((byte)(z1 + 1))) {
                        for (int x12 = -1; x12 < 2; x12 = (int)((byte)(x12 + 1))) {
                            this.setBlock(world, x + x12, y + y1, z + z1, TragicBlocks.DarkSandstone, 4, 2);
                        }
                        this.setBlock(world, x + 2, y + y1, z + z1, TragicBlocks.DarkSandstone, 0, 2);
                        this.setBlock(world, x - 2, y + y1, z + z1, TragicBlocks.DarkSandstone, 0, 2);
                    }
                }
            }
            for (z1 = -9; z1 < 6 && y1 > 0; z1 = (int)((byte)(z1 + 3))) {
                this.setBlock(world, x + 2, y + y1, z + z1, TragicBlocks.DarkSandstone, 3, 2);
                this.setBlock(world, x - 2, y + y1, z + z1, TragicBlocks.DarkSandstone, 3, 2);
            }
            for (z1 = -11; z1 < 12 && y1 > 0; z1 = (int)((byte)(z1 + 4))) {
                this.setBlock(world, x + 10, y + y1, z + z1, TragicBlocks.DarkSandstone, 2, 2);
                this.setBlock(world, x - 10, y + y1, z + z1, TragicBlocks.DarkSandstone, 2, 2);
            }
            if (y1 > 0) {
                this.setBlock(world, x + 6, y + y1, z - 11, TragicBlocks.DarkSandstone, 2, 2);
                this.setBlock(world, x + 3, y + y1, z - 11, TragicBlocks.DarkSandstone, 2, 2);
                this.setBlock(world, x - 3, y + y1, z - 11, TragicBlocks.DarkSandstone, 2, 2);
                this.setBlock(world, x - 6, y + y1, z - 11, TragicBlocks.DarkSandstone, 2, 2);
                if (y1 > 1) {
                    this.setBlock(world, x + 6, y + y1, z + 11, TragicBlocks.DarkSandstone, 2, 2);
                    this.setBlock(world, x + 3, y + y1, z + 11, TragicBlocks.DarkSandstone, 2, 2);
                    this.setBlock(world, x - 3, y + y1, z + 11, TragicBlocks.DarkSandstone, 2, 2);
                    this.setBlock(world, x - 6, y + y1, z + 11, TragicBlocks.DarkSandstone, 2, 2);
                }
            }
            if (y1 == 1) {
                for (int i = 0; i < 42; i = (int)((byte)(i + 1))) {
                    int xr = x + (rand.nextInt(9) + 3) * (rand.nextBoolean() ? -1 : 1);
                    int zr = z + rand.nextInt(24) - 12;
                    this.setBlock(world, xr, y + y1, zr, TragicBlocks.Candle, 8, 2);
                }
                continue;
            }
            if (y1 == 7) {
                this.setBlock(world, x + 2, y + y1, z - 11, TragicBlocks.DarkSandstone, 2, 2);
                this.setBlock(world, x - 2, y + y1, z - 11, TragicBlocks.DarkSandstone, 2, 2);
                this.setBlock(world, x + 1, y + y1, z - 11, TragicBlocks.DarkSandstone, 2, 2);
                this.setBlock(world, x - 1, y + y1, z - 11, TragicBlocks.DarkSandstone, 2, 2);
                this.setBlock(world, x, y + y1, z - 11, TragicBlocks.DarkSandstone, 5, 2);
                continue;
            }
            if (y1 != 8) continue;
            this.setBlock(world, x + 2, y + y1, z - 11, TragicBlocks.Candle, 8, 2);
            this.setBlock(world, x - 2, y + y1, z - 11, TragicBlocks.Candle, 8, 2);
            this.setBlock(world, x + 1, y + y1, z - 11, TragicBlocks.DarkSandstone, 2, 2);
            this.setBlock(world, x - 1, y + y1, z - 11, TragicBlocks.DarkSandstone, 2, 2);
            this.setBlock(world, x, y + y1, z - 11, TragicBlocks.DarkSandstone, 2, 2);
        }
        for (int z1 = 5; z1 < 12; z1 = (int)((byte)(z1 + 1))) {
            this.setBlock(world, x + 2, y + 1, z + z1, TragicBlocks.DarkSandstone, z1 > 5 ? 1 : 0, 2);
            this.setBlock(world, x + 1, y + 1, z + z1, TragicBlocks.DarkSandstone, z1 > 5 ? 1 : 0, 2);
            this.setBlock(world, x, y + 1, z + z1, TragicBlocks.DarkSandstone, z1 > 5 ? 1 : 0, 2);
            this.setBlock(world, x - 1, y + 1, z + z1, TragicBlocks.DarkSandstone, z1 > 5 ? 1 : 0, 2);
            this.setBlock(world, x - 2, y + 1, z + z1, TragicBlocks.DarkSandstone, z1 > 5 ? 1 : 0, 2);
            if (z1 > 5) {
                this.setBlock(world, x + 3, y + 1, z + z1, TragicBlocks.DarkSandstone, z1 > 6 ? 1 : 0, 2);
                this.setBlock(world, x - 3, y + 1, z + z1, TragicBlocks.DarkSandstone, z1 > 6 ? 1 : 0, 2);
                if (z1 > 6) {
                    this.setBlock(world, x + 4, y + 1, z + z1, TragicBlocks.DarkSandstone, z1 > 7 ? 1 : 0, 2);
                    this.setBlock(world, x - 4, y + 1, z + z1, TragicBlocks.DarkSandstone, z1 > 7 ? 1 : 0, 2);
                    this.setBlock(world, x + 5, y + 1, z + z1, TragicBlocks.DarkSandstone, z1 > 7 ? 1 : 0, 2);
                    this.setBlock(world, x - 5, y + 1, z + z1, TragicBlocks.DarkSandstone, z1 > 7 ? 1 : 0, 2);
                    if (z1 > 7) {
                        this.setBlock(world, x + 6, y + 1, z + z1, TragicBlocks.DarkSandstone, z1 > 8 ? 1 : 0, 2);
                        this.setBlock(world, x - 6, y + 1, z + z1, TragicBlocks.DarkSandstone, z1 > 8 ? 1 : 0, 2);
                        if (z1 > 8) {
                            this.setBlock(world, x + 7, y + 1, z + z1, TragicBlocks.DarkSandstone, 0, 2);
                            this.setBlock(world, x - 7, y + 1, z + z1, TragicBlocks.DarkSandstone, 0, 2);
                        }
                    }
                }
            }
            if (z1 < 10) continue;
            this.setBlock(world, x + 1, y + 2, z + z1, TragicBlocks.DarkSandstone, 3, 2);
            this.setBlock(world, x, y + 2, z + z1, TragicBlocks.DarkSandstone, 3, 2);
            this.setBlock(world, x - 1, y + 2, z + z1, TragicBlocks.DarkSandstone, 3, 2);
            if (z1 == 11) {
                for (int y1 = 3; y1 < 7; y1 = (int)((byte)(y1 + 1))) {
                    this.setBlock(world, x + 1, y + y1, z + z1, TragicBlocks.DarkSandstone, 3, 2);
                    if (y1 < 6) {
                        this.setBlock(world, x, y + y1, z + z1, TragicBlocks.DarkSandstone, 3, 2);
                    }
                    this.setBlock(world, x - 1, y + y1, z + z1, TragicBlocks.DarkSandstone, 3, 2);
                }
                continue;
            }
            this.setBlock(world, x + 1, y + 3, z + z1, TragicBlocks.Candle, 8, 2);
            this.setBlock(world, x, y + 3, z + z1, TragicBlocks.SummonBlock, 9, 2);
            this.setBlock(world, x, y + 1, z + z1, (Block)Blocks.field_150486_ae, 0, 2, ChestHooks.epicHook);
            this.setBlock(world, x - 1, y + 3, z + z1, TragicBlocks.Candle, 8, 2);
        }
        this.setBlock(world, x + 2, y + 2, z + 6, TragicBlocks.Candle, 8, 2);
        this.setBlock(world, x - 2, y + 2, z + 6, TragicBlocks.Candle, 8, 2);
        this.setBlock(world, x + 5, y + 2, z + 10, TragicBlocks.Candle, 8, 2);
        this.setBlock(world, x - 5, y + 2, z + 10, TragicBlocks.Candle, 8, 2);
    }

    public void generateTrapRoom(World world, Random rand, int x, int y, int z) {
        int z1;
        int x1;
        int z12;
        int x12;
        int y1;
        for (y1 = 0; y1 < 8; y1 = (int)((byte)(y1 + 1))) {
            for (x12 = -4; x12 < 5; x12 = (int)((byte)(x12 + 1))) {
                for (z12 = -4; z12 < 5; z12 = (int)((byte)(z12 + 1))) {
                    if (y1 == 0 || y1 >= 6) {
                        this.setBlock(world, x + x12, y + y1, z + z12, TragicBlocks.DarkSandstone, 0, 2);
                        continue;
                    }
                    this.setBlockToAir(world, x + x12, y + y1, z + z12);
                }
            }
        }
        for (x1 = -3; x1 < 4; x1 = (int)((byte)(x1 + 1))) {
            for (z1 = -3; z1 < 4; z1 = (int)((byte)(z1 + 1))) {
                this.setBlock(world, x + x1, y, z + z1, TragicBlocks.DarkSandstone, 1, 2);
            }
        }
        for (x1 = -2; x1 < 3; x1 = (int)((byte)(x1 + 1))) {
            this.setBlock(world, x + x1, y, z - 4, TragicBlocks.DarkSandstone, 1, 2);
            this.setBlock(world, x + x1, y, z + 4, TragicBlocks.DarkSandstone, 1, 2);
        }
        for (int z13 = -2; z13 < 3; z13 = (int)((byte)(z13 + 1))) {
            this.setBlock(world, x + 4, y, z + z13, TragicBlocks.DarkSandstone, 1, 2);
            this.setBlock(world, x - 4, y, z + z13, TragicBlocks.DarkSandstone, 1, 2);
        }
        for (x1 = -1; x1 < 2; x1 = (int)((byte)(x1 + 1))) {
            for (z1 = -1; z1 < 2; z1 = (int)((byte)(z1 + 1))) {
                this.setBlock(world, x + x1, y, z + z1, TragicBlocks.DarkSandstone, 0, 2);
            }
        }
        for (y1 = 0; y1 < 8; y1 = (int)((byte)(y1 + 1))) {
            if (y1 == 0) {
                for (x12 = -1; x12 < 2; x12 = (int)((byte)(x12 + 1))) {
                    for (z12 = -1; z12 < 2; z12 = (int)((byte)(z12 + 1))) {
                        this.setBlock(world, x + 1, y, z + 2, TragicBlocks.DarkSandstone, 0, 2);
                        this.setBlock(world, x - 1, y, z + 2, TragicBlocks.DarkSandstone, 0, 2);
                        this.setBlock(world, x, y, z + 2, TragicBlocks.DarkSandstone, 0, 2);
                        this.setBlock(world, x + 1, y, z - 2, TragicBlocks.DarkSandstone, 0, 2);
                        this.setBlock(world, x - 1, y, z - 2, TragicBlocks.DarkSandstone, 0, 2);
                        this.setBlock(world, x, y, z - 2, TragicBlocks.DarkSandstone, 0, 2);
                        this.setBlock(world, x + 2, y, z - 1, TragicBlocks.DarkSandstone, 0, 2);
                        this.setBlock(world, x + 2, y, z, TragicBlocks.DarkSandstone, 0, 2);
                        this.setBlock(world, x + 2, y, z + 1, TragicBlocks.DarkSandstone, 0, 2);
                        this.setBlock(world, x - 2, y, z - 1, TragicBlocks.DarkSandstone, 0, 2);
                        this.setBlock(world, x - 2, y, z, TragicBlocks.DarkSandstone, 0, 2);
                        this.setBlock(world, x - 2, y, z + 1, TragicBlocks.DarkSandstone, 0, 2);
                    }
                }
            }
            if (y1 <= 0 || y1 >= 6) continue;
            if (y1 == 1 || y1 == 5) {
                this.setBlock(world, x + 4, y + y1, z + 4, TragicBlocks.DarkSandstone, 4, 2);
                this.setBlock(world, x - 4, y + y1, z + 4, TragicBlocks.DarkSandstone, 4, 2);
                this.setBlock(world, x + 4, y + y1, z - 4, TragicBlocks.DarkSandstone, 4, 2);
                this.setBlock(world, x - 4, y + y1, z - 4, TragicBlocks.DarkSandstone, 4, 2);
                continue;
            }
            this.setBlock(world, x + 5, y + y1, z + 4, TragicBlocks.DarkSandstone, 4, 2);
            this.setBlock(world, x - 5, y + y1, z + 4, TragicBlocks.DarkSandstone, 4, 2);
            this.setBlock(world, x + 5, y + y1, z - 4, TragicBlocks.DarkSandstone, 4, 2);
            this.setBlock(world, x - 5, y + y1, z - 4, TragicBlocks.DarkSandstone, 4, 2);
            this.setBlock(world, x + 4, y + y1, z + 5, TragicBlocks.DarkSandstone, 4, 2);
            this.setBlock(world, x - 4, y + y1, z + 5, TragicBlocks.DarkSandstone, 4, 2);
            this.setBlock(world, x + 4, y + y1, z - 5, TragicBlocks.DarkSandstone, 4, 2);
            this.setBlock(world, x - 4, y + y1, z - 5, TragicBlocks.DarkSandstone, 4, 2);
        }
        byte r = (byte)rand.nextInt(6);
        switch (r) {
            default: {
                this.setBlock(world, x, y + 1, z, Blocks.field_150447_bR, 0, 2, ChestHooks.uncommonHook);
                this.setBlock(world, x, y + 2, z, Blocks.field_150474_ac, 0, 2, "Blaze");
                break;
            }
            case 1: {
                this.setBlock(world, x, y + 1, z, Blocks.field_150447_bR, 0, 2, ChestHooks.uncommonHook);
                break;
            }
            case 2: {
                this.setBlock(world, x, y + 1, z, Blocks.field_150474_ac, 0, 2, "Blaze");
                break;
            }
            case 3: {
                this.setBlock(world, x, y + 1, z, Blocks.field_150474_ac, 0, 2, "Blaze");
                this.setBlock(world, x, y + 2, z, Blocks.field_150447_bR, 0, 2, ChestHooks.uncommonHook);
                for (x12 = -3; x12 < 4; x12 = (int)((byte)(x12 + 1))) {
                    for (z12 = -3; z12 < 4; z12 = (int)((byte)(z12 + 1))) {
                        this.setBlock(world, x + x12, y - 1, z + z12, TragicBlocks.DarkSandstone, 0, 2);
                        this.setBlock(world, x + x12, y, z + z12, (Block)Blocks.field_150356_k, 0, 2);
                    }
                }
                for (x12 = -4; x12 < 5; x12 = (int)((byte)(x12 + 1))) {
                    for (z12 = -2; z12 < 3; z12 = (int)((byte)(z12 + 1))) {
                        this.setBlock(world, x + x12, y - 1, z + z12, TragicBlocks.DarkSandstone, 0, 2);
                        this.setBlock(world, x + x12, y, z + z12, (Block)Blocks.field_150356_k, 0, 2);
                        this.setBlock(world, x + z12, y - 1, z + x12, TragicBlocks.DarkSandstone, 0, 2);
                        this.setBlock(world, x + z12, y, z + x12, (Block)Blocks.field_150356_k, 0, 2);
                    }
                }
                break;
            }
            case 4: {
                for (x12 = -1; x12 < 2; x12 = (int)((byte)(x12 + 1))) {
                    for (z12 = -1; z12 < 2; z12 = (int)((byte)(z12 + 1))) {
                        this.setBlock(world, x + x12, y + 1, z + z12, Blocks.field_150474_ac, 0, 2, "Blaze");
                    }
                }
                this.setBlock(world, x, y + 1, z, Blocks.field_150447_bR, 0, 2, ChestHooks.uncommonHook);
                break;
            }
            case 5: {
                for (x12 = -1; x12 < 2; x12 = (int)((byte)(x12 + 1))) {
                    for (z12 = -1; z12 < 2; z12 = (int)((byte)(z12 + 1))) {
                        this.setBlock(world, x + x12, y + 1, z + z12, Blocks.field_150474_ac, 0, 2, "Blaze");
                    }
                }
                this.setBlock(world, x, y + 1, z, Blocks.field_150447_bR, 0, 2, ChestHooks.uncommonHook);
                this.setBlock(world, x, y, z, Blocks.field_150335_W, 0, 2);
            }
        }
        this.generateTunnels(world, rand, x, y, z);
    }

    public void generateTunnels(World world, Random rand, int x, int y, int z) {
        for (int y1 = 0; y1 < 7; y1 = (int)((byte)(y1 + 1))) {
            int z1;
            int x1;
            int m;
            int x12;
            int z12;
            for (z12 = -5; z12 > -9; z12 = (int)((byte)(z12 - 1))) {
                for (x12 = -3; x12 < 4; x12 = (int)((byte)(x12 + 1))) {
                    this.setBlockToAir(world, x + x12, y + y1, z + z12);
                }
                if (y1 == 0) {
                    for (x12 = -1; x12 < 2; x12 = (int)((byte)(x12 + 1))) {
                        this.setBlock(world, x + x12, y, z + z12, TragicBlocks.DarkSandstone, 1, 2);
                    }
                    this.setBlock(world, x - 2, y, z + z12, TragicBlocks.DarkSandstone, 0, 2);
                    this.setBlock(world, x + 2, y, z + z12, TragicBlocks.DarkSandstone, 0, 2);
                    if (z12 != -6 && z12 != -7) continue;
                    this.setBlock(world, x - 3, y, z + z12, TragicBlocks.DarkSandstone, 0, 2);
                    this.setBlock(world, x + 3, y, z + z12, TragicBlocks.DarkSandstone, 0, 2);
                    continue;
                }
                if (y1 < 6) {
                    if (z12 == -6 || z12 == -7) {
                        this.setBlock(world, x + 4, y + y1, z + z12, TragicBlocks.DarkSandstone, 4, 2);
                        this.setBlock(world, x - 4, y + y1, z + z12, TragicBlocks.DarkSandstone, 4, 2);
                        if (y1 == 5) {
                            this.setBlock(world, x + 3, y + y1, z + z12, TragicBlocks.DarkSandstone, 2, 2);
                            this.setBlock(world, x - 3, y + y1, z + z12, TragicBlocks.DarkSandstone, 2, 2);
                        }
                    }
                    if (z12 == -5 || z12 == -8) {
                        m = y1 == 5 ? 3 : 2;
                        this.setBlock(world, x + 3, y + y1, z + z12, TragicBlocks.DarkSandstone, m, 2);
                        this.setBlock(world, x - 3, y + y1, z + z12, TragicBlocks.DarkSandstone, m, 2);
                    }
                    if (z12 != -5 || y1 != 1) continue;
                    this.setBlock(world, x + 2, y + y1, z + z12, TragicBlocks.Candle, 8, 2);
                    this.setBlock(world, x - 2, y + y1, z + z12, TragicBlocks.Candle, 8, 2);
                    continue;
                }
                this.setBlock(world, x + 2, y + y1, z + z12, TragicBlocks.DarkSandstone, 4, 2);
                this.setBlock(world, x - 2, y + y1, z + z12, TragicBlocks.DarkSandstone, 4, 2);
                if (z12 == -5) {
                    for (x12 = -1; x12 < 2; x12 = (int)((byte)(x12 + 1))) {
                        this.setBlock(world, x + x12, y + y1, z + z12, TragicBlocks.DarkSandstone, 4, 2);
                    }
                    continue;
                }
                for (x12 = -1; x12 < 2; x12 = (int)((byte)(x12 + 1))) {
                    this.setBlock(world, x + x12, y + y1 + 1, z + z12, TragicBlocks.DarkSandstone, 3, 2);
                }
            }
            for (z12 = 5; z12 < 9; z12 = (int)((byte)(z12 + 1))) {
                for (x12 = -3; x12 < 4; x12 = (int)((byte)(x12 + 1))) {
                    this.setBlockToAir(world, x + x12, y + y1, z + z12);
                }
                if (y1 == 0) {
                    for (x12 = -1; x12 < 2; x12 = (int)((byte)(x12 + 1))) {
                        this.setBlock(world, x + x12, y, z + z12, TragicBlocks.DarkSandstone, 1, 2);
                    }
                    this.setBlock(world, x - 2, y, z + z12, TragicBlocks.DarkSandstone, 0, 2);
                    this.setBlock(world, x + 2, y, z + z12, TragicBlocks.DarkSandstone, 0, 2);
                    if (z12 != 6 && z12 != 7) continue;
                    this.setBlock(world, x - 3, y, z + z12, TragicBlocks.DarkSandstone, 0, 2);
                    this.setBlock(world, x + 3, y, z + z12, TragicBlocks.DarkSandstone, 0, 2);
                    continue;
                }
                if (y1 < 6) {
                    if (z12 == 6 || z12 == 7) {
                        this.setBlock(world, x + 4, y + y1, z + z12, TragicBlocks.DarkSandstone, 4, 2);
                        this.setBlock(world, x - 4, y + y1, z + z12, TragicBlocks.DarkSandstone, 4, 2);
                        if (y1 == 5) {
                            this.setBlock(world, x + 3, y + y1, z + z12, TragicBlocks.DarkSandstone, 2, 2);
                            this.setBlock(world, x - 3, y + y1, z + z12, TragicBlocks.DarkSandstone, 2, 2);
                        }
                    }
                    if (z12 == 5 || z12 == 8) {
                        m = y1 == 5 ? 3 : 2;
                        this.setBlock(world, x + 3, y + y1, z + z12, TragicBlocks.DarkSandstone, m, 2);
                        this.setBlock(world, x - 3, y + y1, z + z12, TragicBlocks.DarkSandstone, m, 2);
                    }
                    if (z12 != 5 || y1 != 1) continue;
                    this.setBlock(world, x + 2, y + y1, z + z12, TragicBlocks.Candle, 8, 2);
                    this.setBlock(world, x - 2, y + y1, z + z12, TragicBlocks.Candle, 8, 2);
                    continue;
                }
                this.setBlock(world, x + 2, y + y1, z + z12, TragicBlocks.DarkSandstone, 4, 2);
                this.setBlock(world, x - 2, y + y1, z + z12, TragicBlocks.DarkSandstone, 4, 2);
                if (z12 == 5) {
                    for (x12 = -1; x12 < 2; x12 = (int)((byte)(x12 + 1))) {
                        this.setBlock(world, x + x12, y + y1, z + z12, TragicBlocks.DarkSandstone, 4, 2);
                    }
                    continue;
                }
                for (x12 = -1; x12 < 2; x12 = (int)((byte)(x12 + 1))) {
                    this.setBlock(world, x + x12, y + y1 + 1, z + z12, TragicBlocks.DarkSandstone, 3, 2);
                }
            }
            for (x1 = -5; x1 > -9; x1 = (int)((byte)(x1 - 1))) {
                for (z1 = -3; z1 < 4; z1 = (int)((byte)(z1 + 1))) {
                    this.setBlockToAir(world, x + x1, y + y1, z + z1);
                }
                if (y1 == 0) {
                    for (z1 = -1; z1 < 2; z1 = (int)((byte)(z1 + 1))) {
                        this.setBlock(world, x + x1, y, z + z1, TragicBlocks.DarkSandstone, 1, 2);
                    }
                    this.setBlock(world, x + x1, y, z + 2, TragicBlocks.DarkSandstone, 0, 2);
                    this.setBlock(world, x + x1, y, z - 2, TragicBlocks.DarkSandstone, 0, 2);
                    if (x1 != -6 && x1 != -7) continue;
                    this.setBlock(world, x + x1, y, z - 3, TragicBlocks.DarkSandstone, 0, 2);
                    this.setBlock(world, x + x1, y, z + 3, TragicBlocks.DarkSandstone, 0, 2);
                    continue;
                }
                if (y1 < 6) {
                    if (x1 == -6 || x1 == -7) {
                        this.setBlock(world, x + x1, y + y1, z + 4, TragicBlocks.DarkSandstone, 4, 2);
                        this.setBlock(world, x + x1, y + y1, z - 4, TragicBlocks.DarkSandstone, 4, 2);
                        if (y1 == 5) {
                            this.setBlock(world, x + x1, y + y1, z + 3, TragicBlocks.DarkSandstone, 2, 2);
                            this.setBlock(world, x + x1, y + y1, z - 3, TragicBlocks.DarkSandstone, 2, 2);
                        }
                    }
                    if (x1 == -5 || x1 == -8) {
                        m = y1 == 5 ? 3 : 2;
                        this.setBlock(world, x + x1, y + y1, z + 3, TragicBlocks.DarkSandstone, m, 2);
                        this.setBlock(world, x + x1, y + y1, z - 3, TragicBlocks.DarkSandstone, m, 2);
                    }
                    if (x1 != -5 || y1 != 1) continue;
                    this.setBlock(world, x + x1, y + y1, z + 2, TragicBlocks.Candle, 8, 2);
                    this.setBlock(world, x + x1, y + y1, z - 2, TragicBlocks.Candle, 8, 2);
                    continue;
                }
                this.setBlock(world, x + x1, y + y1, z + 2, TragicBlocks.DarkSandstone, 4, 2);
                this.setBlock(world, x + x1, y + y1, z - 2, TragicBlocks.DarkSandstone, 4, 2);
                if (x1 == -5) {
                    for (z1 = -1; z1 < 2; z1 = (int)((byte)(z1 + 1))) {
                        this.setBlock(world, x + x1, y + y1, z + z1, TragicBlocks.DarkSandstone, 4, 2);
                    }
                    continue;
                }
                for (z1 = -1; z1 < 2; z1 = (int)((byte)(z1 + 1))) {
                    this.setBlock(world, x + x1, y + y1 + 1, z + z1, TragicBlocks.DarkSandstone, 3, 2);
                }
            }
            for (x1 = 5; x1 < 9; x1 = (int)((byte)(x1 + 1))) {
                for (z1 = -3; z1 < 4; z1 = (int)((byte)(z1 + 1))) {
                    this.setBlockToAir(world, x + x1, y + y1, z + z1);
                }
                if (y1 == 0) {
                    for (z1 = -1; z1 < 2; z1 = (int)((byte)(z1 + 1))) {
                        this.setBlock(world, x + x1, y, z + z1, TragicBlocks.DarkSandstone, 1, 2);
                    }
                    this.setBlock(world, x + x1, y, z + 2, TragicBlocks.DarkSandstone, 0, 2);
                    this.setBlock(world, x + x1, y, z - 2, TragicBlocks.DarkSandstone, 0, 2);
                    if (x1 != 6 && x1 != 7) continue;
                    this.setBlock(world, x + x1, y, z - 3, TragicBlocks.DarkSandstone, 0, 2);
                    this.setBlock(world, x + x1, y, z + 3, TragicBlocks.DarkSandstone, 0, 2);
                    continue;
                }
                if (y1 < 6) {
                    if (x1 == 6 || x1 == 7) {
                        this.setBlock(world, x + x1, y + y1, z + 4, TragicBlocks.DarkSandstone, 4, 2);
                        this.setBlock(world, x + x1, y + y1, z - 4, TragicBlocks.DarkSandstone, 4, 2);
                        if (y1 == 5) {
                            this.setBlock(world, x + x1, y + y1, z + 3, TragicBlocks.DarkSandstone, 2, 2);
                            this.setBlock(world, x + x1, y + y1, z - 3, TragicBlocks.DarkSandstone, 2, 2);
                        }
                    }
                    if (x1 == 5 || x1 == 8) {
                        m = (byte)(y1 == 5 ? 3 : 2);
                        this.setBlock(world, x + x1, y + y1, z + 3, TragicBlocks.DarkSandstone, m, 2);
                        this.setBlock(world, x + x1, y + y1, z - 3, TragicBlocks.DarkSandstone, m, 2);
                    }
                    if (x1 != 5 || y1 != 1) continue;
                    this.setBlock(world, x + x1, y + y1, z + 2, TragicBlocks.Candle, 8, 2);
                    this.setBlock(world, x + x1, y + y1, z - 2, TragicBlocks.Candle, 8, 2);
                    continue;
                }
                this.setBlock(world, x + x1, y + y1, z + 2, TragicBlocks.DarkSandstone, 4, 2);
                this.setBlock(world, x + x1, y + y1, z - 2, TragicBlocks.DarkSandstone, 4, 2);
                if (x1 == 5) {
                    for (z1 = -1; z1 < 2; z1 = (int)((byte)(z1 + 1))) {
                        this.setBlock(world, x + x1, y + y1, z + z1, TragicBlocks.DarkSandstone, 4, 2);
                    }
                    continue;
                }
                for (z1 = -1; z1 < 2; z1 = (int)((byte)(z1 + 1))) {
                    this.setBlock(world, x + x1, y + y1 + 1, z + z1, TragicBlocks.DarkSandstone, 3, 2);
                }
            }
        }
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        tag.func_74773_a("mapValues0", this.map[0]);
        tag.func_74773_a("mapValues1", this.map[1]);
        tag.func_74773_a("mapValues2", this.map[2]);
        tag.func_74773_a("mapValues3", this.map[3]);
        tag.func_74773_a("mapValues4", this.map[4]);
        tag.func_74773_a("map2Values0", this.map2[0]);
        tag.func_74773_a("map2Values1", this.map2[1]);
        tag.func_74773_a("map2Values2", this.map2[2]);
        tag.func_74773_a("map2Values3", this.map2[3]);
        tag.func_74773_a("map2Values4", this.map2[4]);
        return tag;
    }

    @Override
    public Schematic readFromNBT(NBTTagCompound tag) {
        for (int b = 0; b < this.map.length; b = (int)((byte)(b + 1))) {
            this.map[b] = tag.func_74770_j("mapValues" + b);
            this.map2[b] = tag.func_74770_j("map2Values" + b);
        }
        return this;
    }
}

