/*
 * Decompiled with CFR 0.152.
 */
package tragicneko.tragicmc.worldgen.biome;

import java.util.Random;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import tragicneko.tragicmc.TragicBiome;
import tragicneko.tragicmc.TragicBlocks;
import tragicneko.tragicmc.TragicConfig;
import tragicneko.tragicmc.entity.boss.EntityApis;
import tragicneko.tragicmc.entity.mob.EntityArchangel;
import tragicneko.tragicmc.entity.mob.EntityIre;
import tragicneko.tragicmc.worldgen.StringWorldGen;
import tragicneko.tragicmc.worldgen.SurfacePlantWorldGen;
import tragicneko.tragicmc.worldgen.SurfaceWorldGen2;
import tragicneko.tragicmc.worldgen.WorldGenCustomOakTree;

public class BiomeGenHallowedHills
extends TragicBiome {
    public final StringWorldGen stringGen;
    public final SurfaceWorldGen2 lightGen;
    public final SurfaceWorldGen2 fragileGen;
    public final SurfacePlantWorldGen honeydropGen;
    public static final float[][] heights = new float[][]{{0.35f, 0.52f}, {0.12f, 0.36f}, {0.01f, 0.65f}, {1.55f, 0.85f}};

    public BiomeGenHallowedHills(int par1, byte par2) {
        super(par1, par2);
        this.field_76766_R = false;
        this.field_76750_F = 1.6f;
        this.field_76751_G = 0.4f;
        this.field_76749_E = heights[this.variant][0];
        this.field_76748_D = heights[this.variant][1];
        int n = this.variant == 0 ? 4 : (this.field_76760_I.field_76832_z = this.variant == 1 ? 12 : 2);
        this.field_76760_I.field_76802_A = this.variant == 0 || this.variant == 3 ? 1 : (this.variant == 2 ? 12 : 4);
        this.field_76753_B = TragicBlocks.DeadDirt.func_176223_P();
        this.field_76752_A = TragicBlocks.HallowedGrass.func_176223_P();
        if (TragicConfig.getBoolean("allowApis")) {
            this.field_76761_J.add(new BiomeGenBase.SpawnListEntry(EntityApis.class, TragicConfig.getInt("apisSpawnChance"), 0, 0));
        }
        if (TragicConfig.getBoolean("allowArchangel")) {
            this.field_76761_J.add(new BiomeGenBase.SpawnListEntry(EntityArchangel.class, TragicConfig.getInt("archangelSpawnChance"), TragicConfig.getIntArray("archangelGroupSize")[0], TragicConfig.getIntArray("archangelGroupSize")[1]));
        }
        if (TragicConfig.getBoolean("allowIre")) {
            this.field_76761_J.add(new BiomeGenBase.SpawnListEntry(EntityIre.class, TragicConfig.getInt("ireSpawnChance"), TragicConfig.getIntArray("ireGroupSize")[0], TragicConfig.getIntArray("ireGroupSize")[1]));
        }
        this.stringGen = new StringWorldGen(TragicBlocks.StringLight, 0, 12);
        this.lightGen = new SurfaceWorldGen2(6, TragicBlocks.Light, 0, 4, 4);
        this.fragileGen = new SurfaceWorldGen2(2, TragicBlocks.FragileLight, 0, 4, 4);
        this.honeydropGen = new SurfacePlantWorldGen(4, TragicBlocks.Honeydrop, 14, 4, 4, 3);
    }

    @Override
    public int getFlowersFromBiomeType() {
        return this.variant == 2 ? 16 : 6;
    }

    public WorldGenAbstractTree func_150567_a(Random rand) {
        return new WorldGenCustomOakTree(false, 4, TragicBlocks.HallowedWood.func_176223_P(), TragicBlocks.HallowedLeaves.func_176223_P()).setTrim(TragicBlocks.HallowedLeafTrim.func_176223_P());
    }

    public void func_180624_a(World world, Random rand, BlockPos pos) {
        super.func_180624_a(world, rand, pos);
        if (rand.nextBoolean()) {
            this.stringGen.generate(rand, pos.func_177958_n() / 16, pos.func_177952_p() / 16, world);
        }
        if (rand.nextBoolean()) {
            this.lightGen.generate(rand, pos.func_177958_n() / 16, pos.func_177952_p() / 16, world);
        }
        if (rand.nextInt(6) == 0) {
            this.fragileGen.generate(rand, pos.func_177958_n() / 16, pos.func_177952_p() / 16, world);
        }
        if (rand.nextInt(8) == 0) {
            this.honeydropGen.generate(rand, pos.func_177958_n() / 16, pos.func_177952_p() / 16, world);
        }
    }
}

