/*
 * Decompiled with CFR 0.152.
 */
package tragicneko.tragicmc.worldgen.biome;

import java.util.Random;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraft.world.gen.feature.WorldGenerator;
import tragicneko.tragicmc.TragicBiome;
import tragicneko.tragicmc.TragicBlocks;
import tragicneko.tragicmc.TragicConfig;
import tragicneko.tragicmc.entity.boss.EntityEnyvil;
import tragicneko.tragicmc.entity.mob.EntityInkling;
import tragicneko.tragicmc.entity.mob.EntityParasmite;
import tragicneko.tragicmc.entity.mob.EntityPlague;
import tragicneko.tragicmc.worldgen.SurfaceWorldGen;
import tragicneko.tragicmc.worldgen.SurfaceWorldGen2;
import tragicneko.tragicmc.worldgen.WorldGenCustomCanopyTree;
import tragicneko.tragicmc.worldgen.WorldGenCustomTallGrass;

public class BiomeGenDarkForest
extends TragicBiome {
    public final SurfaceWorldGen drudgeGen;
    public final SurfaceWorldGen2 gasGen;
    public static final float[][] heights = new float[][]{{0.05f, 0.15f}, {0.32f, 0.32f}, {0.35f, -0.35f}};

    public BiomeGenDarkForest(int par1, byte par2) {
        super(par1, par2);
        this.field_76761_J.clear();
        if (TragicConfig.getBoolean("allowPlague")) {
            this.field_76761_J.add(new BiomeGenBase.SpawnListEntry(EntityPlague.class, TragicConfig.getInt("plagueSpawnChance"), TragicConfig.getIntArray("plagueGroupSize")[0], TragicConfig.getIntArray("plagueGroupSize")[1]));
        }
        if (TragicConfig.getBoolean("allowInkling")) {
            this.field_76761_J.add(new BiomeGenBase.SpawnListEntry(EntityInkling.class, TragicConfig.getInt("inklingSpawnChance"), TragicConfig.getIntArray("inklingGroupSize")[0], TragicConfig.getIntArray("inklingGroupSize")[1]));
        }
        if (TragicConfig.getBoolean("allowParasmite")) {
            this.field_76761_J.add(new BiomeGenBase.SpawnListEntry(EntityParasmite.class, TragicConfig.getInt("parasmiteSpawnChance"), TragicConfig.getIntArray("parasmiteGroupSize")[0], TragicConfig.getIntArray("parasmiteGroupSize")[1]));
        }
        if (TragicConfig.getBoolean("allowEnyvil")) {
            this.field_76761_J.add(new BiomeGenBase.SpawnListEntry(EntityEnyvil.class, TragicConfig.getInt("enyvilSpawnChance"), 0, 0));
        }
        this.field_76761_J.add(new BiomeGenBase.SpawnListEntry(EntityEnderman.class, 15, 2, 4));
        this.field_76753_B = TragicBlocks.DeadDirt.func_176223_P();
        this.field_76752_A = TragicBlocks.DarkGrass.func_176223_P();
        this.field_76750_F = 1.2f;
        this.field_76751_G = 1.5f;
        this.field_76760_I.field_76832_z = this.variant == 1 ? 8 : (this.variant == 2 ? 4 : 12);
        this.field_76760_I.field_76798_D = this.variant == 2 ? 12 : 2;
        this.field_76760_I.field_76803_B = this.variant == 1 ? 4 : 8;
        this.drudgeGen = new SurfaceWorldGen(3.0, 4.0, true, 24, TragicBlocks.Quicksand, 2, TragicBlocks.DarkGrass, true, true);
        this.gasGen = new SurfaceWorldGen2(8, TragicBlocks.DarkGas, 0, 4, 4);
    }

    @Override
    public int getFlowersFromBiomeType() {
        return this.variant == 2 ? 2 : 8;
    }

    public WorldGenerator func_76730_b(Random p_76730_1_) {
        return new WorldGenCustomTallGrass(TragicBlocks.DarkTallGrass.func_176223_P());
    }

    public WorldGenAbstractTree func_150567_a(Random rand) {
        return new WorldGenCustomCanopyTree(TragicBlocks.Darkwood.func_176223_P(), TragicBlocks.DarkLeaves.func_176223_P());
    }

    public void func_180624_a(World world, Random rand, BlockPos pos) {
        super.func_180624_a(world, rand, pos);
        this.gasGen.generate(rand, pos.func_177958_n() / 16, pos.func_177952_p() / 16, world);
        if (this.variant == 2) {
            this.drudgeGen.generate(rand, pos.func_177958_n() / 16, pos.func_177952_p() / 16, world);
        }
    }
}

