/*
 * Decompiled with CFR 0.152.
 */
package tragicneko.tragicmc.worldgen.biome;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import tragicneko.tragicmc.TragicBiome;
import tragicneko.tragicmc.TragicBlocks;
import tragicneko.tragicmc.TragicConfig;
import tragicneko.tragicmc.entity.miniboss.EntityJarra;
import tragicneko.tragicmc.entity.mob.EntityFusea;
import tragicneko.tragicmc.entity.mob.EntityTox;
import tragicneko.tragicmc.util.WorldHelper;
import tragicneko.tragicmc.worldgen.PitWorldGen;
import tragicneko.tragicmc.worldgen.RuggedTerrainWorldGen;
import tragicneko.tragicmc.worldgen.SurfacePlantWorldGen;
import tragicneko.tragicmc.worldgen.SurfaceWorldGen;
import tragicneko.tragicmc.worldgen.SurfaceWorldGen2;
import tragicneko.tragicmc.worldgen.VoidPitWorldGen;
import tragicneko.tragicmc.worldgen.WorldGenCustomVine;

public class BiomeGenCorrodedSteppe
extends TragicBiome {
    public final SurfaceWorldGen sludgeGen;
    public final RuggedTerrainWorldGen toxicCobbleGen;
    public final SurfaceWorldGen2 gasGen;
    public final VoidPitWorldGen voidPitGen;
    public final WorldGenCustomVine vineGen;
    public final SurfacePlantWorldGen deathglowGen;
    public static final float[][] heights = new float[][]{{0.05f, 0.03f}, {0.35f, 0.83f}, {0.01f, -0.53f}, {0.75f, -0.73f}, {0.01f, -1.25f}};

    public BiomeGenCorrodedSteppe(int par1, byte par2) {
        super(par1, par2);
        this.field_76766_R = false;
        this.field_76765_S = false;
        this.field_76750_F = 1.0f;
        this.field_76751_G = 0.0f;
        this.field_76749_E = heights[this.variant][0];
        this.field_76748_D = heights[this.variant][1];
        this.field_76760_I.field_76832_z = -999;
        this.field_76760_I.field_76798_D = 16;
        this.field_76753_B = TragicBlocks.DarkCobblestone.func_176223_P();
        this.field_76752_A = TragicBlocks.DarkCobblestone.func_176223_P();
        if (TragicConfig.getBoolean("allowJarra")) {
            this.field_76761_J.add(new BiomeGenBase.SpawnListEntry(EntityJarra.class, TragicConfig.getInt("jarraSpawnChance"), TragicConfig.getIntArray("jarraGroupSize")[0], TragicConfig.getIntArray("jarraGroupSize")[1]));
        }
        if (TragicConfig.getBoolean("allowTox")) {
            this.field_76761_J.add(new BiomeGenBase.SpawnListEntry(EntityTox.class, TragicConfig.getInt("toxSpawnChance"), TragicConfig.getIntArray("toxGroupSize")[0], TragicConfig.getIntArray("toxGroupSize")[1]));
        }
        if (TragicConfig.getBoolean("allowFusea")) {
            this.field_76761_J.add(new BiomeGenBase.SpawnListEntry(EntityFusea.class, TragicConfig.getInt("fuseaSpawnChance"), TragicConfig.getIntArray("fuseaGroupSize")[0], TragicConfig.getIntArray("fuseaGroupSize")[1]));
        }
        this.sludgeGen = new SurfaceWorldGen(3.0, 1.5, true, 10, TragicBlocks.Quicksand, 3, TragicBlocks.DarkCobblestone, true, true);
        this.toxicCobbleGen = new RuggedTerrainWorldGen(TragicBlocks.DarkCobblestone, 2, TragicBlocks.DarkCobblestone, 6, 4.0, 3.0, false, 8);
        this.gasGen = new SurfaceWorldGen2((byte)(this.variant == 0 || this.variant == 4 ? 14 : (this.variant >= 3 ? 7 : 2)), TragicBlocks.RadiatedGas, 0, 4, 8);
        this.voidPitGen = new VoidPitWorldGen(2.5, 2.0);
        this.vineGen = new WorldGenCustomVine(TragicBlocks.WickedVine.func_176223_P(), 84);
        this.deathglowGen = new SurfacePlantWorldGen(2, TragicBlocks.Deathglow, 14, 4, 4, 2);
    }

    public void func_180624_a(World world, Random rand, BlockPos pos) {
        super.func_180624_a(world, rand, pos);
        byte mew = (byte)(this.variant > 2 ? 4 : (this.variant == 2 ? 16 : 8));
        for (byte a = 0; a < mew; a = (byte)(a + 1)) {
            int k = pos.func_177958_n() + rand.nextInt(16) - 8;
            int l = pos.func_177952_p() + rand.nextInt(16) - 8;
            this.vineGen.func_180709_b(world, rand, new BlockPos(k, rand.nextInt(64) + 42, l));
        }
        int Xcoord = pos.func_177958_n() + rand.nextInt(16);
        int Zcoord = pos.func_177952_p() + rand.nextInt(16);
        int Ycoord = rand.nextInt(236) + 10;
        ArrayList<BlockPos> cands = WorldHelper.getBlocksInSphericalRange(world, 3.75, Xcoord, Ycoord, Zcoord);
        boolean flag = true;
        for (BlockPos coords : cands) {
            Block block = world.func_180495_p(coords).func_177230_c();
            if (block.func_149662_c() && block.func_149688_o() != Material.field_151579_a && !block.func_149688_o().func_76224_d()) continue;
            flag = false;
            break;
        }
        if (flag) {
            cands = WorldHelper.getBlocksInSphericalRange(world, 2.75, Xcoord, Ycoord, Zcoord);
            for (BlockPos coords : cands) {
                world.func_175656_a(coords, TragicBlocks.ExplosiveGas.func_176223_P());
            }
        }
        this.gasGen.generate(rand, pos.func_177958_n() / 16, pos.func_177952_p() / 16, world);
        if (this.variant > 2) {
            this.sludgeGen.generate(rand, pos.func_177958_n() / 16, pos.func_177952_p() / 16, world);
        }
        this.toxicCobbleGen.generate(rand, pos.func_177958_n() / 16, pos.func_177952_p() / 16, world);
        if (rand.nextInt(8) == 0) {
            boolean flag2 = rand.nextBoolean();
            new PitWorldGen(flag2 ? TragicBlocks.Quicksand : TragicBlocks.RadiatedGas, (byte)(flag2 ? 3 : 0), 12, 6, 4.0, 3.0).generate(rand, pos.func_177958_n() / 16, pos.func_177952_p() / 16, world);
        }
        if (TragicConfig.getBoolean("allowVoidPitGen") && this.variant == 4 && rand.nextInt(200) >= 5) {
            this.voidPitGen.generate(rand, pos.func_177958_n() / 16, pos.func_177952_p() / 16, world);
        }
        if (rand.nextInt(8) == 0) {
            this.deathglowGen.generate(rand, pos.func_177958_n() / 16, pos.func_177952_p() / 16, world);
        }
    }
}

