/*
 * Decompiled with CFR 0.152.
 */
package tragicneko.tragicmc.worldgen;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.util.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import tragicneko.tragicmc.TragicConfig;
import tragicneko.tragicmc.worldgen.IWorldGen;

public class SurfacePlantWorldGen
implements IWorldGen {
    public final byte iterations;
    public final Block block;
    public final byte meta;
    public final byte width;
    public final byte height;
    public final byte plantHeight;

    public SurfacePlantWorldGen(byte iterations, Block block, byte meta, byte width, byte height, byte plantHeight) {
        this.iterations = iterations;
        this.block = block;
        this.meta = meta;
        this.width = width;
        this.height = height;
        this.plantHeight = plantHeight;
    }

    @Override
    public void generate(Random random, int chunkX, int chunkZ, World world) {
        if (!TragicConfig.getBoolean("allowFruitGen")) {
            return;
        }
        int Xcoord = chunkX * 16 + random.nextInt(16);
        int Zcoord = chunkZ * 16 + random.nextInt(16);
        int Ycoord = world.func_175672_r(new BlockPos(Xcoord, 0, Zcoord)).func_177956_o();
        for (byte i = 0; i < this.iterations; i = (byte)(i + 1)) {
            Xcoord += random.nextInt(this.width) - random.nextInt(this.width);
            Zcoord += random.nextInt(this.width) - random.nextInt(this.width);
            Ycoord += random.nextInt(this.height) - random.nextInt(this.height);
            byte pl = (byte)(random.nextInt(this.plantHeight) + 1);
            for (byte y1 = 0; y1 < pl && Ycoord + y1 >= 0 && Ycoord + y1 <= world.func_72940_L(); y1 = (byte)(y1 + 1)) {
                Block block = world.func_180495_p(new BlockPos(Xcoord, Ycoord + y1, Zcoord)).func_177230_c();
                if (!block.canBeReplacedByLeaves((IBlockAccess)world, new BlockPos(Xcoord, Ycoord + y1, Zcoord)) && !block.isAir((IBlockAccess)world, new BlockPos(Xcoord, Ycoord + y1, Zcoord)) || !this.block.func_176196_c(world, new BlockPos(Xcoord, Ycoord + y1, Zcoord))) continue;
                world.func_180501_a(new BlockPos(Xcoord, Ycoord + y1, Zcoord), this.block.func_176203_a((int)this.meta), 2);
            }
        }
    }
}

