/*
 * Decompiled with CFR 0.152.
 */
package tragicneko.tragicmc.worldgen;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Random;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.fml.common.IWorldGenerator;
import tragicneko.tragicmc.TragicConfig;
import tragicneko.tragicmc.TragicMC;
import tragicneko.tragicmc.worldgen.schematic.Schematic;
import tragicneko.tragicmc.worldgen.structure.Structure;
import tragicneko.tragicmc.worldgen.structure.TickBuilder;

public class StructureWorldGen
implements IWorldGenerator {
    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        Structure s;
        if (world.field_72995_K || !world.func_72912_H().func_76089_r() || random.nextInt(500) > TragicConfig.getInt("structureOverallRarity") || (world.field_73011_w.func_177502_q() == TragicConfig.getInt("collisionID") || world.field_73011_w.func_177502_q() == TragicConfig.getInt("synapseID") || world.field_73011_w.func_177502_q() == TragicConfig.getInt("nekoHomeworldID")) && !TragicConfig.getBoolean("allowDimensions")) {
            return;
        }
        int x = chunkX * 16 + random.nextInt(16);
        int y = random.nextInt(118) + random.nextInt(118) + 10;
        int z = chunkZ * 16 + random.nextInt(16);
        int top = world.func_175672_r(new BlockPos(x, 0, z)).func_177956_o();
        ArrayList<Structure> cands = new ArrayList<Structure>();
        for (int i = 0; i < Structure.getRegistrySize(); ++i) {
            s = Structure.getStructureById(i);
            if (s == null || !s.isValidDimension(world.field_73011_w.func_177502_q()) || (!s.isSurfaceStructure() || !s.areCoordsValidForGeneration(world, new BlockPos(x, top, z), random)) && !s.areCoordsValidForGeneration(world, new BlockPos(x, y, z), random)) continue;
            cands.add(s);
        }
        if (cands.isEmpty()) {
            return;
        }
        Collections.shuffle(cands, random);
        Iterator iterator = cands.iterator();
        while (iterator.hasNext()) {
            BlockPos pos = new BlockPos(x, (s = (Structure)iterator.next()).isSurfaceStructure() ? top : y, z);
            Schematic sch = s.generate(world, random, pos);
            if (sch == null) continue;
            String str = " successfully generated at " + pos;
            if (TragicConfig.getBoolean("allowTickBuilder")) {
                str = TickBuilder.getBuilderFor(world) != null ? (TickBuilder.getBuilderFor(world).addSchematic(pos, sch) ? " was added to the TickBuilder with origin of " + pos : " could not be added to the TickBuilder since there is a structure being built at that coordinate already") : " failed to generate due to an error with the TickBuilder, report this.";
            }
            TragicMC.logInfo(s.getLocalizedName() + str);
            break;
        }
    }
}

