/*
 * Decompiled with CFR 0.152.
 */
package tragicneko.tragicmc.worldgen;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;
import tragicneko.tragicmc.TragicConfig;
import tragicneko.tragicmc.util.WorldHelper;
import tragicneko.tragicmc.worldgen.IWorldGen;

public class PitWorldGen
implements IWorldGen {
    public final Block block;
    public final byte meta;
    public final byte depth;
    public final byte depthVar;
    public final double radius;
    public final double variation;

    public PitWorldGen(Block block, byte meta, byte depth, byte depthVar, double radius, double variation) {
        this.block = block;
        this.meta = meta;
        this.depth = depth;
        this.depthVar = depthVar;
        this.radius = radius;
        this.variation = variation;
    }

    @Override
    public void generate(Random random, int chunkX, int chunkZ, World world) {
        if (!TragicConfig.getBoolean("allowVoidPitGen")) {
            return;
        }
        int Xcoord = chunkX * 16 + random.nextInt(16);
        int Zcoord = chunkZ * 16 + random.nextInt(16);
        int Ycoord = world.func_175672_r(new BlockPos(Xcoord, 0, Zcoord)).func_177979_c(random.nextInt(10)).func_177956_o();
        int depth = Ycoord - this.depth - random.nextInt(this.depthVar + 1);
        ArrayList<BlockPos> cands = new ArrayList<BlockPos>();
        double size = this.variation * random.nextDouble() + this.radius;
        int pow = 0;
        while (pow + Ycoord >= depth && pow + Ycoord >= 0 && pow + Ycoord <= 256) {
            ArrayList<BlockPos> list;
            if (size >= 5.5) {
                list = WorldHelper.getBlocksInCircularRange(world, size * 0.31773, Xcoord, Ycoord + pow, Zcoord);
                for (BlockPos coords : list) {
                    if (random.nextInt(5) == 0 || cands.contains(coords)) continue;
                    cands.add(coords);
                }
            }
            list = WorldHelper.getBlocksInCircularRange(world, size * 0.64773, Xcoord, Ycoord + pow, Zcoord);
            for (BlockPos coords : list) {
                if (random.nextInt(4) == 0 || cands.contains(coords)) continue;
                cands.add(coords);
            }
            list = WorldHelper.getBlocksInCircularRange(world, size, Xcoord, Ycoord + pow, Zcoord);
            for (BlockPos coords : list) {
                if (!random.nextBoolean() || cands.contains(coords)) continue;
                cands.add(coords);
            }
            if (size >= 3.0 && random.nextInt(4) == 0) {
                size *= 0.987425;
            }
            pow = (byte)(pow - 1);
        }
        for (BlockPos coords2 : cands) {
            if (coords2.func_177956_o() > depth + 1 || random.nextBoolean()) {
                world.func_175698_g(coords2);
                continue;
            }
            world.func_180501_a(coords2, this.block.func_176203_a((int)this.meta), 2);
        }
    }
}

