/*
 * Decompiled with CFR 0.152.
 */
package tragicneko.tragicmc.worldgen;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;
import tragicneko.tragicmc.TragicConfig;
import tragicneko.tragicmc.util.WorldHelper;
import tragicneko.tragicmc.worldgen.IWorldGen;

public class InvertedSpikeWorldGen
implements IWorldGen {
    public final byte iterations;
    public final double radius;
    public final double variation;
    public final double regression;
    public final double cutoff;

    public InvertedSpikeWorldGen(byte relays, double radius, double var, double regress, double cutoff) {
        this.iterations = relays;
        this.radius = radius;
        this.variation = var;
        this.regression = regress;
        this.cutoff = cutoff;
    }

    @Override
    public void generate(Random random, int chunkX, int chunkZ, World world) {
        if (!TragicConfig.getBoolean("allowInvertedSpikeGen")) {
            return;
        }
        int Xcoord = chunkX * 16 + random.nextInt(16) - random.nextInt(16);
        int Zcoord = chunkZ * 16 + random.nextInt(16) - random.nextInt(16);
        int Ycoord = world.func_175672_r(new BlockPos(Xcoord, 0, Zcoord)).func_177956_o();
        ArrayList<BlockPos> cands = new ArrayList<BlockPos>();
        for (byte buzza = 0; buzza < this.iterations; buzza = (byte)(buzza + 1)) {
            double size = random.nextDouble() * this.variation + this.radius;
            Ycoord = world.func_175672_r(new BlockPos(Xcoord += random.nextInt(8) - random.nextInt(8), 0, Zcoord += random.nextInt(8) - random.nextInt(8))).func_177981_b(1).func_177956_o();
            byte spikeType = (byte)random.nextInt(6);
            boolean flag = false;
            boolean flag2 = false;
            for (int y1 = 0; y1 > -128 && Ycoord + y1 >= 25 && !(size < this.cutoff); y1 = (int)((byte)(y1 - 1))) {
                size *= this.regression;
                if (random.nextBoolean()) {
                    if (random.nextInt(3) == 0 && size >= 0.4888233) {
                        Xcoord += random.nextInt(2) - random.nextInt(2);
                        Zcoord += random.nextInt(2) - random.nextInt(2);
                    }
                    if (spikeType == 1 && !flag && y1 <= 35 && y1 <= 70 && random.nextBoolean() && size <= 0.774446314) {
                        size *= 2.86333567;
                        flag = true;
                    }
                }
                if (random.nextBoolean()) {
                    if (spikeType == 2 && size >= 0.5625292) {
                        Xcoord += random.nextInt(2) - random.nextInt(2);
                        Zcoord += random.nextInt(2) - random.nextInt(2);
                    } else if (spikeType == 3 && !flag2 && random.nextBoolean() && y1 <= 35 && size <= 1.41115648 && size >= 0.76663601) {
                        this.generateChildSpike(world, random, size * 1.32977745, Xcoord + random.nextInt(5) - random.nextInt(5), Ycoord + y1, Zcoord + random.nextInt(5) - random.nextInt(5));
                        flag2 = true;
                    } else if (spikeType == 4 && random.nextBoolean() && y1 <= 35 && size >= 0.76663601) {
                        this.generateChildSpike(world, random, size * 1.12977745, Xcoord + random.nextInt(5) - random.nextInt(5), Ycoord + y1, Zcoord + random.nextInt(5) - random.nextInt(5));
                    } else if (spikeType == 5 && random.nextBoolean()) {
                        if (y1 >= 24) {
                            this.generateChildSpike(world, random, size * 1.12977745, Xcoord + random.nextInt(6) - random.nextInt(6), Ycoord + y1, Zcoord + random.nextInt(6) - random.nextInt(6));
                        } else if (size >= 0.76663601) {
                            this.generateChildSpike(world, random, size * 1.13977745, Xcoord + random.nextInt(5) - random.nextInt(5), Ycoord + y1, Zcoord + random.nextInt(5) - random.nextInt(5));
                        }
                    }
                }
                ArrayList<BlockPos> list = WorldHelper.getBlocksInSphericalRange(world, size, Xcoord, Ycoord + y1, Zcoord);
                for (BlockPos coords : list) {
                    Material material = world.func_180495_p(coords).func_177230_c().func_149688_o();
                    if (material.func_76224_d() || material == Material.field_151579_a || cands.contains(coords)) continue;
                    cands.add(coords);
                }
            }
            for (BlockPos coords : cands) {
                world.func_175698_g(coords);
            }
        }
    }

    public void generateChildSpike(World world, Random rand, double size, double Xcoord, double Ycoord, double Zcoord) {
        ArrayList<BlockPos> cands = new ArrayList<BlockPos>();
        for (int y1 = 0; y1 < 64; y1 = (int)((byte)(y1 + 1))) {
            if (rand.nextBoolean() && (size *= 0.95977745) >= 0.54288233) {
                Xcoord += (double)(rand.nextInt(2) - rand.nextInt(2));
                Zcoord += (double)(rand.nextInt(2) - rand.nextInt(2));
            }
            if (size < 0.36443755 || Ycoord - (double)y1 < 0.0) break;
            ArrayList<BlockPos> list = WorldHelper.getBlocksInSphericalRange(world, size, Xcoord, Ycoord + (double)y1, Zcoord);
            for (BlockPos coords : list) {
                Material material = world.func_180495_p(coords).func_177230_c().func_149688_o();
                if (material.func_76224_d() || material == Material.field_151579_a || cands.contains(coords)) continue;
                cands.add(coords);
            }
        }
        for (BlockPos coords : cands) {
            world.func_175698_g(coords);
        }
    }
}

