/*
 * Decompiled with CFR 0.152.
 */
package tragicneko.tragicmc.util;

import java.util.ArrayList;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import tragicneko.tragicmc.TragicMC;

public class WorldHelper {
    public static Random getRandom() {
        return TragicMC.rand;
    }

    public static Block[] getRandomBlocksInSetRange(World world, int x, int y, int z, int range, int passes) {
        return WorldHelper.getRandomBlocksInSetRangeWithRandomChance(world, x, y, z, range, passes, 4);
    }

    public static Block[] getRandomBlocksInSetRangeWithRandomChance(World world, int x, int y, int z, int range, int passes, int chance) {
        return null;
    }

    public static Block[] getRandomBlocksInSetRangeWithPrejudice(World world, Set set, int range) {
        return WorldHelper.getRandomBlocksInSetRangeWithPrejudiceWithRandomChance(world, set, range, 4);
    }

    public static Block[] getRandomBlocksInSetRangeWithPrejudiceWithRandomChance(World world, Set set, int range, int chance) {
        return null;
    }

    public static Entity[] getRandomEntitiesInRange(World world, Entity entity, double range) {
        return WorldHelper.getRandomEntitiesInRangeWithRandomChance(world, entity, range, 4);
    }

    public static Entity[] getRandomEntitiesInRangeWithRandomChance(World world, Entity entity, double range, int chance) {
        return null;
    }

    public static boolean getMobGriefing(World world) {
        return world.func_82736_K().func_82766_b("mobGriefing");
    }

    public static EnumDifficulty getWorldDifficulty(World world) {
        return world.func_175659_aa();
    }

    public static ArrayList<BlockPos> getBlocksInCircularRange(World world, double radius, double x, double y, double z) {
        ArrayList<BlockPos> list = new ArrayList<BlockPos>();
        if (radius <= 0.0) {
            throw new IllegalArgumentException("Radius cannot be negative!");
        }
        for (double x2 = -radius; x2 < radius + 0.55; x2 += 0.5) {
            for (double z2 = -radius; z2 < radius + 0.55; z2 += 0.5) {
                BlockPos coords;
                if (!((double)MathHelper.func_76133_a((double)(x2 * x2 + z2 * z2)) <= radius) || list.contains(coords = new BlockPos(x + x2, y, z + z2))) continue;
                list.add(coords);
            }
        }
        return list;
    }

    public static ArrayList<BlockPos> getBlocksInCircularRange(World world, double radius, BlockPos center) {
        return WorldHelper.getBlocksInCircularRange(world, radius, center.func_177958_n(), center.func_177956_o(), center.func_177952_p());
    }

    public static ArrayList<BlockPos> getBlocksInSphericalRange(World world, double radius, double x, double y, double z) {
        ArrayList<BlockPos> list = new ArrayList<BlockPos>();
        if (radius <= 0.0) {
            throw new IllegalArgumentException("Radius cannot be negative!");
        }
        double distance = radius + 1.5;
        for (double y1 = -distance; y1 < distance + 0.55; y1 += 0.5) {
            for (double x1 = -distance; x1 < distance + 0.55; x1 += 0.5) {
                for (double z1 = -distance; z1 < distance + 0.55; z1 += 0.5) {
                    BlockPos coords;
                    if (!((double)MathHelper.func_76133_a((double)(x1 * x1 + z1 * z1 + y1 * y1)) < radius) || list.contains(coords = new BlockPos(x + x1, y + y1, z + z1))) continue;
                    list.add(coords);
                }
            }
        }
        return list;
    }

    public static ArrayList<BlockPos> getBlocksInSphericalRange(World world, double radius, BlockPos center) {
        return WorldHelper.getBlocksInSphericalRange(world, radius, center.func_177958_n(), center.func_177956_o(), center.func_177952_p());
    }

    public static MovingObjectPosition getMOPFromEntity(Entity ent, double distance) {
        float f = 1.0f;
        float f1 = ent.field_70127_C + (ent.field_70125_A - ent.field_70127_C) * f;
        float f2 = ent.field_70126_B + (ent.field_70177_z - ent.field_70126_B) * f;
        double d0 = ent.field_70169_q + (ent.field_70165_t - ent.field_70169_q) * (double)f;
        double d1 = ent.field_70167_r + (ent.field_70163_u - ent.field_70167_r) * (double)f + (double)ent.func_70047_e();
        double d2 = ent.field_70166_s + (ent.field_70161_v - ent.field_70166_s) * (double)f;
        Vec3 vec3 = new Vec3(d0, d1, d2);
        float f3 = MathHelper.func_76134_b((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = MathHelper.func_76126_a((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f5 = -MathHelper.func_76134_b((float)(-f1 * ((float)Math.PI / 180)));
        float f6 = MathHelper.func_76126_a((float)(-f1 * ((float)Math.PI / 180)));
        float f7 = f4 * f5;
        float f8 = f3 * f5;
        double d3 = distance;
        if (ent instanceof EntityPlayerMP) {
            d3 = ((EntityPlayerMP)ent).field_71134_c.getBlockReachDistance() + (d3 - 4.0);
        }
        Vec3 vec31 = vec3.func_72441_c((double)f7 * d3, (double)f6 * d3, (double)f8 * d3);
        return ent.field_70170_p.func_147447_a(vec3, vec31, true, false, true);
    }

    public static Vec3 getVecFromEntity(Entity ent, double distance) {
        MovingObjectPosition mop = WorldHelper.getMOPFromEntity(ent, distance);
        return mop != null ? mop.field_72307_f : new Vec3(ent.field_70165_t - ent.field_70169_q, ent.field_70163_u - ent.field_70167_r, ent.field_70161_v - ent.field_70166_s);
    }

    public static Vec3 getVecFromEntity(Entity ent) {
        return WorldHelper.getMOPFromEntity((Entity)ent, (double)6.0).field_72307_f;
    }

    public static double[] getTransportPositionFromSide(EnumFacing facing, double x, double y, double z) {
        switch (facing) {
            case DOWN: {
                y -= 2.2;
                break;
            }
            case UP: {
                break;
            }
            case SOUTH: {
                z -= 1.0;
                break;
            }
            case NORTH: {
                z += 1.0;
                break;
            }
            case WEST: {
                x -= 1.0;
                break;
            }
            case EAST: {
                x += 1.0;
            }
        }
        return new double[]{x, y, z};
    }

    public static double getXPositionFromSide(EnumFacing facing, double x) {
        return WorldHelper.getTransportPositionFromSide(facing, x, 0.0, 0.0)[0];
    }

    public static double getYPositionFromSide(EnumFacing facing, double y) {
        return WorldHelper.getTransportPositionFromSide(facing, 0.0, y, 0.0)[1];
    }

    public static double getZPositionFromSide(EnumFacing facing, double z) {
        return WorldHelper.getTransportPositionFromSide(facing, 0.0, 0.0, z)[2];
    }

    public static ArrayList<BlockPos> getBlocksAdjacent(BlockPos start) {
        ArrayList<BlockPos> list = new ArrayList<BlockPos>();
        list.add(start.func_177984_a());
        list.add(start.func_177974_f());
        list.add(start.func_177976_e());
        list.add(start.func_177968_d());
        list.add(start.func_177978_c());
        list.add(start.func_177977_b());
        return list;
    }

    public static int getDistanceToGround(Entity entity) {
        return WorldHelper.getDistanceToGround(entity.field_70170_p, WorldHelper.getBlockPos(entity));
    }

    public static int getDistanceToGround(World world, BlockPos pos) {
        int y = pos.func_177956_o();
        int i = 0;
        while (y - i > 0) {
            if (WorldHelper.getBlock(world, pos.func_177979_c(i)).func_149688_o().func_76230_c()) {
                return i;
            }
            ++i;
        }
        return y;
    }

    public static BlockPos getBlockPos(Entity entity) {
        return entity.func_180425_c();
    }

    public static Block getBlock(World world, BlockPos pos) {
        return world.func_180495_p(pos).func_177230_c();
    }
}

