/*
 * Decompiled with CFR 0.152.
 */
package tragicneko.tragicmc.properties;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.IExtendedEntityProperties;
import tragicneko.tragicmc.TragicConfig;
import tragicneko.tragicmc.inventory.ContainerAmulet;
import tragicneko.tragicmc.inventory.InventoryAmulet;
import tragicneko.tragicmc.inventory.SlotActiveAmulet;
import tragicneko.tragicmc.items.amulet.ItemAmulet;
import tragicneko.tragicmc.properties.PropertyDoom;

public class PropertyAmulets
implements IExtendedEntityProperties {
    public static final String PROPERTY_NAME = "TragicMC.Amulets";
    private final EntityPlayer thePlayer;
    public final InventoryAmulet inventory;
    private byte slotsOpen;

    public PropertyAmulets(EntityPlayer player) {
        this.thePlayer = player;
        this.slotsOpen = (byte)TragicConfig.getInt("amuletStartSlots");
        this.inventory = new InventoryAmulet(player);
    }

    public static final void register(EntityPlayer player) {
        player.registerExtendedProperties(PROPERTY_NAME, (IExtendedEntityProperties)new PropertyAmulets(player));
    }

    public static final PropertyAmulets get(EntityPlayer player) {
        return (PropertyAmulets)player.getExtendedProperties(PROPERTY_NAME);
    }

    public void saveNBTData(NBTTagCompound compound) {
        NBTTagCompound comp = new NBTTagCompound();
        this.inventory.writeToNBT(comp);
        comp.func_74774_a("slotsOpen", this.slotsOpen);
        compound.func_74782_a(PROPERTY_NAME, (NBTBase)comp);
    }

    public void loadNBTData(NBTTagCompound compound) {
        if (compound == null) {
            return;
        }
        NBTTagCompound comp = (NBTTagCompound)compound.func_74781_a(PROPERTY_NAME);
        if (comp == null) {
            return;
        }
        this.inventory.readFromNBT(comp);
        this.slotsOpen = comp.func_74771_c("slotsOpen");
        if (this.slotsOpen < TragicConfig.getInt("amuletStartSlots")) {
            this.slotsOpen = (byte)TragicConfig.getInt("amuletStartSlots");
        }
    }

    public void init(Entity entity, World world) {
        if (entity instanceof EntityPlayer && PropertyDoom.get((EntityPlayer)entity) == null) {
            PropertyDoom.register((EntityPlayer)entity);
        }
    }

    public boolean openAmuletSlot() {
        if (this.slotsOpen < 3) {
            this.slotsOpen = (byte)(this.slotsOpen + 1);
            return true;
        }
        return false;
    }

    public int getSlotsOpen() {
        return this.slotsOpen;
    }

    public ItemAmulet getActiveAmulet(int slot) {
        if (this.inventory.func_70301_a(slot) != null) {
            ContainerAmulet container = new ContainerAmulet(this.thePlayer, this.thePlayer.field_71071_by, this.inventory);
            Slot invSlot = (Slot)container.field_75151_b.get(slot);
            if (invSlot instanceof SlotActiveAmulet && !((SlotActiveAmulet)invSlot).isLocked()) {
                return (ItemAmulet)this.inventory.func_70301_a(slot).func_77973_b();
            }
        }
        return null;
    }

    public ItemStack getActiveAmuletItemStack(int slot) {
        if (this.inventory.func_70301_a(slot) != null) {
            ContainerAmulet container = new ContainerAmulet(this.thePlayer, this.thePlayer.field_71071_by, this.inventory);
            Slot invSlot = (Slot)container.field_75151_b.get(slot);
            if (invSlot instanceof SlotActiveAmulet && !((SlotActiveAmulet)invSlot).isLocked()) {
                return this.inventory.func_70301_a(slot);
            }
        }
        return null;
    }

    public void damageStackInSlot(int slot, int damage) {
        if (this.getActiveAmulet(slot) != null) {
            ContainerAmulet container = new ContainerAmulet(this.thePlayer, this.thePlayer.field_71071_by, this.inventory);
            Slot invSlot = (Slot)container.field_75151_b.get(slot);
            if (invSlot instanceof SlotActiveAmulet && !((SlotActiveAmulet)invSlot).isLocked()) {
                this.getActiveAmuletItemStack(slot).func_77972_a(damage, (EntityLivingBase)this.thePlayer);
                if (this.getActiveAmuletItemStack(slot).func_77952_i() >= this.getActiveAmuletItemStack(slot).func_77958_k()) {
                    this.inventory.func_70299_a(slot, null);
                }
            }
        }
    }

    public void repairStackInSlot(int slot, int repair) {
        if (this.getActiveAmulet(slot) != null) {
            ContainerAmulet container = new ContainerAmulet(this.thePlayer, this.thePlayer.field_71071_by, this.inventory);
            Slot invSlot = (Slot)container.field_75151_b.get(slot);
            if (invSlot instanceof SlotActiveAmulet && !((SlotActiveAmulet)invSlot).isLocked() && this.getActiveAmuletItemStack(slot).func_77952_i() > 0) {
                this.getActiveAmuletItemStack(slot).func_77964_b(this.inventory.func_70301_a(slot).func_77952_i() - repair);
            }
        }
    }
}

