/*
 * Decompiled with CFR 0.152.
 */
package tragicneko.tragicmc.items.challenge;

import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatBase;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.WeightedRandom;
import net.minecraft.world.World;
import tragicneko.tragicmc.TragicAchievements;
import tragicneko.tragicmc.TragicConfig;
import tragicneko.tragicmc.TragicItems;
import tragicneko.tragicmc.TragicMC;
import tragicneko.tragicmc.items.challenge.Challenge;
import tragicneko.tragicmc.util.EntityDropHelper;
import tragicneko.tragicmc.util.LoreHelper;
import tragicneko.tragicmc.util.TragicEntityList;

public class ItemChallenge
extends Item {
    public static EntityDropHelper.EntityDrop[] badRewards = new EntityDropHelper.EntityDrop[]{new EntityDropHelper.EntityDrop(15, Items.field_151044_h), new EntityDropHelper.EntityDrop(5, Items.field_151033_d), new EntityDropHelper.EntityDrop(5, Items.field_151007_F), new EntityDropHelper.EntityDrop(5, Items.field_151055_y), new EntityDropHelper.EntityDrop(5, Items.field_151103_aS), new EntityDropHelper.EntityDrop(15, Items.field_151025_P), new EntityDropHelper.EntityDrop(5, Items.field_151122_aG), new EntityDropHelper.EntityDrop(5, Items.field_151054_z), new EntityDropHelper.EntityDrop(5, TragicItems.Ash), new EntityDropHelper.EntityDrop(15, TragicItems.Banana), new EntityDropHelper.EntityDrop(10, TragicItems.Sushi), new EntityDropHelper.EntityDrop(5, TragicItems.BoneMarrow), new EntityDropHelper.EntityDrop(30, TragicItems.ChallengeScroll)};
    public static EntityDropHelper.EntityDrop[] cheapRewards = new EntityDropHelper.EntityDrop[]{new EntityDropHelper.EntityDrop(1, Items.field_151045_i), new EntityDropHelper.EntityDrop(1, Items.field_151166_bC), new EntityDropHelper.EntityDrop(5, Items.field_151034_e), new EntityDropHelper.EntityDrop(10, Items.field_151042_j), new EntityDropHelper.EntityDrop(5, Items.field_151043_k), new EntityDropHelper.EntityDrop(15, TragicItems.Tungsten), new EntityDropHelper.EntityDrop(25, TragicItems.BloodSacrifice), new EntityDropHelper.EntityDrop(25, TragicItems.NourishmentSacrifice), new EntityDropHelper.EntityDrop(15, TragicItems.RedMercury), new EntityDropHelper.EntityDrop(20, TragicItems.Quicksilver), new EntityDropHelper.EntityDrop(5, TragicItems.QuicksilverIngot), new EntityDropHelper.EntityDrop(5, Blocks.field_150343_Z), new EntityDropHelper.EntityDrop(15, TragicItems.Deathglow), new EntityDropHelper.EntityDrop(15, TragicItems.Honeydrop), new EntityDropHelper.EntityDrop(10, TragicItems.SkyFruit), new EntityDropHelper.EntityDrop(5, TragicItems.Gloopii), new EntityDropHelper.EntityDrop(1, ItemChallenge.getSpawnEggsMiniBoss()), new EntityDropHelper.EntityDrop(15, TragicItems.ChallengeScroll)};
    public static EntityDropHelper.EntityDrop[] rewards = new EntityDropHelper.EntityDrop[]{new EntityDropHelper.EntityDrop(10, Items.field_151045_i), new EntityDropHelper.EntityDrop(5, Items.field_151166_bC), new EntityDropHelper.EntityDrop(15, TragicItems.AwakeningStone), new EntityDropHelper.EntityDrop(30, TragicItems.AmuletRelease), new EntityDropHelper.EntityDrop(25, TragicItems.DoomConsume), new EntityDropHelper.EntityDrop(20, TragicItems.CooldownDefuse), new EntityDropHelper.EntityDrop(25, TragicItems.Ruby), new EntityDropHelper.EntityDrop(5, Items.field_151042_j), new EntityDropHelper.EntityDrop(25, TragicItems.Sapphire), new EntityDropHelper.EntityDrop(5, Items.field_151043_k), new EntityDropHelper.EntityDrop(20, new ItemStack(Items.field_151153_ao, 1, 0), new ItemStack(Items.field_151153_ao, 1, 1)), new EntityDropHelper.EntityDrop(5, TragicItems.CryingObsidianOrb), new EntityDropHelper.EntityDrop(5, TragicItems.BleedingObsidianOrb), new EntityDropHelper.EntityDrop(5, TragicItems.DyingObsidianOrb), new EntityDropHelper.EntityDrop(5, TragicItems.ObsidianOrb), new EntityDropHelper.EntityDrop(15, TragicItems.GoldenSushi), new EntityDropHelper.EntityDrop(10, TragicItems.Talisman), new EntityDropHelper.EntityDrop(5, TragicItems.BloodSacrifice), new EntityDropHelper.EntityDrop(5, TragicItems.NourishmentSacrifice), new EntityDropHelper.EntityDrop(15, TragicItems.Deathglow), new EntityDropHelper.EntityDrop(35, TragicItems.Honeydrop), new EntityDropHelper.EntityDrop(20, TragicItems.SkyFruit), new EntityDropHelper.EntityDrop(10, TragicItems.Gloopii), new EntityDropHelper.EntityDrop(1, ItemChallenge.getSpawnEggsBoss()), new EntityDropHelper.EntityDrop(3, ItemChallenge.getSpawnEggsMiniBoss()), new EntityDropHelper.EntityDrop(3, ItemChallenge.getEpicWeapons()), new EntityDropHelper.EntityDrop(3, ItemChallenge.getEpicWeapons())};
    private static String[] subNames = new String[]{"inactive", "inProgress", "complete"};

    public ItemChallenge() {
        this.func_77637_a(TragicMC.Survival);
        this.func_77656_e(0);
        this.field_77777_bU = 1;
        this.func_77627_a(true);
        this.func_77655_b("tragicmc.challengeItem");
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        if (stack.func_77952_i() == 0) {
            return EnumRarity.COMMON;
        }
        if (stack.func_77952_i() == 250) {
            return EnumRarity.EPIC;
        }
        if (!stack.func_77942_o() || !stack.func_77978_p().func_74764_b("challengeID") || Challenge.getChallengeFromID(stack.func_77978_p().func_74762_e("challengeID")) == null) {
            return EnumRarity.COMMON;
        }
        switch (Challenge.getChallengeFromID(stack.func_77978_p().func_74762_e("challengeID")).getDifficultyId()) {
            case 3: {
                return EnumRarity.EPIC;
            }
            case 2: {
                return EnumRarity.RARE;
            }
            case 1: {
                return EnumRarity.UNCOMMON;
            }
        }
        return EnumRarity.COMMON;
    }

    public String func_77667_c(ItemStack itemstack) {
        int var = itemstack.func_77952_i() == 250 ? 2 : (itemstack.func_77952_i() != 0 ? 1 : 0);
        return this.func_77658_a() + "." + subNames[var];
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (world.field_72995_K) {
            return stack;
        }
        if (stack.func_77952_i() == 0) {
            try {
                Challenge challenge = Challenge.getChallengeFromID(field_77697_d.nextInt(Challenge.getRegistrySize() - 1) + 1);
                while (challenge == null) {
                    challenge = Challenge.getChallengeFromID(field_77697_d.nextInt(Challenge.getRegistrySize() - 1) + 1);
                }
                stack.func_77964_b(challenge.getChallengeId());
                if (!stack.func_77942_o()) {
                    stack.func_77982_d(new NBTTagCompound());
                }
                stack.func_77978_p().func_74768_a("challengeID", challenge.getChallengeId());
                player.func_145747_a((IChatComponent)new ChatComponentText("Challenge accepted!"));
                if (player instanceof EntityPlayerMP) {
                    player.field_70170_p.func_72956_a((Entity)player, "tragicmc:random.challengestart", 0.4f, 1.0f);
                }
                if (!TragicConfig.getBoolean("allowAchievements") || !(player instanceof EntityPlayerMP)) return stack;
                player.func_71029_a((StatBase)TragicAchievements.challengeScroll);
                return stack;
            }
            catch (Exception e) {
                TragicMC.logError("Challenge item errored while retreiving a Challenge. Report this! ItemStack was " + stack, e);
                return stack;
            }
        }
        if (stack.func_77952_i() == 250) {
            player.func_145747_a((IChatComponent)new ChatComponentText("Challenge completed, have a reward!"));
            Challenge challenge = Challenge.getChallengeFromID(stack.func_77978_p().func_74762_e("challengeID"));
            int extra = field_77697_d.nextInt((challenge.getDifficultyId() + 1) * 2) + 1;
            ItemStack reward = null;
            for (int i = 0; i < extra && i < 5; ++i) {
                EntityItem item = new EntityItem(world);
                try {
                    reward = challenge.getDifficultyId() > 2 ? ((EntityDropHelper.EntityDrop)WeightedRandom.func_76271_a((Random)field_77697_d, Arrays.asList(rewards))).getStack() : (challenge.getDifficultyId() > 0 ? ((EntityDropHelper.EntityDrop)WeightedRandom.func_76271_a((Random)field_77697_d, Arrays.asList(cheapRewards))).getStack() : ((EntityDropHelper.EntityDrop)WeightedRandom.func_76271_a((Random)field_77697_d, Arrays.asList(badRewards))).getStack());
                    item.func_92058_a(reward.func_77946_l());
                    item.func_70107_b(player.field_70165_t + field_77697_d.nextDouble() - field_77697_d.nextDouble(), player.field_70163_u + 0.6, player.field_70161_v + field_77697_d.nextDouble() - field_77697_d.nextDouble());
                    world.func_72838_d((Entity)item);
                }
                catch (Exception e) {
                    TragicMC.logError("Challenge errored while rewarding, silently catching error and continuing", e);
                    continue;
                }
                if (i > 3 && field_77697_d.nextInt(4) == 0) break;
            }
            --stack.field_77994_a;
            return stack;
        }
        if (!stack.func_77942_o()) return stack;
        player.func_145747_a((IChatComponent)new ChatComponentText(Challenge.getNameFromID(stack.func_77978_p().func_74762_e("challengeID")) + " is in progress!"));
        return stack;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer par2EntityPlayer, List par2List, boolean par4) {
        if (stack.func_77952_i() == 250) {
            if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("challengeID")) {
                Challenge challenge = Challenge.getChallengeFromID(stack.func_77978_p().func_74762_e("challengeID"));
                if (challenge == null) {
                    return;
                }
                EnumChatFormatting format = challenge.getDifficultyId() == 1 ? EnumChatFormatting.AQUA : (challenge.getDifficultyId() == 2 ? EnumChatFormatting.BLUE : (challenge.getDifficultyId() == 3 ? EnumChatFormatting.GOLD : EnumChatFormatting.WHITE));
                par2List.add("Challenge: " + format + Challenge.getNameFromID(challenge.getChallengeId()));
                String diff = challenge.getDifficultyId() == 0 ? "Easy" : (challenge.getDifficultyId() == 1 ? "Medium" : (challenge.getDifficultyId() == 2 ? "Hard" : "Harsh"));
                par2List.add("Difficulty: " + format + diff);
            }
            par2List.add(EnumChatFormatting.GOLD + "Challenge complete!");
            par2List.add(EnumChatFormatting.WHITE + "What are you doing reading this, get your reward!");
        } else if (stack.func_77952_i() == 0) {
            par2List.add(EnumChatFormatting.WHITE + "An inactive Challenge Scroll.");
            par2List.add(EnumChatFormatting.RESET + "Right-Click to start a Challenge!");
        } else if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("challengeID")) {
            Challenge challenge = Challenge.getChallengeFromID(stack.func_77978_p().func_74762_e("challengeID"));
            if (challenge == null) {
                return;
            }
            EnumChatFormatting format = challenge.getDifficultyId() == 1 ? EnumChatFormatting.AQUA : (challenge.getDifficultyId() == 2 ? EnumChatFormatting.BLUE : (challenge.getDifficultyId() == 3 ? EnumChatFormatting.GOLD : EnumChatFormatting.WHITE));
            par2List.add("Challenge: " + format + Challenge.getNameFromID(challenge.getChallengeId()));
            String diff = challenge.getDifficultyId() == 0 ? "Easy" : (challenge.getDifficultyId() == 1 ? "Medium" : (challenge.getDifficultyId() == 2 ? "Hard" : "Harsh"));
            par2List.add("Difficulty: " + format + diff);
            LoreHelper.splitDesc(par2List, Challenge.getDesc(challenge.getChallengeId()), 32, EnumChatFormatting.WHITE);
            par2List.add("Progress: " + stack.func_77978_p().func_74762_e("challengeProgress") + "/ " + challenge.getRequirement());
            if (challenge.isLocationBased() && stack.func_77978_p().func_74764_b("challengeLocation")) {
                par2List.add("Proper location: " + (stack.func_77978_p().func_74767_n("challengeLocation") ? "Yes" : "No"));
            }
            if (challenge.isTimed && stack.func_77978_p().func_74764_b("challengeTime")) {
                par2List.add("Time remaining: " + stack.func_77978_p().func_74762_e("challengeTime"));
            }
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return oldStack == null || oldStack.func_77952_i() != newStack.func_77952_i();
    }

    public static ItemStack[] getSpawnEggsMiniBoss() {
        ItemStack[] stacks = new ItemStack[]{new ItemStack(TragicItems.SpawnEgg, 1, TragicEntityList.getIDFromString("TragicMC.Jarra") == -1 ? 0 : TragicEntityList.getIDFromString("TragicMC.Jarra")), new ItemStack(TragicItems.SpawnEgg, 1, TragicEntityList.getIDFromString("TragicMC.Magmox") == -1 ? 0 : TragicEntityList.getIDFromString("TragicMC.Magmox")), new ItemStack(TragicItems.SpawnEgg, 1, TragicEntityList.getIDFromString("TragicMC.Kragul") == -1 ? 0 : TragicEntityList.getIDFromString("TragicMC.Kragul")), new ItemStack(TragicItems.SpawnEgg, 1, TragicEntityList.getIDFromString("TragicMC.MegaCryse") == -1 ? 0 : TragicEntityList.getIDFromString("TragicMC.MegaCryse")), new ItemStack(TragicItems.SpawnEgg, 1, TragicEntityList.getIDFromString("TragicMC.StinKing") == -1 ? 0 : TragicEntityList.getIDFromString("TragicMC.StinKing")), new ItemStack(TragicItems.SpawnEgg, 1, TragicEntityList.getIDFromString("TragicMC.GreaterStin") == -1 ? 0 : TragicEntityList.getIDFromString("TragicMC.GreaterStin")), new ItemStack(TragicItems.SpawnEgg, 1, TragicEntityList.getIDFromString("TragicMC.StinQueen") == -1 ? 0 : TragicEntityList.getIDFromString("TragicMC.StinQueen")), new ItemStack(TragicItems.SpawnEgg, 1, TragicEntityList.getIDFromString("TragicMC.VoxStellarum") == -1 ? 0 : TragicEntityList.getIDFromString("TragicMC.VoxStellarum")), new ItemStack(TragicItems.SpawnEgg, 1, TragicEntityList.getIDFromString("TragicMC.VolatileFusea") == -1 ? 0 : TragicEntityList.getIDFromString("TragicMC.VolatileFusea"))};
        return stacks;
    }

    public static ItemStack[] getSpawnEggsBoss() {
        ItemStack[] stacks = new ItemStack[]{new ItemStack(TragicItems.SpawnEgg, 1, TragicEntityList.getIDFromString("TragicMC.Apis") == -1 ? 0 : TragicEntityList.getIDFromString("TragicMC.Apis")), new ItemStack(TragicItems.SpawnEgg, 1, TragicEntityList.getIDFromString("TragicMC.Polaris") == -1 ? 0 : TragicEntityList.getIDFromString("TragicMC.Polaris")), new ItemStack(TragicItems.SpawnEgg, 1, TragicEntityList.getIDFromString("TragicMC.Yeti") == -1 ? 0 : TragicEntityList.getIDFromString("TragicMC.Yeti")), new ItemStack(TragicItems.SpawnEgg, 1, TragicEntityList.getIDFromString("TragicMC.TimeController") == -1 ? 0 : TragicEntityList.getIDFromString("TragicMC.TimeController")), new ItemStack(TragicItems.SpawnEgg, 1, TragicEntityList.getIDFromString("TragicMC.Kitsune") == -1 ? 0 : TragicEntityList.getIDFromString("TragicMC.Kitsune")), new ItemStack(TragicItems.SpawnEgg, 1, TragicEntityList.getIDFromString("TragicMC.DeathReaper") == -1 ? 0 : TragicEntityList.getIDFromString("TragicMC.Enyvil")), new ItemStack(TragicItems.SpawnEgg, 1, TragicEntityList.getIDFromString("TragicMC.Enyvil") == -1 ? 0 : TragicEntityList.getIDFromString("TragicMC.Kitsune")), new ItemStack(TragicItems.SpawnEgg, 1, TragicEntityList.getIDFromString("TragicMC.Claymation") == -1 ? 0 : TragicEntityList.getIDFromString("TragicMC.Claymation"))};
        return stacks;
    }

    public static ItemStack[] getAmulets() {
        ItemStack[] stacks = new ItemStack[]{new ItemStack(TragicItems.ApisAmulet), new ItemStack(TragicItems.CreeperAmulet), new ItemStack(TragicItems.BlacksmithAmulet), new ItemStack(TragicItems.KitsuneAmulet), new ItemStack(TragicItems.ZombieAmulet), new ItemStack(TragicItems.SkeletonAmulet), new ItemStack(TragicItems.SunkenAmulet), new ItemStack(TragicItems.PeaceAmulet), new ItemStack(TragicItems.ChickenAmulet), new ItemStack(TragicItems.ClaymationAmulet), new ItemStack(TragicItems.YetiAmulet), new ItemStack(TragicItems.MartyrAmulet), new ItemStack(TragicItems.EndermanAmulet)};
        return stacks;
    }

    public static ItemStack[] getEpicWeapons() {
        ItemStack[] stacks = new ItemStack[]{new ItemStack(TragicItems.Titan), new ItemStack(TragicItems.Paranoia), new ItemStack(TragicItems.Butcher), new ItemStack(TragicItems.Thardus), new ItemStack(TragicItems.DragonFang), new ItemStack(TragicItems.Splinter), new ItemStack(TragicItems.SilentHellraiser)};
        return stacks;
    }
}

