/*
 * Decompiled with CFR 0.152.
 */
package tragicneko.tragicmc.items.challenge;

import com.google.common.base.Predicate;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.RegistryNamespacedDefaultedByKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import tragicneko.tragicmc.TragicBiome;
import tragicneko.tragicmc.TragicBlocks;
import tragicneko.tragicmc.TragicItems;
import tragicneko.tragicmc.entity.alpha.EntityOverlordCore;
import tragicneko.tragicmc.entity.boss.EntityApis;
import tragicneko.tragicmc.entity.boss.EntityKitsune;
import tragicneko.tragicmc.entity.boss.EntityTimeController;
import tragicneko.tragicmc.entity.boss.TragicBoss;
import tragicneko.tragicmc.entity.miniboss.TragicMiniBoss;
import tragicneko.tragicmc.entity.mob.EntityAbomination;
import tragicneko.tragicmc.entity.mob.EntityArchangel;
import tragicneko.tragicmc.entity.mob.EntityFusea;
import tragicneko.tragicmc.entity.mob.EntityHarvester;
import tragicneko.tragicmc.entity.mob.EntityHunter;
import tragicneko.tragicmc.entity.mob.EntityInkling;
import tragicneko.tragicmc.entity.mob.EntityNorVox;
import tragicneko.tragicmc.entity.mob.EntityPirah;
import tragicneko.tragicmc.entity.mob.EntityPlague;
import tragicneko.tragicmc.entity.mob.EntityPsygote;
import tragicneko.tragicmc.entity.mob.EntityRagr;
import tragicneko.tragicmc.entity.mob.EntityRanmas;
import tragicneko.tragicmc.entity.mob.EntityStin;
import tragicneko.tragicmc.entity.mob.EntityTragicNeko;
import tragicneko.tragicmc.entity.mob.EntityWisp;
import tragicneko.tragicmc.entity.mob.TragicMob;
import tragicneko.tragicmc.items.challenge.ChallengeBlock;
import tragicneko.tragicmc.items.challenge.ChallengeEntity;
import tragicneko.tragicmc.items.challenge.ChallengeEquipment;
import tragicneko.tragicmc.items.challenge.ChallengeItem;
import tragicneko.tragicmc.items.challenge.ChallengeLive;
import tragicneko.tragicmc.items.challenge.ChallengeLore;
import tragicneko.tragicmc.items.challenge.ChallengeRange;
import tragicneko.tragicmc.util.WorldHelper;

public class Challenge {
    private static final String[] challengeNames = new String[]{"null", "zombieKills", "collectWheat", "stayAlive", "stayAlive3", "survive", "endermanKills", "bossKills", "collectLeather", "stayAlive7", "witherKill", "findEmerald", "findDiamonds", "collectAsh", "miniBossKills", "stinKills", "tragicNekoKills", "collectGoldenApples", "findWisp", "findApis", "findIronGolem", "findSnowBlock", "iceBucketChallenge", "findRecord11", "collectFish", "collectGunpowder", "collectRedSand", "bossKill", "survive2", "collectCooldownDefuse", "findStarlitCliffs", "findMesa", "findMushroomIsland", "findBedrock", "findWater", "findAshenGrass", "findRedMushroomBlock", "findSand", "findMossyCobblestone", "findIronOre", "findIceMountains", "findDeepOcean", "findNorVox", "killInklings", "findHorses", "killTragicMobs", "findOcelots", "findVillagers", "killGhasts", "findSlime", "killZombiePigmen", "survive3", "cliffDiamond", "killVillagers", "collectEmeralds", "collectIronBlocks", "killPirah", "killSkeletons", "findClay", "findLeaves", "killKitsune", "killRagr", "killWisps", "goFishing", "goFishing2", "findLightChestplate", "findAwakeningStone", "findDimensionalKey", "findSavanna", "collectPotatoes", "collectStatues", "findAbomination", "findPlague", "findTimeController", "collectSmoothNetherrack", "collectRedFlowers", "goFishing3", "findMobStatue", "collectTNT", "collectEnderPearls", "findEpicLore", "findRareLore", "collectEpicLore", "collectUncommonLore", "wearDiamondArmor", "wearPumpkin", "wearDarkArmor", "findEverlastingLight", "collectExoticFruit", "collectChallengeScrolls", "findEnderChest", "killBats", "longTermKilling", "killPlayer", "findPlayer", "longTermKilling2", "longTermKilling3", "killAnimals", "findWolf", "collectRedstone", "killEnderDragon", "travelFar", "travelFar2", "travelFar3", "travelFar4", "findScorchedWasteland", "findIreNetCannon", "findArchangel", "findRanmas", "findDarkForest", "killOverlordCore", "findSynapse", "collectNanoBots", "findWingsOfLiberation", "killFusea", "findPermafrost", "netherBed", "darkAeris", "findAshenBadlands", "findHallowedHills", "findPsygote", "killHarvesters", "collectConduit", "findQuicksand", "killHunters", "findSoulChest", "onABoat", "collectQuartz", "findGuiltyThorn", "chickenMassacre", "thisIsAmazing"};
    public static final RegistryNamespacedDefaultedByKey<ResourceLocation, Challenge> challengeRegistry = new RegistryNamespacedDefaultedByKey((Object)new ResourceLocation("null"));
    public static final Challenge nullChallenge = new Challenge(0, false, 0);
    public static final Challenge zombieKills = new ChallengeEntity(1, false, 50, EntityZombie.class, false).setDifficulty(EnumDifficulty.EASY);
    public static final Challenge collectWheat = new ChallengeItem(2, true, 48, new ItemStack(Items.field_151015_O), false);
    public static final Challenge stayAlive = new ChallengeLive(3, false, 1200);
    public static final Challenge stayAlive3 = new ChallengeLive(4, false, 3600).setDifficulty(EnumDifficulty.EASY);
    public static final Challenge survive = new ChallengeLive(5, false, 180).setDifficulty(EnumDifficulty.EASY).setMobRushChallenge();
    public static final Challenge endermanKills = new ChallengeEntity(6, false, 30, EntityEnderman.class, false).setDifficulty(EnumDifficulty.NORMAL);
    public static final Challenge bossKills = new ChallengeEntity(7, false, 10, TragicBoss.class, false).setDifficulty(EnumDifficulty.HARD);
    public static final Challenge collectLeather = new ChallengeItem(8, true, 32, new ItemStack(Items.field_151116_aA), false);
    public static final Challenge stayAlive7 = new ChallengeLive(9, false, 8400).setDifficulty(EnumDifficulty.NORMAL);
    public static final Challenge witherKill = new ChallengeEntity(10, false, 1, EntityWither.class, false).setDifficulty(EnumDifficulty.NORMAL);
    public static final Challenge findEmerald = new ChallengeItem(11, true, 1, new ItemStack(Items.field_151166_bC), false).setDifficulty(EnumDifficulty.NORMAL);
    public static final Challenge findDiamonds = new ChallengeItem(12, true, 6, new ItemStack(Items.field_151045_i), false).setDifficulty(EnumDifficulty.EASY);
    public static final Challenge collectAsh = new ChallengeItem(13, true, 64, new ItemStack(TragicItems.Ash), false);
    public static final Challenge miniBossKills = new ChallengeEntity(14, false, 25, TragicMiniBoss.class, false).setDifficulty(EnumDifficulty.NORMAL);
    public static final Challenge stinKills = new ChallengeEntity(15, false, 25, EntityStin.class, false).setDifficulty(EnumDifficulty.EASY);
    public static final Challenge tragicNekoKills = new ChallengeEntity(16, false, 10, EntityTragicNeko.class, false).setDifficulty(EnumDifficulty.EASY);
    public static final Challenge collectGoldenApples = new ChallengeItem(17, true, 16, new ItemStack(Items.field_151153_ao, 1, 1), false).setDifficulty(EnumDifficulty.HARD);
    public static final Challenge findWisp = new ChallengeEntity(18, true, 1, EntityWisp.class, true);
    public static final Challenge findApis = new ChallengeEntity(19, true, 1, EntityApis.class, true).setDifficulty(EnumDifficulty.EASY);
    public static final Challenge findIronGolem = new ChallengeEntity(20, true, 1, EntityIronGolem.class, true).setDifficulty(EnumDifficulty.EASY);
    public static final Challenge findSnowBlock = new ChallengeBlock(21, true, 1, Blocks.field_150433_aE.func_176223_P(), true).setDifficulty(EnumDifficulty.EASY);
    public static final Challenge iceBucketChallenge = new ChallengeItem(22, true, 1, new ItemStack(Items.field_151133_ar), false).setLocationBased(BiomeGenBase.field_76774_n).setDifficulty(EnumDifficulty.HARD);
    public static final Challenge findRecord11 = new ChallengeItem(23, true, 1, new ItemStack(Items.field_151086_cn), false).setDifficulty(EnumDifficulty.HARD);
    public static final Challenge collectFish = new ChallengeItem(24, true, 64, new ItemStack(Items.field_151115_aP), false).setDifficulty(EnumDifficulty.EASY);
    public static final Challenge collectGunpowder = new ChallengeItem(25, true, 64, new ItemStack(Items.field_151016_H), false).setDifficulty(EnumDifficulty.NORMAL);
    public static final Challenge collectRedSand = new ChallengeItem(26, true, 64, new ItemStack((Block)Blocks.field_150354_m, 1, 1), false).setDifficulty(EnumDifficulty.NORMAL);
    public static final Challenge bossKill = new ChallengeEntity(27, false, 1, TragicBoss.class, false).setDifficulty(EnumDifficulty.NORMAL);
    public static final Challenge survive2 = new ChallengeLive(28, false, 360).setDifficulty(EnumDifficulty.NORMAL).setMobRushChallenge();
    public static final Challenge collectCooldownDefuse = new ChallengeItem(29, true, 3, new ItemStack(TragicItems.CooldownDefuse), false).setDifficulty(EnumDifficulty.EASY);
    public static final Challenge findStarlitCliffs = new Challenge(30, true, 0).setLocationBased(TragicBiome.StarlitCliffs).setDifficulty(EnumDifficulty.HARD);
    public static final Challenge findMesa = new Challenge(31, true, 0).setLocationBased(BiomeGenBase.field_150589_Z).setDifficulty(EnumDifficulty.NORMAL);
    public static final Challenge findMushroomIsland = new Challenge(32, true, 0).setLocationBased(BiomeGenBase.field_76789_p).setDifficulty(EnumDifficulty.NORMAL);
    public static final Challenge findBedrock = new ChallengeBlock(33, true, 1, Blocks.field_150357_h.func_176223_P(), false).setDifficulty(EnumDifficulty.EASY);
    public static final Challenge findWater = new ChallengeBlock(34, true, 1, Blocks.field_150355_j.func_176223_P(), true);
    public static final Challenge findAshenGrass = new ChallengeBlock(35, true, 1, TragicBlocks.AshenGrass.func_176223_P(), false).setDifficulty(EnumDifficulty.EASY);
    public static final Challenge findRedMushroomBlock = new ChallengeBlock(36, true, 1, Blocks.field_150419_aX.func_176223_P(), true).setDifficulty(EnumDifficulty.EASY);
    public static final Challenge findSand = new ChallengeBlock(37, true, 1, Blocks.field_150354_m.func_176223_P(), false);
    public static final Challenge findMossyCobblestone = new ChallengeBlock(38, true, 1, Blocks.field_150341_Y.func_176223_P(), false).setDifficulty(EnumDifficulty.NORMAL);
    public static final Challenge findIronOre = new ChallengeBlock(39, true, 1, Blocks.field_150366_p.func_176223_P(), false).setDifficulty(EnumDifficulty.EASY);
    public static final Challenge findIceMountains = new Challenge(40, true, 0).setLocationBased(BiomeGenBase.field_76775_o).setDifficulty(EnumDifficulty.NORMAL);
    public static final Challenge findDeepOcean = new Challenge(41, true, 0).setLocationBased(BiomeGenBase.field_150575_M).setDifficulty(EnumDifficulty.EASY);
    public static final Challenge findNorVox = new ChallengeEntity(42, true, 1, EntityNorVox.class, true).setDifficulty(EnumDifficulty.EASY);
    public static final Challenge killInklings = new ChallengeEntity(43, false, 50, EntityInkling.class, false).setDifficulty(EnumDifficulty.EASY);
    public static final Challenge findHorses = new ChallengeEntity(44, true, 1, EntityHorse.class, true).setDifficulty(EnumDifficulty.EASY);
    public static final Challenge killTragicMobs = new ChallengeEntity(45, false, 100, TragicMob.class, false).setDifficulty(EnumDifficulty.NORMAL);
    public static final Challenge findOcelots = new ChallengeEntity(46, true, 1, EntityOcelot.class, true).setDifficulty(EnumDifficulty.NORMAL);
    public static final Challenge findVillagers = new ChallengeEntity(47, true, 1, EntityVillager.class, true).setDifficulty(EnumDifficulty.EASY);
    public static final Challenge killGhasts = new ChallengeEntity(48, false, 15, EntityGhast.class, false);
    public static final Challenge findSlime = new ChallengeEntity(49, true, 1, EntitySlime.class, true);
    public static final Challenge killZombiePigmen = new ChallengeEntity(50, false, 100, EntityPigZombie.class, false).setDifficulty(EnumDifficulty.NORMAL);
    public static final Challenge survive3 = new ChallengeLive(51, false, 720).setDifficulty(EnumDifficulty.HARD).setMobRushChallenge();
    public static final Challenge cliffDiamond = new ChallengeItem(52, true, 1, new ItemStack(Items.field_151045_i), false).setLocationBased(BiomeGenBase.field_76770_e).setDifficulty(EnumDifficulty.EASY);
    public static final Challenge killVillagers = new ChallengeEntity(53, false, 5, EntityVillager.class, false).setDifficulty(EnumDifficulty.EASY);
    public static final Challenge collectEmeralds = new ChallengeItem(54, true, 16, new ItemStack(Items.field_151166_bC), false).setDifficulty(EnumDifficulty.EASY);
    public static final Challenge collectIronBlocks = new ChallengeItem(55, true, 64, new ItemStack(Blocks.field_150339_S), false).setDifficulty(EnumDifficulty.NORMAL);
    public static final Challenge killPirah = new ChallengeEntity(56, false, 25, EntityPirah.class, false).setDifficulty(EnumDifficulty.EASY);
    public static final Challenge killSkeletons = new ChallengeEntity(57, false, 50, EntitySkeleton.class, false).setDifficulty(EnumDifficulty.NORMAL);
    public static final Challenge findClay = new ChallengeBlock(58, true, 1, Blocks.field_150435_aG.func_176223_P(), false);
    public static final Challenge findLeaves = new ChallengeBlock(59, true, 1, Blocks.field_150362_t.func_176223_P(), true);
    public static final Challenge killKitsune = new ChallengeEntity(60, false, 1, EntityKitsune.class, false).setDifficulty(EnumDifficulty.NORMAL);
    public static final Challenge killRagr = new ChallengeEntity(61, false, 3, EntityRagr.class, false).setDifficulty(EnumDifficulty.NORMAL);
    public static final Challenge killWisps = new ChallengeEntity(62, false, 10, EntityWisp.class, false).setDifficulty(EnumDifficulty.EASY);
    public static final Challenge goFishing = new ChallengeItem(63, true, 1, new ItemStack((Item)Items.field_151112_aM), true).setLocationBased(BiomeGenBase.field_76781_i);
    public static final Challenge goFishing2 = new ChallengeItem(64, true, 1, new ItemStack((Item)Items.field_151112_aM), true).setLocationBased(BiomeGenBase.field_76787_r);
    public static final Challenge findLightChestplate = new ChallengeItem(65, true, 1, new ItemStack(TragicItems.LightPlate), false).setDifficulty(EnumDifficulty.NORMAL);
    public static final Challenge findAwakeningStone = new ChallengeItem(66, true, 1, new ItemStack(TragicItems.AwakeningStone), false).setDifficulty(EnumDifficulty.NORMAL);
    public static final Challenge findDimensionalKey = new ChallengeItem(67, true, 1, new ItemStack(TragicItems.DimensionalKey), false).setDifficulty(EnumDifficulty.HARD);
    public static final Challenge findSavanna = new Challenge(68, true, 0).setLocationBased(BiomeGenBase.field_150588_X);
    public static final Challenge collectPotatoes = new ChallengeItem(69, true, 64, new ItemStack(Items.field_151174_bG), true).setDifficulty(EnumDifficulty.EASY);
    public static final Challenge collectStatues = new ChallengeItem(70, true, 10, new ItemStack(TragicItems.MobStatue), true).setDifficulty(EnumDifficulty.HARD);
    public static final Challenge findAbomination = new ChallengeEntity(71, true, 1, EntityAbomination.class, true).setDifficulty(EnumDifficulty.EASY);
    public static final Challenge findPlague = new ChallengeEntity(72, true, 1, EntityPlague.class, true);
    public static final Challenge findTimeController = new ChallengeEntity(73, true, 1, EntityTimeController.class, true).setDifficulty(EnumDifficulty.NORMAL);
    public static final Challenge collectSmoothNetherrack = new ChallengeBlock(74, true, 32, TragicBlocks.SmoothNetherrack.func_176223_P(), false);
    public static final Challenge collectRedFlowers = new ChallengeItem(75, true, 32, new ItemStack((Block)Blocks.field_150328_O, 1, 0), false).setDifficulty(EnumDifficulty.EASY);
    public static final Challenge goFishing3 = new ChallengeItem(76, true, 1, new ItemStack((Item)Items.field_151112_aM), true).setLocationBased(BiomeGenBase.field_76777_m).setDifficulty(EnumDifficulty.NORMAL);
    public static final Challenge findMobStatue = new ChallengeItem(77, true, 1, new ItemStack(TragicItems.MobStatue), false).setDifficulty(EnumDifficulty.EASY);
    public static final Challenge collectTNT = new ChallengeItem(78, true, 64, new ItemStack(Blocks.field_150335_W), false).setDifficulty(EnumDifficulty.HARD);
    public static final Challenge collectEnderPearls = new ChallengeItem(79, true, 16, new ItemStack(Items.field_151079_bi), false).setDifficulty(EnumDifficulty.EASY);
    public static final Challenge findEpicLore = new ChallengeLore(80, true, 1, 3).setDifficulty(EnumDifficulty.NORMAL);
    public static final Challenge findRareLore = new ChallengeLore(81, true, 1, 2).setDifficulty(EnumDifficulty.EASY);
    public static final Challenge collectEpicLore = new ChallengeLore(82, true, 5, 3).setDifficulty(EnumDifficulty.HARD);
    public static final Challenge collectUncommonLore = new ChallengeLore(83, true, 10, 1).setDifficulty(EnumDifficulty.EASY);
    public static final Challenge wearDiamondArmor = new ChallengeEquipment(84, true, 4, new ItemStack[]{new ItemStack((Item)Items.field_151161_ac), new ItemStack((Item)Items.field_151163_ad), new ItemStack((Item)Items.field_151173_ae), new ItemStack((Item)Items.field_151175_af)}).setDifficulty(EnumDifficulty.NORMAL);
    public static final Challenge wearPumpkin = new ChallengeEquipment(85, true, 1, new ItemStack[]{new ItemStack(Blocks.field_150423_aK)});
    public static final Challenge wearDarkArmor = new ChallengeEquipment(86, true, 4, new ItemStack[]{new ItemStack(TragicItems.DarkHelm), new ItemStack(TragicItems.DarkPlate), new ItemStack(TragicItems.DarkLegs), new ItemStack(TragicItems.DarkBoots)}).setDifficulty(EnumDifficulty.HARD);
    public static final Challenge findEverlastingLight = new ChallengeItem(87, true, 1, new ItemStack(TragicItems.EverlastingLight), false).setDifficulty(EnumDifficulty.NORMAL);
    public static final Challenge collectExoticFruit = new ChallengeItem(88, true, 16, new ItemStack(TragicItems.Honeydrop), false).setDifficulty(EnumDifficulty.EASY);
    public static final Challenge collectChallengeScrolls = new ChallengeItem(89, true, 5, new ItemStack(TragicItems.ChallengeScroll), false).setDifficulty(EnumDifficulty.NORMAL);
    public static final Challenge findEnderChest = new ChallengeItem(90, true, 1, new ItemStack(Blocks.field_150477_bB), false).setDifficulty(EnumDifficulty.NORMAL);
    public static final Challenge killBats = new ChallengeEntity(91, false, 15, EntityBat.class, false).setDifficulty(EnumDifficulty.EASY);
    public static final Challenge longTermKilling = new ChallengeEntity(92, false, 100, EntityCreature.class, false).setDifficulty(EnumDifficulty.EASY);
    public static final Challenge killPlayer = new ChallengeEntity(93, false, 1, EntityPlayer.class, false).setDifficulty(EnumDifficulty.HARD);
    public static final Challenge findPlayer = new ChallengeEntity(94, true, 1, EntityPlayer.class, true).setDifficulty(EnumDifficulty.EASY);
    public static final Challenge longTermKilling2 = new ChallengeEntity(95, false, 500, EntityCreature.class, false).setDifficulty(EnumDifficulty.NORMAL);
    public static final Challenge longTermKilling3 = new ChallengeEntity(96, false, 1000, EntityCreature.class, false).setDifficulty(EnumDifficulty.HARD);
    public static final Challenge killAnimals = new ChallengeEntity(97, false, 30, EntityAnimal.class, false).setDifficulty(EnumDifficulty.EASY);
    public static final Challenge findWolf = new ChallengeEntity(98, true, 1, EntityWolf.class, true).setDifficulty(EnumDifficulty.EASY);
    public static final Challenge collectRedstone = new ChallengeItem(99, true, 64, new ItemStack(Items.field_151137_ax), false).setDifficulty(EnumDifficulty.EASY);
    public static final Challenge killEnderDragon = new ChallengeEntity(100, false, 1, EntityDragon.class, false).setDifficulty(EnumDifficulty.NORMAL);
    public static final Challenge travelFar = new ChallengeRange(101, false, 1000);
    public static final Challenge travelFar2 = new ChallengeRange(102, false, 5000).setDifficulty(EnumDifficulty.EASY);
    public static final Challenge travelFar3 = new ChallengeRange(103, false, 10000).setDifficulty(EnumDifficulty.NORMAL);
    public static final Challenge travelFar4 = new ChallengeRange(104, false, 100000).setDifficulty(EnumDifficulty.HARD);
    public static final Challenge findScorchedWasteland = new Challenge(105, true, 0).setLocationBased(TragicBiome.ScorchedWastelands).setDifficulty(EnumDifficulty.EASY);
    public static final Challenge findIreNetCannon = new ChallengeItem(106, true, 1, new ItemStack(TragicItems.IreNetParticleCannon), true).setDifficulty(EnumDifficulty.NORMAL);
    public static final Challenge findArchangel = new ChallengeEntity(107, true, 1, EntityArchangel.class, true).setDifficulty(EnumDifficulty.EASY);
    public static final Challenge findRanmas = new ChallengeEntity(108, true, 1, EntityRanmas.class, true).setDifficulty(EnumDifficulty.HARD);
    public static final Challenge findDarkForest = new Challenge(109, true, 0).setLocationBased(TragicBiome.DarkForest);
    public static final Challenge killOverlordCore = new ChallengeEntity(110, false, 1, EntityOverlordCore.class, false).setDifficulty(EnumDifficulty.HARD);
    public static final Challenge findSynapse = new Challenge(111, true, 0).setLocationBased(TragicBiome.Synapse).setDifficulty(EnumDifficulty.NORMAL);
    public static final Challenge collectNanoBots = new ChallengeItem(112, true, 64, new ItemStack(TragicItems.NanoBots), false).setDifficulty(EnumDifficulty.EASY);
    public static final Challenge findWingsOfLiberation = new ChallengeItem(113, true, 1, new ItemStack(TragicItems.WingsOfLiberation), true).setDifficulty(EnumDifficulty.NORMAL);
    public static final Challenge killFusea = new ChallengeEntity(114, false, 10, EntityFusea.class, false).setDifficulty(EnumDifficulty.EASY);
    public static final Challenge findPermafrost = new ChallengeBlock(115, true, 1, TragicBlocks.Permafrost.func_176223_P(), true).setDifficulty(EnumDifficulty.EASY);
    public static final Challenge netherBed = new ChallengeItem(116, true, 1, new ItemStack(Blocks.field_150324_C), false).setLocationBased(BiomeGenBase.field_76778_j).setDifficulty(EnumDifficulty.EASY);
    public static final Challenge darkAeris = new ChallengeItem(117, true, 1, new ItemStack(TragicBlocks.Aeris), false).setLocationBased(TragicBiome.DarkMarsh).setDifficulty(EnumDifficulty.NORMAL);
    public static final Challenge findAshenBadlands = new Challenge(118, true, 0).setLocationBased(TragicBiome.AshenBadlands).setDifficulty(EnumDifficulty.EASY);
    public static final Challenge findHallowedHills = new Challenge(119, true, 0).setLocationBased(TragicBiome.HallowedHills).setDifficulty(EnumDifficulty.EASY);
    public static final Challenge findPsygote = new ChallengeEntity(120, true, 1, EntityPsygote.class, true).setDifficulty(EnumDifficulty.EASY);
    public static final Challenge killHarvesters = new ChallengeEntity(121, false, 10, EntityHarvester.class, false).setDifficulty(EnumDifficulty.NORMAL);
    public static final Challenge collectConduit = new ChallengeItem(122, true, 64, new ItemStack(TragicBlocks.Conduit), false).setDifficulty(EnumDifficulty.NORMAL);
    public static final Challenge findQuicksand = new ChallengeBlock(123, true, 1, TragicBlocks.Quicksand.func_176223_P(), false).setDifficulty(EnumDifficulty.EASY);
    public static final Challenge killHunters = new ChallengeEntity(124, false, 30, EntityHunter.class, true).setDifficulty(EnumDifficulty.EASY);
    public static final Challenge findSoulChest = new ChallengeBlock(125, true, 1, TragicBlocks.SoulChest.func_176223_P(), true).setDifficulty(EnumDifficulty.HARD);
    public static final Challenge onABoat = new ChallengeEntity(126, true, 1, EntityBoat.class, true).setLocationBased(BiomeGenBase.field_150575_M).setDifficulty(EnumDifficulty.EASY);
    public static final Challenge collectQuartz = new ChallengeItem(127, true, 64, new ItemStack(Blocks.field_150371_ca), false);
    public static final Challenge findGuiltyThorn = new ChallengeItem(128, true, 1, new ItemStack(TragicItems.GuiltyThorn), false).setDifficulty(EnumDifficulty.EASY);
    public static final Challenge chickenMassacre = new ChallengeEntity(129, true, 20, EntityChicken.class, false).setTimed(600).setDifficulty(EnumDifficulty.HARD);
    public static final Challenge thisIsAmazing = new ChallengeEntity(130, true, 5, EntityCreature.class, false).setTimed(200).setDifficulty(EnumDifficulty.HARD);
    protected final boolean savesProgress;
    protected final int requirement;
    protected EnumDifficulty difficulty = EnumDifficulty.PEACEFUL;
    protected boolean isTimed = false;
    protected int timeLimit = 0;
    protected boolean isMobRush = false;
    protected boolean isLocationBased = false;
    protected Predicate locationPredicate = null;
    public static final String CHALLENGE_PROG = "challengeProgress";
    public static final String CHALLENGE_LOC = "challengeLocation";
    public static final String CHALLENGE_TIME = "challengeTime";
    public static final String CHALLENGE_ID = "challengeID";

    public Challenge(int id, boolean saveProgress, int requirement) {
        ResourceLocation rl = new ResourceLocation("tragicmc:" + challengeNames[id]);
        if (challengeRegistry.func_148741_d((Object)rl)) {
            throw new IllegalArgumentException("There is a Challenge using that name (" + rl + ") already!");
        }
        challengeRegistry.func_177775_a(id, (Object)rl, (Object)this);
        this.savesProgress = saveProgress;
        this.requirement = requirement;
    }

    public void onLivingDeath(ItemStack stack, EntityLivingBase entity) {
        if (stack.func_77978_p().func_74764_b(CHALLENGE_PROG) && !this.savesProgress) {
            stack.func_77978_p().func_74768_a(CHALLENGE_PROG, 0);
        }
    }

    public void onLivingKill(ItemStack stack, EntityLivingBase entity, EntityPlayer player) {
    }

    public void onLivingUpdate(ItemStack stack, EntityPlayer player) {
        if (stack.func_77978_p().func_74764_b(CHALLENGE_PROG)) {
            if (this.isTimed) {
                if (!stack.func_77978_p().func_74764_b(CHALLENGE_TIME) || stack.func_77978_p().func_74764_b(CHALLENGE_TIME) && stack.func_77978_p().func_74762_e(CHALLENGE_TIME) <= 0) {
                    stack.func_77978_p().func_74768_a(CHALLENGE_TIME, this.timeLimit);
                    stack.func_77978_p().func_74768_a(CHALLENGE_PROG, 0);
                } else if (stack.func_77978_p().func_74764_b(CHALLENGE_TIME) && stack.func_77978_p().func_74762_e(CHALLENGE_TIME) > 0) {
                    stack.func_77978_p().func_74768_a(CHALLENGE_TIME, stack.func_77978_p().func_74762_e(CHALLENGE_TIME) - 1);
                }
            }
            if (this.isMobRush) {
                List list = player.field_70170_p.func_72872_a(EntityMob.class, player.func_174813_aQ().func_72314_b(100.0, 100.0, 100.0));
                for (int j = 0; j < list.size(); ++j) {
                    ((EntityMob)list.get(j)).func_70624_b((EntityLivingBase)player);
                }
                Chunk chk = player.field_70170_p.func_175726_f(WorldHelper.getBlockPos((Entity)player));
                chk.func_177415_c(chk.func_177416_w() + 10000L);
            }
            if (this.isLocationBased) {
                BiomeGenBase currentBiome = player.field_70170_p.func_180494_b(WorldHelper.getBlockPos((Entity)player));
                boolean flag = this.locationPredicate != null && this.locationPredicate.apply((Object)currentBiome);
                stack.func_77978_p().func_74757_a(CHALLENGE_LOC, flag);
            }
        }
        this.updateStackProgress(stack, player.field_70170_p, (Entity)player);
    }

    public void updateStackProgress(ItemStack stack, World world, Entity entity) {
        if (stack.func_77978_p().func_74764_b(CHALLENGE_PROG) && stack.func_77978_p().func_74762_e(CHALLENGE_PROG) >= this.requirement && (this.isLocationBased && stack.func_77978_p().func_74764_b(CHALLENGE_LOC) && stack.func_77978_p().func_74767_n(CHALLENGE_LOC) || !this.isLocationBased)) {
            stack.func_77964_b(250);
            this.onCompletion(entity);
        }
    }

    public void onCompletion(Entity entity) {
    }

    public Challenge setMobRushChallenge() {
        this.isMobRush = true;
        return this;
    }

    public Challenge setDifficulty(EnumDifficulty dif) {
        this.difficulty = dif;
        return this;
    }

    public Challenge setLocationBased(Predicate pred) {
        this.locationPredicate = pred;
        this.isLocationBased = true;
        return this;
    }

    public Challenge setLocationBased(BiomeGenBase biome) {
        return this.setLocationBased(new SingleBiomePred(biome));
    }

    public Challenge setTimed(int limit) {
        this.isTimed = true;
        this.timeLimit = limit;
        return this;
    }

    public int getChallengeId() {
        return challengeRegistry.func_148757_b((Object)this);
    }

    public boolean getSavesProgress() {
        return this.savesProgress;
    }

    public int getRequirement() {
        return this.requirement;
    }

    public EnumDifficulty getDifficulty() {
        return this.difficulty;
    }

    public int getDifficultyId() {
        return this.difficulty.func_151525_a();
    }

    public boolean getTimed() {
        return this.isTimed;
    }

    public int getTimeLimit() {
        return this.timeLimit;
    }

    public boolean isMobRush() {
        return this.isMobRush;
    }

    public boolean isLocationBased() {
        return this.isLocationBased;
    }

    public Predicate getLocationPredicate() {
        return this.locationPredicate;
    }

    public static String getNameFromID(int id) {
        return StatCollector.func_74838_a((String)("challenge." + challengeNames[id] + ".name"));
    }

    public static String getDesc(int id) {
        return StatCollector.func_74838_a((String)("challenge." + challengeNames[id] + ".desc"));
    }

    public static Challenge getChallengeFromID(int id) {
        return (Challenge)challengeRegistry.func_148754_a(id);
    }

    public static int getRegistrySize() {
        return challengeRegistry.func_148742_b().size();
    }

    static class SingleBiomePred
    implements Predicate {
        private final BiomeGenBase biome;

        public SingleBiomePred(BiomeGenBase biome) {
            this.biome = biome;
        }

        public boolean apply(Object input) {
            return input instanceof BiomeGenBase && this.canApply((BiomeGenBase)input);
        }

        public boolean canApply(BiomeGenBase b) {
            return b == this.biome;
        }
    }
}

