/*
 * Decompiled with CFR 0.152.
 */
package tragicneko.tragicmc.events;

import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import tragicneko.tragicmc.TragicConfig;
import tragicneko.tragicmc.doomsday.Doomsday;
import tragicneko.tragicmc.items.ItemDoomsdayScroll;
import tragicneko.tragicmc.items.armor.TragicArmor;
import tragicneko.tragicmc.items.weapons.TragicBow;
import tragicneko.tragicmc.items.weapons.TragicTool;
import tragicneko.tragicmc.items.weapons.TragicWeapon;
import tragicneko.tragicmc.network.MessageDoom;
import tragicneko.tragicmc.properties.PropertyDoom;
import tragicneko.tragicmc.proxy.CommonProxy;

public class DoomEvents {
    @SubscribeEvent
    public void onEntityConstructing(EntityEvent.EntityConstructing event) {
        if (event.entity instanceof EntityPlayer) {
            PropertyDoom doom = PropertyDoom.get((EntityPlayer)event.entity);
            if (doom == null) {
                PropertyDoom.register((EntityPlayer)event.entity);
            } else {
                doom.loadNBTData(new NBTTagCompound());
            }
            if (event.entity instanceof EntityPlayerMP && doom != null && TragicConfig.getBoolean("allowNetwork")) {
                CommonProxy.net.sendTo((IMessage)new MessageDoom((EntityPlayer)event.entity), (EntityPlayerMP)event.entity);
            }
        }
    }

    @SubscribeEvent
    public void onEntityUpdate(LivingEvent.LivingUpdateEvent event) {
        PropertyDoom doom;
        if (event.entityLiving instanceof EntityPlayer && !event.entity.field_70170_p.field_72995_K && (doom = PropertyDoom.get((EntityPlayer)event.entityLiving)) != null) {
            doom.onUpdate();
            if (event.entityLiving instanceof EntityPlayerMP && TragicConfig.getBoolean("allowNetwork")) {
                CommonProxy.net.sendTo((IMessage)new MessageDoom((EntityPlayer)event.entity), (EntityPlayerMP)event.entity);
            }
        }
    }

    @SubscribeEvent
    public void onLivingDeathEvent(PlayerEvent.Clone event) {
        if (!event.entity.field_70170_p.field_72995_K && TragicConfig.getBoolean("allowDoom") && PropertyDoom.get(event.original) != null) {
            NBTTagCompound tag = new NBTTagCompound();
            PropertyDoom.get(event.original).saveNBTData(tag);
            PropertyDoom.get(event.entityPlayer).loadNBTData(tag);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onAttack(LivingHurtEvent event) {
        EntityPlayer player;
        PropertyDoom properties;
        PropertyDoom properties2;
        if (event.entityLiving instanceof EntityPlayer && TragicConfig.getBoolean("allowDoomPainRecharge") && !event.entityLiving.field_70170_p.field_72995_K && (properties2 = PropertyDoom.get((EntityPlayer)event.entityLiving)) != null) {
            properties2.applyDoomPainRecharge(event.ammount);
        }
        if (event.entityLiving instanceof EntityMob && TragicConfig.getBoolean("allowDoomPainRecharge") && event.source.func_76346_g() instanceof EntityLivingBase && event.source.func_76346_g() instanceof EntityPlayer && (properties = PropertyDoom.get(player = (EntityPlayer)event.source.func_76346_g())) != null) {
            properties.applyDoomPainRecharge(event.ammount);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onDeath(PlayerEvent.Clone event) {
        if (event.entityLiving instanceof EntityPlayerMP && !event.wasDeath) {
            EntityPlayerMP player = (EntityPlayerMP)event.entityLiving;
            if (TragicConfig.getBoolean("allowNetwork")) {
                CommonProxy.net.sendTo((IMessage)new MessageDoom((EntityPlayer)player), player);
            }
        }
    }

    @SubscribeEvent
    public void onDeath(LivingDeathEvent event) {
        if (event.entityLiving instanceof EntityMob && TragicConfig.getBoolean("allowDoomKillRecharge") && event.source.func_76346_g() instanceof EntityLivingBase && event.source.func_76346_g() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.source.func_76346_g();
            PropertyDoom properties = PropertyDoom.get(player);
            properties.increaseDoom(TragicConfig.getInt("doomRechargeAmount"));
        }
    }

    @SubscribeEvent
    public void onAnvilUse(AnvilUpdateEvent event) {
        if (TragicConfig.getBoolean("allowDoomScrollImbue") && DoomEvents.canApplyScroll(event.left) && event.right != null && event.right.func_77973_b() instanceof ItemDoomsdayScroll) {
            event.output = ItemStack.func_77944_b((ItemStack)event.left);
            NBTTagCompound tag = event.output.func_77942_o() ? event.output.func_77978_p() : new NBTTagCompound();
            Doomsday dday = Doomsday.getDoomsdayFromId(event.right.func_77952_i() + 1);
            if (dday != null) {
                tag.func_74768_a("doomsdayID", dday.getDoomId());
            }
            if (!event.output.func_77942_o()) {
                event.output.func_77982_d(tag);
            }
            event.cost = event.cost + (15 + (dday != null && dday.getDoomsdayType() == Doomsday.EnumDoomType.COMBINATION ? 15 : 0));
        }
    }

    @SubscribeEvent
    public void onTooltip(ItemTooltipEvent event) {
        if (TragicConfig.getBoolean("allowDoomScrollImbue") && event.itemStack != null && event.itemStack.func_77942_o() && event.itemStack.func_77978_p().func_74764_b("doomsdayID")) {
            Doomsday dday = Doomsday.getDoomsdayFromId(event.itemStack.func_77978_p().func_74762_e("doomsdayID"));
            if (dday == null) {
                return;
            }
            event.toolTip.add(EnumChatFormatting.WHITE + "Doomsday:");
            EnumChatFormatting format = dday.getDoomsdayType().getFormat();
            event.toolTip.add(format + dday.getLocalizedType() + ": " + dday.getLocalizedName());
            event.toolTip.add(EnumChatFormatting.ITALIC + "Cost/Cooldown: " + EnumChatFormatting.GOLD + dday.getScaledDoomRequirement(event.entityPlayer.field_70170_p) + EnumChatFormatting.RESET + " / " + EnumChatFormatting.DARK_AQUA + dday.getScaledCooldown(event.entityPlayer.field_70170_p.func_175659_aa()));
            event.toolTip.add("");
            if (event.itemStack.func_77973_b() instanceof ItemArmor) {
                event.toolTip.add(EnumChatFormatting.ITALIC + "This item is considered an armor piece");
                event.toolTip.add(EnumChatFormatting.ITALIC + "you must wear a full set of the same");
                event.toolTip.add(EnumChatFormatting.ITALIC + "Doomsday to use it.");
                event.toolTip.add("");
            }
        }
    }

    public static boolean canApplyScroll(ItemStack stack) {
        return stack != null && !(stack.func_77973_b() instanceof ItemDoomsdayScroll) && !(stack.func_77973_b() instanceof TragicWeapon) && !(stack.func_77973_b() instanceof TragicTool) && !(stack.func_77973_b() instanceof TragicBow) && !(stack.func_77973_b() instanceof TragicArmor);
    }
}

