/*
 * Decompiled with CFR 0.152.
 */
package tragicneko.tragicmc.entity.projectile;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import tragicneko.tragicmc.util.WorldHelper;

public abstract class EntityProjectile
extends Entity {
    protected int xTile = -1;
    protected int yTile = -1;
    protected int zTile = -1;
    protected Block inTile;
    protected boolean inGround;
    public EntityLivingBase shootingEntity;
    protected int ticksAlive;
    protected int ticksInAir;
    public double accelerationX;
    public double accelerationY;
    public double accelerationZ;

    public EntityProjectile(World par1World) {
        super(par1World);
        this.func_70105_a(1.0f, 1.0f);
    }

    public void func_70110_aj() {
    }

    protected void func_70088_a() {
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_70112_a(double par1) {
        double d1 = this.func_174813_aQ().func_72320_b() * 4.0;
        return par1 < (d1 *= 64.0) * d1;
    }

    public EntityProjectile(World par1World, double par2, double par4, double par6, double par8, double par10, double par12) {
        super(par1World);
        this.func_70105_a(1.0f, 1.0f);
        this.func_70012_b(par2, par4, par6, this.field_70177_z, this.field_70125_A);
        this.func_70107_b(par2, par4, par6);
        double d6 = MathHelper.func_76133_a((double)(par8 * par8 + par10 * par10 + par12 * par12));
        this.accelerationX = par8 / d6 * 0.1;
        this.accelerationY = par10 / d6 * 0.1;
        this.accelerationZ = par12 / d6 * 0.1;
    }

    public EntityProjectile(World par1World, EntityLivingBase par2EntityLivingBase, double par3, double par5, double par7) {
        super(par1World);
        this.shootingEntity = par2EntityLivingBase;
        this.func_70105_a(1.0f, 1.0f);
        this.func_70012_b(par2EntityLivingBase.field_70165_t, par2EntityLivingBase.field_70163_u, par2EntityLivingBase.field_70161_v, par2EntityLivingBase.field_70177_z, par2EntityLivingBase.field_70125_A);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.field_70179_y = 0.0;
        this.field_70181_x = 0.0;
        this.field_70159_w = 0.0;
        double d3 = MathHelper.func_76133_a((double)((par3 += this.field_70146_Z.nextGaussian() * 0.4) * par3 + (par5 += this.field_70146_Z.nextGaussian() * 0.4) * par5 + (par7 += this.field_70146_Z.nextGaussian() * 0.4) * par7));
        this.accelerationX = par3 / d3 * 0.1;
        this.accelerationY = par5 / d3 * 0.1;
        this.accelerationZ = par7 / d3 * 0.1;
    }

    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K && (this.shootingEntity != null && this.shootingEntity.field_70128_L || !this.field_70170_p.func_175697_a(WorldHelper.getBlockPos(this), 4) || !this.field_70170_p.func_72863_F().func_73149_a((int)this.field_70165_t / 16, (int)this.field_70161_v / 16))) {
            this.func_70106_y();
        } else {
            super.func_70030_z();
            if (this.inGround) {
                if (this.field_70170_p.func_180495_p(new BlockPos(this.xTile, this.yTile, this.zTile)).func_177230_c() == this.inTile) {
                    ++this.ticksAlive;
                    if (this.ticksAlive >= 600) {
                        this.func_70106_y();
                    }
                    return;
                }
                this.inGround = false;
                this.field_70159_w *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
                this.field_70181_x *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
                this.field_70179_y *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
                this.ticksAlive = 0;
                this.ticksInAir = 0;
            } else {
                ++this.ticksInAir;
            }
            Vec3 vec3 = new Vec3(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            Vec3 vec31 = new Vec3(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
            MovingObjectPosition movingobjectposition = this.field_70170_p.func_72933_a(vec3, vec31);
            vec3 = new Vec3(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            vec31 = new Vec3(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
            if (movingobjectposition != null) {
                vec31 = new Vec3(movingobjectposition.field_72307_f.field_72450_a, movingobjectposition.field_72307_f.field_72448_b, movingobjectposition.field_72307_f.field_72449_c);
            }
            Entity entity = null;
            List list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_72314_b(1.0, 1.0, 1.0));
            double d0 = 0.0;
            for (int i = 0; i < list.size(); ++i) {
                double d1;
                Entity entity1 = (Entity)list.get(i);
                if (!entity1.func_70067_L() || entity1.func_70028_i((Entity)this.shootingEntity) && this.ticksInAir < 25) continue;
                float f = 0.3f;
                AxisAlignedBB axisalignedbb = entity1.func_174813_aQ().func_72314_b((double)f, (double)f, (double)f);
                MovingObjectPosition movingobjectposition1 = axisalignedbb.func_72327_a(vec3, vec31);
                if (movingobjectposition1 == null || !((d1 = vec3.func_72438_d(movingobjectposition1.field_72307_f)) < d0) && d0 != 0.0) continue;
                entity = entity1;
                d0 = d1;
            }
            if (entity != null) {
                movingobjectposition = new MovingObjectPosition(entity);
            }
            if (movingobjectposition != null) {
                this.onImpact(movingobjectposition);
            }
            this.field_70165_t += this.field_70159_w;
            this.field_70163_u += this.field_70181_x;
            this.field_70161_v += this.field_70179_y;
            float f1 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
            this.field_70177_z = (float)(Math.atan2(this.field_70179_y, this.field_70159_w) * 180.0 / Math.PI) + 90.0f;
            this.field_70125_A = (float)(Math.atan2(f1, this.field_70181_x) * 180.0 / Math.PI) - 90.0f;
            while (this.field_70125_A - this.field_70127_C < -180.0f) {
                this.field_70127_C -= 360.0f;
            }
            while (this.field_70125_A - this.field_70127_C >= 180.0f) {
                this.field_70127_C += 360.0f;
            }
            while (this.field_70177_z - this.field_70126_B < -180.0f) {
                this.field_70126_B -= 360.0f;
            }
            while (this.field_70177_z - this.field_70126_B >= 180.0f) {
                this.field_70126_B += 360.0f;
            }
            this.field_70125_A = this.field_70127_C + (this.field_70125_A - this.field_70127_C) * 0.2f;
            this.field_70177_z = this.field_70126_B + (this.field_70177_z - this.field_70126_B) * 0.2f;
            float f2 = this.getMotionFactor();
            if (this.func_70090_H()) {
                for (int j = 0; j < 4; ++j) {
                    float f3 = 0.25f;
                    this.field_70170_p.func_175688_a(EnumParticleTypes.WATER_BUBBLE, this.field_70165_t - this.field_70159_w * (double)f3, this.field_70163_u - this.field_70181_x * (double)f3, this.field_70161_v - this.field_70179_y * (double)f3, this.field_70159_w, this.field_70181_x, this.field_70179_y, new int[0]);
                }
                f2 = 0.8f;
            }
            this.field_70159_w += this.accelerationX;
            this.field_70181_x += this.accelerationY;
            this.field_70179_y += this.accelerationZ;
            this.field_70159_w *= (double)f2;
            this.field_70181_x *= (double)f2;
            this.field_70179_y *= (double)f2;
            this.field_70170_p.func_175688_a(this.getParticleString(), this.field_70165_t - this.field_70159_w, this.field_70163_u + (double)(this.field_70131_O / 4.0f) - this.field_70181_x, this.field_70161_v - this.field_70179_y, 0.0, 0.0, 0.0, new int[0]);
            this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            if (this.field_70173_aa > this.getLifespan()) {
                this.func_70106_y();
            }
        }
    }

    protected EnumParticleTypes getParticleString() {
        return EnumParticleTypes.SMOKE_NORMAL;
    }

    public float getMotionFactor() {
        return 0.95f;
    }

    protected abstract void onImpact(MovingObjectPosition var1);

    public void func_70014_b(NBTTagCompound par1NBTTagCompound) {
        par1NBTTagCompound.func_74777_a("xTile", (short)this.xTile);
        par1NBTTagCompound.func_74777_a("yTile", (short)this.yTile);
        par1NBTTagCompound.func_74777_a("zTile", (short)this.zTile);
        par1NBTTagCompound.func_74774_a("inTile", (byte)Block.func_149682_b((Block)this.inTile));
        par1NBTTagCompound.func_74774_a("inGround", (byte)(this.inGround ? 1 : 0));
        par1NBTTagCompound.func_74782_a("direction", (NBTBase)this.func_70087_a(new double[]{this.field_70159_w, this.field_70181_x, this.field_70179_y}));
    }

    public void func_70037_a(NBTTagCompound par1NBTTagCompound) {
        this.xTile = par1NBTTagCompound.func_74765_d("xTile");
        this.yTile = par1NBTTagCompound.func_74765_d("yTile");
        this.zTile = par1NBTTagCompound.func_74765_d("zTile");
        this.inTile = Block.func_149729_e((int)(par1NBTTagCompound.func_74771_c("inTile") & 0xFF));
        boolean bl = this.inGround = par1NBTTagCompound.func_74771_c("inGround") == 1;
        if (par1NBTTagCompound.func_150297_b("direction", 9)) {
            NBTTagList nbttaglist = par1NBTTagCompound.func_150295_c("direction", 6);
            this.field_70159_w = nbttaglist.func_150309_d(0);
            this.field_70181_x = nbttaglist.func_150309_d(1);
            this.field_70179_y = nbttaglist.func_150309_d(2);
        } else {
            this.func_70106_y();
        }
    }

    public boolean func_70067_L() {
        return true;
    }

    public float func_70111_Y() {
        return 1.0f;
    }

    public boolean func_70097_a(DamageSource par1DamageSource, float par2) {
        if (this.func_180431_b(par1DamageSource) || this.field_70170_p.field_72995_K) {
            return false;
        }
        this.func_70018_K();
        if (par1DamageSource.func_76363_c()) {
            this.func_70106_y();
            return true;
        }
        if (this.canBeDeflected()) {
            Vec3 vec3 = WorldHelper.getVecFromEntity(par1DamageSource.func_76346_g(), 1.0);
            if (vec3 != null) {
                this.field_70159_w = vec3.field_72450_a;
                this.field_70181_x = vec3.field_72448_b;
                this.field_70179_y = vec3.field_72449_c;
                this.accelerationX = this.field_70159_w * 0.1;
                this.accelerationY = this.field_70181_x * 0.1;
                this.accelerationZ = this.field_70179_y * 0.1;
            }
            if (par1DamageSource.func_76346_g() instanceof EntityLivingBase) {
                this.shootingEntity = (EntityLivingBase)par1DamageSource.func_76346_g();
            }
            return true;
        }
        return false;
    }

    public boolean canBeDeflected() {
        return false;
    }

    public float func_70013_c(float par1) {
        return 1.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_70070_b(float par1) {
        return 0xFFFFFF;
    }

    public int getLifespan() {
        return 60;
    }
}

