/*
 * Decompiled with CFR 0.152.
 */
package tragicneko.tragicmc.entity.mob;

import com.google.common.base.Predicate;
import java.util.Calendar;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityFireball;
import net.minecraft.entity.projectile.EntityWitherSkull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.stats.StatBase;
import net.minecraft.util.BlockPos;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import tragicneko.tragicmc.TragicAchievements;
import tragicneko.tragicmc.TragicBlocks;
import tragicneko.tragicmc.TragicConfig;
import tragicneko.tragicmc.TragicItems;
import tragicneko.tragicmc.TragicMC;
import tragicneko.tragicmc.TragicPotion;
import tragicneko.tragicmc.entity.alpha.EntityOverlordCore;
import tragicneko.tragicmc.entity.boss.TragicBoss;
import tragicneko.tragicmc.entity.miniboss.EntityGreaterStin;
import tragicneko.tragicmc.entity.miniboss.EntityJarra;
import tragicneko.tragicmc.entity.miniboss.EntityKragul;
import tragicneko.tragicmc.entity.miniboss.EntityMagmox;
import tragicneko.tragicmc.entity.miniboss.EntityMegaCryse;
import tragicneko.tragicmc.entity.miniboss.EntityStinKing;
import tragicneko.tragicmc.entity.miniboss.EntityStinQueen;
import tragicneko.tragicmc.entity.miniboss.EntityVoxStellarum;
import tragicneko.tragicmc.entity.miniboss.TragicMiniBoss;
import tragicneko.tragicmc.entity.mob.EntityPlague;
import tragicneko.tragicmc.entity.projectile.EntityProjectile;
import tragicneko.tragicmc.util.EntityDropHelper;
import tragicneko.tragicmc.util.WorldHelper;

public abstract class TragicMob
extends EntityMob {
    protected Class<? extends TragicMiniBoss> superiorForm;
    public static final int DW_CHANGE_STATE = 16;
    public static final int DW_CORRUPTION_TICKS = 17;
    public static final int DW_SUPPORT = 18;
    private int supportID = -1;
    private int supportAmp = 1;
    public static final Predicate playerTarget = new Predicate(){

        public boolean apply(Object input) {
            return this.canApply((Entity)input);
        }

        public boolean canApply(Entity entity) {
            return entity instanceof EntityPlayer;
        }
    };

    public TragicMob(World par1World) {
        super(par1World);
        this.field_70757_a = -this.func_70627_aG();
    }

    protected boolean canCorrupt() {
        return true;
    }

    protected boolean canChange() {
        return this.superiorForm != null && TragicConfig.getBoolean("allowMobTransformation");
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(16, (Object)0);
        this.field_70180_af.func_75682_a(17, (Object)0);
        this.field_70180_af.func_75682_a(18, (Object)0);
    }

    public int getCorruptionTicks() {
        return this.field_70180_af.func_75679_c(17);
    }

    protected void setCorruptionTicks(int i) {
        this.field_70180_af.func_75692_b(17, (Object)i);
    }

    protected void incrementCorruptionTicks() {
        int pow = this.getCorruptionTicks();
        this.setCorruptionTicks(++pow);
    }

    public boolean isChanging() {
        return this.field_70180_af.func_75683_a(16) == 1;
    }

    public void setChanging(boolean flag) {
        this.field_70180_af.func_75692_b(16, (Object)(flag ? (byte)1 : 0));
    }

    public boolean isSupport() {
        return this.field_70180_af.func_75683_a(18) == 1;
    }

    public void setSupport(boolean flag) {
        this.field_70180_af.func_75692_b(18, (Object)(flag ? (byte)1 : 0));
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70170_p.field_72995_K) {
            this.updateSize();
            if (this.isChanging()) {
                this.func_70656_aK();
            }
            if (this.isSupport() && this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD) {
                double d = 0.35;
                double d2 = 0.35;
                for (int i = 0; i < 3; i = (int)((byte)(i + 1))) {
                    this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, this.field_70165_t + (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble()) * (double)this.field_70130_N * 1.25, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble()) * (double)this.field_70130_N * 1.25, (this.field_70146_Z.nextDouble() - 0.6) * 0.1, this.field_70146_Z.nextDouble() * 0.1, (this.field_70146_Z.nextDouble() - 0.6) * 0.1, new int[0]);
                    this.field_70170_p.func_175688_a(EnumParticleTypes.REDSTONE, this.field_70165_t + (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble()) * (double)this.field_70130_N * 1.25, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble()) * (double)this.field_70130_N * 1.25, 0.6, 0.2, 0.6, new int[0]);
                    this.field_70170_p.func_175688_a(EnumParticleTypes.REDSTONE, this.field_70165_t + (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble()) * (double)this.field_70130_N * 1.25, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble()) * (double)this.field_70130_N * 1.25, this.field_70146_Z.nextDouble() * d + d2, this.field_70146_Z.nextDouble() * d + d2, this.field_70146_Z.nextDouble() * d + d2, new int[0]);
                    this.field_70170_p.func_175688_a(EnumParticleTypes.REDSTONE, this.field_70165_t + (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble()) * (double)this.field_70130_N * 1.25, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble()) * (double)this.field_70130_N * 1.25, this.field_70146_Z.nextDouble() * d + d2, this.field_70146_Z.nextDouble() * d + d2, this.field_70146_Z.nextDouble() * d + d2, new int[0]);
                    this.field_70170_p.func_175688_a(EnumParticleTypes.REDSTONE, this.field_70165_t + (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble()) * (double)this.field_70130_N * 1.25, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble()) * (double)this.field_70130_N * 1.25, this.field_70146_Z.nextDouble() * d + d2, this.field_70146_Z.nextDouble() * d + d2, this.field_70146_Z.nextDouble() * d + d2, new int[0]);
                }
            }
            if (this.isCorrupted()) {
                for (int i = 0; i < 3; i = (int)((byte)(i + 1))) {
                    this.field_70170_p.func_175688_a(EnumParticleTypes.SPELL_MOB_AMBIENT, this.field_70165_t + (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble()) * (double)this.field_70130_N * 1.25, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble()) * (double)this.field_70130_N * 1.25, 0.2, 0.2, 0.2, new int[0]);
                }
            }
            return;
        }
        if (this.isChanging() && this.field_70173_aa > 1) {
            this.change();
            return;
        }
        if (this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD && this.isSupport() && this.field_70173_aa % 30 == 0) {
            if (this.supportID < 0) {
                this.supportID = this.getRandomPotionID();
                this.supportAmp = this.field_70146_Z.nextInt(2);
            }
            if (Potion.field_76425_a[this.supportID] != null) {
                PotionEffect effect = new PotionEffect(this.supportID, 300, this.supportAmp);
                this.func_70690_d(effect);
                List list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72314_b(32.0, 32.0, 32.0));
                for (Entity e : list) {
                    if (!(e instanceof EntityMob) || !this.func_70685_l(e) || ((EntityMob)e).func_70638_az() == this) continue;
                    ((EntityMob)e).func_70690_d(effect);
                }
            }
        }
        if (this.func_70638_az() != null && this.func_70638_az().field_70128_L) {
            this.func_70624_b(null);
        }
        if (this.func_70638_az() != null && !TragicConfig.getBoolean("allowMobInfighting") && (this.func_70638_az() instanceof TragicMob || this.func_70638_az() instanceof TragicBoss)) {
            this.func_70624_b(null);
        }
        if (this.func_70638_az() == null && this.canCorrupt() && TragicConfig.getBoolean("allowCorruption") && this.func_82165_m(TragicPotion.Corruption.field_76415_H)) {
            EntityPlayer entityplayer = this.field_70170_p.func_72890_a((Entity)this, 16.0);
            EntityPlayer result = null;
            if (entityplayer != null && this.func_70685_l((Entity)entityplayer)) {
                result = entityplayer;
            } else if (TragicConfig.getBoolean("allowMobInfighting")) {
                List list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72314_b(16.0, 16.0, 16.0));
                for (int i = 0; i < list.size(); ++i) {
                    Entity entity = (Entity)list.get(i);
                    if (!this.func_70685_l(entity) || entity == this || entity instanceof EntityWither || entity instanceof EntityDragon || entity instanceof TragicBoss || entity.getClass() == ((Object)((Object)this)).getClass() || entity instanceof EntityPlague) continue;
                    if (entity instanceof TragicMob) {
                        if (this.superiorForm != null && entity.getClass() != this.superiorForm && entity.getClass() != this.getLesserForm()) {
                            result = entity;
                            break;
                        }
                        if (entity.getClass() == this.getLesserForm() || this.superiorForm != null) continue;
                        result = entity;
                        break;
                    }
                    if (!(entity instanceof EntityAnimal)) continue;
                    result = entity;
                    break;
                }
                this.func_70624_b((EntityLivingBase)result);
            }
        }
        if (TragicConfig.getBoolean("allowCorruption")) {
            if (this.func_70644_a(TragicPotion.Corruption) && !(this instanceof TragicMiniBoss)) {
                this.incrementCorruptionTicks();
            } else {
                int i = this instanceof TragicMiniBoss ? 0 : this.getCorruptionTicks() - 1;
                this.setCorruptionTicks(i);
            }
            if (this.canChange() && this.getCorruptionTicks() >= 400 && this.field_70146_Z.nextInt(200) <= TragicConfig.getInt("mobTransformationChance") && this.field_70173_aa % 20 == 0) {
                this.setChanging(true);
            }
        } else if (this.canChange() && this.field_70173_aa >= 6000 && this.field_70173_aa % 20 == 0 && this.field_70146_Z.nextInt(100) <= TragicConfig.getInt("mobTransformationChance")) {
            this.setChanging(true);
        }
        if (this.getIllumination() && TragicConfig.getBoolean("allowMobIllumination") && this.field_70173_aa % 4 == 0) {
            BlockPos pos;
            int w = MathHelper.func_76141_d((float)this.field_70130_N);
            int h = MathHelper.func_76141_d((float)this.field_70131_O);
            if (w < 2) {
                w = 2;
            }
            if (h < 2) {
                h = 2;
            }
            if (EntityOverlordCore.replaceableBlocks.contains(WorldHelper.getBlock(this.field_70170_p, pos = WorldHelper.getBlockPos((Entity)this).func_177963_a((double)(this.field_70146_Z.nextInt(w) - this.field_70146_Z.nextInt(w)), (double)((float)(this.field_70146_Z.nextInt(h) - this.field_70146_Z.nextInt(h)) + this.field_70131_O * 2.0f / 3.0f), (double)(this.field_70146_Z.nextInt(w) - this.field_70146_Z.nextInt(w)))))) {
                this.field_70170_p.func_175656_a(pos, TragicBlocks.Luminescence.func_176223_P());
            }
        }
    }

    protected void change() {
        if (this.isChangeAllowed()) {
            TragicMob boss = (TragicMob)((Object)this.getSuperiorForm());
            boss.func_180432_n((Entity)this);
            boss.func_82149_j((Entity)this);
            this.field_70170_p.func_72900_e((Entity)this);
            this.field_70170_p.func_72838_d((Entity)boss);
            boss.func_70690_d(new PotionEffect(Potion.field_76420_g.field_76415_H, 200, 2));
            boss.func_70690_d(new PotionEffect(Potion.field_76429_m.field_76415_H, 200, 2));
            boss.setChanging(false);
            boss.func_85030_a("tragicmc:random.change", 1.0f, 1.0f);
            boss.updateSize();
        } else {
            this.setChanging(false);
        }
    }

    protected TragicMiniBoss getSuperiorForm() {
        try {
            return this.superiorForm.getConstructor(World.class).newInstance(this.field_70170_p);
        }
        catch (Exception e) {
            TragicMC.logError("Error while trying to instantiate a superior form of a changeable entity for transformation", e);
            return null;
        }
    }

    protected abstract boolean isChangeAllowed();

    public boolean isCorrupted() {
        return this.getCorruptionTicks() > 0;
    }

    public boolean func_70652_k(Entity par1Entity) {
        if (this.field_70170_p.field_72995_K || TragicConfig.getBoolean("allowStun") && this.func_70644_a(TragicPotion.Stun)) {
            return false;
        }
        Boolean result = super.func_70652_k(par1Entity);
        if (result.booleanValue() && TragicConfig.getBoolean("allowCorruption") && this.canCorrupt() && this.field_70146_Z.nextInt(4) == 0 && this.func_70644_a(TragicPotion.Corruption)) {
            if (par1Entity instanceof TragicMob && ((TragicMob)par1Entity).canCorrupt()) {
                ((TragicMob)par1Entity).func_70690_d(new PotionEffect(TragicPotion.Corruption.field_76415_H, 600, 1));
            } else if (par1Entity instanceof EntityMob && !(par1Entity instanceof TragicMob)) {
                ((EntityMob)par1Entity).func_70690_d(new PotionEffect(TragicPotion.Corruption.field_76415_H, 600, 1));
            } else if (par1Entity instanceof EntityAnimal) {
                ((EntityAnimal)par1Entity).func_70690_d(new PotionEffect(TragicPotion.Corruption.field_76415_H, 400, 1));
            } else if (par1Entity instanceof EntityPlayer && !((EntityPlayer)par1Entity).field_71075_bZ.field_75098_d) {
                ((EntityLivingBase)par1Entity).func_70690_d(new PotionEffect(TragicPotion.Corruption.field_76415_H, 200, 1));
            }
        }
        return result;
    }

    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        if (tag.func_74764_b("corruptionTicks")) {
            this.setCorruptionTicks(tag.func_74762_e("corruptionTicks"));
        }
        if (tag.func_74764_b("changeState")) {
            this.setChanging(tag.func_74771_c("changeState") == 1);
        }
        if (tag.func_74764_b("support")) {
            this.setSupport(tag.func_74771_c("support") == 1);
        }
        if (tag.func_74764_b("supportID")) {
            this.supportID = tag.func_74762_e("supportID");
        }
        if (tag.func_74764_b("supportAmp")) {
            this.supportAmp = tag.func_74762_e("supportAmp");
        }
        this.updateSize();
    }

    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        tag.func_74768_a("corruptionTicks", this.getCorruptionTicks());
        tag.func_74774_a("changeState", this.isChanging() ? (byte)1 : 0);
        tag.func_74774_a("support", this.isSupport() ? (byte)1 : 0);
        tag.func_74768_a("supportID", this.supportID);
        tag.func_74768_a("supportAmp", this.supportAmp);
    }

    public boolean getMobGriefing() {
        return this.field_70170_p.func_82736_K().func_82766_b("mobGriefing");
    }

    public boolean getAllowLoot() {
        return this.field_70170_p.func_82736_K().func_82766_b("doMobLoot");
    }

    protected void func_70609_aI() {
        ++this.field_70725_aQ;
        if (this.field_70725_aQ == 20) {
            if (!this.field_70170_p.field_72995_K && this.field_70718_bc > 0) {
                int j;
                for (int i = this.func_70693_a(this.field_70717_bb); i > 0; i -= j) {
                    j = EntityXPOrb.func_70527_a((int)i);
                    this.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, j));
                }
            }
            this.func_70106_y();
            this.func_70656_aK();
        }
    }

    protected void func_70628_a(boolean flag, int l) {
        super.func_70628_a(flag, l);
        if (!this.field_70170_p.field_72995_K) {
            int x = this.getDropAmount() + l;
            int drops = 0;
            for (int i = 0; i < x; ++i) {
                ItemStack drop;
                if (this.field_70146_Z.nextInt(100) <= TragicConfig.getInt("commonMobDropChance") + x * 4) {
                    ItemStack itemStack = drop = this.isMobVariant() ? EntityDropHelper.getDropFromVariant(((Object)((Object)this)).getClass(), true) : EntityDropHelper.getDropFromEntity(((Object)((Object)this)).getClass(), true);
                    if (drop != null) {
                        this.capturedDrops.add(new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, drop));
                    }
                    ++drops;
                }
                if (flag && this.field_70146_Z.nextInt(100) <= TragicConfig.getInt("rareMobDropChance") + x) {
                    ItemStack itemStack = drop = this.isMobVariant() ? EntityDropHelper.getDropFromVariant(((Object)((Object)this)).getClass(), false) : EntityDropHelper.getDropFromEntity(((Object)((Object)this)).getClass(), false);
                    if (drop != null) {
                        this.capturedDrops.add(new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, drop));
                    }
                    ++drops;
                }
                if ((double)drops > (double)x * 2.5) break;
            }
            if (!TragicConfig.getBoolean("allowMobStatueDrops")) {
                return;
            }
            int id = 0;
            if (this instanceof EntityJarra) {
                id = 6;
            } else if (this instanceof EntityKragul) {
                id = 7;
            } else if (this instanceof EntityMagmox) {
                id = 8;
            } else if (this instanceof EntityMegaCryse) {
                id = 9;
            } else if (this instanceof EntityStinKing) {
                id = 10;
            } else if (this instanceof EntityStinQueen) {
                id = 11;
            } else if (this instanceof EntityGreaterStin) {
                id = 12;
            } else if (this instanceof EntityVoxStellarum) {
                id = 13;
            }
            if (id != 0 && this.field_70146_Z.nextInt(100) <= TragicConfig.getInt("mobStatueDropChance") && flag) {
                this.capturedDrops.add(new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, new ItemStack(TragicItems.MobStatue, 1, id)));
            }
        }
    }

    public void func_70645_a(DamageSource par1DamageSource) {
        super.func_70645_a(par1DamageSource);
        if (par1DamageSource.func_76346_g() != null && par1DamageSource.func_76346_g() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)par1DamageSource.func_76346_g();
            if (TragicConfig.getBoolean("allowAchievements")) {
                player.func_71029_a((StatBase)TragicAchievements.kill);
                if (this instanceof TragicMiniBoss) {
                    player.func_71029_a((StatBase)TragicAchievements.killMiniBoss);
                }
            }
        }
    }

    public boolean isMobVariant() {
        return false;
    }

    public void func_70074_a(EntityLivingBase entity) {
        super.func_70074_a(entity);
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        int i = (int)(entity.func_110138_aP() * 20.0f);
        if (entity instanceof EntityPlayer) {
            i *= 20;
        }
        this.func_70690_d(new PotionEffect(Potion.field_76420_g.field_76415_H, i, 2));
        this.func_70690_d(new PotionEffect(Potion.field_76429_m.field_76415_H, i, 2));
        if (entity.func_110138_aP() >= this.func_110138_aP() && this.canChange() && this.isCorrupted()) {
            this.setChanging(true);
        }
    }

    public Class<? extends TragicMob> getLesserForm() {
        return ((Object)((Object)this)).getClass();
    }

    public boolean func_70686_a(Class par1Class) {
        return super.func_70686_a(par1Class) && par1Class != TragicBoss.class && this instanceof TragicMiniBoss ? par1Class != this.getLesserForm() : true;
    }

    public IEntityLivingData func_180482_a(DifficultyInstance ins, IEntityLivingData data) {
        IEntityLivingData sData = super.func_180482_a(ins, data);
        this.updateSize();
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD && TragicConfig.getBoolean("allowRandomSupportMob")) {
            this.setSupport(this.field_70146_Z.nextInt(50) == 0);
        }
        if (!TragicConfig.getBoolean("allowGroupBuffs") || this.isBuffExempt()) {
            return sData;
        }
        if (sData == null) {
            if (this.field_70146_Z.nextInt(200) <= TragicConfig.getInt("groupBuffChance")) {
                int id = this.getRandomPotionID();
                PotionEffect effect = new PotionEffect(id, 99999, this.field_70146_Z.nextInt(2));
                this.func_70690_d(effect);
                return new GroupBuff(effect);
            }
        } else if (data instanceof GroupBuff) {
            this.func_70690_d(((GroupBuff)data).getReducedEffect());
            return sData;
        }
        return sData;
    }

    private int getRandomPotionID() {
        int id = Potion.field_76420_g.field_76415_H;
        switch (this.field_70146_Z.nextInt(12)) {
            default: {
                break;
            }
            case 1: {
                id = Potion.field_76424_c.field_76415_H;
                break;
            }
            case 2: {
                id = Potion.field_76441_p.field_76415_H;
                break;
            }
            case 3: {
                id = this.func_70668_bt() == EnumCreatureAttribute.UNDEAD ? Potion.field_76436_u.field_76415_H : Potion.field_76428_l.field_76415_H;
                break;
            }
            case 4: {
                id = Potion.field_76426_n.field_76415_H;
                break;
            }
            case 5: {
                id = Potion.field_76429_m.field_76415_H;
                break;
            }
            case 6: {
                id = Potion.field_76430_j.field_76415_H;
                break;
            }
            case 7: {
                id = TragicConfig.getBoolean("allowImmunity") ? TragicPotion.Immunity.field_76415_H : Potion.field_76422_e.field_76415_H;
                break;
            }
            case 8: {
                id = TragicConfig.getBoolean("allowClarity") ? TragicPotion.Clarity.field_76415_H : Potion.field_76429_m.field_76415_H;
                break;
            }
            case 9: {
                id = TragicConfig.getBoolean("allowResurrection") ? TragicPotion.Resurrection.field_76415_H : Potion.field_76422_e.field_76415_H;
                break;
            }
            case 10: {
                id = TragicConfig.getBoolean("allowAquaSuperiority") ? TragicPotion.AquaSuperiority.field_76415_H : Potion.field_76430_j.field_76415_H;
            }
        }
        return id;
    }

    public int getDropAmount() {
        return 1;
    }

    protected Entity fireProjectileAtEntity(Entity entity, Entity target, float dispersal) {
        entity.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
        entity.func_70107_b(this.field_70165_t, this.field_70163_u + (double)(this.field_70131_O * 2.0f / 3.0f), this.field_70161_v);
        if (entity instanceof EntityProjectile) {
            ((EntityProjectile)entity).shootingEntity = this;
        } else if (entity instanceof EntityFireball) {
            ((EntityFireball)entity).field_70235_a = this;
        }
        double d0 = target.field_70165_t - this.field_70165_t;
        double d1 = target.field_70163_u - this.field_70163_u + (double)target.field_70131_O * 0.5 - (double)(this.field_70131_O * 2.0f / 3.0f);
        double d2 = target.field_70161_v - this.field_70161_v;
        float mf = entity instanceof EntityProjectile ? ((EntityProjectile)entity).getMotionFactor() : (entity instanceof EntityWitherSkull && ((EntityWitherSkull)entity).func_82342_d() ? 0.73f : 0.95f);
        float dist = this.func_70032_d((Entity)this.func_70638_az());
        if (this.field_70170_p.func_175659_aa().func_151525_a() > 2) {
            d0 += target.field_70159_w * (double)dist / (double)mf;
            d1 += (target.field_70181_x + 0.09) * (double)dist / (double)mf;
            d2 += target.field_70179_y * (double)dist / (double)mf;
        }
        float f = MathHelper.func_76129_c((float)dist) * dispersal;
        double d3 = MathHelper.func_76133_a((double)((d0 += (double)f * this.field_70146_Z.nextGaussian()) * d0 + d1 * d1 + (d2 += (double)f * this.field_70146_Z.nextGaussian()) * d2));
        if (entity instanceof EntityProjectile) {
            ((EntityProjectile)entity).accelerationX = d0 / d3 * 0.1;
            ((EntityProjectile)entity).accelerationY = d1 / d3 * 0.1;
            ((EntityProjectile)entity).accelerationZ = d2 / d3 * 0.1;
        } else if (entity instanceof EntityFireball) {
            ((EntityFireball)entity).field_70232_b = d0 / d3 * 0.1;
            ((EntityFireball)entity).field_70233_c = d1 / d3 * 0.1;
            ((EntityFireball)entity).field_70230_d = d2 / d3 * 0.1;
        }
        this.field_70170_p.func_72838_d(entity);
        return entity;
    }

    public boolean func_70097_a(DamageSource src, float dmg) {
        if (src == DamageSource.field_76368_d && this.field_70154_o != null) {
            return false;
        }
        return super.func_70097_a(src, dmg);
    }

    public String func_70005_c_() {
        String s;
        String string = s = this.isMobVariant() ? this.getVariantName() : null;
        if (s == null) {
            return super.func_70005_c_();
        }
        return StatCollector.func_74838_a((String)("entity." + s + ".name"));
    }

    protected String getVariantName() {
        return EntityList.func_75621_b((Entity)this);
    }

    public boolean isHalloween() {
        Calendar calendar = this.field_70170_p.func_83015_S();
        return calendar.get(2) + 1 == 10 && calendar.get(5) > 27 || calendar.get(2) + 1 == 11 && calendar.get(5) < 4;
    }

    public boolean getIllumination() {
        return false;
    }

    protected boolean teleportRandomly() {
        double d0 = this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * 24.0;
        double d1 = this.field_70163_u + (double)(this.field_70146_Z.nextInt(64) - 32);
        double d2 = this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * 24.0;
        return this.teleportTo(d0, d1, d2);
    }

    protected boolean teleportToEntity(Entity par1Entity) {
        Vec3 vec3 = new Vec3(this.field_70165_t - par1Entity.field_70165_t, this.func_174813_aQ().field_72338_b + (double)(this.field_70131_O / 2.0f) - par1Entity.field_70163_u + (double)par1Entity.func_70047_e(), this.field_70161_v - par1Entity.field_70161_v);
        vec3 = vec3.func_72432_b();
        double d0 = 16.0;
        double d1 = this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * 8.0 - vec3.field_72450_a * d0;
        double d2 = this.field_70163_u + (double)(this.field_70146_Z.nextInt(16) - 8) - vec3.field_72448_b * d0;
        double d3 = this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * 8.0 - vec3.field_72449_c * d0;
        return this.teleportTo(d1, d2, d3);
    }

    protected boolean teleportTo(double par1, double par3, double par5) {
        if (this.field_70128_L) {
            return false;
        }
        double d3 = this.field_70165_t;
        double d4 = this.field_70163_u;
        double d5 = this.field_70161_v;
        this.field_70165_t = par1;
        this.field_70163_u = par3;
        this.field_70161_v = par5;
        boolean flag = false;
        int i = MathHelper.func_76128_c((double)this.field_70165_t);
        int j = MathHelper.func_76128_c((double)this.field_70163_u);
        int k = MathHelper.func_76128_c((double)this.field_70161_v);
        boolean flag2 = false;
        if (this.field_70170_p.func_175642_b(EnumSkyBlock.BLOCK, new BlockPos(i, j, k)) <= this.getTeleportLight()) {
            flag2 = true;
        }
        if (this.field_70170_p.func_175667_e(new BlockPos(i, j, k)) && flag2) {
            boolean flag1 = false;
            while (!flag1 && j > 0) {
                Block block = this.field_70170_p.func_180495_p(new BlockPos(i, j - 1, k)).func_177230_c();
                if (block.func_149688_o().func_76230_c()) {
                    flag1 = true;
                    continue;
                }
                this.field_70163_u -= 1.0;
                --j;
            }
            if (flag1) {
                this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                if (this.field_70170_p.func_72945_a((Entity)this, this.func_174813_aQ()).isEmpty() && !this.field_70170_p.func_72953_d(this.func_174813_aQ())) {
                    flag = true;
                }
            }
        }
        if (!flag) {
            this.func_70107_b(d3, d4, d5);
            return false;
        }
        int short1 = 128;
        for (int l = 0; l < short1; ++l) {
            double d6 = (double)l / ((double)short1 - 1.0);
            float f = (this.field_70146_Z.nextFloat() - 0.5f) * 0.2f;
            float f1 = (this.field_70146_Z.nextFloat() - 0.5f) * 0.2f;
            float f2 = (this.field_70146_Z.nextFloat() - 0.5f) * 0.2f;
            double d7 = d3 + (this.field_70165_t - d3) * d6 + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N * 2.0;
            double d8 = d4 + (this.field_70163_u - d4) * d6 + this.field_70146_Z.nextDouble() * (double)this.field_70131_O;
            double d9 = d5 + (this.field_70161_v - d5) * d6 + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N * 2.0;
            this.field_70170_p.func_175688_a(this.getTeleportParticle(), d7, d8, d9, (double)f, (double)f1, (double)f2, new int[0]);
        }
        this.field_70170_p.func_72908_a(d3, d4, d5, this.getTeleportSound(), 0.2f, 1.0f);
        this.func_85030_a(this.getTeleportSound(), 0.2f, 1.0f);
        this.onTeleport(d3, d4, d5);
        return true;
    }

    protected String getTeleportSound() {
        return "mob.endermen.portal";
    }

    protected EnumParticleTypes getTeleportParticle() {
        return EnumParticleTypes.PORTAL;
    }

    protected int getTeleportLight() {
        return 8;
    }

    protected void onTeleport(double x, double y, double z) {
    }

    protected boolean teleportPlayer(EntityPlayerMP mp) {
        if (mp.field_71075_bZ.field_75098_d) {
            return false;
        }
        double x = mp.field_70165_t;
        double y = mp.field_70163_u;
        double z = mp.field_70161_v;
        double x2 = this.field_70165_t;
        double y2 = this.field_70163_u;
        double z2 = this.field_70161_v;
        if (mp.field_71135_a.func_147362_b().func_150724_d() && this.field_70170_p == mp.field_70170_p) {
            if (mp.func_70115_ae()) {
                mp.func_70078_a(null);
            }
            mp.field_71135_a.func_147364_a(x2, y2, z2, mp.field_70177_z, mp.field_70125_A);
            int short1 = 128;
            for (int l = 0; l < short1; ++l) {
                double d6 = (double)l / ((double)short1 - 1.0);
                float f = (this.field_70146_Z.nextFloat() - 0.5f) * 0.2f;
                float f1 = (this.field_70146_Z.nextFloat() - 0.5f) * 0.2f;
                float f2 = (this.field_70146_Z.nextFloat() - 0.5f) * 0.2f;
                double d7 = x + (x2 - x) * d6 + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N * 2.0;
                double d8 = y + (y2 - y) * d6 + this.field_70146_Z.nextDouble() * (double)this.field_70131_O;
                double d9 = z + (z2 - z) * d6 + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N * 2.0;
                this.field_70170_p.func_175688_a(this.getTeleportParticle(), d7, d8, d9, (double)f, (double)f1, (double)f2, new int[0]);
            }
            mp.field_70143_R = 0.0f;
            this.field_70170_p.func_72956_a((Entity)mp, this.getTeleportSound(), 0.4f, 0.4f);
            return true;
        }
        return false;
    }

    protected void updateSize() {
    }

    public boolean isBuffExempt() {
        return false;
    }

    protected boolean spawnEntityNearby(EntityLiving entity, int hRange, int vRange, boolean withTarget) {
        for (int y1 = -vRange; y1 < vRange + 1; ++y1) {
            for (int z1 = -hRange; z1 < hRange + 1; ++z1) {
                for (int x1 = -vRange; x1 < hRange + 1; ++x1) {
                    if (!World.func_175683_a((IBlockAccess)this.field_70170_p, (BlockPos)new BlockPos((int)this.field_70165_t + x1, (int)this.field_70163_u + y1 - 1, (int)this.field_70161_v + z1)) || !this.field_70146_Z.nextBoolean()) continue;
                    entity.func_70107_b(this.field_70165_t + (double)x1, this.field_70163_u + (double)y1, this.field_70161_v + (double)z1);
                    if (!this.field_70170_p.func_72855_b(entity.func_174813_aQ()) || !this.field_70170_p.func_72945_a((Entity)entity, entity.func_174813_aQ()).isEmpty() || this.field_70170_p.func_72953_d(entity.func_174813_aQ())) continue;
                    this.field_70170_p.func_72838_d((Entity)entity);
                    entity.func_180482_a(this.field_70170_p.func_175649_E(new BlockPos(this.field_70165_t + (double)x1, this.field_70163_u + (double)y1, this.field_70161_v + (double)z1)), null);
                    if (withTarget && this.func_70638_az() != null) {
                        entity.func_70624_b(this.func_70638_az());
                    }
                    this.field_70170_p.func_72956_a((Entity)this, "tragicmc:random.siren", 1.0f, 1.0f);
                    return true;
                }
            }
        }
        return false;
    }

    public static class GroupBuff
    implements IEntityLivingData {
        public final PotionEffect effect;

        public GroupBuff(PotionEffect effect) {
            this.effect = effect;
        }

        public PotionEffect getReducedEffect() {
            return new PotionEffect(this.effect.func_76456_a(), this.effect.func_76459_b() * 3 / 4, this.effect.func_76458_c() / 2 * 3);
        }
    }
}

